/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RedisGraphQueryUtil {
    public static final List<String> DUMMY_LIST = Collections.emptyList();
    public static final Map<String, List<String>> DUMMY_MAP = Collections.emptyMap();
    public static final String COMPACT_STRING = "--COMPACT";
    public static final String TIMEOUT_STRING = "TIMEOUT";

    private RedisGraphQueryUtil() {
    }

    public static String prepareQuery(String string, Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder("CYPHER ");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append('=').append(RedisGraphQueryUtil.valueToString(entry.getValue())).append(' ');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String valueToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return RedisGraphQueryUtil.quoteString((String)object);
        }
        if (object instanceof Character) {
            return RedisGraphQueryUtil.quoteString(((Character)object).toString());
        }
        if (object instanceof Object[]) {
            return RedisGraphQueryUtil.arrayToString((Object[])object);
        }
        if (object instanceof List) {
            return RedisGraphQueryUtil.arrayToString((List)object);
        }
        return object.toString();
    }

    private static String quoteString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 12);
        stringBuilder.append('\"');
        stringBuilder.append(string.replace("\"", "\\\""));
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private static String arrayToString(Object[] objectArray) {
        return RedisGraphQueryUtil.arrayToString(Arrays.asList(objectArray));
    }

    private static String arrayToString(List<Object> list) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        stringBuilder.append(String.join((CharSequence)", ", list.stream().map(RedisGraphQueryUtil::valueToString).collect(Collectors.toList())));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

