/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph;

import java.util.HashMap;
import java.util.Map;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.graph.GraphProtocol;
import me.ulrich.clans.library.redis.jedis.graph.RedisGraphQueryUtil;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class GraphQueryParams
implements IParams {
    private boolean readonly;
    private String query;
    private Map<String, Object> params;
    private Long timeout;

    public GraphQueryParams() {
    }

    public static GraphQueryParams queryParams() {
        return new GraphQueryParams();
    }

    public GraphQueryParams(String string) {
        this.query = string;
    }

    public static GraphQueryParams queryParams(String string) {
        return new GraphQueryParams(string);
    }

    public GraphQueryParams readonly() {
        return this.readonly(true);
    }

    public GraphQueryParams readonly(boolean bl) {
        this.readonly = bl;
        return this;
    }

    public GraphQueryParams query(String string) {
        this.query = string;
        return this;
    }

    public GraphQueryParams params(Map<String, Object> map) {
        this.params = map;
        return this;
    }

    public GraphQueryParams addParam(String string, Object object) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(string, object);
        return this;
    }

    public GraphQueryParams timeout(long l2) {
        this.timeout = l2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.query == null) {
            throw new JedisException("Query string must be set.");
        }
        if (this.params == null) {
            commandArguments.add(this.query);
        } else {
            commandArguments.add(RedisGraphQueryUtil.prepareQuery(this.query, this.params));
        }
        commandArguments.add(GraphProtocol.GraphKeyword.__COMPACT);
        if (this.timeout != null) {
            commandArguments.add(GraphProtocol.GraphKeyword.TIMEOUT).add(this.timeout).blocking();
        }
    }

    public CommandArguments getArguments(String string) {
        return new CommandArguments(!this.readonly ? GraphProtocol.GraphCommand.QUERY : GraphProtocol.GraphCommand.RO_QUERY).key(string).addParams(this);
    }
}

