/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.graph.GraphCache;
import me.ulrich.clans.library.redis.jedis.graph.GraphProtocol;
import me.ulrich.clans.library.redis.jedis.graph.GraphQueryParams;
import me.ulrich.clans.library.redis.jedis.graph.Record;
import me.ulrich.clans.library.redis.jedis.graph.RedisGraphCommands;
import me.ulrich.clans.library.redis.jedis.graph.ResultSet;
import me.ulrich.clans.library.redis.jedis.graph.ResultSetBuilder;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;

public class GraphCommandObjects {
    private final RedisGraphCommands graph;
    private final Connection connection;
    private final ConnectionProvider provider;
    private final ConcurrentHashMap<String, Builder<ResultSet>> builders = new ConcurrentHashMap();

    public GraphCommandObjects(RedisGraphCommands redisGraphCommands) {
        this.graph = redisGraphCommands;
        this.connection = null;
        this.provider = null;
    }

    public GraphCommandObjects(Connection connection) {
        this.connection = connection;
        this.provider = null;
        this.graph = null;
    }

    public GraphCommandObjects(ConnectionProvider connectionProvider) {
        this.provider = connectionProvider;
        this.connection = null;
        this.graph = null;
    }

    public final CommandObject<ResultSet> graphQuery(String string, String string2) {
        return new CommandObject<ResultSet>(new CommandArguments(GraphProtocol.GraphCommand.QUERY).key(string).add(string2).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(string));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String string, String string2) {
        return new CommandObject<ResultSet>(new CommandArguments(GraphProtocol.GraphCommand.RO_QUERY).key(string).add(string2).add(GraphProtocol.GraphKeyword.__COMPACT), this.getBuilder(string));
    }

    public final CommandObject<ResultSet> graphQuery(String string, String string2, long l2) {
        return this.graphQuery(string, GraphQueryParams.queryParams(string2).timeout(l2));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String string, String string2, long l2) {
        return this.graphQuery(string, GraphQueryParams.queryParams().readonly().query(string2).timeout(l2));
    }

    public final CommandObject<ResultSet> graphQuery(String string, String string2, Map<String, Object> map) {
        return this.graphQuery(string, GraphQueryParams.queryParams(string2).params(map));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String string, String string2, Map<String, Object> map) {
        return this.graphQuery(string, GraphQueryParams.queryParams().readonly().query(string2).params(map));
    }

    public final CommandObject<ResultSet> graphQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.graphQuery(string, GraphQueryParams.queryParams(string2).params(map).timeout(l2));
    }

    public final CommandObject<ResultSet> graphReadonlyQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.graphQuery(string, GraphQueryParams.queryParams().readonly().query(string2).params(map).timeout(l2));
    }

    private CommandObject<ResultSet> graphQuery(String string, GraphQueryParams graphQueryParams) {
        return new CommandObject<ResultSet>(graphQueryParams.getArguments(string), this.getBuilder(string));
    }

    public final CommandObject<String> graphDelete(String string) {
        return new CommandObject<String>(new CommandArguments(GraphProtocol.GraphCommand.DELETE).key(string), BuilderFactory.STRING);
    }

    private Builder<ResultSet> getBuilder(String string) {
        if (!this.builders.containsKey(string)) {
            this.createBuilder(string);
        }
        return this.builders.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuilder(String string) {
        ConcurrentHashMap<String, Builder<ResultSet>> concurrentHashMap = this.builders;
        synchronized (concurrentHashMap) {
            this.builders.putIfAbsent(string, new ResultSetBuilder(new GraphCacheImpl(string)));
        }
    }

    private class GraphCacheList {
        private final String name;
        private final String query;
        private final List<String> data = new CopyOnWriteArrayList<String>();

        public GraphCacheList(String string, String string2) {
            this.name = string;
            this.query = "CALL " + string2 + "()";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getCachedData(int n2) {
            if (n2 >= this.data.size()) {
                List<String> list = this.data;
                synchronized (list) {
                    if (n2 >= this.data.size()) {
                        this.getProcedureInfo();
                    }
                }
            }
            return this.data.get(n2);
        }

        private void getProcedureInfo() {
            ResultSet resultSet = this.callProcedure();
            Iterator iterator = resultSet.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (n2 >= this.data.size()) {
                    arrayList.add(record.getString(0));
                }
                ++n2;
            }
            this.data.addAll(arrayList);
        }

        private ResultSet callProcedure() {
            if (GraphCommandObjects.this.graph != null) {
                return GraphCommandObjects.this.graph.graphQuery(this.name, this.query);
            }
            CommandObject commandObject = new CommandObject(new CommandArguments(GraphProtocol.GraphCommand.QUERY).key(this.name).add(this.query).add(GraphProtocol.GraphKeyword.__COMPACT), GraphCommandObjects.this.getBuilder(this.name));
            if (GraphCommandObjects.this.connection != null) {
                return (ResultSet)GraphCommandObjects.this.connection.executeCommand(commandObject);
            }
            try (Connection connection = GraphCommandObjects.this.provider.getConnection(commandObject.getArguments());){
                ResultSet resultSet = (ResultSet)connection.executeCommand(commandObject);
                return resultSet;
            }
        }
    }

    private class GraphCacheImpl
    implements GraphCache {
        private final GraphCacheList labels;
        private final GraphCacheList propertyNames;
        private final GraphCacheList relationshipTypes;

        public GraphCacheImpl(String string) {
            this.labels = new GraphCacheList(string, "db.labels");
            this.propertyNames = new GraphCacheList(string, "db.propertyKeys");
            this.relationshipTypes = new GraphCacheList(string, "db.relationshipTypes");
        }

        @Override
        public String getLabel(int n2) {
            return this.labels.getCachedData(n2);
        }

        @Override
        public String getRelationshipType(int n2) {
            return this.relationshipTypes.getCachedData(n2);
        }

        @Override
        public String getPropertyName(int n2) {
            return this.propertyNames.getCachedData(n2);
        }
    }
}

