/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.executors;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.executors.CommandExecutor;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableCommandExecutor
implements CommandExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ConnectionProvider provider;
    protected final int maxAttempts;
    protected final Duration maxTotalRetriesDuration;

    public RetryableCommandExecutor(ConnectionProvider connectionProvider, int n2, Duration duration) {
        this.provider = connectionProvider;
        this.maxAttempts = n2;
        this.maxTotalRetriesDuration = duration;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T executeCommand(CommandObject<T> commandObject) {
        Instant instant = Instant.now().plus(this.maxTotalRetriesDuration);
        int n2 = 0;
        JedisConnectionException jedisConnectionException = null;
        for (int i2 = this.maxAttempts; i2 > 0; --i2) {
            try (Connection connection = null;){
                connection = this.provider.getConnection(commandObject.getArguments());
                T t2 = this.execute(connection, commandObject);
                return t2;
            }
            if (!Instant.now().isAfter(instant)) continue;
            throw new JedisException("Retry deadline exceeded.");
        }
        JedisException jedisException = new JedisException("No more attempts left.");
        jedisException.addSuppressed(jedisConnectionException);
        throw jedisException;
    }

    protected <T> T execute(Connection connection, CommandObject<T> commandObject) {
        return connection.executeCommand(commandObject);
    }

    private boolean handleConnectionProblem(int n2, int n3, Instant instant) {
        if (n3 < 2) {
            return false;
        }
        this.sleep(RetryableCommandExecutor.getBackoffSleepMillis(n2, instant));
        return true;
    }

    private static long getBackoffSleepMillis(int n2, Instant instant) {
        if (n2 <= 0) {
            return 0L;
        }
        long l2 = Duration.between(Instant.now(), instant).toMillis();
        if (l2 < 0L) {
            throw new JedisException("Retry deadline exceeded.");
        }
        return l2 / (long)(n2 * (n2 + 1));
    }

    protected void sleep(long l2) {
        try {
            TimeUnit.MILLISECONDS.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new JedisException(interruptedException);
        }
    }
}

