/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.executors;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisClusterOperationException;
import me.ulrich.clans.library.redis.jedis.executors.CommandExecutor;
import me.ulrich.clans.library.redis.jedis.providers.ClusterConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterCommandExecutor
implements CommandExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public final ClusterConnectionProvider provider;
    protected final int maxAttempts;
    protected final Duration maxTotalRetriesDuration;

    public ClusterCommandExecutor(ClusterConnectionProvider clusterConnectionProvider, int n2, Duration duration) {
        this.provider = clusterConnectionProvider;
        this.maxAttempts = n2;
        this.maxTotalRetriesDuration = duration;
    }

    @Override
    public void close() {
        this.provider.close();
    }

    /*
     * Exception decompiling
     */
    @Override
    public final <T> T executeCommand(CommandObject<T> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <T> T execute(Connection connection, CommandObject<T> commandObject) {
        return connection.executeCommand(commandObject);
    }

    private boolean handleConnectionProblem(int n2, int n3, Instant instant) {
        if (this.maxAttempts < 3) {
            if (n2 == 0) {
                this.provider.renewSlotCache();
                return true;
            }
            return false;
        }
        if (n3 < 2) {
            return false;
        }
        this.sleep(ClusterCommandExecutor.getBackoffSleepMillis(n2, instant));
        this.provider.renewSlotCache();
        return true;
    }

    private static long getBackoffSleepMillis(int n2, Instant instant) {
        if (n2 <= 0) {
            return 0L;
        }
        long l2 = Duration.between(Instant.now(), instant).toMillis();
        if (l2 < 0L) {
            throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
        }
        long l3 = l2 / (long)(n2 * n2);
        return ThreadLocalRandom.current().nextLong(l3 + 1L);
    }

    protected void sleep(long l2) {
        try {
            TimeUnit.MILLISECONDS.sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            throw new JedisClusterOperationException(interruptedException);
        }
    }
}

