/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.bloom;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.bloom.RedisBloomProtocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class CFReserveParams
implements IParams {
    private Long bucketSize;
    private Integer maxIterations;
    private Integer expansion;

    public static CFReserveParams reserveParams() {
        return new CFReserveParams();
    }

    public CFReserveParams bucketSize(long l2) {
        this.bucketSize = l2;
        return this;
    }

    public CFReserveParams maxIterations(int n2) {
        this.maxIterations = n2;
        return this;
    }

    public CFReserveParams expansion(int n2) {
        this.expansion = n2;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.bucketSize != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.BUCKETSIZE).add(Protocol.toByteArray(this.bucketSize));
        }
        if (this.maxIterations != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.MAXITERATIONS).add(Protocol.toByteArray(this.maxIterations));
        }
        if (this.expansion != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.EXPANSION).add(Protocol.toByteArray(this.expansion));
        }
    }
}

