/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.bloom;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.bloom.RedisBloomProtocol;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class BFInsertParams
implements IParams {
    private Long capacity;
    private Double errorRate;
    private Integer expansion;
    private boolean noCreate = false;
    private boolean nonScaling = false;

    public static BFInsertParams insertParams() {
        return new BFInsertParams();
    }

    public BFInsertParams capacity(long l2) {
        this.capacity = l2;
        return this;
    }

    public BFInsertParams error(double d2) {
        this.errorRate = d2;
        return this;
    }

    public BFInsertParams expansion(int n2) {
        this.expansion = n2;
        return this;
    }

    public BFInsertParams noCreate() {
        this.noCreate = true;
        return this;
    }

    public BFInsertParams nonScaling() {
        this.nonScaling = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments commandArguments) {
        if (this.capacity != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.CAPACITY).add(Protocol.toByteArray(this.capacity));
        }
        if (this.errorRate != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.ERROR).add(Protocol.toByteArray(this.errorRate));
        }
        if (this.expansion != null) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.EXPANSION).add(Protocol.toByteArray(this.expansion));
        }
        if (this.noCreate) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.NOCREATE);
        }
        if (this.nonScaling) {
            commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.NONSCALING);
        }
    }
}

