/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis.args;

import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public final class RawableFactory {
    public static Rawable from(int n2) {
        return RawableFactory.from(Protocol.toByteArray(n2));
    }

    public static Rawable from(double d2) {
        return RawableFactory.from(Protocol.toByteArray(d2));
    }

    public static Rawable from(byte[] byArray) {
        return new Raw(byArray);
    }

    public static Rawable from(String string) {
        return new RawString(string);
    }

    private RawableFactory() {
        throw new InstantiationError();
    }

    public static class RawString
    extends Raw {
        public RawString(String string) {
            super(SafeEncoder.encode(string));
        }
    }

    public static class Raw
    implements Rawable {
        private final byte[] raw;

        public Raw(byte[] byArray) {
            this.raw = byArray;
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

