/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import me.ulrich.clans.library.redis.jedis.BinaryJedisPubSub;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.ClusterCommandObjects;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.CommandObjects;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisPubSub;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.ShardedCommandObjects;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.args.BitCountOption;
import me.ulrich.clans.library.redis.jedis.args.BitOP;
import me.ulrich.clans.library.redis.jedis.args.ExpiryOption;
import me.ulrich.clans.library.redis.jedis.args.FlushMode;
import me.ulrich.clans.library.redis.jedis.args.FunctionRestorePolicy;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.ListDirection;
import me.ulrich.clans.library.redis.jedis.args.ListPosition;
import me.ulrich.clans.library.redis.jedis.args.SortedSetOption;
import me.ulrich.clans.library.redis.jedis.bloom.BFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.BFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.TDigestMergeParams;
import me.ulrich.clans.library.redis.jedis.commands.JedisBinaryCommands;
import me.ulrich.clans.library.redis.jedis.commands.JedisCommands;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.commands.RedisModuleCommands;
import me.ulrich.clans.library.redis.jedis.commands.SampleBinaryKeyedCommands;
import me.ulrich.clans.library.redis.jedis.commands.SampleKeyedCommands;
import me.ulrich.clans.library.redis.jedis.executors.ClusterCommandExecutor;
import me.ulrich.clans.library.redis.jedis.executors.CommandExecutor;
import me.ulrich.clans.library.redis.jedis.executors.DefaultCommandExecutor;
import me.ulrich.clans.library.redis.jedis.executors.RetryableCommandExecutor;
import me.ulrich.clans.library.redis.jedis.executors.SimpleCommandExecutor;
import me.ulrich.clans.library.redis.jedis.graph.GraphCommandObjects;
import me.ulrich.clans.library.redis.jedis.graph.ResultSet;
import me.ulrich.clans.library.redis.jedis.json.JsonSetParams;
import me.ulrich.clans.library.redis.jedis.json.Path;
import me.ulrich.clans.library.redis.jedis.json.Path2;
import me.ulrich.clans.library.redis.jedis.params.BitPosParams;
import me.ulrich.clans.library.redis.jedis.params.GeoAddParams;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusParam;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusStoreParam;
import me.ulrich.clans.library.redis.jedis.params.GeoSearchParam;
import me.ulrich.clans.library.redis.jedis.params.GetExParams;
import me.ulrich.clans.library.redis.jedis.params.LCSParams;
import me.ulrich.clans.library.redis.jedis.params.LPosParams;
import me.ulrich.clans.library.redis.jedis.params.MigrateParams;
import me.ulrich.clans.library.redis.jedis.params.RestoreParams;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.params.SetParams;
import me.ulrich.clans.library.redis.jedis.params.SortingParams;
import me.ulrich.clans.library.redis.jedis.params.StrAlgoLCSParams;
import me.ulrich.clans.library.redis.jedis.params.XAddParams;
import me.ulrich.clans.library.redis.jedis.params.XAutoClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XPendingParams;
import me.ulrich.clans.library.redis.jedis.params.XReadGroupParams;
import me.ulrich.clans.library.redis.jedis.params.XReadParams;
import me.ulrich.clans.library.redis.jedis.params.XTrimParams;
import me.ulrich.clans.library.redis.jedis.params.ZAddParams;
import me.ulrich.clans.library.redis.jedis.params.ZIncrByParams;
import me.ulrich.clans.library.redis.jedis.params.ZParams;
import me.ulrich.clans.library.redis.jedis.params.ZRangeParams;
import me.ulrich.clans.library.redis.jedis.providers.ClusterConnectionProvider;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import me.ulrich.clans.library.redis.jedis.providers.PooledConnectionProvider;
import me.ulrich.clans.library.redis.jedis.providers.ShardedConnectionProvider;
import me.ulrich.clans.library.redis.jedis.resps.FunctionStats;
import me.ulrich.clans.library.redis.jedis.resps.GeoRadiusResponse;
import me.ulrich.clans.library.redis.jedis.resps.KeyedListElement;
import me.ulrich.clans.library.redis.jedis.resps.KeyedZSetElement;
import me.ulrich.clans.library.redis.jedis.resps.LCSMatchResult;
import me.ulrich.clans.library.redis.jedis.resps.LibraryInfo;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumersInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingSummary;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.FTCreateParams;
import me.ulrich.clans.library.redis.jedis.search.FTSearchParams;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.TSAlterParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSCreateParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSElement;
import me.ulrich.clans.library.redis.jedis.timeseries.TSGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSInfo;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyValue;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyedElements;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMRangeParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSRangeParams;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import me.ulrich.clans.library.redis.jedis.util.JedisURIHelper;
import me.ulrich.clans.library.redis.jedis.util.KeyValue;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.json.JSONArray;

public class UnifiedJedis
implements AutoCloseable,
JedisBinaryCommands,
JedisCommands,
RedisModuleCommands,
SampleBinaryKeyedCommands,
SampleKeyedCommands {
    protected final ConnectionProvider provider;
    protected final CommandExecutor executor;
    private final CommandObjects commandObjects;
    private final GraphCommandObjects graphCommandObjects = new GraphCommandObjects(this);

    public UnifiedJedis() {
        this(new HostAndPort("127.0.0.1", 6379));
    }

    public UnifiedJedis(HostAndPort hostAndPort) {
        this(new PooledConnectionProvider(hostAndPort));
    }

    public UnifiedJedis(String string) {
        this(URI.create(string));
    }

    public UnifiedJedis(URI uRI) {
        this(JedisURIHelper.getHostAndPort(uRI), (JedisClientConfig)DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uRI)).password(JedisURIHelper.getPassword(uRI)).database(JedisURIHelper.getDBIndex(uRI)).ssl(JedisURIHelper.isRedisSSLScheme(uRI)).build());
    }

    public UnifiedJedis(URI uRI, JedisClientConfig jedisClientConfig) {
        this(JedisURIHelper.getHostAndPort(uRI), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(jedisClientConfig.getConnectionTimeoutMillis()).socketTimeoutMillis(jedisClientConfig.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(jedisClientConfig.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uRI)).password(JedisURIHelper.getPassword(uRI)).database(JedisURIHelper.getDBIndex(uRI)).clientName(jedisClientConfig.getClientName()).ssl(JedisURIHelper.isRedisSSLScheme(uRI)).sslSocketFactory(jedisClientConfig.getSslSocketFactory()).sslParameters(jedisClientConfig.getSslParameters()).hostnameVerifier(jedisClientConfig.getHostnameVerifier()).build());
    }

    public UnifiedJedis(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this(new PooledConnectionProvider(hostAndPort, jedisClientConfig));
    }

    public UnifiedJedis(ConnectionProvider connectionProvider) {
        this.provider = connectionProvider;
        this.executor = new DefaultCommandExecutor(connectionProvider);
        this.commandObjects = new CommandObjects();
    }

    public UnifiedJedis(JedisSocketFactory jedisSocketFactory) {
        this(new Connection(jedisSocketFactory));
    }

    public UnifiedJedis(Connection connection) {
        this.provider = null;
        this.executor = new SimpleCommandExecutor(connection);
        this.commandObjects = new CommandObjects();
    }

    public UnifiedJedis(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2) {
        this(new ClusterConnectionProvider(set, jedisClientConfig), n2, Duration.ofMillis(n2 * jedisClientConfig.getSocketTimeoutMillis()));
    }

    public UnifiedJedis(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2, Duration duration) {
        this(new ClusterConnectionProvider(set, jedisClientConfig), n2, duration);
    }

    public UnifiedJedis(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, int n2, Duration duration) {
        this(new ClusterConnectionProvider(set, jedisClientConfig, genericObjectPoolConfig), n2, duration);
    }

    public UnifiedJedis(ClusterConnectionProvider clusterConnectionProvider, int n2, Duration duration) {
        this.provider = clusterConnectionProvider;
        this.executor = new ClusterCommandExecutor(clusterConnectionProvider, n2, duration);
        this.commandObjects = new ClusterCommandObjects();
    }

    public UnifiedJedis(ShardedConnectionProvider shardedConnectionProvider) {
        this.provider = shardedConnectionProvider;
        this.executor = new DefaultCommandExecutor(shardedConnectionProvider);
        this.commandObjects = new ShardedCommandObjects(shardedConnectionProvider.getHashingAlgo());
    }

    public UnifiedJedis(ShardedConnectionProvider shardedConnectionProvider, Pattern pattern) {
        this.provider = shardedConnectionProvider;
        this.executor = new DefaultCommandExecutor(shardedConnectionProvider);
        this.commandObjects = new ShardedCommandObjects(shardedConnectionProvider.getHashingAlgo(), pattern);
    }

    public UnifiedJedis(ConnectionProvider connectionProvider, int n2, Duration duration) {
        this.provider = connectionProvider;
        this.executor = new RetryableCommandExecutor(connectionProvider, n2, duration);
        this.commandObjects = new CommandObjects();
    }

    public UnifiedJedis(CommandExecutor commandExecutor) {
        this.provider = null;
        this.executor = commandExecutor;
        this.commandObjects = new CommandObjects();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.executor);
    }

    public final <T> T executeCommand(CommandObject<T> commandObject) {
        return this.executor.executeCommand(commandObject);
    }

    @Override
    public boolean exists(String string) {
        return this.executeCommand(this.commandObjects.exists(string));
    }

    @Override
    public long exists(String ... stringArray) {
        return this.executeCommand(this.commandObjects.exists(stringArray));
    }

    @Override
    public long persist(String string) {
        return this.executeCommand(this.commandObjects.persist(string));
    }

    @Override
    public String type(String string) {
        return this.executeCommand(this.commandObjects.type(string));
    }

    @Override
    public boolean exists(byte[] byArray) {
        return this.executeCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public long exists(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public long persist(byte[] byArray) {
        return this.executeCommand(this.commandObjects.persist(byArray));
    }

    @Override
    public String type(byte[] byArray) {
        return this.executeCommand(this.commandObjects.type(byArray));
    }

    @Override
    public byte[] dump(String string) {
        return this.executeCommand(this.commandObjects.dump(string));
    }

    @Override
    public String restore(String string, long l2, byte[] byArray) {
        return this.executeCommand(this.commandObjects.restore(string, l2, byArray));
    }

    @Override
    public String restore(String string, long l2, byte[] byArray, RestoreParams restoreParams) {
        return this.executeCommand(this.commandObjects.restore(string, l2, byArray, restoreParams));
    }

    @Override
    public byte[] dump(byte[] byArray) {
        return this.executeCommand(this.commandObjects.dump(byArray));
    }

    @Override
    public String restore(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.restore(byArray, l2, byArray2));
    }

    @Override
    public String restore(byte[] byArray, long l2, byte[] byArray2, RestoreParams restoreParams) {
        return this.executeCommand(this.commandObjects.restore(byArray, l2, byArray2, restoreParams));
    }

    @Override
    public long expire(String string, long l2) {
        return this.executeCommand(this.commandObjects.expire(string, l2));
    }

    @Override
    public long expire(String string, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expire(string, l2, expiryOption));
    }

    @Override
    public long pexpire(String string, long l2) {
        return this.executeCommand(this.commandObjects.pexpire(string, l2));
    }

    @Override
    public long pexpire(String string, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpire(string, l2, expiryOption));
    }

    @Override
    public long expireTime(String string) {
        return this.executeCommand(this.commandObjects.expireTime(string));
    }

    @Override
    public long pexpireTime(String string) {
        return this.executeCommand(this.commandObjects.pexpireTime(string));
    }

    @Override
    public long expireAt(String string, long l2) {
        return this.executeCommand(this.commandObjects.expireAt(string, l2));
    }

    @Override
    public long expireAt(String string, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expireAt(string, l2, expiryOption));
    }

    @Override
    public long pexpireAt(String string, long l2) {
        return this.executeCommand(this.commandObjects.pexpireAt(string, l2));
    }

    @Override
    public long pexpireAt(String string, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpireAt(string, l2, expiryOption));
    }

    @Override
    public long expire(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.expire(byArray, l2));
    }

    @Override
    public long expire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expire(byArray, l2, expiryOption));
    }

    @Override
    public long pexpire(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.pexpire(byArray, l2));
    }

    @Override
    public long pexpire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.pexpire(byArray, l2, expiryOption));
    }

    @Override
    public long expireTime(byte[] byArray) {
        return this.executeCommand(this.commandObjects.expireTime(byArray));
    }

    @Override
    public long pexpireTime(byte[] byArray) {
        return this.executeCommand(this.commandObjects.pexpireTime(byArray));
    }

    @Override
    public long expireAt(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.expireAt(byArray, l2));
    }

    @Override
    public long expireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expireAt(byArray, l2, expiryOption));
    }

    @Override
    public long pexpireAt(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.pexpireAt(byArray, l2));
    }

    @Override
    public long pexpireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.executeCommand(this.commandObjects.expireAt(byArray, l2, expiryOption));
    }

    @Override
    public long ttl(String string) {
        return this.executeCommand(this.commandObjects.ttl(string));
    }

    @Override
    public long pttl(String string) {
        return this.executeCommand(this.commandObjects.pttl(string));
    }

    @Override
    public long touch(String string) {
        return this.executeCommand(this.commandObjects.touch(string));
    }

    @Override
    public long touch(String ... stringArray) {
        return this.executeCommand(this.commandObjects.touch(stringArray));
    }

    @Override
    public long ttl(byte[] byArray) {
        return this.executeCommand(this.commandObjects.ttl(byArray));
    }

    @Override
    public long pttl(byte[] byArray) {
        return this.executeCommand(this.commandObjects.pttl(byArray));
    }

    @Override
    public long touch(byte[] byArray) {
        return this.executeCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public long touch(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public List<String> sort(String string) {
        return this.executeCommand(this.commandObjects.sort(string));
    }

    @Override
    public List<String> sort(String string, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sort(string, sortingParams));
    }

    @Override
    public long sort(String string, String string2) {
        return this.executeCommand(this.commandObjects.sort(string, string2));
    }

    @Override
    public long sort(String string, SortingParams sortingParams, String string2) {
        return this.executeCommand(this.commandObjects.sort(string, sortingParams, string2));
    }

    @Override
    public List<String> sortReadonly(String string, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sortReadonly(string, sortingParams));
    }

    @Override
    public List<byte[]> sort(byte[] byArray) {
        return this.executeCommand(this.commandObjects.sort(byArray));
    }

    @Override
    public List<byte[]> sort(byte[] byArray, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sort(byArray, sortingParams));
    }

    @Override
    public long sort(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.sort(byArray, byArray2));
    }

    @Override
    public List<byte[]> sortReadonly(byte[] byArray, SortingParams sortingParams) {
        return this.executeCommand(this.commandObjects.sortReadonly(byArray, sortingParams));
    }

    @Override
    public long sort(byte[] byArray, SortingParams sortingParams, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.sort(byArray, sortingParams, byArray2));
    }

    @Override
    public long del(String string) {
        return this.executeCommand(this.commandObjects.del(string));
    }

    @Override
    public long del(String ... stringArray) {
        return this.executeCommand(this.commandObjects.del(stringArray));
    }

    @Override
    public long unlink(String string) {
        return this.executeCommand(this.commandObjects.unlink(string));
    }

    @Override
    public long unlink(String ... stringArray) {
        return this.executeCommand(this.commandObjects.unlink(stringArray));
    }

    @Override
    public long del(byte[] byArray) {
        return this.executeCommand(this.commandObjects.del(byArray));
    }

    @Override
    public long del(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.del(byArray));
    }

    @Override
    public long unlink(byte[] byArray) {
        return this.executeCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public long unlink(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public Long memoryUsage(String string) {
        return this.executeCommand(this.commandObjects.memoryUsage(string));
    }

    @Override
    public Long memoryUsage(String string, int n2) {
        return this.executeCommand(this.commandObjects.memoryUsage(string, n2));
    }

    @Override
    public Long memoryUsage(byte[] byArray) {
        return this.executeCommand(this.commandObjects.memoryUsage(byArray));
    }

    @Override
    public Long memoryUsage(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.memoryUsage(byArray, n2));
    }

    @Override
    public boolean copy(String string, String string2, boolean bl) {
        return this.executeCommand(this.commandObjects.copy(string, string2, bl));
    }

    @Override
    public String rename(String string, String string2) {
        return this.executeCommand(this.commandObjects.rename(string, string2));
    }

    @Override
    public long renamenx(String string, String string2) {
        return this.executeCommand(this.commandObjects.renamenx(string, string2));
    }

    @Override
    public boolean copy(byte[] byArray, byte[] byArray2, boolean bl) {
        return this.executeCommand(this.commandObjects.copy(byArray, byArray2, bl));
    }

    @Override
    public String rename(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.rename(byArray, byArray2));
    }

    @Override
    public long renamenx(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.renamenx(byArray, byArray2));
    }

    public long dbSize() {
        return this.executeCommand(this.commandObjects.dbSize());
    }

    @Override
    public Set<String> keys(String string) {
        return this.executeCommand(this.commandObjects.keys(string));
    }

    @Override
    public ScanResult<String> scan(String string) {
        return this.executeCommand(this.commandObjects.scan(string));
    }

    @Override
    public ScanResult<String> scan(String string, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.scan(string, scanParams));
    }

    @Override
    public ScanResult<String> scan(String string, ScanParams scanParams, String string2) {
        return this.executeCommand(this.commandObjects.scan(string, scanParams, string2));
    }

    @Override
    public Set<byte[]> keys(byte[] byArray) {
        return this.executeCommand(this.commandObjects.keys(byArray));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray) {
        return this.executeCommand(this.commandObjects.scan(byArray));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.scan(byArray, scanParams));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.scan(byArray, scanParams, byArray2));
    }

    @Override
    public String randomKey() {
        return this.executeCommand(this.commandObjects.randomKey());
    }

    @Override
    public byte[] randomBinaryKey() {
        return this.executeCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public String set(String string, String string2) {
        return this.executeCommand(this.commandObjects.set(string, string2));
    }

    @Override
    public String set(String string, String string2, SetParams setParams) {
        return this.executeCommand(this.commandObjects.set(string, string2, setParams));
    }

    @Override
    public String get(String string) {
        return this.executeCommand(this.commandObjects.get(string));
    }

    @Override
    public String setGet(String string, String string2, SetParams setParams) {
        return this.executeCommand(this.commandObjects.setGet(string, string2, setParams));
    }

    @Override
    public String getDel(String string) {
        return this.executeCommand(this.commandObjects.getDel(string));
    }

    @Override
    public String getEx(String string, GetExParams getExParams) {
        return this.executeCommand(this.commandObjects.getEx(string, getExParams));
    }

    @Override
    public String set(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.set(byArray, byArray2));
    }

    @Override
    public String set(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return this.executeCommand(this.commandObjects.set(byArray, byArray2, setParams));
    }

    @Override
    public byte[] get(byte[] byArray) {
        return this.executeCommand(this.commandObjects.get(byArray));
    }

    @Override
    public byte[] setGet(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return this.executeCommand(this.commandObjects.setGet(byArray, byArray2, setParams));
    }

    @Override
    public byte[] getDel(byte[] byArray) {
        return this.executeCommand(this.commandObjects.getDel(byArray));
    }

    @Override
    public byte[] getEx(byte[] byArray, GetExParams getExParams) {
        return this.executeCommand(this.commandObjects.getEx(byArray, getExParams));
    }

    @Override
    public boolean setbit(String string, long l2, boolean bl) {
        return this.executeCommand(this.commandObjects.setbit(string, l2, bl));
    }

    @Override
    public boolean getbit(String string, long l2) {
        return this.executeCommand(this.commandObjects.getbit(string, l2));
    }

    @Override
    public long setrange(String string, long l2, String string2) {
        return this.executeCommand(this.commandObjects.setrange(string, l2, string2));
    }

    @Override
    public String getrange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.getrange(string, l2, l3));
    }

    @Override
    public boolean setbit(byte[] byArray, long l2, boolean bl) {
        return this.executeCommand(this.commandObjects.setbit(byArray, l2, bl));
    }

    @Override
    public boolean getbit(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.getbit(byArray, l2));
    }

    @Override
    public long setrange(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.setrange(byArray, l2, byArray2));
    }

    @Override
    public byte[] getrange(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.getrange(byArray, l2, l3));
    }

    @Override
    public String getSet(String string, String string2) {
        return this.executeCommand(this.commandObjects.getSet(string, string2));
    }

    @Override
    public long setnx(String string, String string2) {
        return this.executeCommand(this.commandObjects.setnx(string, string2));
    }

    @Override
    public String setex(String string, long l2, String string2) {
        return this.executeCommand(this.commandObjects.setex(string, l2, string2));
    }

    @Override
    public String psetex(String string, long l2, String string2) {
        return this.executeCommand(this.commandObjects.psetex(string, l2, string2));
    }

    @Override
    public byte[] getSet(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.getSet(byArray, byArray2));
    }

    @Override
    public long setnx(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.setnx(byArray, byArray2));
    }

    @Override
    public String setex(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.setex(byArray, l2, byArray2));
    }

    @Override
    public String psetex(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.psetex(byArray, l2, byArray2));
    }

    @Override
    public long incr(String string) {
        return this.executeCommand(this.commandObjects.incr(string));
    }

    @Override
    public long incrBy(String string, long l2) {
        return this.executeCommand(this.commandObjects.incrBy(string, l2));
    }

    @Override
    public double incrByFloat(String string, double d2) {
        return this.executeCommand(this.commandObjects.incrByFloat(string, d2));
    }

    @Override
    public long decr(String string) {
        return this.executeCommand(this.commandObjects.decr(string));
    }

    @Override
    public long decrBy(String string, long l2) {
        return this.executeCommand(this.commandObjects.decrBy(string, l2));
    }

    @Override
    public long incr(byte[] byArray) {
        return this.executeCommand(this.commandObjects.incr(byArray));
    }

    @Override
    public long incrBy(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.incrBy(byArray, l2));
    }

    @Override
    public double incrByFloat(byte[] byArray, double d2) {
        return this.executeCommand(this.commandObjects.incrByFloat(byArray, d2));
    }

    @Override
    public long decr(byte[] byArray) {
        return this.executeCommand(this.commandObjects.decr(byArray));
    }

    @Override
    public long decrBy(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.decrBy(byArray, l2));
    }

    @Override
    public List<String> mget(String ... stringArray) {
        return this.executeCommand(this.commandObjects.mget(stringArray));
    }

    @Override
    public String mset(String ... stringArray) {
        return this.executeCommand(this.commandObjects.mset(stringArray));
    }

    @Override
    public long msetnx(String ... stringArray) {
        return this.executeCommand(this.commandObjects.msetnx(stringArray));
    }

    @Override
    public List<byte[]> mget(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.mget(byArray));
    }

    @Override
    public String mset(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.mset(byArray));
    }

    @Override
    public long msetnx(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.msetnx(byArray));
    }

    @Override
    public long append(String string, String string2) {
        return this.executeCommand(this.commandObjects.append(string, string2));
    }

    @Override
    public String substr(String string, int n2, int n3) {
        return this.executeCommand(this.commandObjects.substr(string, n2, n3));
    }

    @Override
    public long strlen(String string) {
        return this.executeCommand(this.commandObjects.strlen(string));
    }

    @Override
    public long append(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.append(byArray, byArray2));
    }

    @Override
    public byte[] substr(byte[] byArray, int n2, int n3) {
        return this.executeCommand(this.commandObjects.substr(byArray, n2, n3));
    }

    @Override
    public long strlen(byte[] byArray) {
        return this.executeCommand(this.commandObjects.strlen(byArray));
    }

    @Override
    public long bitcount(String string) {
        return this.executeCommand(this.commandObjects.bitcount(string));
    }

    @Override
    public long bitcount(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.bitcount(string, l2, l3));
    }

    @Override
    public long bitcount(String string, long l2, long l3, BitCountOption bitCountOption) {
        return this.executeCommand(this.commandObjects.bitcount(string, l2, l3, bitCountOption));
    }

    @Override
    public long bitpos(String string, boolean bl) {
        return this.executeCommand(this.commandObjects.bitpos(string, bl));
    }

    @Override
    public long bitpos(String string, boolean bl, BitPosParams bitPosParams) {
        return this.executeCommand(this.commandObjects.bitpos(string, bl, bitPosParams));
    }

    @Override
    public long bitcount(byte[] byArray) {
        return this.executeCommand(this.commandObjects.bitcount(byArray));
    }

    @Override
    public long bitcount(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.bitcount(byArray, l2, l3));
    }

    @Override
    public long bitcount(byte[] byArray, long l2, long l3, BitCountOption bitCountOption) {
        return this.executeCommand(this.commandObjects.bitcount(byArray, l2, l3, bitCountOption));
    }

    @Override
    public long bitpos(byte[] byArray, boolean bl) {
        return this.executeCommand(this.commandObjects.bitpos(byArray, bl));
    }

    @Override
    public long bitpos(byte[] byArray, boolean bl, BitPosParams bitPosParams) {
        return this.executeCommand(this.commandObjects.bitpos(byArray, bl, bitPosParams));
    }

    @Override
    public List<Long> bitfield(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bitfield(string, stringArray));
    }

    @Override
    public List<Long> bitfieldReadonly(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bitfieldReadonly(string, stringArray));
    }

    @Override
    public List<Long> bitfield(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.bitfield(byArray, byArray2));
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.bitfieldReadonly(byArray, byArray2));
    }

    @Override
    public long bitop(BitOP bitOP, String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bitop(bitOP, string, stringArray));
    }

    @Override
    public long bitop(BitOP bitOP, byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.bitop(bitOP, byArray, byArray2));
    }

    @Override
    public LCSMatchResult strAlgoLCSKeys(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.executeCommand(this.commandObjects.strAlgoLCSKeys(string, string2, strAlgoLCSParams));
    }

    @Override
    public LCSMatchResult strAlgoLCSKeys(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.executeCommand(this.commandObjects.strAlgoLCSKeys(byArray, byArray2, strAlgoLCSParams));
    }

    @Override
    public LCSMatchResult lcs(String string, String string2, LCSParams lCSParams) {
        return this.executeCommand(this.commandObjects.lcs(string, string2, lCSParams));
    }

    @Override
    public LCSMatchResult lcs(byte[] byArray, byte[] byArray2, LCSParams lCSParams) {
        return this.executeCommand(this.commandObjects.lcs(byArray, byArray2, lCSParams));
    }

    @Override
    public long rpush(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.rpush(string, stringArray));
    }

    @Override
    public long lpush(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.lpush(string, stringArray));
    }

    @Override
    public long llen(String string) {
        return this.executeCommand(this.commandObjects.llen(string));
    }

    @Override
    public List<String> lrange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.lrange(string, l2, l3));
    }

    @Override
    public String ltrim(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.ltrim(string, l2, l3));
    }

    @Override
    public String lindex(String string, long l2) {
        return this.executeCommand(this.commandObjects.lindex(string, l2));
    }

    @Override
    public long rpush(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.rpush(byArray, byArray2));
    }

    @Override
    public long lpush(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.lpush(byArray, byArray2));
    }

    @Override
    public long llen(byte[] byArray) {
        return this.executeCommand(this.commandObjects.llen(byArray));
    }

    @Override
    public List<byte[]> lrange(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.lrange(byArray, l2, l3));
    }

    @Override
    public String ltrim(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.ltrim(byArray, l2, l3));
    }

    @Override
    public byte[] lindex(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.lindex(byArray, l2));
    }

    @Override
    public String lset(String string, long l2, String string2) {
        return this.executeCommand(this.commandObjects.lset(string, l2, string2));
    }

    @Override
    public long lrem(String string, long l2, String string2) {
        return this.executeCommand(this.commandObjects.lrem(string, l2, string2));
    }

    @Override
    public String lpop(String string) {
        return this.executeCommand(this.commandObjects.lpop(string));
    }

    @Override
    public List<String> lpop(String string, int n2) {
        return this.executeCommand(this.commandObjects.lpop(string, n2));
    }

    @Override
    public String lset(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.lset(byArray, l2, byArray2));
    }

    @Override
    public long lrem(byte[] byArray, long l2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.lrem(byArray, l2, byArray2));
    }

    @Override
    public byte[] lpop(byte[] byArray) {
        return this.executeCommand(this.commandObjects.lpop(byArray));
    }

    @Override
    public List<byte[]> lpop(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.lpop(byArray, n2));
    }

    @Override
    public Long lpos(String string, String string2) {
        return this.executeCommand(this.commandObjects.lpos(string, string2));
    }

    @Override
    public Long lpos(String string, String string2, LPosParams lPosParams) {
        return this.executeCommand(this.commandObjects.lpos(string, string2, lPosParams));
    }

    @Override
    public List<Long> lpos(String string, String string2, LPosParams lPosParams, long l2) {
        return this.executeCommand(this.commandObjects.lpos(string, string2, lPosParams, l2));
    }

    @Override
    public Long lpos(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.lpos(byArray, byArray2));
    }

    @Override
    public Long lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams) {
        return this.executeCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams));
    }

    @Override
    public List<Long> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams, long l2) {
        return this.executeCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams, l2));
    }

    @Override
    public String rpop(String string) {
        return this.executeCommand(this.commandObjects.rpop(string));
    }

    @Override
    public List<String> rpop(String string, int n2) {
        return this.executeCommand(this.commandObjects.rpop(string, n2));
    }

    @Override
    public byte[] rpop(byte[] byArray) {
        return this.executeCommand(this.commandObjects.rpop(byArray));
    }

    @Override
    public List<byte[]> rpop(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.rpop(byArray, n2));
    }

    @Override
    public long linsert(String string, ListPosition listPosition, String string2, String string3) {
        return this.executeCommand(this.commandObjects.linsert(string, listPosition, string2, string3));
    }

    @Override
    public long lpushx(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.lpushx(string, stringArray));
    }

    @Override
    public long rpushx(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.rpushx(string, stringArray));
    }

    @Override
    public long linsert(byte[] byArray, ListPosition listPosition, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.linsert(byArray, listPosition, byArray2, byArray3));
    }

    @Override
    public long lpushx(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.lpushx(byArray, byArray2));
    }

    @Override
    public long rpushx(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.rpushx(byArray, byArray2));
    }

    @Override
    public List<String> blpop(int n2, String string) {
        return this.executeCommand(this.commandObjects.blpop(n2, string));
    }

    @Override
    public KeyedListElement blpop(double d2, String string) {
        return this.executeCommand(this.commandObjects.blpop(d2, string));
    }

    @Override
    public List<String> brpop(int n2, String string) {
        return this.executeCommand(this.commandObjects.brpop(n2, string));
    }

    @Override
    public KeyedListElement brpop(double d2, String string) {
        return this.executeCommand(this.commandObjects.brpop(d2, string));
    }

    @Override
    public List<String> blpop(int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.blpop(n2, stringArray));
    }

    @Override
    public KeyedListElement blpop(double d2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.blpop(d2, stringArray));
    }

    @Override
    public List<String> brpop(int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.brpop(n2, stringArray));
    }

    @Override
    public KeyedListElement brpop(double d2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.brpop(d2, stringArray));
    }

    @Override
    public List<byte[]> blpop(int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.blpop(n2, byArray));
    }

    @Override
    public List<byte[]> blpop(double d2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.blpop(d2, byArray));
    }

    @Override
    public List<byte[]> brpop(int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.brpop(n2, byArray));
    }

    @Override
    public List<byte[]> brpop(double d2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.brpop(d2, byArray));
    }

    @Override
    public String rpoplpush(String string, String string2) {
        return this.executeCommand(this.commandObjects.rpoplpush(string, string2));
    }

    @Override
    public String brpoplpush(String string, String string2, int n2) {
        return this.executeCommand(this.commandObjects.brpoplpush(string, string2, n2));
    }

    @Override
    public byte[] rpoplpush(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.rpoplpush(byArray, byArray2));
    }

    @Override
    public byte[] brpoplpush(byte[] byArray, byte[] byArray2, int n2) {
        return this.executeCommand(this.commandObjects.brpoplpush(byArray, byArray2, n2));
    }

    @Override
    public String lmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2) {
        return this.executeCommand(this.commandObjects.lmove(string, string2, listDirection, listDirection2));
    }

    @Override
    public String blmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return this.executeCommand(this.commandObjects.blmove(string, string2, listDirection, listDirection2, d2));
    }

    @Override
    public byte[] lmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2) {
        return this.executeCommand(this.commandObjects.lmove(byArray, byArray2, listDirection, listDirection2));
    }

    @Override
    public byte[] blmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return this.executeCommand(this.commandObjects.blmove(byArray, byArray2, listDirection, listDirection2, d2));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection listDirection, String ... stringArray) {
        return this.executeCommand(this.commandObjects.lmpop(listDirection, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection listDirection, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.lmpop(listDirection, n2, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(long l2, ListDirection listDirection, String ... stringArray) {
        return this.executeCommand(this.commandObjects.blmpop(l2, listDirection, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(long l2, ListDirection listDirection, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.blmpop(l2, listDirection, n2, stringArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection listDirection, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.lmpop(listDirection, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection listDirection, int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.lmpop(listDirection, n2, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(long l2, ListDirection listDirection, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.blmpop(l2, listDirection, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(long l2, ListDirection listDirection, int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.blmpop(l2, listDirection, n2, byArray));
    }

    @Override
    public long hset(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.hset(string, string2, string3));
    }

    @Override
    public long hset(String string, Map<String, String> map) {
        return this.executeCommand(this.commandObjects.hset(string, map));
    }

    @Override
    public String hget(String string, String string2) {
        return this.executeCommand(this.commandObjects.hget(string, string2));
    }

    @Override
    public long hsetnx(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.hsetnx(string, string2, string3));
    }

    @Override
    public String hmset(String string, Map<String, String> map) {
        return this.executeCommand(this.commandObjects.hmset(string, map));
    }

    @Override
    public List<String> hmget(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.hmget(string, stringArray));
    }

    @Override
    public long hset(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.hset(byArray, byArray2, byArray3));
    }

    @Override
    public long hset(byte[] byArray, Map<byte[], byte[]> map) {
        return this.executeCommand(this.commandObjects.hset(byArray, map));
    }

    @Override
    public byte[] hget(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.hget(byArray, byArray2));
    }

    @Override
    public long hsetnx(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.hsetnx(byArray, byArray2, byArray3));
    }

    @Override
    public String hmset(byte[] byArray, Map<byte[], byte[]> map) {
        return this.executeCommand(this.commandObjects.hmset(byArray, map));
    }

    @Override
    public List<byte[]> hmget(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.hmget(byArray, byArray2));
    }

    @Override
    public long hincrBy(String string, String string2, long l2) {
        return this.executeCommand(this.commandObjects.hincrBy(string, string2, l2));
    }

    @Override
    public double hincrByFloat(String string, String string2, double d2) {
        return this.executeCommand(this.commandObjects.hincrByFloat(string, string2, d2));
    }

    @Override
    public boolean hexists(String string, String string2) {
        return this.executeCommand(this.commandObjects.hexists(string, string2));
    }

    @Override
    public long hdel(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.hdel(string, stringArray));
    }

    @Override
    public long hlen(String string) {
        return this.executeCommand(this.commandObjects.hlen(string));
    }

    @Override
    public long hincrBy(byte[] byArray, byte[] byArray2, long l2) {
        return this.executeCommand(this.commandObjects.hincrBy(byArray, byArray2, l2));
    }

    @Override
    public double hincrByFloat(byte[] byArray, byte[] byArray2, double d2) {
        return this.executeCommand(this.commandObjects.hincrByFloat(byArray, byArray2, d2));
    }

    @Override
    public boolean hexists(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.hexists(byArray, byArray2));
    }

    @Override
    public long hdel(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.hdel(byArray, byArray2));
    }

    @Override
    public long hlen(byte[] byArray) {
        return this.executeCommand(this.commandObjects.hlen(byArray));
    }

    @Override
    public Set<String> hkeys(String string) {
        return this.executeCommand(this.commandObjects.hkeys(string));
    }

    @Override
    public List<String> hvals(String string) {
        return this.executeCommand(this.commandObjects.hvals(string));
    }

    @Override
    public Map<String, String> hgetAll(String string) {
        return this.executeCommand(this.commandObjects.hgetAll(string));
    }

    @Override
    public Set<byte[]> hkeys(byte[] byArray) {
        return this.executeCommand(this.commandObjects.hkeys(byArray));
    }

    @Override
    public List<byte[]> hvals(byte[] byArray) {
        return this.executeCommand(this.commandObjects.hvals(byArray));
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] byArray) {
        return this.executeCommand(this.commandObjects.hgetAll(byArray));
    }

    @Override
    public String hrandfield(String string) {
        return this.executeCommand(this.commandObjects.hrandfield(string));
    }

    @Override
    public List<String> hrandfield(String string, long l2) {
        return this.executeCommand(this.commandObjects.hrandfield(string, l2));
    }

    @Override
    public Map<String, String> hrandfieldWithValues(String string, long l2) {
        return this.executeCommand(this.commandObjects.hrandfieldWithValues(string, l2));
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String string, String string2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.hscan(string, string2, scanParams));
    }

    @Override
    public long hstrlen(String string, String string2) {
        return this.executeCommand(this.commandObjects.hstrlen(string, string2));
    }

    @Override
    public byte[] hrandfield(byte[] byArray) {
        return this.executeCommand(this.commandObjects.hrandfield(byArray));
    }

    @Override
    public List<byte[]> hrandfield(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.hrandfield(byArray, l2));
    }

    @Override
    public Map<byte[], byte[]> hrandfieldWithValues(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.hrandfieldWithValues(byArray, l2));
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.hscan(byArray, byArray2, scanParams));
    }

    @Override
    public long hstrlen(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.hstrlen(byArray, byArray2));
    }

    @Override
    public long sadd(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.sadd(string, stringArray));
    }

    @Override
    public Set<String> smembers(String string) {
        return this.executeCommand(this.commandObjects.smembers(string));
    }

    @Override
    public long srem(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.srem(string, stringArray));
    }

    @Override
    public String spop(String string) {
        return this.executeCommand(this.commandObjects.spop(string));
    }

    @Override
    public Set<String> spop(String string, long l2) {
        return this.executeCommand(this.commandObjects.spop(string, l2));
    }

    @Override
    public long scard(String string) {
        return this.executeCommand(this.commandObjects.scard(string));
    }

    @Override
    public boolean sismember(String string, String string2) {
        return this.executeCommand(this.commandObjects.sismember(string, string2));
    }

    @Override
    public List<Boolean> smismember(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.smismember(string, stringArray));
    }

    @Override
    public long sadd(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.sadd(byArray, byArray2));
    }

    @Override
    public Set<byte[]> smembers(byte[] byArray) {
        return this.executeCommand(this.commandObjects.smembers(byArray));
    }

    @Override
    public long srem(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.srem(byArray, byArray2));
    }

    @Override
    public byte[] spop(byte[] byArray) {
        return this.executeCommand(this.commandObjects.spop(byArray));
    }

    @Override
    public Set<byte[]> spop(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.spop(byArray, l2));
    }

    @Override
    public long scard(byte[] byArray) {
        return this.executeCommand(this.commandObjects.scard(byArray));
    }

    @Override
    public boolean sismember(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.sismember(byArray, byArray2));
    }

    @Override
    public List<Boolean> smismember(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.smismember(byArray, byArray2));
    }

    @Override
    public String srandmember(String string) {
        return this.executeCommand(this.commandObjects.srandmember(string));
    }

    @Override
    public List<String> srandmember(String string, int n2) {
        return this.executeCommand(this.commandObjects.srandmember(string, n2));
    }

    @Override
    public ScanResult<String> sscan(String string, String string2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.sscan(string, string2, scanParams));
    }

    @Override
    public byte[] srandmember(byte[] byArray) {
        return this.executeCommand(this.commandObjects.srandmember(byArray));
    }

    @Override
    public List<byte[]> srandmember(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.srandmember(byArray, n2));
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.sscan(byArray, byArray2, scanParams));
    }

    @Override
    public Set<String> sdiff(String ... stringArray) {
        return this.executeCommand(this.commandObjects.sdiff(stringArray));
    }

    @Override
    public long sdiffstore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.sdiffstore(string, stringArray));
    }

    @Override
    public Set<String> sinter(String ... stringArray) {
        return this.executeCommand(this.commandObjects.sinter(stringArray));
    }

    @Override
    public long sinterstore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.sinterstore(string, stringArray));
    }

    @Override
    public long sintercard(String ... stringArray) {
        return this.executeCommand(this.commandObjects.sintercard(stringArray));
    }

    @Override
    public long sintercard(int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.sintercard(n2, stringArray));
    }

    @Override
    public Set<String> sunion(String ... stringArray) {
        return this.executeCommand(this.commandObjects.sunion(stringArray));
    }

    @Override
    public long sunionstore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.sunionstore(string, stringArray));
    }

    @Override
    public long smove(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.smove(string, string2, string3));
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.sdiff(byArray));
    }

    @Override
    public long sdiffstore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.sdiffstore(byArray, byArray2));
    }

    @Override
    public Set<byte[]> sinter(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.sinter(byArray));
    }

    @Override
    public long sinterstore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.sinterstore(byArray, byArray2));
    }

    @Override
    public long sintercard(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.sintercard(byArray));
    }

    @Override
    public long sintercard(int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.sintercard(n2, byArray));
    }

    @Override
    public Set<byte[]> sunion(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.sunion(byArray));
    }

    @Override
    public long sunionstore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.sunionstore(byArray, byArray2));
    }

    @Override
    public long smove(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.smove(byArray, byArray2, byArray3));
    }

    @Override
    public long zadd(String string, double d2, String string2) {
        return this.executeCommand(this.commandObjects.zadd(string, d2, string2));
    }

    @Override
    public long zadd(String string, double d2, String string2, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zadd(string, d2, string2, zAddParams));
    }

    @Override
    public long zadd(String string, Map<String, Double> map) {
        return this.executeCommand(this.commandObjects.zadd(string, map));
    }

    @Override
    public long zadd(String string, Map<String, Double> map, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zadd(string, map, zAddParams));
    }

    @Override
    public Double zaddIncr(String string, double d2, String string2, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zaddIncr(string, d2, string2, zAddParams));
    }

    @Override
    public long zadd(byte[] byArray, double d2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.zadd(byArray, d2, byArray2));
    }

    @Override
    public long zadd(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zadd(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public long zadd(byte[] byArray, Map<byte[], Double> map) {
        return this.executeCommand(this.commandObjects.zadd(byArray, map));
    }

    @Override
    public long zadd(byte[] byArray, Map<byte[], Double> map, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zadd(byArray, map, zAddParams));
    }

    @Override
    public Double zaddIncr(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return this.executeCommand(this.commandObjects.zaddIncr(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public long zrem(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zrem(string, stringArray));
    }

    @Override
    public double zincrby(String string, double d2, String string2) {
        return this.executeCommand(this.commandObjects.zincrby(string, d2, string2));
    }

    @Override
    public Double zincrby(String string, double d2, String string2, ZIncrByParams zIncrByParams) {
        return this.executeCommand(this.commandObjects.zincrby(string, d2, string2, zIncrByParams));
    }

    @Override
    public Long zrank(String string, String string2) {
        return this.executeCommand(this.commandObjects.zrank(string, string2));
    }

    @Override
    public Long zrevrank(String string, String string2) {
        return this.executeCommand(this.commandObjects.zrevrank(string, string2));
    }

    @Override
    public long zrem(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zrem(byArray, byArray2));
    }

    @Override
    public double zincrby(byte[] byArray, double d2, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.zincrby(byArray, d2, byArray2));
    }

    @Override
    public Double zincrby(byte[] byArray, double d2, byte[] byArray2, ZIncrByParams zIncrByParams) {
        return this.executeCommand(this.commandObjects.zincrby(byArray, d2, byArray2, zIncrByParams));
    }

    @Override
    public Long zrank(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.zrank(byArray, byArray2));
    }

    @Override
    public Long zrevrank(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.zrevrank(byArray, byArray2));
    }

    @Override
    public String zrandmember(String string) {
        return this.executeCommand(this.commandObjects.zrandmember(string));
    }

    @Override
    public List<String> zrandmember(String string, long l2) {
        return this.executeCommand(this.commandObjects.zrandmember(string, l2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(String string, long l2) {
        return this.executeCommand(this.commandObjects.zrandmemberWithScores(string, l2));
    }

    @Override
    public long zcard(String string) {
        return this.executeCommand(this.commandObjects.zcard(string));
    }

    @Override
    public Double zscore(String string, String string2) {
        return this.executeCommand(this.commandObjects.zscore(string, string2));
    }

    @Override
    public List<Double> zmscore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zmscore(string, stringArray));
    }

    @Override
    public byte[] zrandmember(byte[] byArray) {
        return this.executeCommand(this.commandObjects.zrandmember(byArray));
    }

    @Override
    public List<byte[]> zrandmember(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.zrandmember(byArray, l2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(byte[] byArray, long l2) {
        return this.executeCommand(this.commandObjects.zrandmemberWithScores(byArray, l2));
    }

    @Override
    public long zcard(byte[] byArray) {
        return this.executeCommand(this.commandObjects.zcard(byArray));
    }

    @Override
    public Double zscore(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.zscore(byArray, byArray2));
    }

    @Override
    public List<Double> zmscore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zmscore(byArray, byArray2));
    }

    @Override
    public Tuple zpopmax(String string) {
        return this.executeCommand(this.commandObjects.zpopmax(string));
    }

    @Override
    public List<Tuple> zpopmax(String string, int n2) {
        return this.executeCommand(this.commandObjects.zpopmax(string, n2));
    }

    @Override
    public Tuple zpopmin(String string) {
        return this.executeCommand(this.commandObjects.zpopmin(string));
    }

    @Override
    public List<Tuple> zpopmin(String string, int n2) {
        return this.executeCommand(this.commandObjects.zpopmin(string, n2));
    }

    @Override
    public long zcount(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zcount(string, d2, d3));
    }

    @Override
    public long zcount(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zcount(string, string2, string3));
    }

    @Override
    public Tuple zpopmax(byte[] byArray) {
        return this.executeCommand(this.commandObjects.zpopmax(byArray));
    }

    @Override
    public List<Tuple> zpopmax(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.zpopmax(byArray, n2));
    }

    @Override
    public Tuple zpopmin(byte[] byArray) {
        return this.executeCommand(this.commandObjects.zpopmin(byArray));
    }

    @Override
    public List<Tuple> zpopmin(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.zpopmin(byArray, n2));
    }

    @Override
    public long zcount(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zcount(byArray, d2, d3));
    }

    @Override
    public long zcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zcount(byArray, byArray2, byArray3));
    }

    @Override
    public List<String> zrange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrange(string, l2, l3));
    }

    @Override
    public List<String> zrevrange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrevrange(string, l2, l3));
    }

    @Override
    public List<Tuple> zrangeWithScores(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(string, l2, l3));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrevrangeWithScores(string, l2, l3));
    }

    @Override
    public List<String> zrange(String string, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrange(string, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(String string, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(string, zRangeParams));
    }

    @Override
    public long zrangestore(String string, String string2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangestore(string, string2, zRangeParams));
    }

    @Override
    public List<String> zrangeByScore(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(string, d2, d3));
    }

    @Override
    public List<String> zrangeByScore(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(string, string2, string3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(string, d2, d3));
    }

    @Override
    public List<String> zrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(string, string2, string3));
    }

    @Override
    public List<String> zrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public List<byte[]> zrange(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrange(byArray, l2, l3));
    }

    @Override
    public List<byte[]> zrevrange(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrevrange(byArray, l2, l3));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(byArray, l2, l3));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zrevrangeWithScores(byArray, l2, l3));
    }

    @Override
    public List<byte[]> zrange(byte[] byArray, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrange(byArray, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] byArray, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangeWithScores(byArray, zRangeParams));
    }

    @Override
    public long zrangestore(byte[] byArray, byte[] byArray2, ZRangeParams zRangeParams) {
        return this.executeCommand(this.commandObjects.zrangestore(byArray, byArray2, zRangeParams));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(byArray, d2, d3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(byArray, d2, d3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScore(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public long zremrangeByRank(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zremrangeByRank(string, l2, l3));
    }

    @Override
    public long zremrangeByScore(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(string, d2, d3));
    }

    @Override
    public long zremrangeByScore(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(string, string2, string3));
    }

    @Override
    public long zremrangeByRank(byte[] byArray, long l2, long l3) {
        return this.executeCommand(this.commandObjects.zremrangeByRank(byArray, l2, l3));
    }

    @Override
    public long zremrangeByScore(byte[] byArray, double d2, double d3) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(byArray, d2, d3));
    }

    @Override
    public long zremrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zremrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public long zlexcount(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zlexcount(string, string2, string3));
    }

    @Override
    public List<String> zrangeByLex(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrangeByLex(string, string2, string3));
    }

    @Override
    public List<String> zrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByLex(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(string, string2, string3));
    }

    @Override
    public List<String> zrevrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public long zremrangeByLex(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.zremrangeByLex(string, string2, string3));
    }

    @Override
    public long zlexcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zlexcount(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.executeCommand(this.commandObjects.zrevrangeByLex(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public long zremrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.zremrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public ScanResult<Tuple> zscan(String string, String string2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.zscan(string, string2, scanParams));
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.executeCommand(this.commandObjects.zscan(byArray, byArray2, scanParams));
    }

    @Override
    public KeyedZSetElement bzpopmax(double d2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bzpopmax(d2, stringArray));
    }

    @Override
    public KeyedZSetElement bzpopmin(double d2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bzpopmin(d2, stringArray));
    }

    @Override
    public List<byte[]> bzpopmax(double d2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.bzpopmax(d2, byArray));
    }

    @Override
    public List<byte[]> bzpopmin(double d2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.bzpopmin(d2, byArray));
    }

    @Override
    public Set<String> zdiff(String ... stringArray) {
        return this.executeCommand(this.commandObjects.zdiff(stringArray));
    }

    @Override
    public Set<Tuple> zdiffWithScores(String ... stringArray) {
        return this.executeCommand(this.commandObjects.zdiffWithScores(stringArray));
    }

    @Override
    public long zdiffStore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zdiffStore(string, stringArray));
    }

    @Override
    public Set<byte[]> zdiff(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zdiff(byArray));
    }

    @Override
    public Set<Tuple> zdiffWithScores(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zdiffWithScores(byArray));
    }

    @Override
    public long zdiffStore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zdiffStore(byArray, byArray2));
    }

    @Override
    public long zinterstore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zinterstore(string, stringArray));
    }

    @Override
    public long zinterstore(String string, ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zinterstore(string, zParams, stringArray));
    }

    @Override
    public Set<String> zinter(ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zinter(zParams, stringArray));
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zinterWithScores(zParams, stringArray));
    }

    @Override
    public long zinterstore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zinterstore(byArray, byArray2));
    }

    @Override
    public long zinterstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zinterstore(byArray, zParams, byArray2));
    }

    @Override
    public long zintercard(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zintercard(byArray));
    }

    @Override
    public long zintercard(long l2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zintercard(l2, byArray));
    }

    @Override
    public long zintercard(String ... stringArray) {
        return this.executeCommand(this.commandObjects.zintercard(stringArray));
    }

    @Override
    public long zintercard(long l2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zintercard(l2, stringArray));
    }

    @Override
    public Set<byte[]> zinter(ZParams zParams, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zinter(zParams, byArray));
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams zParams, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zinterWithScores(zParams, byArray));
    }

    @Override
    public Set<String> zunion(ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zunion(zParams, stringArray));
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zunionWithScores(zParams, stringArray));
    }

    @Override
    public long zunionstore(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zunionstore(string, stringArray));
    }

    @Override
    public long zunionstore(String string, ZParams zParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zunionstore(string, zParams, stringArray));
    }

    @Override
    public Set<byte[]> zunion(ZParams zParams, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zunion(zParams, byArray));
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams zParams, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zunionWithScores(zParams, byArray));
    }

    @Override
    public long zunionstore(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zunionstore(byArray, byArray2));
    }

    @Override
    public long zunionstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.zunionstore(byArray, zParams, byArray2));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption sortedSetOption, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zmpop(sortedSetOption, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.zmpop(sortedSetOption, n2, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, stringArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption sortedSetOption, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zmpop(sortedSetOption, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.zmpop(sortedSetOption, n2, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, byArray));
    }

    @Override
    public long geoadd(String string, double d2, double d3, String string2) {
        return this.executeCommand(this.commandObjects.geoadd(string, d2, d3, string2));
    }

    @Override
    public long geoadd(String string, Map<String, GeoCoordinate> map) {
        return this.executeCommand(this.commandObjects.geoadd(string, map));
    }

    @Override
    public long geoadd(String string, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        return this.executeCommand(this.commandObjects.geoadd(string, geoAddParams, map));
    }

    @Override
    public Double geodist(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.geodist(string, string2, string3));
    }

    @Override
    public Double geodist(String string, String string2, String string3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geodist(string, string2, string3, geoUnit));
    }

    @Override
    public List<String> geohash(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.geohash(string, stringArray));
    }

    @Override
    public List<GeoCoordinate> geopos(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.geopos(string, stringArray));
    }

    @Override
    public long geoadd(byte[] byArray, double d2, double d3, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.geoadd(byArray, d2, d3, byArray2));
    }

    @Override
    public long geoadd(byte[] byArray, Map<byte[], GeoCoordinate> map) {
        return this.executeCommand(this.commandObjects.geoadd(byArray, map));
    }

    @Override
    public long geoadd(byte[] byArray, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        return this.executeCommand(this.commandObjects.geoadd(byArray, geoAddParams, map));
    }

    @Override
    public Double geodist(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.geodist(byArray, byArray2, byArray3));
    }

    @Override
    public Double geodist(byte[] byArray, byte[] byArray2, byte[] byArray3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geodist(byArray, byArray2, byArray3, geoUnit));
    }

    @Override
    public List<byte[]> geohash(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.geohash(byArray, byArray2));
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.geopos(byArray, byArray2));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusStore(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.executeCommand(this.commandObjects.georadiusStore(string, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public long georadiusByMemberStore(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberStore(string, string2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, String string2, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(string, string2, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearch(string, geoSearchParam));
    }

    @Override
    public long geosearchStore(String string, String string2, String string3, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, String string3, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearchStore(string, string2, geoSearchParam));
    }

    @Override
    public long geosearchStoreStoreDist(String string, String string2, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearchStoreStoreDist(string, string2, geoSearchParam));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusStore(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.executeCommand(this.commandObjects.georadiusStore(byArray, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public long georadiusByMemberStore(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.executeCommand(this.commandObjects.georadiusByMemberStore(byArray, byArray2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, byte[] byArray2, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(byArray, byArray2, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearch(byArray, geoSearchParam));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoSearchParam));
    }

    @Override
    public long geosearchStoreStoreDist(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return this.executeCommand(this.commandObjects.geosearchStoreStoreDist(byArray, byArray2, geoSearchParam));
    }

    @Override
    public long pfadd(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.pfadd(string, stringArray));
    }

    @Override
    public String pfmerge(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.pfmerge(string, stringArray));
    }

    @Override
    public long pfcount(String string) {
        return this.executeCommand(this.commandObjects.pfcount(string));
    }

    @Override
    public long pfcount(String ... stringArray) {
        return this.executeCommand(this.commandObjects.pfcount(stringArray));
    }

    @Override
    public long pfadd(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.pfadd(byArray, byArray2));
    }

    @Override
    public String pfmerge(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.pfmerge(byArray, byArray2));
    }

    @Override
    public long pfcount(byte[] byArray) {
        return this.executeCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public long pfcount(byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public StreamEntryID xadd(String string, StreamEntryID streamEntryID, Map<String, String> map) {
        return this.executeCommand(this.commandObjects.xadd(string, streamEntryID, map));
    }

    @Override
    public StreamEntryID xadd(String string, XAddParams xAddParams, Map<String, String> map) {
        return this.executeCommand(this.commandObjects.xadd(string, xAddParams, map));
    }

    @Override
    public long xlen(String string) {
        return this.executeCommand(this.commandObjects.xlen(string));
    }

    @Override
    public List<StreamEntry> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return this.executeCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2));
    }

    @Override
    public List<StreamEntry> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return this.executeCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2, n2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return this.executeCommand(this.commandObjects.xrevrange(string, streamEntryID, streamEntryID2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return this.executeCommand(this.commandObjects.xrevrange(string, streamEntryID, streamEntryID2, n2));
    }

    @Override
    public List<StreamEntry> xrange(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.xrange(string, string2, string3));
    }

    @Override
    public List<StreamEntry> xrange(String string, String string2, String string3, int n2) {
        return this.executeCommand(this.commandObjects.xrange(string, string2, string3, n2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.xrevrange(string, string2, string3));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, String string2, String string3, int n2) {
        return this.executeCommand(this.commandObjects.xrevrange(string, string2, string3, n2));
    }

    @Override
    public long xack(String string, String string2, StreamEntryID ... streamEntryIDArray) {
        return this.executeCommand(this.commandObjects.xack(string, string2, streamEntryIDArray));
    }

    @Override
    public String xgroupCreate(String string, String string2, StreamEntryID streamEntryID, boolean bl) {
        return this.executeCommand(this.commandObjects.xgroupCreate(string, string2, streamEntryID, bl));
    }

    @Override
    public String xgroupSetID(String string, String string2, StreamEntryID streamEntryID) {
        return this.executeCommand(this.commandObjects.xgroupSetID(string, string2, streamEntryID));
    }

    @Override
    public long xgroupDestroy(String string, String string2) {
        return this.executeCommand(this.commandObjects.xgroupDestroy(string, string2));
    }

    @Override
    public boolean xgroupCreateConsumer(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.xgroupCreateConsumer(string, string2, string3));
    }

    @Override
    public long xgroupDelConsumer(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.xgroupDelConsumer(string, string2, string3));
    }

    @Override
    public StreamPendingSummary xpending(String string, String string2) {
        return this.executeCommand(this.commandObjects.xpending(string, string2));
    }

    @Override
    public List<StreamPendingEntry> xpending(String string, String string2, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2, String string3) {
        return this.executeCommand(this.commandObjects.xpending(string, string2, streamEntryID, streamEntryID2, n2, string3));
    }

    @Override
    public List<StreamPendingEntry> xpending(String string, String string2, XPendingParams xPendingParams) {
        return this.executeCommand(this.commandObjects.xpending(string, string2, xPendingParams));
    }

    @Override
    public long xdel(String string, StreamEntryID ... streamEntryIDArray) {
        return this.executeCommand(this.commandObjects.xdel(string, streamEntryIDArray));
    }

    @Override
    public long xtrim(String string, long l2, boolean bl) {
        return this.executeCommand(this.commandObjects.xtrim(string, l2, bl));
    }

    @Override
    public long xtrim(String string, XTrimParams xTrimParams) {
        return this.executeCommand(this.commandObjects.xtrim(string, xTrimParams));
    }

    @Override
    public List<StreamEntry> xclaim(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return this.executeCommand(this.commandObjects.xclaim(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public List<StreamEntryID> xclaimJustId(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return this.executeCommand(this.commandObjects.xclaimJustId(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return this.executeCommand(this.commandObjects.xautoclaim(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return this.executeCommand(this.commandObjects.xautoclaimJustId(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public StreamInfo xinfoStream(String string) {
        return this.executeCommand(this.commandObjects.xinfoStream(string));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String string) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(string));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String string, int n2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(string, n2));
    }

    @Override
    @Deprecated
    public List<StreamGroupInfo> xinfoGroup(String string) {
        return this.executeCommand(this.commandObjects.xinfoGroup(string));
    }

    @Override
    public List<StreamGroupInfo> xinfoGroups(String string) {
        return this.executeCommand(this.commandObjects.xinfoGroups(string));
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(String string, String string2) {
        return this.executeCommand(this.commandObjects.xinfoConsumers(string, string2));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> map) {
        return this.executeCommand(this.commandObjects.xread(xReadParams, map));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String string, String string2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> map) {
        return this.executeCommand(this.commandObjects.xreadGroup(string, string2, xReadGroupParams, map));
    }

    @Override
    public byte[] xadd(byte[] byArray, XAddParams xAddParams, Map<byte[], byte[]> map) {
        return this.executeCommand(this.commandObjects.xadd(byArray, xAddParams, map));
    }

    @Override
    public long xlen(byte[] byArray) {
        return this.executeCommand(this.commandObjects.xlen(byArray));
    }

    @Override
    public List<byte[]> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.xrange(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return this.executeCommand(this.commandObjects.xrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public List<byte[]> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return this.executeCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public long xack(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        return this.executeCommand(this.commandObjects.xack(byArray, byArray2, byArray3));
    }

    @Override
    public String xgroupCreate(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        return this.executeCommand(this.commandObjects.xgroupCreate(byArray, byArray2, byArray3, bl));
    }

    @Override
    public String xgroupSetID(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.xgroupSetID(byArray, byArray2, byArray3));
    }

    @Override
    public long xgroupDestroy(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.xgroupDestroy(byArray, byArray2));
    }

    @Override
    public boolean xgroupCreateConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.xgroupCreateConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public long xgroupDelConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.executeCommand(this.commandObjects.xgroupDelConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public long xdel(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.xdel(byArray, byArray2));
    }

    @Override
    public long xtrim(byte[] byArray, long l2, boolean bl) {
        return this.executeCommand(this.commandObjects.xtrim(byArray, l2, bl));
    }

    @Override
    public long xtrim(byte[] byArray, XTrimParams xTrimParams) {
        return this.executeCommand(this.commandObjects.xtrim(byArray, xTrimParams));
    }

    @Override
    public Object xpending(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.xpending(byArray, byArray2));
    }

    @Override
    public List<Object> xpending(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, byte[] byArray5) {
        return this.executeCommand(this.commandObjects.xpending(byArray, byArray2, byArray3, byArray4, n2, byArray5));
    }

    @Override
    public List<Object> xpending(byte[] byArray, byte[] byArray2, XPendingParams xPendingParams) {
        return this.executeCommand(this.commandObjects.xpending(byArray, byArray2, xPendingParams));
    }

    @Override
    public List<byte[]> xclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return this.executeCommand(this.commandObjects.xclaim(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public List<byte[]> xclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return this.executeCommand(this.commandObjects.xclaimJustId(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public List<Object> xautoclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return this.executeCommand(this.commandObjects.xautoclaim(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public List<Object> xautoclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return this.executeCommand(this.commandObjects.xautoclaimJustId(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public Object xinfoStream(byte[] byArray) {
        return this.executeCommand(this.commandObjects.xinfoStream(byArray));
    }

    @Override
    public Object xinfoStreamFull(byte[] byArray) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(byArray));
    }

    @Override
    public Object xinfoStreamFull(byte[] byArray, int n2) {
        return this.executeCommand(this.commandObjects.xinfoStreamFull(byArray, n2));
    }

    @Override
    @Deprecated
    public List<Object> xinfoGroup(byte[] byArray) {
        return this.executeCommand(this.commandObjects.xinfoGroup(byArray));
    }

    @Override
    public List<Object> xinfoGroups(byte[] byArray) {
        return this.executeCommand(this.commandObjects.xinfoGroups(byArray));
    }

    @Override
    public List<Object> xinfoConsumers(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.xinfoConsumers(byArray, byArray2));
    }

    @Override
    public List<byte[]> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... entryArray) {
        return this.executeCommand(this.commandObjects.xread(xReadParams, entryArray));
    }

    @Override
    public List<byte[]> xreadGroup(byte[] byArray, byte[] byArray2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... entryArray) {
        return this.executeCommand(this.commandObjects.xreadGroup(byArray, byArray2, xReadGroupParams, entryArray));
    }

    @Override
    public Object eval(String string) {
        return this.executeCommand(this.commandObjects.eval(string));
    }

    @Override
    public Object eval(String string, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.eval(string, n2, stringArray));
    }

    @Override
    public Object eval(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.eval(string, list, list2));
    }

    @Override
    public Object evalReadonly(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.evalReadonly(string, list, list2));
    }

    @Override
    public Object evalsha(String string) {
        return this.executeCommand(this.commandObjects.evalsha(string));
    }

    @Override
    public Object evalsha(String string, int n2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.evalsha(string, n2, stringArray));
    }

    @Override
    public Object evalsha(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.evalsha(string, list, list2));
    }

    @Override
    public Object evalshaReadonly(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.evalshaReadonly(string, list, list2));
    }

    @Override
    public Object eval(byte[] byArray) {
        return this.executeCommand(this.commandObjects.eval(byArray));
    }

    @Override
    public Object eval(byte[] byArray, int n2, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.eval(byArray, n2, byArray2));
    }

    @Override
    public Object eval(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.eval(byArray, list, list2));
    }

    @Override
    public Object evalReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.evalReadonly(byArray, list, list2));
    }

    @Override
    public Object evalsha(byte[] byArray) {
        return this.executeCommand(this.commandObjects.evalsha(byArray));
    }

    @Override
    public Object evalsha(byte[] byArray, int n2, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.evalsha(byArray, n2, byArray2));
    }

    @Override
    public Object evalsha(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.evalsha(byArray, list, list2));
    }

    @Override
    public Object evalshaReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.evalshaReadonly(byArray, list, list2));
    }

    @Override
    public Object fcall(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.fcall(string, list, list2));
    }

    @Override
    public Object fcallReadonly(String string, List<String> list, List<String> list2) {
        return this.executeCommand(this.commandObjects.fcallReadonly(string, list, list2));
    }

    @Override
    public String functionDelete(String string) {
        return this.executeCommand(this.commandObjects.functionDelete(string));
    }

    @Override
    public String functionFlush() {
        return this.executeCommand(this.commandObjects.functionFlush());
    }

    @Override
    public String functionFlush(FlushMode flushMode) {
        return this.executeCommand(this.commandObjects.functionFlush(flushMode));
    }

    @Override
    public String functionKill() {
        return this.executeCommand(this.commandObjects.functionKill());
    }

    @Override
    public List<LibraryInfo> functionList() {
        return this.executeCommand(this.commandObjects.functionList());
    }

    @Override
    public List<LibraryInfo> functionList(String string) {
        return this.executeCommand(this.commandObjects.functionList(string));
    }

    @Override
    public List<LibraryInfo> functionListWithCode() {
        return this.executeCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public List<LibraryInfo> functionListWithCode(String string) {
        return this.executeCommand(this.commandObjects.functionListWithCode(string));
    }

    @Override
    public String functionLoad(String string) {
        return this.executeCommand(this.commandObjects.functionLoad(string));
    }

    @Override
    public String functionLoadReplace(String string) {
        return this.executeCommand(this.commandObjects.functionLoadReplace(string));
    }

    @Override
    public FunctionStats functionStats() {
        return this.executeCommand(this.commandObjects.functionStats());
    }

    @Override
    public Object fcall(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.fcall(byArray, list, list2));
    }

    @Override
    public Object fcallReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.executeCommand(this.commandObjects.fcallReadonly(byArray, list, list2));
    }

    @Override
    public String functionDelete(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionDelete(byArray));
    }

    @Override
    public byte[] functionDump() {
        return this.executeCommand(this.commandObjects.functionDump());
    }

    @Override
    public List<Object> functionListBinary() {
        return this.executeCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public List<Object> functionList(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionList(byArray));
    }

    @Override
    public List<Object> functionListWithCodeBinary() {
        return this.executeCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public List<Object> functionListWithCode(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionListWithCode(byArray));
    }

    @Override
    public String functionLoad(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionLoad(byArray));
    }

    @Override
    public String functionLoadReplace(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionLoadReplace(byArray));
    }

    @Override
    public String functionRestore(byte[] byArray) {
        return this.executeCommand(this.commandObjects.functionRestore(byArray));
    }

    @Override
    public String functionRestore(byte[] byArray, FunctionRestorePolicy functionRestorePolicy) {
        return this.executeCommand(this.commandObjects.functionRestore(byArray, functionRestorePolicy));
    }

    @Override
    public Object functionStatsBinary() {
        return this.executeCommand(this.commandObjects.functionStatsBinary());
    }

    @Override
    public Long objectRefcount(String string) {
        return this.executeCommand(this.commandObjects.objectRefcount(string));
    }

    @Override
    public String objectEncoding(String string) {
        return this.executeCommand(this.commandObjects.objectEncoding(string));
    }

    @Override
    public Long objectIdletime(String string) {
        return this.executeCommand(this.commandObjects.objectIdletime(string));
    }

    @Override
    public Long objectFreq(String string) {
        return this.executeCommand(this.commandObjects.objectFreq(string));
    }

    @Override
    public Long objectRefcount(byte[] byArray) {
        return this.executeCommand(this.commandObjects.objectRefcount(byArray));
    }

    @Override
    public byte[] objectEncoding(byte[] byArray) {
        return this.executeCommand(this.commandObjects.objectEncoding(byArray));
    }

    @Override
    public Long objectIdletime(byte[] byArray) {
        return this.executeCommand(this.commandObjects.objectIdletime(byArray));
    }

    @Override
    public Long objectFreq(byte[] byArray) {
        return this.executeCommand(this.commandObjects.objectFreq(byArray));
    }

    @Override
    public String migrate(String string, int n2, String string2, int n3) {
        return this.executeCommand(this.commandObjects.migrate(string, n2, string2, n3));
    }

    @Override
    public String migrate(String string, int n2, int n3, MigrateParams migrateParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, stringArray));
    }

    @Override
    public String migrate(String string, int n2, byte[] byArray, int n3) {
        return this.executeCommand(this.commandObjects.migrate(string, n2, byArray, n3));
    }

    @Override
    public String migrate(String string, int n2, int n3, MigrateParams migrateParams, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, byArray));
    }

    @Override
    public long waitReplicas(String string, int n2, long l2) {
        return this.executeCommand(this.commandObjects.waitReplicas(string, n2, l2));
    }

    @Override
    public long waitReplicas(byte[] byArray, int n2, long l2) {
        return this.executeCommand(this.commandObjects.waitReplicas(byArray, n2, l2));
    }

    @Override
    public Object eval(String string, String string2) {
        return this.executeCommand(this.commandObjects.eval(string, string2));
    }

    @Override
    public Object evalsha(String string, String string2) {
        return this.executeCommand(this.commandObjects.evalsha(string, string2));
    }

    @Override
    public Object eval(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.eval(byArray, byArray2));
    }

    @Override
    public Object evalsha(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.evalsha(byArray, byArray2));
    }

    @Override
    public Boolean scriptExists(String string, String string2) {
        return this.scriptExists(string2, new String[]{string}).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.scriptExists(string, stringArray));
    }

    @Override
    public Boolean scriptExists(byte[] byArray, byte[] byArray2) {
        return this.scriptExists(byArray2, new byte[][]{byArray}).get(0);
    }

    @Override
    public List<Boolean> scriptExists(byte[] byArray, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.scriptExists(byArray, byArray2));
    }

    @Override
    public String scriptLoad(String string, String string2) {
        return this.executeCommand(this.commandObjects.scriptLoad(string, string2));
    }

    @Override
    public String scriptFlush(String string) {
        return this.executeCommand(this.commandObjects.scriptFlush(string));
    }

    @Override
    public String scriptFlush(String string, FlushMode flushMode) {
        return this.executeCommand(this.commandObjects.scriptFlush(string, flushMode));
    }

    @Override
    public String scriptKill(String string) {
        return this.executeCommand(this.commandObjects.scriptKill(string));
    }

    @Override
    public byte[] scriptLoad(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.scriptLoad(byArray, byArray2));
    }

    @Override
    public String scriptFlush(byte[] byArray) {
        return this.executeCommand(this.commandObjects.scriptFlush(byArray));
    }

    @Override
    public String scriptFlush(byte[] byArray, FlushMode flushMode) {
        return this.executeCommand(this.commandObjects.scriptFlush(byArray, flushMode));
    }

    @Override
    public String scriptKill(byte[] byArray) {
        return this.executeCommand(this.commandObjects.scriptKill(byArray));
    }

    public long publish(String string, String string2) {
        return this.executeCommand(this.commandObjects.publish(string, string2));
    }

    public long publish(byte[] byArray, byte[] byArray2) {
        return this.executeCommand(this.commandObjects.publish(byArray, byArray2));
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... stringArray) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceed(connection, stringArray);
        }
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... stringArray) {
        try (Connection connection = this.provider.getConnection();){
            jedisPubSub.proceedWithPatterns(connection, stringArray);
        }
    }

    public void subscribe(BinaryJedisPubSub binaryJedisPubSub, byte[] ... byArray) {
        try (Connection connection = this.provider.getConnection();){
            binaryJedisPubSub.proceed(connection, byArray);
        }
    }

    public void psubscribe(BinaryJedisPubSub binaryJedisPubSub, byte[] ... byArray) {
        try (Connection connection = this.provider.getConnection();){
            binaryJedisPubSub.proceedWithPatterns(connection, byArray);
        }
    }

    public LCSMatchResult strAlgoLCSStrings(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.executeCommand(this.commandObjects.strAlgoLCSStrings(string, string2, strAlgoLCSParams));
    }

    public LCSMatchResult strAlgoLCSStrings(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.executeCommand(this.commandObjects.strAlgoLCSStrings(byArray, byArray2, strAlgoLCSParams));
    }

    @Override
    public String ftCreate(String string, IndexOptions indexOptions, Schema schema) {
        return this.executeCommand(this.commandObjects.ftCreate(string, indexOptions, schema));
    }

    @Override
    public String ftCreate(String string, FTCreateParams fTCreateParams, Iterable<SchemaField> iterable) {
        return this.executeCommand(this.commandObjects.ftCreate(string, fTCreateParams, iterable));
    }

    @Override
    public String ftAlter(String string, Schema schema) {
        return this.executeCommand(this.commandObjects.ftAlter(string, schema));
    }

    @Override
    public String ftAlter(String string, Iterable<SchemaField> iterable) {
        return this.executeCommand(this.commandObjects.ftAlter(string, iterable));
    }

    @Override
    public SearchResult ftSearch(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftSearch(string, string2));
    }

    @Override
    public SearchResult ftSearch(String string, String string2, FTSearchParams fTSearchParams) {
        return this.executeCommand(this.commandObjects.ftSearch(string, string2, fTSearchParams));
    }

    @Override
    public SearchResult ftSearch(String string, Query query) {
        return this.executeCommand(this.commandObjects.ftSearch(string, query));
    }

    @Override
    public SearchResult ftSearch(byte[] byArray, Query query) {
        return this.executeCommand(this.commandObjects.ftSearch(byArray, query));
    }

    @Override
    public String ftExplain(String string, Query query) {
        return this.executeCommand(this.commandObjects.ftExplain(string, query));
    }

    @Override
    public List<String> ftExplainCLI(String string, Query query) {
        return this.executeCommand(this.commandObjects.ftExplainCLI(string, query));
    }

    @Override
    public AggregationResult ftAggregate(String string, AggregationBuilder aggregationBuilder) {
        return this.executeCommand(this.commandObjects.ftAggregate(string, aggregationBuilder));
    }

    @Override
    public AggregationResult ftCursorRead(String string, long l2, int n2) {
        return this.executeCommand(this.commandObjects.ftCursorRead(string, l2, n2));
    }

    @Override
    public String ftCursorDel(String string, long l2) {
        return this.executeCommand(this.commandObjects.ftCursorDel(string, l2));
    }

    @Override
    public String ftDropIndex(String string) {
        return this.executeCommand(this.commandObjects.ftDropIndex(string));
    }

    @Override
    public String ftDropIndexDD(String string) {
        return this.executeCommand(this.commandObjects.ftDropIndexDD(string));
    }

    @Override
    public String ftSynUpdate(String string, String string2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.ftSynUpdate(string, string2, stringArray));
    }

    @Override
    public Map<String, List<String>> ftSynDump(String string) {
        return this.executeCommand(this.commandObjects.ftSynDump(string));
    }

    @Override
    public long ftDictAdd(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.ftDictAdd(string, stringArray));
    }

    @Override
    public long ftDictDel(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.ftDictDel(string, stringArray));
    }

    @Override
    public Set<String> ftDictDump(String string) {
        return this.executeCommand(this.commandObjects.ftDictDump(string));
    }

    @Override
    public long ftDictAddBySampleKey(String string, String string2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.ftDictAddBySampleKey(string, string2, stringArray));
    }

    @Override
    public long ftDictDelBySampleKey(String string, String string2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.ftDictDelBySampleKey(string, string2, stringArray));
    }

    @Override
    public Set<String> ftDictDumpBySampleKey(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftDictDumpBySampleKey(string, string2));
    }

    @Override
    public Map<String, Object> ftInfo(String string) {
        return this.executeCommand(this.commandObjects.ftInfo(string));
    }

    @Override
    public Set<String> ftTagVals(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftTagVals(string, string2));
    }

    @Override
    public String ftAliasAdd(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftAliasAdd(string, string2));
    }

    @Override
    public String ftAliasUpdate(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftAliasUpdate(string, string2));
    }

    @Override
    public String ftAliasDel(String string) {
        return this.executeCommand(this.commandObjects.ftAliasDel(string));
    }

    @Override
    public Map<String, String> ftConfigGet(String string) {
        return this.executeCommand(this.commandObjects.ftConfigGet(string));
    }

    @Override
    public Map<String, String> ftConfigGet(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftConfigGet(string, string2));
    }

    @Override
    public String ftConfigSet(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftConfigSet(string, string2));
    }

    @Override
    public String ftConfigSet(String string, String string2, String string3) {
        return this.executeCommand(this.commandObjects.ftConfigSet(string, string2, string3));
    }

    @Override
    public long ftSugAdd(String string, String string2, double d2) {
        return this.executeCommand(this.commandObjects.ftSugAdd(string, string2, d2));
    }

    @Override
    public long ftSugAddIncr(String string, String string2, double d2) {
        return this.executeCommand(this.commandObjects.ftSugAddIncr(string, string2, d2));
    }

    @Override
    public List<String> ftSugGet(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftSugGet(string, string2));
    }

    @Override
    public List<String> ftSugGet(String string, String string2, boolean bl, int n2) {
        return this.executeCommand(this.commandObjects.ftSugGet(string, string2, bl, n2));
    }

    @Override
    public List<Tuple> ftSugGetWithScores(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftSugGetWithScores(string, string2));
    }

    @Override
    public List<Tuple> ftSugGetWithScores(String string, String string2, boolean bl, int n2) {
        return this.executeCommand(this.commandObjects.ftSugGetWithScores(string, string2, bl, n2));
    }

    @Override
    public boolean ftSugDel(String string, String string2) {
        return this.executeCommand(this.commandObjects.ftSugDel(string, string2));
    }

    @Override
    public long ftSugLen(String string) {
        return this.executeCommand(this.commandObjects.ftSugLen(string));
    }

    @Override
    public String jsonSet(String string, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonSet(string, path2, object));
    }

    @Override
    public String jsonSetWithEscape(String string, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonSetWithEscape(string, path2, object));
    }

    @Override
    public String jsonSet(String string, Path path, Object object) {
        return this.executeCommand(this.commandObjects.jsonSet(string, path, object));
    }

    @Override
    public String jsonSetWithPlainString(String string, Path path, String string2) {
        return this.executeCommand(this.commandObjects.jsonSetWithPlainString(string, path, string2));
    }

    @Override
    public String jsonSet(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return this.executeCommand(this.commandObjects.jsonSet(string, path2, object, jsonSetParams));
    }

    @Override
    public String jsonSetWithEscape(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return this.executeCommand(this.commandObjects.jsonSetWithEscape(string, path2, object, jsonSetParams));
    }

    @Override
    public String jsonSet(String string, Path path, Object object, JsonSetParams jsonSetParams) {
        return this.executeCommand(this.commandObjects.jsonSet(string, path, object, jsonSetParams));
    }

    @Override
    public Object jsonGet(String string) {
        return this.executeCommand(this.commandObjects.jsonGet(string));
    }

    @Override
    public <T> T jsonGet(String string, Class<T> clazz) {
        return this.executeCommand(this.commandObjects.jsonGet(string, clazz));
    }

    @Override
    public Object jsonGet(String string, Path2 ... path2Array) {
        return this.executeCommand(this.commandObjects.jsonGet(string, path2Array));
    }

    @Override
    public Object jsonGet(String string, Path ... pathArray) {
        return this.executeCommand(this.commandObjects.jsonGet(string, pathArray));
    }

    @Override
    public String jsonGetAsPlainString(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonGetAsPlainString(string, path));
    }

    @Override
    public <T> T jsonGet(String string, Class<T> clazz, Path ... pathArray) {
        return this.executeCommand(this.commandObjects.jsonGet(string, clazz, pathArray));
    }

    @Override
    public List<JSONArray> jsonMGet(Path2 path2, String ... stringArray) {
        return this.executeCommand(this.commandObjects.jsonMGet(path2, stringArray));
    }

    @Override
    public <T> List<T> jsonMGet(Path path, Class<T> clazz, String ... stringArray) {
        return this.executeCommand(this.commandObjects.jsonMGet(path, clazz, stringArray));
    }

    @Override
    public long jsonDel(String string) {
        return this.executeCommand(this.commandObjects.jsonDel(string));
    }

    @Override
    public long jsonDel(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonDel(string, path2));
    }

    @Override
    public long jsonDel(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonDel(string, path));
    }

    @Override
    public long jsonClear(String string) {
        return this.executeCommand(this.commandObjects.jsonClear(string));
    }

    @Override
    public long jsonClear(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonClear(string, path2));
    }

    @Override
    public long jsonClear(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonClear(string, path));
    }

    @Override
    public List<Boolean> jsonToggle(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonToggle(string, path2));
    }

    @Override
    public String jsonToggle(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonToggle(string, path));
    }

    @Override
    public Class<?> jsonType(String string) {
        return this.executeCommand(this.commandObjects.jsonType(string));
    }

    @Override
    public List<Class<?>> jsonType(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonType(string, path2));
    }

    @Override
    public Class<?> jsonType(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonType(string, path));
    }

    @Override
    public long jsonStrAppend(String string, Object object) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(string, object));
    }

    @Override
    public List<Long> jsonStrAppend(String string, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(string, path2, object));
    }

    @Override
    public long jsonStrAppend(String string, Path path, Object object) {
        return this.executeCommand(this.commandObjects.jsonStrAppend(string, path, object));
    }

    @Override
    public Long jsonStrLen(String string) {
        return this.executeCommand(this.commandObjects.jsonStrLen(string));
    }

    @Override
    public List<Long> jsonStrLen(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonStrLen(string, path2));
    }

    @Override
    public Long jsonStrLen(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonStrLen(string, path));
    }

    @Override
    public JSONArray jsonNumIncrBy(String string, Path2 path2, double d2) {
        return this.executeCommand(this.commandObjects.jsonNumIncrBy(string, path2, d2));
    }

    @Override
    public double jsonNumIncrBy(String string, Path path, double d2) {
        return this.executeCommand(this.commandObjects.jsonNumIncrBy(string, path, d2));
    }

    @Override
    public List<Long> jsonArrAppend(String string, Path2 path2, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrAppend(string, path2, objectArray));
    }

    @Override
    public List<Long> jsonArrAppendWithEscape(String string, Path2 path2, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrAppendWithEscape(string, path2, objectArray));
    }

    @Override
    public Long jsonArrAppend(String string, Path path, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrAppend(string, path, objectArray));
    }

    @Override
    public List<Long> jsonArrIndex(String string, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonArrIndex(string, path2, object));
    }

    @Override
    public List<Long> jsonArrIndexWithEscape(String string, Path2 path2, Object object) {
        return this.executeCommand(this.commandObjects.jsonArrIndexWithEscape(string, path2, object));
    }

    @Override
    public long jsonArrIndex(String string, Path path, Object object) {
        return this.executeCommand(this.commandObjects.jsonArrIndex(string, path, object));
    }

    @Override
    public List<Long> jsonArrInsert(String string, Path2 path2, int n2, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrInsert(string, path2, n2, objectArray));
    }

    @Override
    public List<Long> jsonArrInsertWithEscape(String string, Path2 path2, int n2, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrInsertWithEscape(string, path2, n2, objectArray));
    }

    @Override
    public long jsonArrInsert(String string, Path path, int n2, Object ... objectArray) {
        return this.executeCommand(this.commandObjects.jsonArrInsert(string, path, n2, objectArray));
    }

    @Override
    public Object jsonArrPop(String string) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string));
    }

    @Override
    public <T> T jsonArrPop(String string, Class<T> clazz) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, clazz));
    }

    @Override
    public List<Object> jsonArrPop(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, path2));
    }

    @Override
    public Object jsonArrPop(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, path));
    }

    @Override
    public <T> T jsonArrPop(String string, Class<T> clazz, Path path) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, clazz, path));
    }

    @Override
    public List<Object> jsonArrPop(String string, Path2 path2, int n2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, path2, n2));
    }

    @Override
    public Object jsonArrPop(String string, Path path, int n2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, path, n2));
    }

    @Override
    public <T> T jsonArrPop(String string, Class<T> clazz, Path path, int n2) {
        return this.executeCommand(this.commandObjects.jsonArrPop(string, clazz, path, n2));
    }

    @Override
    public Long jsonArrLen(String string) {
        return this.executeCommand(this.commandObjects.jsonArrLen(string));
    }

    @Override
    public List<Long> jsonArrLen(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonArrLen(string, path2));
    }

    @Override
    public Long jsonArrLen(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonArrLen(string, path));
    }

    @Override
    public List<Long> jsonArrTrim(String string, Path2 path2, int n2, int n3) {
        return this.executeCommand(this.commandObjects.jsonArrTrim(string, path2, n2, n3));
    }

    @Override
    public Long jsonArrTrim(String string, Path path, int n2, int n3) {
        return this.executeCommand(this.commandObjects.jsonArrTrim(string, path, n2, n3));
    }

    @Override
    public Long jsonObjLen(String string) {
        return this.executeCommand(this.commandObjects.jsonObjLen(string));
    }

    @Override
    public Long jsonObjLen(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonObjLen(string, path));
    }

    @Override
    public List<Long> jsonObjLen(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonObjLen(string, path2));
    }

    @Override
    public List<String> jsonObjKeys(String string) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(string));
    }

    @Override
    public List<String> jsonObjKeys(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(string, path));
    }

    @Override
    public List<List<String>> jsonObjKeys(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonObjKeys(string, path2));
    }

    @Override
    public long jsonDebugMemory(String string) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(string));
    }

    @Override
    public long jsonDebugMemory(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(string, path));
    }

    @Override
    public List<Long> jsonDebugMemory(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonDebugMemory(string, path2));
    }

    @Override
    public List<Object> jsonResp(String string) {
        return this.executeCommand(this.commandObjects.jsonResp(string));
    }

    @Override
    public List<Object> jsonResp(String string, Path path) {
        return this.executeCommand(this.commandObjects.jsonResp(string, path));
    }

    @Override
    public List<List<Object>> jsonResp(String string, Path2 path2) {
        return this.executeCommand(this.commandObjects.jsonResp(string, path2));
    }

    @Override
    public String tsCreate(String string) {
        return this.executeCommand(this.commandObjects.tsCreate(string));
    }

    @Override
    public String tsCreate(String string, TSCreateParams tSCreateParams) {
        return this.executeCommand(this.commandObjects.tsCreate(string, tSCreateParams));
    }

    @Override
    public long tsDel(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.tsDel(string, l2, l3));
    }

    @Override
    public String tsAlter(String string, TSAlterParams tSAlterParams) {
        return this.executeCommand(this.commandObjects.tsAlter(string, tSAlterParams));
    }

    @Override
    public long tsAdd(String string, double d2) {
        return this.executeCommand(this.commandObjects.tsAdd(string, d2));
    }

    @Override
    public long tsAdd(String string, long l2, double d2) {
        return this.executeCommand(this.commandObjects.tsAdd(string, l2, d2));
    }

    @Override
    public long tsAdd(String string, long l2, double d2, TSCreateParams tSCreateParams) {
        return this.executeCommand(this.commandObjects.tsAdd(string, l2, d2, tSCreateParams));
    }

    @Override
    public List<Long> tsMAdd(Map.Entry<String, TSElement> ... entryArray) {
        return this.executeCommand(this.commandObjects.tsMAdd(entryArray));
    }

    @Override
    public long tsIncrBy(String string, double d2) {
        return this.executeCommand(this.commandObjects.tsIncrBy(string, d2));
    }

    @Override
    public long tsIncrBy(String string, double d2, long l2) {
        return this.executeCommand(this.commandObjects.tsIncrBy(string, d2, l2));
    }

    @Override
    public long tsDecrBy(String string, double d2) {
        return this.executeCommand(this.commandObjects.tsDecrBy(string, d2));
    }

    @Override
    public long tsDecrBy(String string, double d2, long l2) {
        return this.executeCommand(this.commandObjects.tsDecrBy(string, d2, l2));
    }

    @Override
    public List<TSElement> tsRange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.tsRange(string, l2, l3));
    }

    @Override
    public List<TSElement> tsRange(String string, TSRangeParams tSRangeParams) {
        return this.executeCommand(this.commandObjects.tsRange(string, tSRangeParams));
    }

    @Override
    public List<TSElement> tsRevRange(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.tsRevRange(string, l2, l3));
    }

    @Override
    public List<TSElement> tsRevRange(String string, TSRangeParams tSRangeParams) {
        return this.executeCommand(this.commandObjects.tsRevRange(string, tSRangeParams));
    }

    @Override
    public List<TSKeyedElements> tsMRange(long l2, long l3, String ... stringArray) {
        return this.executeCommand(this.commandObjects.tsMRange(l2, l3, stringArray));
    }

    @Override
    public List<TSKeyedElements> tsMRange(TSMRangeParams tSMRangeParams) {
        return this.executeCommand(this.commandObjects.tsMRange(tSMRangeParams));
    }

    @Override
    public List<TSKeyedElements> tsMRevRange(long l2, long l3, String ... stringArray) {
        return this.executeCommand(this.commandObjects.tsMRevRange(l2, l3, stringArray));
    }

    @Override
    public List<TSKeyedElements> tsMRevRange(TSMRangeParams tSMRangeParams) {
        return this.executeCommand(this.commandObjects.tsMRevRange(tSMRangeParams));
    }

    @Override
    public TSElement tsGet(String string) {
        return this.executeCommand(this.commandObjects.tsGet(string));
    }

    @Override
    public TSElement tsGet(String string, TSGetParams tSGetParams) {
        return this.executeCommand(this.commandObjects.tsGet(string, tSGetParams));
    }

    @Override
    public List<TSKeyValue<TSElement>> tsMGet(TSMGetParams tSMGetParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.tsMGet(tSMGetParams, stringArray));
    }

    @Override
    public String tsCreateRule(String string, String string2, AggregationType aggregationType, long l2) {
        return this.executeCommand(this.commandObjects.tsCreateRule(string, string2, aggregationType, l2));
    }

    @Override
    public String tsCreateRule(String string, String string2, AggregationType aggregationType, long l2, long l3) {
        return this.executeCommand(this.commandObjects.tsCreateRule(string, string2, aggregationType, l2, l3));
    }

    @Override
    public String tsDeleteRule(String string, String string2) {
        return this.executeCommand(this.commandObjects.tsDeleteRule(string, string2));
    }

    @Override
    public List<String> tsQueryIndex(String ... stringArray) {
        return this.executeCommand(this.commandObjects.tsQueryIndex(stringArray));
    }

    @Override
    public TSInfo tsInfo(String string) {
        return this.executor.executeCommand(this.commandObjects.tsInfo(string));
    }

    @Override
    public TSInfo tsInfoDebug(String string) {
        return this.executeCommand(this.commandObjects.tsInfoDebug(string));
    }

    @Override
    public String bfReserve(String string, double d2, long l2) {
        return this.executeCommand(this.commandObjects.bfReserve(string, d2, l2));
    }

    @Override
    public String bfReserve(String string, double d2, long l2, BFReserveParams bFReserveParams) {
        return this.executeCommand(this.commandObjects.bfReserve(string, d2, l2, bFReserveParams));
    }

    @Override
    public boolean bfAdd(String string, String string2) {
        return this.executeCommand(this.commandObjects.bfAdd(string, string2));
    }

    @Override
    public List<Boolean> bfMAdd(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bfMAdd(string, stringArray));
    }

    @Override
    public List<Boolean> bfInsert(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bfInsert(string, stringArray));
    }

    @Override
    public List<Boolean> bfInsert(String string, BFInsertParams bFInsertParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bfInsert(string, bFInsertParams, stringArray));
    }

    @Override
    public boolean bfExists(String string, String string2) {
        return this.executeCommand(this.commandObjects.bfExists(string, string2));
    }

    @Override
    public List<Boolean> bfMExists(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.bfMExists(string, stringArray));
    }

    @Override
    public Map.Entry<Long, byte[]> bfScanDump(String string, long l2) {
        return this.executeCommand(this.commandObjects.bfScanDump(string, l2));
    }

    @Override
    public String bfLoadChunk(String string, long l2, byte[] byArray) {
        return this.executeCommand(this.commandObjects.bfLoadChunk(string, l2, byArray));
    }

    @Override
    public Map<String, Object> bfInfo(String string) {
        return this.executeCommand(this.commandObjects.bfInfo(string));
    }

    @Override
    public String cfReserve(String string, long l2) {
        return this.executeCommand(this.commandObjects.cfReserve(string, l2));
    }

    @Override
    public String cfReserve(String string, long l2, CFReserveParams cFReserveParams) {
        return this.executeCommand(this.commandObjects.cfReserve(string, l2, cFReserveParams));
    }

    @Override
    public boolean cfAdd(String string, String string2) {
        return this.executeCommand(this.commandObjects.cfAdd(string, string2));
    }

    @Override
    public boolean cfAddNx(String string, String string2) {
        return this.executeCommand(this.commandObjects.cfAddNx(string, string2));
    }

    @Override
    public List<Boolean> cfInsert(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cfInsert(string, stringArray));
    }

    @Override
    public List<Boolean> cfInsert(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cfInsert(string, cFInsertParams, stringArray));
    }

    @Override
    public List<Boolean> cfInsertNx(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cfInsertNx(string, stringArray));
    }

    @Override
    public List<Boolean> cfInsertNx(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cfInsertNx(string, cFInsertParams, stringArray));
    }

    @Override
    public boolean cfExists(String string, String string2) {
        return this.executeCommand(this.commandObjects.cfExists(string, string2));
    }

    @Override
    public List<Boolean> cfMExists(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cfMExists(string, stringArray));
    }

    @Override
    public boolean cfDel(String string, String string2) {
        return this.executeCommand(this.commandObjects.cfDel(string, string2));
    }

    @Override
    public long cfCount(String string, String string2) {
        return this.executeCommand(this.commandObjects.cfCount(string, string2));
    }

    @Override
    public Map.Entry<Long, byte[]> cfScanDump(String string, long l2) {
        return this.executeCommand(this.commandObjects.cfScanDump(string, l2));
    }

    @Override
    public String cfLoadChunk(String string, long l2, byte[] byArray) {
        return this.executeCommand(this.commandObjects.cfLoadChunk(string, l2, byArray));
    }

    @Override
    public Map<String, Object> cfInfo(String string) {
        return this.executeCommand(this.commandObjects.cfInfo(string));
    }

    @Override
    public String cmsInitByDim(String string, long l2, long l3) {
        return this.executeCommand(this.commandObjects.cmsInitByDim(string, l2, l3));
    }

    @Override
    public String cmsInitByProb(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.cmsInitByProb(string, d2, d3));
    }

    @Override
    public List<Long> cmsIncrBy(String string, Map<String, Long> map) {
        return this.executeCommand(this.commandObjects.cmsIncrBy(string, map));
    }

    @Override
    public List<Long> cmsQuery(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cmsQuery(string, stringArray));
    }

    @Override
    public String cmsMerge(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.cmsMerge(string, stringArray));
    }

    @Override
    public String cmsMerge(String string, Map<String, Long> map) {
        return this.executeCommand(this.commandObjects.cmsMerge(string, map));
    }

    @Override
    public Map<String, Object> cmsInfo(String string) {
        return this.executeCommand(this.commandObjects.cmsInfo(string));
    }

    @Override
    public String topkReserve(String string, long l2) {
        return this.executeCommand(this.commandObjects.topkReserve(string, l2));
    }

    @Override
    public String topkReserve(String string, long l2, long l3, long l4, double d2) {
        return this.executeCommand(this.commandObjects.topkReserve(string, l2, l3, l4, d2));
    }

    @Override
    public List<String> topkAdd(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.topkAdd(string, stringArray));
    }

    @Override
    public List<String> topkIncrBy(String string, Map<String, Long> map) {
        return this.executeCommand(this.commandObjects.topkIncrBy(string, map));
    }

    @Override
    public List<Boolean> topkQuery(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.topkQuery(string, stringArray));
    }

    @Override
    public List<Long> topkCount(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.topkCount(string, stringArray));
    }

    @Override
    public List<String> topkList(String string) {
        return this.executeCommand(this.commandObjects.topkList(string));
    }

    @Override
    public Map<String, Object> topkInfo(String string) {
        return this.executeCommand(this.commandObjects.topkInfo(string));
    }

    @Override
    public String tdigestCreate(String string) {
        return this.executeCommand(this.commandObjects.tdigestCreate(string));
    }

    @Override
    public String tdigestCreate(String string, int n2) {
        return this.executeCommand(this.commandObjects.tdigestCreate(string, n2));
    }

    @Override
    public String tdigestReset(String string) {
        return this.executeCommand(this.commandObjects.tdigestReset(string));
    }

    @Override
    public String tdigestMerge(String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.tdigestMerge(string, stringArray));
    }

    @Override
    public String tdigestMerge(TDigestMergeParams tDigestMergeParams, String string, String ... stringArray) {
        return this.executeCommand(this.commandObjects.tdigestMerge(tDigestMergeParams, string, stringArray));
    }

    @Override
    public Map<String, Object> tdigestInfo(String string) {
        return this.executeCommand(this.commandObjects.tdigestInfo(string));
    }

    @Override
    public String tdigestAdd(String string, double ... dArray) {
        return this.executeCommand(this.commandObjects.tdigestAdd(string, dArray));
    }

    @Override
    public List<Double> tdigestCDF(String string, double ... dArray) {
        return this.executeCommand(this.commandObjects.tdigestCDF(string, dArray));
    }

    @Override
    public List<Double> tdigestQuantile(String string, double ... dArray) {
        return this.executeCommand(this.commandObjects.tdigestQuantile(string, dArray));
    }

    @Override
    public double tdigestMin(String string) {
        return this.executeCommand(this.commandObjects.tdigestMin(string));
    }

    @Override
    public double tdigestMax(String string) {
        return this.executeCommand(this.commandObjects.tdigestMax(string));
    }

    @Override
    public double tdigestTrimmedMean(String string, double d2, double d3) {
        return this.executeCommand(this.commandObjects.tdigestTrimmedMean(string, d2, d3));
    }

    @Override
    public List<Long> tdigestRank(String string, double ... dArray) {
        return this.executeCommand(this.commandObjects.tdigestRank(string, dArray));
    }

    @Override
    public List<Long> tdigestRevRank(String string, double ... dArray) {
        return this.executeCommand(this.commandObjects.tdigestRevRank(string, dArray));
    }

    @Override
    public List<Double> tdigestByRank(String string, long ... lArray) {
        return this.executeCommand(this.commandObjects.tdigestByRank(string, lArray));
    }

    @Override
    public List<Double> tdigestByRevRank(String string, long ... lArray) {
        return this.executeCommand(this.commandObjects.tdigestByRevRank(string, lArray));
    }

    @Override
    public ResultSet graphQuery(String string, String string2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(string, string2));
    }

    @Override
    public ResultSet graphReadonlyQuery(String string, String string2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2));
    }

    @Override
    public ResultSet graphQuery(String string, String string2, long l2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(string, string2, l2));
    }

    @Override
    public ResultSet graphReadonlyQuery(String string, String string2, long l2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, l2));
    }

    @Override
    public ResultSet graphQuery(String string, String string2, Map<String, Object> map) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(string, string2, map));
    }

    @Override
    public ResultSet graphReadonlyQuery(String string, String string2, Map<String, Object> map) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, map));
    }

    @Override
    public ResultSet graphQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.executeCommand(this.graphCommandObjects.graphQuery(string, string2, map, l2));
    }

    @Override
    public ResultSet graphReadonlyQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.executeCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, map, l2));
    }

    @Override
    public String graphDelete(String string) {
        return this.executeCommand(this.graphCommandObjects.graphDelete(string));
    }

    @Override
    public List<String> graphList() {
        return this.executeCommand(this.commandObjects.graphList());
    }

    @Override
    public List<String> graphProfile(String string, String string2) {
        return this.executeCommand(this.commandObjects.graphProfile(string, string2));
    }

    @Override
    public List<String> graphExplain(String string, String string2) {
        return this.executeCommand(this.commandObjects.graphExplain(string, string2));
    }

    @Override
    public List<List<String>> graphSlowlog(String string) {
        return this.executeCommand(this.commandObjects.graphSlowlog(string));
    }

    @Override
    public String graphConfigSet(String string, Object object) {
        return this.executeCommand(this.commandObjects.graphConfigSet(string, object));
    }

    @Override
    public Map<String, Object> graphConfigGet(String string) {
        return this.executeCommand(this.commandObjects.graphConfigGet(string));
    }

    public Object sendCommand(ProtocolCommand protocolCommand) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand));
    }

    public Object sendCommand(ProtocolCommand protocolCommand, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects((Object[])byArray));
    }

    public Object sendBlockingCommand(ProtocolCommand protocolCommand, byte[] ... byArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects((Object[])byArray).blocking());
    }

    public Object sendCommand(ProtocolCommand protocolCommand, String ... stringArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects(stringArray));
    }

    public Object sendBlockingCommand(ProtocolCommand protocolCommand, String ... stringArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects(stringArray).blocking());
    }

    public Object sendCommand(byte[] byArray, ProtocolCommand protocolCommand, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects((Object[])byArray2).processKey(byArray));
    }

    public Object sendBlockingCommand(byte[] byArray, ProtocolCommand protocolCommand, byte[] ... byArray2) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects((Object[])byArray2).blocking().processKey(byArray));
    }

    public Object sendCommand(String string, ProtocolCommand protocolCommand, String ... stringArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects(stringArray).processKey(string));
    }

    public Object sendBlockingCommand(String string, ProtocolCommand protocolCommand, String ... stringArray) {
        return this.executeCommand(this.commandObjects.commandArguments(protocolCommand).addObjects(stringArray).blocking().processKey(string));
    }

    public Object executeCommand(CommandArguments commandArguments) {
        return this.executeCommand(new CommandObject<Object>(commandArguments, BuilderFactory.RAW_OBJECT));
    }
}

