/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class StreamEntryID
implements Serializable,
Comparable<StreamEntryID> {
    private static final long serialVersionUID = 1L;
    private long time;
    private long sequence;
    public static final StreamEntryID NEW_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "*";
        }
    };
    public static final StreamEntryID LAST_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "$";
        }
    };
    public static final StreamEntryID UNRECEIVED_ENTRY = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return ">";
        }
    };
    public static final StreamEntryID MINIMUM_ID = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "-";
        }
    };
    public static final StreamEntryID MAXIMUM_ID = new StreamEntryID(){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "+";
        }
    };

    public StreamEntryID() {
        this(0L, 0L);
    }

    public StreamEntryID(byte[] byArray) {
        this(SafeEncoder.encode(byArray));
    }

    public StreamEntryID(String string) {
        String[] stringArray = string.split("-");
        this.time = Long.parseLong(stringArray[0]);
        this.sequence = Long.parseLong(stringArray[1]);
    }

    public StreamEntryID(long l2) {
        this(l2, 0L);
    }

    public StreamEntryID(long l2, long l3) {
        this.time = l2;
        this.sequence = l3;
    }

    public String toString() {
        return this.time + "-" + this.sequence;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StreamEntryID streamEntryID = (StreamEntryID)object;
        return this.time == streamEntryID.time && this.sequence == streamEntryID.sequence;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(StreamEntryID streamEntryID) {
        int n2 = Long.compare(this.time, streamEntryID.time);
        return n2 != 0 ? n2 : Long.compare(this.sequence, streamEntryID.sequence);
    }

    public long getTime() {
        return this.time;
    }

    public long getSequence() {
        return this.sequence;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeLong(this.time);
        objectOutputStream.writeLong(this.sequence);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.time = objectInputStream.readLong();
        this.sequence = objectInputStream.readLong();
    }
}

