/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.List;
import java.util.regex.Pattern;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.MultiNodePipelineBase;
import me.ulrich.clans.library.redis.jedis.ShardedCommandArguments;
import me.ulrich.clans.library.redis.jedis.ShardedCommandObjects;
import me.ulrich.clans.library.redis.jedis.providers.ShardedConnectionProvider;
import me.ulrich.clans.library.redis.jedis.util.Hashing;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ShardedPipeline
extends MultiNodePipelineBase {
    private final ShardedConnectionProvider provider;
    private AutoCloseable closeable = null;

    public ShardedPipeline(List<HostAndPort> list, JedisClientConfig jedisClientConfig) {
        this(new ShardedConnectionProvider(list, jedisClientConfig));
        this.closeable = this.provider;
    }

    public ShardedPipeline(ShardedConnectionProvider shardedConnectionProvider) {
        super(new ShardedCommandObjects(shardedConnectionProvider.getHashingAlgo()));
        this.provider = shardedConnectionProvider;
    }

    public ShardedPipeline(List<HostAndPort> list, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, Hashing hashing, Pattern pattern) {
        this(new ShardedConnectionProvider(list, jedisClientConfig, genericObjectPoolConfig, hashing), pattern);
        this.closeable = this.provider;
    }

    public ShardedPipeline(ShardedConnectionProvider shardedConnectionProvider, Pattern pattern) {
        super(new ShardedCommandObjects(shardedConnectionProvider.getHashingAlgo(), pattern));
        this.provider = shardedConnectionProvider;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            IOUtils.closeQuietly(this.closeable);
        }
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments commandArguments) {
        return this.provider.getNode(((ShardedCommandArguments)commandArguments).getKeyHash());
    }

    @Override
    protected Connection getConnection(HostAndPort hostAndPort) {
        return this.provider.getConnection(hostAndPort);
    }

    public void prepareGraphCommands() {
        super.prepareGraphCommands(this.provider);
    }
}

