/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.Set;
import java.util.regex.Pattern;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.CommandObjects;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.ShardedCommandArguments;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.util.Hashing;
import me.ulrich.clans.library.redis.jedis.util.JedisClusterHashTag;

public class ShardedCommandObjects
extends CommandObjects {
    private final Hashing algo;
    private final Pattern tagPattern;
    private static final String KEYS_PATTERN_MESSAGE = "Cluster mode only supports KEYS command with pattern containing hash-tag ( curly-brackets enclosed string )";
    private static final String SCAN_PATTERN_MESSAGE = "Cluster mode only supports SCAN command with MATCH pattern containing hash-tag ( curly-brackets enclosed string )";

    public ShardedCommandObjects(Hashing hashing) {
        this(hashing, null);
    }

    public ShardedCommandObjects(Hashing hashing, Pattern pattern) {
        this.algo = hashing;
        this.tagPattern = pattern;
    }

    @Override
    protected ShardedCommandArguments commandArguments(ProtocolCommand protocolCommand) {
        return new ShardedCommandArguments(this.algo, this.tagPattern, protocolCommand);
    }

    @Override
    public CommandObject<Long> dbSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CommandObject<Set<String>> keys(String string) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(string)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.KEYS).key(string).processKey(string), BuilderFactory.STRING_SET);
    }

    @Override
    public final CommandObject<Set<byte[]>> keys(byte[] byArray) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(byArray)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.KEYS).key(byArray).processKey(byArray), BuilderFactory.BINARY_SET);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams) {
        String string2 = scanParams.match();
        if (string2 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(string2)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams).processKey(string2), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams, String string2) {
        String string3 = scanParams.match();
        if (string3 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(string3)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams).processKey(string3).add(Protocol.Keyword.TYPE).add(string2), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams) {
        byte[] byArray2 = scanParams.binaryMatch();
        if (byArray2 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(byArray2)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams).processKey(byArray2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        byte[] byArray3 = scanParams.binaryMatch();
        if (byArray3 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(byArray3)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams).processKey(byArray3).add(Protocol.Keyword.TYPE).add(byArray2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    @Override
    public final CommandObject<Long> waitReplicas(int n2, long l2) {
        throw new UnsupportedOperationException();
    }
}

