/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.util.Hashing;

public class ShardedCommandArguments
extends CommandArguments {
    private final Hashing algo;
    private final Pattern tagPattern;
    private Long keyHash = null;

    public ShardedCommandArguments(Hashing hashing, ProtocolCommand protocolCommand) {
        this(hashing, null, protocolCommand);
    }

    public ShardedCommandArguments(Hashing hashing, Pattern pattern, ProtocolCommand protocolCommand) {
        super(protocolCommand);
        this.algo = hashing;
        this.tagPattern = pattern;
    }

    public Long getKeyHash() {
        return this.keyHash;
    }

    @Override
    protected CommandArguments processKey(byte[] byArray) {
        long l2 = this.algo.hash(byArray);
        if (this.keyHash == null) {
            this.keyHash = l2;
        } else if (this.keyHash != l2) {
            throw new JedisException("Keys must generate same hash.");
        }
        return this;
    }

    @Override
    protected CommandArguments processKey(String string) {
        string = this.getKeyTag(string);
        long l2 = this.algo.hash(string);
        if (this.keyHash == null) {
            this.keyHash = l2;
        } else if (this.keyHash != l2) {
            throw new JedisException("Keys must generate same hash.");
        }
        return this;
    }

    private String getKeyTag(String string) {
        Matcher matcher;
        if (this.tagPattern != null && (matcher = this.tagPattern.matcher(string)).find()) {
            return matcher.group(1);
        }
        return string;
    }
}

