/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.function.Supplier;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisDataException;

public class Response<T>
implements Supplier<T> {
    protected T response = null;
    protected JedisDataException exception = null;
    private boolean building = false;
    private boolean built = false;
    private boolean set = false;
    private Builder<T> builder;
    private Object data;
    private Response<?> dependency = null;

    public Response(Builder<T> builder) {
        this.builder = builder;
    }

    public void set(Object object) {
        this.data = object;
        this.set = true;
    }

    @Override
    public T get() {
        if (this.dependency != null && this.dependency.set && !this.dependency.built) {
            super.build();
        }
        if (!this.set) {
            throw new IllegalStateException("Please close pipeline or multi block before calling this method.");
        }
        if (!this.built) {
            this.build();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.response;
    }

    public void setDependency(Response<?> response) {
        this.dependency = response;
    }

    private void build() {
        if (this.building) {
            return;
        }
        this.building = true;
        try {
            if (this.data != null) {
                if (this.data instanceof JedisDataException) {
                    this.exception = (JedisDataException)this.data;
                } else {
                    this.response = this.builder.build(this.data);
                }
            }
            this.data = null;
        }
        finally {
            this.building = false;
            this.built = true;
        }
    }

    public String toString() {
        return "Response " + this.builder.toString();
    }
}

