/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisAccessControlException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisAskDataException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisBusyException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisClusterException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisDataException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisMovedDataException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisNoScriptException;
import me.ulrich.clans.library.redis.jedis.util.RedisInputStream;
import me.ulrich.clans.library.redis.jedis.util.RedisOutputStream;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public final class Protocol {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_DATABASE = 0;
    public static final int CLUSTER_HASHSLOTS = 16384;
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte DOLLAR_BYTE = 36;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte PLUS_BYTE = 43;
    public static final byte MINUS_BYTE = 45;
    public static final byte COLON_BYTE = 58;
    public static final byte[] BYTES_TRUE = Protocol.toByteArray(1);
    public static final byte[] BYTES_FALSE = Protocol.toByteArray(0);
    public static final byte[] BYTES_TILDE = SafeEncoder.encode("~");
    public static final byte[] BYTES_EQUAL = SafeEncoder.encode("=");
    public static final byte[] BYTES_ASTERISK = SafeEncoder.encode("*");
    public static final byte[] POSITIVE_INFINITY_BYTES = "+inf".getBytes();
    public static final byte[] NEGATIVE_INFINITY_BYTES = "-inf".getBytes();
    private static final String ASK_PREFIX = "ASK ";
    private static final String MOVED_PREFIX = "MOVED ";
    private static final String CLUSTERDOWN_PREFIX = "CLUSTERDOWN ";
    private static final String BUSY_PREFIX = "BUSY ";
    private static final String NOSCRIPT_PREFIX = "NOSCRIPT ";
    private static final String WRONGPASS_PREFIX = "WRONGPASS";
    private static final String NOPERM_PREFIX = "NOPERM";

    private Protocol() {
    }

    public static void sendCommand(RedisOutputStream redisOutputStream, CommandArguments commandArguments) {
        try {
            redisOutputStream.write((byte)42);
            redisOutputStream.writeIntCrLf(commandArguments.size());
            for (Rawable rawable : commandArguments) {
                redisOutputStream.write((byte)36);
                byte[] byArray = rawable.getRaw();
                redisOutputStream.writeIntCrLf(byArray.length);
                redisOutputStream.write(byArray);
                redisOutputStream.writeCrLf();
            }
        }
        catch (IOException iOException) {
            throw new JedisConnectionException(iOException);
        }
    }

    private static void processError(RedisInputStream redisInputStream) {
        String string = redisInputStream.readLine();
        if (string.startsWith(MOVED_PREFIX)) {
            String[] stringArray = Protocol.parseTargetHostAndSlot(string);
            throw new JedisMovedDataException(string, HostAndPort.from(stringArray[1]), Integer.parseInt(stringArray[0]));
        }
        if (string.startsWith(ASK_PREFIX)) {
            String[] stringArray = Protocol.parseTargetHostAndSlot(string);
            throw new JedisAskDataException(string, HostAndPort.from(stringArray[1]), Integer.parseInt(stringArray[0]));
        }
        if (string.startsWith(CLUSTERDOWN_PREFIX)) {
            throw new JedisClusterException(string);
        }
        if (string.startsWith(BUSY_PREFIX)) {
            throw new JedisBusyException(string);
        }
        if (string.startsWith(NOSCRIPT_PREFIX)) {
            throw new JedisNoScriptException(string);
        }
        if (string.startsWith(WRONGPASS_PREFIX)) {
            throw new JedisAccessControlException(string);
        }
        if (string.startsWith(NOPERM_PREFIX)) {
            throw new JedisAccessControlException(string);
        }
        throw new JedisDataException(string);
    }

    public static String readErrorLineIfPossible(RedisInputStream redisInputStream) {
        byte by = redisInputStream.readByte();
        if (by != 45) {
            return null;
        }
        return redisInputStream.readLine();
    }

    private static String[] parseTargetHostAndSlot(String string) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split(" ");
        stringArray[0] = stringArray2[1];
        stringArray[1] = stringArray2[2];
        return stringArray;
    }

    private static Object process(RedisInputStream redisInputStream) {
        byte by = redisInputStream.readByte();
        switch (by) {
            case 43: {
                return Protocol.processStatusCodeReply(redisInputStream);
            }
            case 36: {
                return Protocol.processBulkReply(redisInputStream);
            }
            case 42: {
                return Protocol.processMultiBulkReply(redisInputStream);
            }
            case 58: {
                return Protocol.processInteger(redisInputStream);
            }
            case 45: {
                Protocol.processError(redisInputStream);
                return null;
            }
        }
        throw new JedisConnectionException("Unknown reply: " + (char)by);
    }

    private static byte[] processStatusCodeReply(RedisInputStream redisInputStream) {
        return redisInputStream.readLineBytes();
    }

    private static byte[] processBulkReply(RedisInputStream redisInputStream) {
        int n2;
        int n3 = redisInputStream.readIntCrLf();
        if (n3 == -1) {
            return null;
        }
        byte[] byArray = new byte[n3];
        for (int i2 = 0; i2 < n3; i2 += n2) {
            n2 = redisInputStream.read(byArray, i2, n3 - i2);
            if (n2 != -1) continue;
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        redisInputStream.readByte();
        redisInputStream.readByte();
        return byArray;
    }

    private static Long processInteger(RedisInputStream redisInputStream) {
        return redisInputStream.readLongCrLf();
    }

    private static List<Object> processMultiBulkReply(RedisInputStream redisInputStream) {
        int n2 = redisInputStream.readIntCrLf();
        if (n2 == -1) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                arrayList.add(Protocol.process(redisInputStream));
                continue;
            }
            catch (JedisDataException jedisDataException) {
                arrayList.add(jedisDataException);
            }
        }
        return arrayList;
    }

    public static Object read(RedisInputStream redisInputStream) {
        return Protocol.process(redisInputStream);
    }

    public static final byte[] toByteArray(boolean bl) {
        return bl ? BYTES_TRUE : BYTES_FALSE;
    }

    public static final byte[] toByteArray(int n2) {
        return SafeEncoder.encode(String.valueOf(n2));
    }

    public static final byte[] toByteArray(long l2) {
        return SafeEncoder.encode(String.valueOf(l2));
    }

    public static final byte[] toByteArray(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY_BYTES;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_BYTES;
        }
        return SafeEncoder.encode(String.valueOf(d2));
    }

    public static enum ClusterKeyword implements Rawable
    {
        MEET,
        RESET,
        INFO,
        FAILOVER,
        SLOTS,
        NODES,
        REPLICAS,
        SLAVES,
        MYID,
        ADDSLOTS,
        DELSLOTS,
        GETKEYSINSLOT,
        SETSLOT,
        NODE,
        MIGRATING,
        IMPORTING,
        STABLE,
        FORGET,
        FLUSHSLOTS,
        KEYSLOT,
        COUNTKEYSINSLOT,
        SAVECONFIG,
        REPLICATE,
        LINKS,
        ADDSLOTSRANGE,
        DELSLOTSRANGE,
        BUMPEPOCH;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum ResponseKeyword implements Rawable
    {
        SUBSCRIBE,
        PSUBSCRIBE,
        UNSUBSCRIBE,
        PUNSUBSCRIBE,
        MESSAGE,
        PMESSAGE,
        PONG;

        private final byte[] raw = SafeEncoder.encode(this.name().toLowerCase(Locale.ENGLISH));

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum SentinelKeyword implements Rawable
    {
        MYID,
        MASTERS,
        MASTER,
        SENTINELS,
        SLAVES,
        REPLICAS,
        RESET,
        FAILOVER,
        REMOVE,
        SET,
        MONITOR,
        GET_MASTER_ADDR_BY_NAME("GET-MASTER-ADDR-BY-NAME");

        private final byte[] raw;

        private SentinelKeyword() {
            this.raw = SafeEncoder.encode(this.name());
        }

        private SentinelKeyword(String string2) {
            this.raw = SafeEncoder.encode(string2);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum Keyword implements Rawable
    {
        AGGREGATE,
        ALPHA,
        BY,
        GET,
        LIMIT,
        NO,
        NOSORT,
        ONE,
        SET,
        STORE,
        WEIGHTS,
        WITHSCORES,
        RESETSTAT,
        REWRITE,
        RESET,
        FLUSH,
        EXISTS,
        LOAD,
        LEN,
        HELP,
        SCHEDULE,
        MATCH,
        COUNT,
        TYPE,
        KEYS,
        REFCOUNT,
        ENCODING,
        IDLETIME,
        FREQ,
        REPLACE,
        GETNAME,
        SETNAME,
        LIST,
        ID,
        KILL,
        PAUSE,
        UNBLOCK,
        STREAMS,
        CREATE,
        MKSTREAM,
        SETID,
        DESTROY,
        DELCONSUMER,
        MAXLEN,
        GROUP,
        IDLE,
        TIME,
        BLOCK,
        NOACK,
        RETRYCOUNT,
        STREAM,
        GROUPS,
        CONSUMERS,
        JUSTID,
        WITHVALUES,
        NOMKSTREAM,
        MINID,
        CREATECONSUMER,
        SETUSER,
        GETUSER,
        DELUSER,
        WHOAMI,
        USERS,
        CAT,
        GENPASS,
        LOG,
        SAVE,
        DRYRUN,
        COPY,
        AUTH,
        AUTH2,
        NX,
        XX,
        EX,
        PX,
        EXAT,
        PXAT,
        CH,
        ABSTTL,
        KEEPTTL,
        INCR,
        INFO,
        CHANNELS,
        NUMPAT,
        NUMSUB,
        NOW,
        REV,
        WITHCOORD,
        WITHDIST,
        WITHHASH,
        ANY,
        FROMMEMBER,
        FROMLONLAT,
        BYRADIUS,
        BYBOX,
        BYLEX,
        BYSCORE,
        STOREDIST,
        TO,
        FORCE,
        TIMEOUT,
        DB,
        UNLOAD,
        ABORT,
        IDX,
        MINMATCHLEN,
        WITHMATCHLEN,
        FULL,
        DELETE,
        LIBRARYNAME,
        WITHCODE,
        DESCRIPTION,
        GETKEYS,
        GETKEYSANDFLAGS,
        DOCS,
        FILTERBY,
        DUMP,
        MODULE,
        ACLCAT,
        PATTERN,
        DOCTOR,
        USAGE,
        SAMPLES,
        PURGE,
        STATS,
        ASC,
        DESC,
        LCS,
        STRINGS;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum Command implements ProtocolCommand
    {
        PING,
        SET,
        GET,
        GETDEL,
        GETEX,
        QUIT,
        EXISTS,
        DEL,
        UNLINK,
        TYPE,
        FLUSHDB,
        KEYS,
        RANDOMKEY,
        MOVE,
        RENAME,
        RENAMENX,
        DBSIZE,
        EXPIRE,
        EXPIREAT,
        TTL,
        SELECT,
        FLUSHALL,
        GETSET,
        MGET,
        SETNX,
        SETEX,
        MSET,
        MSETNX,
        DECRBY,
        DECR,
        INCRBY,
        INCR,
        APPEND,
        SUBSTR,
        HSET,
        HGET,
        HSETNX,
        HMSET,
        HMGET,
        HINCRBY,
        HEXISTS,
        HDEL,
        HLEN,
        HKEYS,
        HVALS,
        HGETALL,
        HRANDFIELD,
        HINCRBYFLOAT,
        HSTRLEN,
        MIGRATE,
        RPUSH,
        LPUSH,
        LLEN,
        LRANGE,
        LTRIM,
        LINDEX,
        LSET,
        LREM,
        LPOP,
        RPOP,
        BLPOP,
        BRPOP,
        LINSERT,
        LPOS,
        RPOPLPUSH,
        BRPOPLPUSH,
        BLMOVE,
        LMOVE,
        SADD,
        SMEMBERS,
        SREM,
        SPOP,
        SMOVE,
        SCARD,
        SRANDMEMBER,
        SINTER,
        SINTERSTORE,
        SUNION,
        SUNIONSTORE,
        SDIFF,
        SDIFFSTORE,
        SISMEMBER,
        SMISMEMBER,
        SINTERCARD,
        MULTI,
        DISCARD,
        EXEC,
        WATCH,
        UNWATCH,
        SORT,
        SORT_RO,
        AUTH,
        INFO,
        SHUTDOWN,
        MONITOR,
        CONFIG,
        LCS,
        SUBSCRIBE,
        PUBLISH,
        UNSUBSCRIBE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        PUBSUB,
        STRLEN,
        LPUSHX,
        RPUSHX,
        ECHO,
        ZADD,
        ZDIFF,
        ZDIFFSTORE,
        ZRANGE,
        ZREM,
        ZINCRBY,
        ZRANK,
        ZREVRANK,
        ZREVRANGE,
        ZRANDMEMBER,
        ZCARD,
        ZSCORE,
        ZPOPMAX,
        ZPOPMIN,
        ZCOUNT,
        ZUNION,
        ZUNIONSTORE,
        ZINTER,
        ZINTERSTORE,
        ZRANGEBYSCORE,
        ZREVRANGEBYSCORE,
        ZREMRANGEBYRANK,
        ZREMRANGEBYSCORE,
        ZLEXCOUNT,
        ZRANGEBYLEX,
        ZREVRANGEBYLEX,
        ZREMRANGEBYLEX,
        ZMSCORE,
        ZRANGESTORE,
        ZINTERCARD,
        SAVE,
        BGSAVE,
        BGREWRITEAOF,
        LASTSAVE,
        PERSIST,
        SETBIT,
        GETBIT,
        BITPOS,
        SETRANGE,
        GETRANGE,
        EVAL,
        EVALSHA,
        SCRIPT,
        SLOWLOG,
        OBJECT,
        BITCOUNT,
        BITOP,
        SENTINEL,
        DUMP,
        RESTORE,
        PEXPIRE,
        PEXPIREAT,
        PTTL,
        INCRBYFLOAT,
        PSETEX,
        CLIENT,
        TIME,
        SCAN,
        HSCAN,
        SSCAN,
        ZSCAN,
        WAIT,
        CLUSTER,
        ASKING,
        READONLY,
        READWRITE,
        SLAVEOF,
        REPLICAOF,
        COPY,
        PFADD,
        PFCOUNT,
        PFMERGE,
        MODULE,
        ACL,
        GEOADD,
        GEODIST,
        GEOHASH,
        GEOPOS,
        GEORADIUS,
        GEORADIUS_RO,
        GEORADIUSBYMEMBER,
        GEORADIUSBYMEMBER_RO,
        BITFIELD,
        TOUCH,
        SWAPDB,
        MEMORY,
        BZPOPMIN,
        BZPOPMAX,
        XADD,
        XLEN,
        XDEL,
        XTRIM,
        XRANGE,
        XREVRANGE,
        XREAD,
        XACK,
        XGROUP,
        XREADGROUP,
        XPENDING,
        XCLAIM,
        XAUTOCLAIM,
        XINFO,
        BITFIELD_RO,
        ROLE,
        FAILOVER,
        GEOSEARCH,
        GEOSEARCHSTORE,
        EVAL_RO,
        EVALSHA_RO,
        LOLWUT,
        EXPIRETIME,
        PEXPIRETIME,
        FUNCTION,
        FCALL,
        FCALL_RO,
        LMPOP,
        BLMPOP,
        ZMPOP,
        BZMPOP,
        COMMAND,
        STRALGO;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

