/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.CommandObjects;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.Response;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.args.BitCountOption;
import me.ulrich.clans.library.redis.jedis.args.BitOP;
import me.ulrich.clans.library.redis.jedis.args.ExpiryOption;
import me.ulrich.clans.library.redis.jedis.args.FlushMode;
import me.ulrich.clans.library.redis.jedis.args.FunctionRestorePolicy;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.ListDirection;
import me.ulrich.clans.library.redis.jedis.args.ListPosition;
import me.ulrich.clans.library.redis.jedis.args.SortedSetOption;
import me.ulrich.clans.library.redis.jedis.bloom.BFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.BFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.TDigestMergeParams;
import me.ulrich.clans.library.redis.jedis.commands.PipelineBinaryCommands;
import me.ulrich.clans.library.redis.jedis.commands.PipelineCommands;
import me.ulrich.clans.library.redis.jedis.commands.RedisModulePipelineCommands;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.graph.GraphCommandObjects;
import me.ulrich.clans.library.redis.jedis.graph.ResultSet;
import me.ulrich.clans.library.redis.jedis.json.JsonSetParams;
import me.ulrich.clans.library.redis.jedis.json.Path;
import me.ulrich.clans.library.redis.jedis.json.Path2;
import me.ulrich.clans.library.redis.jedis.params.BitPosParams;
import me.ulrich.clans.library.redis.jedis.params.GeoAddParams;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusParam;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusStoreParam;
import me.ulrich.clans.library.redis.jedis.params.GeoSearchParam;
import me.ulrich.clans.library.redis.jedis.params.GetExParams;
import me.ulrich.clans.library.redis.jedis.params.LCSParams;
import me.ulrich.clans.library.redis.jedis.params.LPosParams;
import me.ulrich.clans.library.redis.jedis.params.MigrateParams;
import me.ulrich.clans.library.redis.jedis.params.RestoreParams;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.params.SetParams;
import me.ulrich.clans.library.redis.jedis.params.SortingParams;
import me.ulrich.clans.library.redis.jedis.params.StrAlgoLCSParams;
import me.ulrich.clans.library.redis.jedis.params.XAddParams;
import me.ulrich.clans.library.redis.jedis.params.XAutoClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XPendingParams;
import me.ulrich.clans.library.redis.jedis.params.XReadGroupParams;
import me.ulrich.clans.library.redis.jedis.params.XReadParams;
import me.ulrich.clans.library.redis.jedis.params.XTrimParams;
import me.ulrich.clans.library.redis.jedis.params.ZAddParams;
import me.ulrich.clans.library.redis.jedis.params.ZIncrByParams;
import me.ulrich.clans.library.redis.jedis.params.ZParams;
import me.ulrich.clans.library.redis.jedis.params.ZRangeParams;
import me.ulrich.clans.library.redis.jedis.providers.ConnectionProvider;
import me.ulrich.clans.library.redis.jedis.resps.FunctionStats;
import me.ulrich.clans.library.redis.jedis.resps.GeoRadiusResponse;
import me.ulrich.clans.library.redis.jedis.resps.KeyedListElement;
import me.ulrich.clans.library.redis.jedis.resps.KeyedZSetElement;
import me.ulrich.clans.library.redis.jedis.resps.LCSMatchResult;
import me.ulrich.clans.library.redis.jedis.resps.LibraryInfo;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumersInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingSummary;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.FTCreateParams;
import me.ulrich.clans.library.redis.jedis.search.FTSearchParams;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.TSAlterParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSCreateParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSElement;
import me.ulrich.clans.library.redis.jedis.timeseries.TSGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyValue;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyedElements;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMRangeParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSRangeParams;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import me.ulrich.clans.library.redis.jedis.util.KeyValue;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiNodePipelineBase
implements Closeable,
PipelineBinaryCommands,
PipelineCommands,
RedisModulePipelineCommands {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<HostAndPort, Queue<Response<?>>> pipelinedResponses = new LinkedHashMap();
    private final Map<HostAndPort, Connection> connections = new LinkedHashMap<HostAndPort, Connection>();
    private volatile boolean synced = false;
    private final CommandObjects commandObjects;
    private GraphCommandObjects graphCommandObjects;

    public MultiNodePipelineBase(CommandObjects commandObjects) {
        this.commandObjects = commandObjects;
    }

    protected final void prepareGraphCommands(ConnectionProvider connectionProvider) {
        this.graphCommandObjects = new GraphCommandObjects(connectionProvider);
    }

    protected abstract HostAndPort getNodeKey(CommandArguments var1);

    protected abstract Connection getConnection(HostAndPort var1);

    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        Connection connection;
        Queue<Object> queue;
        HostAndPort hostAndPort = this.getNodeKey(commandObject.getArguments());
        if (this.pipelinedResponses.containsKey(hostAndPort)) {
            queue = this.pipelinedResponses.get(hostAndPort);
            connection = this.connections.get(hostAndPort);
        } else {
            queue = new LinkedList();
            connection = this.getConnection(hostAndPort);
            this.pipelinedResponses.put(hostAndPort, queue);
            this.connections.put(hostAndPort, connection);
        }
        connection.sendCommand(commandObject.getArguments());
        Response<T> response = new Response<T>(commandObject.getBuilder());
        queue.add(response);
        return response;
    }

    @Override
    public void close() {
        try {
            this.sync();
        }
        finally {
            for (Connection connection : this.connections.values()) {
                IOUtils.closeQuietly(connection);
            }
        }
    }

    public final void sync() {
        if (this.synced) {
            return;
        }
        Iterator<Map.Entry<HostAndPort, Queue<Response<?>>>> iterator = this.pipelinedResponses.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<HostAndPort, Queue<Response<?>>> entry = iterator.next();
            HostAndPort hostAndPort = entry.getKey();
            Queue<Response<?>> queue = entry.getValue();
            Connection connection = this.connections.get(hostAndPort);
            try {
                List<Object> list = connection.getMany(queue.size());
                for (Object object : list) {
                    queue.poll().set(object);
                }
            }
            catch (JedisConnectionException jedisConnectionException) {
                this.log.error("Error with connection to " + hostAndPort, jedisConnectionException);
                iterator.remove();
                this.connections.remove(hostAndPort);
                IOUtils.closeQuietly(connection);
            }
        }
        this.synced = true;
    }

    @Override
    public Response<Boolean> exists(String string) {
        return this.appendCommand(this.commandObjects.exists(string));
    }

    @Override
    public Response<Long> exists(String ... stringArray) {
        return this.appendCommand(this.commandObjects.exists(stringArray));
    }

    @Override
    public Response<Long> persist(String string) {
        return this.appendCommand(this.commandObjects.persist(string));
    }

    @Override
    public Response<String> type(String string) {
        return this.appendCommand(this.commandObjects.type(string));
    }

    @Override
    public Response<byte[]> dump(String string) {
        return this.appendCommand(this.commandObjects.dump(string));
    }

    @Override
    public Response<String> restore(String string, long l2, byte[] byArray) {
        return this.appendCommand(this.commandObjects.restore(string, l2, byArray));
    }

    @Override
    public Response<String> restore(String string, long l2, byte[] byArray, RestoreParams restoreParams) {
        return this.appendCommand(this.commandObjects.restore(string, l2, byArray, restoreParams));
    }

    @Override
    public Response<Long> expire(String string, long l2) {
        return this.appendCommand(this.commandObjects.expire(string, l2));
    }

    @Override
    public Response<Long> expire(String string, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expire(string, l2, expiryOption));
    }

    @Override
    public Response<Long> pexpire(String string, long l2) {
        return this.appendCommand(this.commandObjects.pexpire(string, l2));
    }

    @Override
    public Response<Long> pexpire(String string, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpire(string, l2, expiryOption));
    }

    @Override
    public Response<Long> expireTime(String string) {
        return this.appendCommand(this.commandObjects.expireTime(string));
    }

    @Override
    public Response<Long> pexpireTime(String string) {
        return this.appendCommand(this.commandObjects.pexpireTime(string));
    }

    @Override
    public Response<Long> expireAt(String string, long l2) {
        return this.appendCommand(this.commandObjects.expireAt(string, l2));
    }

    @Override
    public Response<Long> expireAt(String string, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expireAt(string, l2, expiryOption));
    }

    @Override
    public Response<Long> pexpireAt(String string, long l2) {
        return this.appendCommand(this.commandObjects.pexpireAt(string, l2));
    }

    @Override
    public Response<Long> pexpireAt(String string, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpireAt(string, l2, expiryOption));
    }

    @Override
    public Response<Long> ttl(String string) {
        return this.appendCommand(this.commandObjects.ttl(string));
    }

    @Override
    public Response<Long> pttl(String string) {
        return this.appendCommand(this.commandObjects.pttl(string));
    }

    @Override
    public Response<Long> touch(String string) {
        return this.appendCommand(this.commandObjects.touch(string));
    }

    @Override
    public Response<Long> touch(String ... stringArray) {
        return this.appendCommand(this.commandObjects.touch(stringArray));
    }

    @Override
    public Response<List<String>> sort(String string) {
        return this.appendCommand(this.commandObjects.sort(string));
    }

    @Override
    public Response<Long> sort(String string, String string2) {
        return this.appendCommand(this.commandObjects.sort(string, string2));
    }

    @Override
    public Response<List<String>> sort(String string, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sort(string, sortingParams));
    }

    @Override
    public Response<Long> sort(String string, SortingParams sortingParams, String string2) {
        return this.appendCommand(this.commandObjects.sort(string, sortingParams, string2));
    }

    @Override
    public Response<List<String>> sortReadonly(String string, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sortReadonly(string, sortingParams));
    }

    @Override
    public Response<Long> del(String string) {
        return this.appendCommand(this.commandObjects.del(string));
    }

    @Override
    public Response<Long> del(String ... stringArray) {
        return this.appendCommand(this.commandObjects.del(stringArray));
    }

    @Override
    public Response<Long> unlink(String string) {
        return this.appendCommand(this.commandObjects.unlink(string));
    }

    @Override
    public Response<Long> unlink(String ... stringArray) {
        return this.appendCommand(this.commandObjects.unlink(stringArray));
    }

    @Override
    public Response<Boolean> copy(String string, String string2, boolean bl) {
        return this.appendCommand(this.commandObjects.copy(string, string2, bl));
    }

    @Override
    public Response<String> rename(String string, String string2) {
        return this.appendCommand(this.commandObjects.rename(string, string2));
    }

    @Override
    public Response<Long> renamenx(String string, String string2) {
        return this.appendCommand(this.commandObjects.renamenx(string, string2));
    }

    @Override
    public Response<Long> memoryUsage(String string) {
        return this.appendCommand(this.commandObjects.memoryUsage(string));
    }

    @Override
    public Response<Long> memoryUsage(String string, int n2) {
        return this.appendCommand(this.commandObjects.memoryUsage(string, n2));
    }

    @Override
    public Response<Long> objectRefcount(String string) {
        return this.appendCommand(this.commandObjects.objectRefcount(string));
    }

    @Override
    public Response<String> objectEncoding(String string) {
        return this.appendCommand(this.commandObjects.objectEncoding(string));
    }

    @Override
    public Response<Long> objectIdletime(String string) {
        return this.appendCommand(this.commandObjects.objectIdletime(string));
    }

    @Override
    public Response<Long> objectFreq(String string) {
        return this.appendCommand(this.commandObjects.objectFreq(string));
    }

    @Override
    public Response<String> migrate(String string, int n2, String string2, int n3) {
        return this.appendCommand(this.commandObjects.migrate(string, n2, string2, n3));
    }

    @Override
    public Response<String> migrate(String string, int n2, int n3, MigrateParams migrateParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, stringArray));
    }

    @Override
    public Response<Set<String>> keys(String string) {
        return this.appendCommand(this.commandObjects.keys(string));
    }

    @Override
    public Response<ScanResult<String>> scan(String string) {
        return this.appendCommand(this.commandObjects.scan(string));
    }

    @Override
    public Response<ScanResult<String>> scan(String string, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.scan(string, scanParams));
    }

    @Override
    public Response<ScanResult<String>> scan(String string, ScanParams scanParams, String string2) {
        return this.appendCommand(this.commandObjects.scan(string, scanParams, string2));
    }

    @Override
    public Response<String> randomKey() {
        return this.appendCommand(this.commandObjects.randomKey());
    }

    @Override
    public Response<String> get(String string) {
        return this.appendCommand(this.commandObjects.get(string));
    }

    @Override
    public Response<String> setGet(String string, String string2, SetParams setParams) {
        return this.appendCommand(this.commandObjects.setGet(string, string2, setParams));
    }

    @Override
    public Response<String> getDel(String string) {
        return this.appendCommand(this.commandObjects.getDel(string));
    }

    @Override
    public Response<String> getEx(String string, GetExParams getExParams) {
        return this.appendCommand(this.commandObjects.getEx(string, getExParams));
    }

    @Override
    public Response<Boolean> setbit(String string, long l2, boolean bl) {
        return this.appendCommand(this.commandObjects.setbit(string, l2, bl));
    }

    @Override
    public Response<Boolean> getbit(String string, long l2) {
        return this.appendCommand(this.commandObjects.getbit(string, l2));
    }

    @Override
    public Response<Long> setrange(String string, long l2, String string2) {
        return this.appendCommand(this.commandObjects.setrange(string, l2, string2));
    }

    @Override
    public Response<String> getrange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.getrange(string, l2, l3));
    }

    @Override
    public Response<String> getSet(String string, String string2) {
        return this.appendCommand(this.commandObjects.getSet(string, string2));
    }

    @Override
    public Response<Long> setnx(String string, String string2) {
        return this.appendCommand(this.commandObjects.setnx(string, string2));
    }

    @Override
    public Response<String> setex(String string, long l2, String string2) {
        return this.appendCommand(this.commandObjects.setex(string, l2, string2));
    }

    @Override
    public Response<String> psetex(String string, long l2, String string2) {
        return this.appendCommand(this.commandObjects.psetex(string, l2, string2));
    }

    @Override
    public Response<List<String>> mget(String ... stringArray) {
        return this.appendCommand(this.commandObjects.mget(stringArray));
    }

    @Override
    public Response<String> mset(String ... stringArray) {
        return this.appendCommand(this.commandObjects.mset(stringArray));
    }

    @Override
    public Response<Long> msetnx(String ... stringArray) {
        return this.appendCommand(this.commandObjects.msetnx(stringArray));
    }

    @Override
    public Response<Long> incr(String string) {
        return this.appendCommand(this.commandObjects.incr(string));
    }

    @Override
    public Response<Long> incrBy(String string, long l2) {
        return this.appendCommand(this.commandObjects.incrBy(string, l2));
    }

    @Override
    public Response<Double> incrByFloat(String string, double d2) {
        return this.appendCommand(this.commandObjects.incrByFloat(string, d2));
    }

    @Override
    public Response<Long> decr(String string) {
        return this.appendCommand(this.commandObjects.decr(string));
    }

    @Override
    public Response<Long> decrBy(String string, long l2) {
        return this.appendCommand(this.commandObjects.decrBy(string, l2));
    }

    @Override
    public Response<Long> append(String string, String string2) {
        return this.appendCommand(this.commandObjects.append(string, string2));
    }

    @Override
    public Response<String> substr(String string, int n2, int n3) {
        return this.appendCommand(this.commandObjects.substr(string, n2, n3));
    }

    @Override
    public Response<Long> strlen(String string) {
        return this.appendCommand(this.commandObjects.strlen(string));
    }

    @Override
    public Response<Long> bitcount(String string) {
        return this.appendCommand(this.commandObjects.bitcount(string));
    }

    @Override
    public Response<Long> bitcount(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.bitcount(string, l2, l3));
    }

    @Override
    public Response<Long> bitcount(String string, long l2, long l3, BitCountOption bitCountOption) {
        return this.appendCommand(this.commandObjects.bitcount(string, l2, l3, bitCountOption));
    }

    @Override
    public Response<Long> bitpos(String string, boolean bl) {
        return this.appendCommand(this.commandObjects.bitpos(string, bl));
    }

    @Override
    public Response<Long> bitpos(String string, boolean bl, BitPosParams bitPosParams) {
        return this.appendCommand(this.commandObjects.bitpos(string, bl, bitPosParams));
    }

    @Override
    public Response<List<Long>> bitfield(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bitfield(string, stringArray));
    }

    @Override
    public Response<List<Long>> bitfieldReadonly(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bitfieldReadonly(string, stringArray));
    }

    @Override
    public Response<Long> bitop(BitOP bitOP, String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bitop(bitOP, string, stringArray));
    }

    @Override
    public Response<LCSMatchResult> strAlgoLCSKeys(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.appendCommand(this.commandObjects.strAlgoLCSKeys(string, string2, strAlgoLCSParams));
    }

    @Override
    public Response<LCSMatchResult> lcs(String string, String string2, LCSParams lCSParams) {
        return this.appendCommand(this.commandObjects.lcs(string, string2, lCSParams));
    }

    @Override
    public Response<String> set(String string, String string2) {
        return this.appendCommand(this.commandObjects.set(string, string2));
    }

    @Override
    public Response<String> set(String string, String string2, SetParams setParams) {
        return this.appendCommand(this.commandObjects.set(string, string2, setParams));
    }

    @Override
    public Response<Long> rpush(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.rpush(string, stringArray));
    }

    @Override
    public Response<Long> lpush(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.lpush(string, stringArray));
    }

    @Override
    public Response<Long> llen(String string) {
        return this.appendCommand(this.commandObjects.llen(string));
    }

    @Override
    public Response<List<String>> lrange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.lrange(string, l2, l3));
    }

    @Override
    public Response<String> ltrim(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.ltrim(string, l2, l3));
    }

    @Override
    public Response<String> lindex(String string, long l2) {
        return this.appendCommand(this.commandObjects.lindex(string, l2));
    }

    @Override
    public Response<String> lset(String string, long l2, String string2) {
        return this.appendCommand(this.commandObjects.lset(string, l2, string2));
    }

    @Override
    public Response<Long> lrem(String string, long l2, String string2) {
        return this.appendCommand(this.commandObjects.lrem(string, l2, string2));
    }

    @Override
    public Response<String> lpop(String string) {
        return this.appendCommand(this.commandObjects.lpop(string));
    }

    @Override
    public Response<List<String>> lpop(String string, int n2) {
        return this.appendCommand(this.commandObjects.lpop(string, n2));
    }

    @Override
    public Response<Long> lpos(String string, String string2) {
        return this.appendCommand(this.commandObjects.lpos(string, string2));
    }

    @Override
    public Response<Long> lpos(String string, String string2, LPosParams lPosParams) {
        return this.appendCommand(this.commandObjects.lpos(string, string2, lPosParams));
    }

    @Override
    public Response<List<Long>> lpos(String string, String string2, LPosParams lPosParams, long l2) {
        return this.appendCommand(this.commandObjects.lpos(string, string2, lPosParams, l2));
    }

    @Override
    public Response<String> rpop(String string) {
        return this.appendCommand(this.commandObjects.rpop(string));
    }

    @Override
    public Response<List<String>> rpop(String string, int n2) {
        return this.appendCommand(this.commandObjects.rpop(string, n2));
    }

    @Override
    public Response<Long> linsert(String string, ListPosition listPosition, String string2, String string3) {
        return this.appendCommand(this.commandObjects.linsert(string, listPosition, string2, string3));
    }

    @Override
    public Response<Long> lpushx(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.lpushx(string, stringArray));
    }

    @Override
    public Response<Long> rpushx(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.rpushx(string, stringArray));
    }

    @Override
    public Response<List<String>> blpop(int n2, String string) {
        return this.appendCommand(this.commandObjects.blpop(n2, string));
    }

    @Override
    public Response<KeyedListElement> blpop(double d2, String string) {
        return this.appendCommand(this.commandObjects.blpop(d2, string));
    }

    @Override
    public Response<List<String>> brpop(int n2, String string) {
        return this.appendCommand(this.commandObjects.brpop(n2, string));
    }

    @Override
    public Response<KeyedListElement> brpop(double d2, String string) {
        return this.appendCommand(this.commandObjects.brpop(d2, string));
    }

    @Override
    public Response<List<String>> blpop(int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.blpop(n2, stringArray));
    }

    @Override
    public Response<KeyedListElement> blpop(double d2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.blpop(d2, stringArray));
    }

    @Override
    public Response<List<String>> brpop(int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.brpop(n2, stringArray));
    }

    @Override
    public Response<KeyedListElement> brpop(double d2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.brpop(d2, stringArray));
    }

    @Override
    public Response<String> rpoplpush(String string, String string2) {
        return this.appendCommand(this.commandObjects.rpoplpush(string, string2));
    }

    @Override
    public Response<String> brpoplpush(String string, String string2, int n2) {
        return this.appendCommand(this.commandObjects.brpoplpush(string, string2, n2));
    }

    @Override
    public Response<String> lmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2) {
        return this.appendCommand(this.commandObjects.lmove(string, string2, listDirection, listDirection2));
    }

    @Override
    public Response<String> blmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return this.appendCommand(this.commandObjects.blmove(string, string2, listDirection, listDirection2, d2));
    }

    @Override
    public Response<KeyValue<String, List<String>>> lmpop(ListDirection listDirection, String ... stringArray) {
        return this.appendCommand(this.commandObjects.lmpop(listDirection, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<String>>> lmpop(ListDirection listDirection, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.lmpop(listDirection, n2, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<String>>> blmpop(long l2, ListDirection listDirection, String ... stringArray) {
        return this.appendCommand(this.commandObjects.blmpop(l2, listDirection, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<String>>> blmpop(long l2, ListDirection listDirection, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.blmpop(l2, listDirection, n2, stringArray));
    }

    @Override
    public Response<Long> hset(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.hset(string, string2, string3));
    }

    @Override
    public Response<Long> hset(String string, Map<String, String> map) {
        return this.appendCommand(this.commandObjects.hset(string, map));
    }

    @Override
    public Response<String> hget(String string, String string2) {
        return this.appendCommand(this.commandObjects.hget(string, string2));
    }

    @Override
    public Response<Long> hsetnx(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.hsetnx(string, string2, string3));
    }

    @Override
    public Response<String> hmset(String string, Map<String, String> map) {
        return this.appendCommand(this.commandObjects.hmset(string, map));
    }

    @Override
    public Response<List<String>> hmget(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.hmget(string, stringArray));
    }

    @Override
    public Response<Long> hincrBy(String string, String string2, long l2) {
        return this.appendCommand(this.commandObjects.hincrBy(string, string2, l2));
    }

    @Override
    public Response<Double> hincrByFloat(String string, String string2, double d2) {
        return this.appendCommand(this.commandObjects.hincrByFloat(string, string2, d2));
    }

    @Override
    public Response<Boolean> hexists(String string, String string2) {
        return this.appendCommand(this.commandObjects.hexists(string, string2));
    }

    @Override
    public Response<Long> hdel(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.hdel(string, stringArray));
    }

    @Override
    public Response<Long> hlen(String string) {
        return this.appendCommand(this.commandObjects.hlen(string));
    }

    @Override
    public Response<Set<String>> hkeys(String string) {
        return this.appendCommand(this.commandObjects.hkeys(string));
    }

    @Override
    public Response<List<String>> hvals(String string) {
        return this.appendCommand(this.commandObjects.hvals(string));
    }

    @Override
    public Response<Map<String, String>> hgetAll(String string) {
        return this.appendCommand(this.commandObjects.hgetAll(string));
    }

    @Override
    public Response<String> hrandfield(String string) {
        return this.appendCommand(this.commandObjects.hrandfield(string));
    }

    @Override
    public Response<List<String>> hrandfield(String string, long l2) {
        return this.appendCommand(this.commandObjects.hrandfield(string, l2));
    }

    @Override
    public Response<Map<String, String>> hrandfieldWithValues(String string, long l2) {
        return this.appendCommand(this.commandObjects.hrandfieldWithValues(string, l2));
    }

    @Override
    public Response<ScanResult<Map.Entry<String, String>>> hscan(String string, String string2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.hscan(string, string2, scanParams));
    }

    @Override
    public Response<Long> hstrlen(String string, String string2) {
        return this.appendCommand(this.commandObjects.hstrlen(string, string2));
    }

    @Override
    public Response<Long> sadd(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.sadd(string, stringArray));
    }

    @Override
    public Response<Set<String>> smembers(String string) {
        return this.appendCommand(this.commandObjects.smembers(string));
    }

    @Override
    public Response<Long> srem(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.srem(string, stringArray));
    }

    @Override
    public Response<String> spop(String string) {
        return this.appendCommand(this.commandObjects.spop(string));
    }

    @Override
    public Response<Set<String>> spop(String string, long l2) {
        return this.appendCommand(this.commandObjects.spop(string, l2));
    }

    @Override
    public Response<Long> scard(String string) {
        return this.appendCommand(this.commandObjects.scard(string));
    }

    @Override
    public Response<Boolean> sismember(String string, String string2) {
        return this.appendCommand(this.commandObjects.sismember(string, string2));
    }

    @Override
    public Response<List<Boolean>> smismember(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.smismember(string, stringArray));
    }

    @Override
    public Response<String> srandmember(String string) {
        return this.appendCommand(this.commandObjects.srandmember(string));
    }

    @Override
    public Response<List<String>> srandmember(String string, int n2) {
        return this.appendCommand(this.commandObjects.srandmember(string, n2));
    }

    @Override
    public Response<ScanResult<String>> sscan(String string, String string2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.sscan(string, string2, scanParams));
    }

    @Override
    public Response<Set<String>> sdiff(String ... stringArray) {
        return this.appendCommand(this.commandObjects.sdiff(stringArray));
    }

    @Override
    public Response<Long> sdiffstore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.sdiffstore(string, stringArray));
    }

    @Override
    public Response<Set<String>> sinter(String ... stringArray) {
        return this.appendCommand(this.commandObjects.sinter(stringArray));
    }

    @Override
    public Response<Long> sinterstore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.sinterstore(string, stringArray));
    }

    @Override
    public Response<Long> sintercard(String ... stringArray) {
        return this.appendCommand(this.commandObjects.sintercard(stringArray));
    }

    @Override
    public Response<Long> sintercard(int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.sintercard(n2, stringArray));
    }

    @Override
    public Response<Set<String>> sunion(String ... stringArray) {
        return this.appendCommand(this.commandObjects.sunion(stringArray));
    }

    @Override
    public Response<Long> sunionstore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.sunionstore(string, stringArray));
    }

    @Override
    public Response<Long> smove(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.smove(string, string2, string3));
    }

    @Override
    public Response<Long> zadd(String string, double d2, String string2) {
        return this.appendCommand(this.commandObjects.zadd(string, d2, string2));
    }

    @Override
    public Response<Long> zadd(String string, double d2, String string2, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zadd(string, d2, string2, zAddParams));
    }

    @Override
    public Response<Long> zadd(String string, Map<String, Double> map) {
        return this.appendCommand(this.commandObjects.zadd(string, map));
    }

    @Override
    public Response<Long> zadd(String string, Map<String, Double> map, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zadd(string, map, zAddParams));
    }

    @Override
    public Response<Double> zaddIncr(String string, double d2, String string2, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zaddIncr(string, d2, string2, zAddParams));
    }

    @Override
    public Response<Long> zrem(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zrem(string, stringArray));
    }

    @Override
    public Response<Double> zincrby(String string, double d2, String string2) {
        return this.appendCommand(this.commandObjects.zincrby(string, d2, string2));
    }

    @Override
    public Response<Double> zincrby(String string, double d2, String string2, ZIncrByParams zIncrByParams) {
        return this.appendCommand(this.commandObjects.zincrby(string, d2, string2, zIncrByParams));
    }

    @Override
    public Response<Long> zrank(String string, String string2) {
        return this.appendCommand(this.commandObjects.zrank(string, string2));
    }

    @Override
    public Response<Long> zrevrank(String string, String string2) {
        return this.appendCommand(this.commandObjects.zrevrank(string, string2));
    }

    @Override
    public Response<List<String>> zrange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrange(string, l2, l3));
    }

    @Override
    public Response<List<String>> zrevrange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrevrange(string, l2, l3));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(string, l2, l3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeWithScores(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrevrangeWithScores(string, l2, l3));
    }

    @Override
    public Response<List<String>> zrange(String string, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrange(string, zRangeParams));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(String string, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(string, zRangeParams));
    }

    @Override
    public Response<Long> zrangestore(String string, String string2, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangestore(string, string2, zRangeParams));
    }

    @Override
    public Response<String> zrandmember(String string) {
        return this.appendCommand(this.commandObjects.zrandmember(string));
    }

    @Override
    public Response<List<String>> zrandmember(String string, long l2) {
        return this.appendCommand(this.commandObjects.zrandmember(string, l2));
    }

    @Override
    public Response<List<Tuple>> zrandmemberWithScores(String string, long l2) {
        return this.appendCommand(this.commandObjects.zrandmemberWithScores(string, l2));
    }

    @Override
    public Response<Long> zcard(String string) {
        return this.appendCommand(this.commandObjects.zcard(string));
    }

    @Override
    public Response<Double> zscore(String string, String string2) {
        return this.appendCommand(this.commandObjects.zscore(string, string2));
    }

    @Override
    public Response<List<Double>> zmscore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zmscore(string, stringArray));
    }

    @Override
    public Response<Tuple> zpopmax(String string) {
        return this.appendCommand(this.commandObjects.zpopmax(string));
    }

    @Override
    public Response<List<Tuple>> zpopmax(String string, int n2) {
        return this.appendCommand(this.commandObjects.zpopmax(string, n2));
    }

    @Override
    public Response<Tuple> zpopmin(String string) {
        return this.appendCommand(this.commandObjects.zpopmin(string));
    }

    @Override
    public Response<List<Tuple>> zpopmin(String string, int n2) {
        return this.appendCommand(this.commandObjects.zpopmin(string, n2));
    }

    @Override
    public Response<Long> zcount(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zcount(string, d2, d3));
    }

    @Override
    public Response<Long> zcount(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zcount(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrangeByScore(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(string, d2, d3));
    }

    @Override
    public Response<List<String>> zrangeByScore(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(string, d2, d3));
    }

    @Override
    public Response<List<String>> zrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public Response<List<String>> zrevrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public Response<Long> zremrangeByRank(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zremrangeByRank(string, l2, l3));
    }

    @Override
    public Response<Long> zremrangeByScore(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(string, d2, d3));
    }

    @Override
    public Response<Long> zremrangeByScore(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(string, string2, string3));
    }

    @Override
    public Response<Long> zlexcount(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zlexcount(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrangeByLex(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrangeByLex(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public Response<List<String>> zrevrangeByLex(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(string, string2, string3));
    }

    @Override
    public Response<List<String>> zrevrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public Response<Long> zremrangeByLex(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.zremrangeByLex(string, string2, string3));
    }

    @Override
    public Response<ScanResult<Tuple>> zscan(String string, String string2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.zscan(string, string2, scanParams));
    }

    @Override
    public Response<KeyedZSetElement> bzpopmax(double d2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bzpopmax(d2, stringArray));
    }

    @Override
    public Response<KeyedZSetElement> bzpopmin(double d2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bzpopmin(d2, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption sortedSetOption, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zmpop(sortedSetOption, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zmpop(sortedSetOption, n2, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bzmpop(l2, sortedSetOption, stringArray));
    }

    @Override
    public Response<KeyValue<String, List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, stringArray));
    }

    @Override
    public Response<Set<String>> zdiff(String ... stringArray) {
        return this.appendCommand(this.commandObjects.zdiff(stringArray));
    }

    @Override
    public Response<Set<Tuple>> zdiffWithScores(String ... stringArray) {
        return this.appendCommand(this.commandObjects.zdiffWithScores(stringArray));
    }

    @Override
    public Response<Long> zdiffStore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zdiffStore(string, stringArray));
    }

    @Override
    public Response<Long> zinterstore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zinterstore(string, stringArray));
    }

    @Override
    public Response<Long> zinterstore(String string, ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zinterstore(string, zParams, stringArray));
    }

    @Override
    public Response<Set<String>> zinter(ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zinter(zParams, stringArray));
    }

    @Override
    public Response<Set<Tuple>> zinterWithScores(ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zinterWithScores(zParams, stringArray));
    }

    @Override
    public Response<Long> zintercard(String ... stringArray) {
        return this.appendCommand(this.commandObjects.zintercard(stringArray));
    }

    @Override
    public Response<Long> zintercard(long l2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zintercard(l2, stringArray));
    }

    @Override
    public Response<Set<String>> zunion(ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zunion(zParams, stringArray));
    }

    @Override
    public Response<Set<Tuple>> zunionWithScores(ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zunionWithScores(zParams, stringArray));
    }

    @Override
    public Response<Long> zunionstore(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zunionstore(string, stringArray));
    }

    @Override
    public Response<Long> zunionstore(String string, ZParams zParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.zunionstore(string, zParams, stringArray));
    }

    @Override
    public Response<Long> geoadd(String string, double d2, double d3, String string2) {
        return this.appendCommand(this.commandObjects.geoadd(string, d2, d3, string2));
    }

    @Override
    public Response<Long> geoadd(String string, Map<String, GeoCoordinate> map) {
        return this.appendCommand(this.commandObjects.geoadd(string, map));
    }

    @Override
    public Response<Long> geoadd(String string, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        return this.appendCommand(this.commandObjects.geoadd(string, geoAddParams, map));
    }

    @Override
    public Response<Double> geodist(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.geodist(string, string2, string3));
    }

    @Override
    public Response<Double> geodist(String string, String string2, String string3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geodist(string, string2, string3, geoUnit));
    }

    @Override
    public Response<List<String>> geohash(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.geohash(string, stringArray));
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.geopos(string, stringArray));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<Long> georadiusStore(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.appendCommand(this.commandObjects.georadiusStore(string, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public Response<Long> georadiusByMemberStore(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberStore(string, string2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String string, String string2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(string, string2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String string, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String string, String string2, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(string, string2, d2, d3, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String string, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(String string, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearch(string, geoSearchParam));
    }

    @Override
    public Response<Long> geosearchStore(String string, String string2, String string3, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(String string, String string2, String string3, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, d3, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(String string, String string2, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearchStore(string, string2, geoSearchParam));
    }

    @Override
    public Response<Long> geosearchStoreStoreDist(String string, String string2, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearchStoreStoreDist(string, string2, geoSearchParam));
    }

    @Override
    public Response<Long> pfadd(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.pfadd(string, stringArray));
    }

    @Override
    public Response<String> pfmerge(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.pfmerge(string, stringArray));
    }

    @Override
    public Response<Long> pfcount(String string) {
        return this.appendCommand(this.commandObjects.pfcount(string));
    }

    @Override
    public Response<Long> pfcount(String ... stringArray) {
        return this.appendCommand(this.commandObjects.pfcount(stringArray));
    }

    @Override
    public Response<StreamEntryID> xadd(String string, StreamEntryID streamEntryID, Map<String, String> map) {
        return this.appendCommand(this.commandObjects.xadd(string, streamEntryID, map));
    }

    @Override
    public Response<StreamEntryID> xadd(String string, XAddParams xAddParams, Map<String, String> map) {
        return this.appendCommand(this.commandObjects.xadd(string, xAddParams, map));
    }

    @Override
    public Response<Long> xlen(String string) {
        return this.appendCommand(this.commandObjects.xlen(string));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return this.appendCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return this.appendCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2, n2));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return this.appendCommand(this.commandObjects.xrevrange(string, streamEntryID2, streamEntryID));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return this.appendCommand(this.commandObjects.xrevrange(string, streamEntryID2, streamEntryID, n2));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.xrange(string, string2, string3));
    }

    @Override
    public Response<List<StreamEntry>> xrange(String string, String string2, String string3, int n2) {
        return this.appendCommand(this.commandObjects.xrange(string, string2, string3, n2));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.xrevrange(string, string3, string2));
    }

    @Override
    public Response<List<StreamEntry>> xrevrange(String string, String string2, String string3, int n2) {
        return this.appendCommand(this.commandObjects.xrevrange(string, string3, string2, n2));
    }

    @Override
    public Response<Long> xack(String string, String string2, StreamEntryID ... streamEntryIDArray) {
        return this.appendCommand(this.commandObjects.xack(string, string2, streamEntryIDArray));
    }

    @Override
    public Response<String> xgroupCreate(String string, String string2, StreamEntryID streamEntryID, boolean bl) {
        return this.appendCommand(this.commandObjects.xgroupCreate(string, string2, streamEntryID, bl));
    }

    @Override
    public Response<String> xgroupSetID(String string, String string2, StreamEntryID streamEntryID) {
        return this.appendCommand(this.commandObjects.xgroupSetID(string, string2, streamEntryID));
    }

    @Override
    public Response<Long> xgroupDestroy(String string, String string2) {
        return this.appendCommand(this.commandObjects.xgroupDestroy(string, string2));
    }

    @Override
    public Response<Boolean> xgroupCreateConsumer(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.xgroupCreateConsumer(string, string2, string3));
    }

    @Override
    public Response<Long> xgroupDelConsumer(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.xgroupDelConsumer(string, string2, string3));
    }

    @Override
    public Response<StreamPendingSummary> xpending(String string, String string2) {
        return this.appendCommand(this.commandObjects.xpending(string, string2));
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(String string, String string2, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2, String string3) {
        return this.appendCommand(this.commandObjects.xpending(string, string2, streamEntryID, streamEntryID2, n2, string3));
    }

    @Override
    public Response<List<StreamPendingEntry>> xpending(String string, String string2, XPendingParams xPendingParams) {
        return this.appendCommand(this.commandObjects.xpending(string, string2, xPendingParams));
    }

    @Override
    public Response<Long> xdel(String string, StreamEntryID ... streamEntryIDArray) {
        return this.appendCommand(this.commandObjects.xdel(string, streamEntryIDArray));
    }

    @Override
    public Response<Long> xtrim(String string, long l2, boolean bl) {
        return this.appendCommand(this.commandObjects.xtrim(string, l2, bl));
    }

    @Override
    public Response<Long> xtrim(String string, XTrimParams xTrimParams) {
        return this.appendCommand(this.commandObjects.xtrim(string, xTrimParams));
    }

    @Override
    public Response<List<StreamEntry>> xclaim(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return this.appendCommand(this.commandObjects.xclaim(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public Response<List<StreamEntryID>> xclaimJustId(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return this.appendCommand(this.commandObjects.xclaimJustId(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public Response<Map.Entry<StreamEntryID, List<StreamEntry>>> xautoclaim(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return this.appendCommand(this.commandObjects.xautoclaim(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public Response<Map.Entry<StreamEntryID, List<StreamEntryID>>> xautoclaimJustId(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return this.appendCommand(this.commandObjects.xautoclaimJustId(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public Response<StreamInfo> xinfoStream(String string) {
        return this.appendCommand(this.commandObjects.xinfoStream(string));
    }

    @Override
    public Response<StreamFullInfo> xinfoStreamFull(String string) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(string));
    }

    @Override
    public Response<StreamFullInfo> xinfoStreamFull(String string, int n2) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(string, n2));
    }

    @Override
    @Deprecated
    public Response<List<StreamGroupInfo>> xinfoGroup(String string) {
        return this.appendCommand(this.commandObjects.xinfoGroup(string));
    }

    @Override
    public Response<List<StreamGroupInfo>> xinfoGroups(String string) {
        return this.appendCommand(this.commandObjects.xinfoGroups(string));
    }

    @Override
    public Response<List<StreamConsumersInfo>> xinfoConsumers(String string, String string2) {
        return this.appendCommand(this.commandObjects.xinfoConsumers(string, string2));
    }

    @Override
    public Response<List<Map.Entry<String, List<StreamEntry>>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> map) {
        return this.appendCommand(this.commandObjects.xread(xReadParams, map));
    }

    @Override
    public Response<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String string, String string2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> map) {
        return this.appendCommand(this.commandObjects.xreadGroup(string, string2, xReadGroupParams, map));
    }

    @Override
    public Response<Object> eval(String string) {
        return this.appendCommand(this.commandObjects.eval(string));
    }

    @Override
    public Response<Object> eval(String string, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.eval(string, n2, stringArray));
    }

    @Override
    public Response<Object> eval(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.eval(string, list, list2));
    }

    @Override
    public Response<Object> evalReadonly(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.evalReadonly(string, list, list2));
    }

    @Override
    public Response<Object> evalsha(String string) {
        return this.appendCommand(this.commandObjects.evalsha(string));
    }

    @Override
    public Response<Object> evalsha(String string, int n2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.evalsha(string, n2, stringArray));
    }

    @Override
    public Response<Object> evalsha(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.evalsha(string, list, list2));
    }

    @Override
    public Response<Object> evalshaReadonly(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.evalshaReadonly(string, list, list2));
    }

    @Override
    public Response<Long> waitReplicas(String string, int n2, long l2) {
        return this.appendCommand(this.commandObjects.waitReplicas(string, n2, l2));
    }

    @Override
    public Response<Object> eval(String string, String string2) {
        return this.appendCommand(this.commandObjects.eval(string, string2));
    }

    @Override
    public Response<Object> evalsha(String string, String string2) {
        return this.appendCommand(this.commandObjects.evalsha(string, string2));
    }

    @Override
    public Response<List<Boolean>> scriptExists(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.scriptExists(string, stringArray));
    }

    @Override
    public Response<String> scriptLoad(String string, String string2) {
        return this.appendCommand(this.commandObjects.scriptLoad(string, string2));
    }

    @Override
    public Response<String> scriptFlush(String string) {
        return this.appendCommand(this.commandObjects.scriptFlush(string));
    }

    @Override
    public Response<String> scriptFlush(String string, FlushMode flushMode) {
        return this.appendCommand(this.commandObjects.scriptFlush(string, flushMode));
    }

    @Override
    public Response<String> scriptKill(String string) {
        return this.appendCommand(this.commandObjects.scriptKill(string));
    }

    @Override
    public Response<Object> fcall(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.fcall(byArray, list, list2));
    }

    @Override
    public Response<Object> fcall(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.fcall(string, list, list2));
    }

    @Override
    public Response<Object> fcallReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.fcallReadonly(byArray, list, list2));
    }

    @Override
    public Response<Object> fcallReadonly(String string, List<String> list, List<String> list2) {
        return this.appendCommand(this.commandObjects.fcallReadonly(string, list, list2));
    }

    @Override
    public Response<String> functionDelete(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionDelete(byArray));
    }

    @Override
    public Response<String> functionDelete(String string) {
        return this.appendCommand(this.commandObjects.functionDelete(string));
    }

    @Override
    public Response<byte[]> functionDump() {
        return this.appendCommand(this.commandObjects.functionDump());
    }

    @Override
    public Response<List<LibraryInfo>> functionList(String string) {
        return this.appendCommand(this.commandObjects.functionList(string));
    }

    @Override
    public Response<List<LibraryInfo>> functionList() {
        return this.appendCommand(this.commandObjects.functionList());
    }

    @Override
    public Response<List<LibraryInfo>> functionListWithCode(String string) {
        return this.appendCommand(this.commandObjects.functionListWithCode(string));
    }

    @Override
    public Response<List<LibraryInfo>> functionListWithCode() {
        return this.appendCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public Response<List<Object>> functionListBinary() {
        return this.appendCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public Response<List<Object>> functionList(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionList(byArray));
    }

    @Override
    public Response<List<Object>> functionListWithCodeBinary() {
        return this.appendCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public Response<List<Object>> functionListWithCode(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionListWithCode(byArray));
    }

    @Override
    public Response<String> functionLoad(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionLoad(byArray));
    }

    @Override
    public Response<String> functionLoad(String string) {
        return this.appendCommand(this.commandObjects.functionLoad(string));
    }

    @Override
    public Response<String> functionLoadReplace(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionLoadReplace(byArray));
    }

    @Override
    public Response<String> functionLoadReplace(String string) {
        return this.appendCommand(this.commandObjects.functionLoadReplace(string));
    }

    @Override
    public Response<String> functionRestore(byte[] byArray) {
        return this.appendCommand(this.commandObjects.functionRestore(byArray));
    }

    @Override
    public Response<String> functionRestore(byte[] byArray, FunctionRestorePolicy functionRestorePolicy) {
        return this.appendCommand(this.commandObjects.functionRestore(byArray, functionRestorePolicy));
    }

    @Override
    public Response<String> functionFlush() {
        return this.appendCommand(this.commandObjects.functionFlush());
    }

    @Override
    public Response<String> functionFlush(FlushMode flushMode) {
        return this.appendCommand(this.commandObjects.functionFlush(flushMode));
    }

    @Override
    public Response<String> functionKill() {
        return this.appendCommand(this.commandObjects.functionKill());
    }

    @Override
    public Response<FunctionStats> functionStats() {
        return this.appendCommand(this.commandObjects.functionStats());
    }

    @Override
    public Response<Object> functionStatsBinary() {
        return this.appendCommand(this.commandObjects.functionStatsBinary());
    }

    public Response<Long> publish(String string, String string2) {
        return this.appendCommand(this.commandObjects.publish(string, string2));
    }

    public Response<LCSMatchResult> strAlgoLCSStrings(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.appendCommand(this.commandObjects.strAlgoLCSStrings(string, string2, strAlgoLCSParams));
    }

    @Override
    public Response<Long> geoadd(byte[] byArray, double d2, double d3, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.geoadd(byArray, d2, d3, byArray2));
    }

    @Override
    public Response<Long> geoadd(byte[] byArray, Map<byte[], GeoCoordinate> map) {
        return this.appendCommand(this.commandObjects.geoadd(byArray, map));
    }

    @Override
    public Response<Long> geoadd(byte[] byArray, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        return this.appendCommand(this.commandObjects.geoadd(byArray, geoAddParams, map));
    }

    @Override
    public Response<Double> geodist(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.geodist(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Double> geodist(byte[] byArray, byte[] byArray2, byte[] byArray3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geodist(byArray, byArray2, byArray3, geoUnit));
    }

    @Override
    public Response<List<byte[]>> geohash(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.geohash(byArray, byArray2));
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.geopos(byArray, byArray2));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public Response<Long> georadiusStore(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.appendCommand(this.commandObjects.georadiusStore(byArray, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public Response<Long> georadiusByMemberStore(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return this.appendCommand(this.commandObjects.georadiusByMemberStore(byArray, byArray2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] byArray, byte[] byArray2, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(byArray, byArray2, d2, d3, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public Response<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearch(byArray, geoSearchParam));
    }

    @Override
    public Response<Long> geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, d3, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return this.appendCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public Response<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoSearchParam));
    }

    @Override
    public Response<Long> geosearchStoreStoreDist(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return this.appendCommand(this.commandObjects.geosearchStoreStoreDist(byArray, byArray2, geoSearchParam));
    }

    @Override
    public Response<Long> hset(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.hset(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> hset(byte[] byArray, Map<byte[], byte[]> map) {
        return this.appendCommand(this.commandObjects.hset(byArray, map));
    }

    @Override
    public Response<byte[]> hget(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.hget(byArray, byArray2));
    }

    @Override
    public Response<Long> hsetnx(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.hsetnx(byArray, byArray2, byArray3));
    }

    @Override
    public Response<String> hmset(byte[] byArray, Map<byte[], byte[]> map) {
        return this.appendCommand(this.commandObjects.hmset(byArray, map));
    }

    @Override
    public Response<List<byte[]>> hmget(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.hmget(byArray, byArray2));
    }

    @Override
    public Response<Long> hincrBy(byte[] byArray, byte[] byArray2, long l2) {
        return this.appendCommand(this.commandObjects.hincrBy(byArray, byArray2, l2));
    }

    @Override
    public Response<Double> hincrByFloat(byte[] byArray, byte[] byArray2, double d2) {
        return this.appendCommand(this.commandObjects.hincrByFloat(byArray, byArray2, d2));
    }

    @Override
    public Response<Boolean> hexists(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.hexists(byArray, byArray2));
    }

    @Override
    public Response<Long> hdel(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.hdel(byArray, byArray2));
    }

    @Override
    public Response<Long> hlen(byte[] byArray) {
        return this.appendCommand(this.commandObjects.hlen(byArray));
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] byArray) {
        return this.appendCommand(this.commandObjects.hkeys(byArray));
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] byArray) {
        return this.appendCommand(this.commandObjects.hvals(byArray));
    }

    @Override
    public Response<Map<byte[], byte[]>> hgetAll(byte[] byArray) {
        return this.appendCommand(this.commandObjects.hgetAll(byArray));
    }

    @Override
    public Response<byte[]> hrandfield(byte[] byArray) {
        return this.appendCommand(this.commandObjects.hrandfield(byArray));
    }

    @Override
    public Response<List<byte[]>> hrandfield(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.hrandfield(byArray, l2));
    }

    @Override
    public Response<Map<byte[], byte[]>> hrandfieldWithValues(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.hrandfieldWithValues(byArray, l2));
    }

    @Override
    public Response<ScanResult<Map.Entry<byte[], byte[]>>> hscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.hscan(byArray, byArray2, scanParams));
    }

    @Override
    public Response<Long> hstrlen(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.hstrlen(byArray, byArray2));
    }

    @Override
    public Response<Long> pfadd(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.pfadd(byArray, byArray2));
    }

    @Override
    public Response<String> pfmerge(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.pfmerge(byArray, byArray2));
    }

    @Override
    public Response<Long> pfcount(byte[] byArray) {
        return this.appendCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public Response<Long> pfcount(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public Response<Boolean> exists(byte[] byArray) {
        return this.appendCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public Response<Long> exists(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public Response<Long> persist(byte[] byArray) {
        return this.appendCommand(this.commandObjects.persist(byArray));
    }

    @Override
    public Response<String> type(byte[] byArray) {
        return this.appendCommand(this.commandObjects.type(byArray));
    }

    @Override
    public Response<byte[]> dump(byte[] byArray) {
        return this.appendCommand(this.commandObjects.dump(byArray));
    }

    @Override
    public Response<String> restore(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.restore(byArray, l2, byArray2));
    }

    @Override
    public Response<String> restore(byte[] byArray, long l2, byte[] byArray2, RestoreParams restoreParams) {
        return this.appendCommand(this.commandObjects.restore(byArray, l2, byArray2, restoreParams));
    }

    @Override
    public Response<Long> expire(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.expire(byArray, l2));
    }

    @Override
    public Response<Long> expire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expire(byArray, l2, expiryOption));
    }

    @Override
    public Response<Long> pexpire(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.pexpire(byArray, l2));
    }

    @Override
    public Response<Long> pexpire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpire(byArray, l2, expiryOption));
    }

    @Override
    public Response<Long> expireTime(byte[] byArray) {
        return this.appendCommand(this.commandObjects.expireTime(byArray));
    }

    @Override
    public Response<Long> pexpireTime(byte[] byArray) {
        return this.appendCommand(this.commandObjects.pexpireTime(byArray));
    }

    @Override
    public Response<Long> expireAt(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.expireAt(byArray, l2));
    }

    @Override
    public Response<Long> expireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.expireAt(byArray, l2, expiryOption));
    }

    @Override
    public Response<Long> pexpireAt(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.pexpireAt(byArray, l2));
    }

    @Override
    public Response<Long> pexpireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return this.appendCommand(this.commandObjects.pexpireAt(byArray, l2, expiryOption));
    }

    @Override
    public Response<Long> ttl(byte[] byArray) {
        return this.appendCommand(this.commandObjects.ttl(byArray));
    }

    @Override
    public Response<Long> pttl(byte[] byArray) {
        return this.appendCommand(this.commandObjects.pttl(byArray));
    }

    @Override
    public Response<Long> touch(byte[] byArray) {
        return this.appendCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public Response<Long> touch(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public Response<List<byte[]>> sort(byte[] byArray) {
        return this.appendCommand(this.commandObjects.sort(byArray));
    }

    @Override
    public Response<List<byte[]>> sort(byte[] byArray, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sort(byArray, sortingParams));
    }

    @Override
    public Response<List<byte[]>> sortReadonly(byte[] byArray, SortingParams sortingParams) {
        return this.appendCommand(this.commandObjects.sortReadonly(byArray, sortingParams));
    }

    @Override
    public Response<Long> del(byte[] byArray) {
        return this.appendCommand(this.commandObjects.del(byArray));
    }

    @Override
    public Response<Long> del(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.del(byArray));
    }

    @Override
    public Response<Long> unlink(byte[] byArray) {
        return this.appendCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public Response<Long> unlink(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public Response<Boolean> copy(byte[] byArray, byte[] byArray2, boolean bl) {
        return this.appendCommand(this.commandObjects.copy(byArray, byArray2, bl));
    }

    @Override
    public Response<String> rename(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.rename(byArray, byArray2));
    }

    @Override
    public Response<Long> renamenx(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.renamenx(byArray, byArray2));
    }

    @Override
    public Response<Long> sort(byte[] byArray, SortingParams sortingParams, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.sort(byArray, sortingParams, byArray2));
    }

    @Override
    public Response<Long> sort(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.sort(byArray, byArray2));
    }

    @Override
    public Response<Long> memoryUsage(byte[] byArray) {
        return this.appendCommand(this.commandObjects.memoryUsage(byArray));
    }

    @Override
    public Response<Long> memoryUsage(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.memoryUsage(byArray, n2));
    }

    @Override
    public Response<Long> objectRefcount(byte[] byArray) {
        return this.appendCommand(this.commandObjects.objectRefcount(byArray));
    }

    @Override
    public Response<byte[]> objectEncoding(byte[] byArray) {
        return this.appendCommand(this.commandObjects.objectEncoding(byArray));
    }

    @Override
    public Response<Long> objectIdletime(byte[] byArray) {
        return this.appendCommand(this.commandObjects.objectIdletime(byArray));
    }

    @Override
    public Response<Long> objectFreq(byte[] byArray) {
        return this.appendCommand(this.commandObjects.objectFreq(byArray));
    }

    @Override
    public Response<String> migrate(String string, int n2, byte[] byArray, int n3) {
        return this.appendCommand(this.commandObjects.migrate(string, n2, byArray, n3));
    }

    @Override
    public Response<String> migrate(String string, int n2, int n3, MigrateParams migrateParams, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, byArray));
    }

    @Override
    public Response<Set<byte[]>> keys(byte[] byArray) {
        return this.appendCommand(this.commandObjects.keys(byArray));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] byArray) {
        return this.appendCommand(this.commandObjects.scan(byArray));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.scan(byArray, scanParams));
    }

    @Override
    public Response<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.scan(byArray, scanParams, byArray2));
    }

    @Override
    public Response<byte[]> randomBinaryKey() {
        return this.appendCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public Response<Long> rpush(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.rpush(byArray, byArray2));
    }

    @Override
    public Response<Long> lpush(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.lpush(byArray, byArray2));
    }

    @Override
    public Response<Long> llen(byte[] byArray) {
        return this.appendCommand(this.commandObjects.llen(byArray));
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.lrange(byArray, l2, l3));
    }

    @Override
    public Response<String> ltrim(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.ltrim(byArray, l2, l3));
    }

    @Override
    public Response<byte[]> lindex(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.lindex(byArray, l2));
    }

    @Override
    public Response<String> lset(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.lset(byArray, l2, byArray2));
    }

    @Override
    public Response<Long> lrem(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.lrem(byArray, l2, byArray2));
    }

    @Override
    public Response<byte[]> lpop(byte[] byArray) {
        return this.appendCommand(this.commandObjects.lpop(byArray));
    }

    @Override
    public Response<List<byte[]>> lpop(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.lpop(byArray, n2));
    }

    @Override
    public Response<Long> lpos(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.lpos(byArray, byArray2));
    }

    @Override
    public Response<Long> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams) {
        return this.appendCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams));
    }

    @Override
    public Response<List<Long>> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams, long l2) {
        return this.appendCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams, l2));
    }

    @Override
    public Response<byte[]> rpop(byte[] byArray) {
        return this.appendCommand(this.commandObjects.rpop(byArray));
    }

    @Override
    public Response<List<byte[]>> rpop(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.rpop(byArray, n2));
    }

    @Override
    public Response<Long> linsert(byte[] byArray, ListPosition listPosition, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.linsert(byArray, listPosition, byArray2, byArray3));
    }

    @Override
    public Response<Long> lpushx(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.lpushx(byArray, byArray2));
    }

    @Override
    public Response<Long> rpushx(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.rpushx(byArray, byArray2));
    }

    @Override
    public Response<List<byte[]>> blpop(int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.blpop(n2, byArray));
    }

    @Override
    public Response<List<byte[]>> blpop(double d2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.blpop(d2, byArray));
    }

    @Override
    public Response<List<byte[]>> brpop(int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.brpop(n2, byArray));
    }

    @Override
    public Response<List<byte[]>> brpop(double d2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.brpop(d2, byArray));
    }

    @Override
    public Response<byte[]> rpoplpush(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.rpoplpush(byArray, byArray2));
    }

    @Override
    public Response<byte[]> brpoplpush(byte[] byArray, byte[] byArray2, int n2) {
        return this.appendCommand(this.commandObjects.brpoplpush(byArray, byArray2, n2));
    }

    @Override
    public Response<byte[]> lmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2) {
        return this.appendCommand(this.commandObjects.lmove(byArray, byArray2, listDirection, listDirection2));
    }

    @Override
    public Response<byte[]> blmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return this.appendCommand(this.commandObjects.blmove(byArray, byArray2, listDirection, listDirection2, d2));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection listDirection, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.lmpop(listDirection, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection listDirection, int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.lmpop(listDirection, n2, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> blmpop(long l2, ListDirection listDirection, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.blmpop(l2, listDirection, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<byte[]>>> blmpop(long l2, ListDirection listDirection, int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.blmpop(l2, listDirection, n2, byArray));
    }

    public Response<Long> publish(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.publish(byArray, byArray2));
    }

    public Response<LCSMatchResult> strAlgoLCSStrings(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.appendCommand(this.commandObjects.strAlgoLCSStrings(byArray, byArray2, strAlgoLCSParams));
    }

    @Override
    public Response<Long> waitReplicas(byte[] byArray, int n2, long l2) {
        return this.appendCommand(this.commandObjects.waitReplicas(byArray, n2, l2));
    }

    @Override
    public Response<Object> eval(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.eval(byArray, byArray2));
    }

    @Override
    public Response<Object> evalsha(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.evalsha(byArray, byArray2));
    }

    @Override
    public Response<List<Boolean>> scriptExists(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.scriptExists(byArray, byArray2));
    }

    @Override
    public Response<byte[]> scriptLoad(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.scriptLoad(byArray, byArray2));
    }

    @Override
    public Response<String> scriptFlush(byte[] byArray) {
        return this.appendCommand(this.commandObjects.scriptFlush(byArray));
    }

    @Override
    public Response<String> scriptFlush(byte[] byArray, FlushMode flushMode) {
        return this.appendCommand(this.commandObjects.scriptFlush(byArray, flushMode));
    }

    @Override
    public Response<String> scriptKill(byte[] byArray) {
        return this.appendCommand(this.commandObjects.scriptKill(byArray));
    }

    @Override
    public Response<Object> eval(byte[] byArray) {
        return this.appendCommand(this.commandObjects.eval(byArray));
    }

    @Override
    public Response<Object> eval(byte[] byArray, int n2, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.eval(byArray, n2, byArray2));
    }

    @Override
    public Response<Object> eval(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.eval(byArray, list, list2));
    }

    @Override
    public Response<Object> evalReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.evalReadonly(byArray, list, list2));
    }

    @Override
    public Response<Object> evalsha(byte[] byArray) {
        return this.appendCommand(this.commandObjects.evalsha(byArray));
    }

    @Override
    public Response<Object> evalsha(byte[] byArray, int n2, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.evalsha(byArray, n2, byArray2));
    }

    @Override
    public Response<Object> evalsha(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.evalsha(byArray, list, list2));
    }

    @Override
    public Response<Object> evalshaReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        return this.appendCommand(this.commandObjects.evalshaReadonly(byArray, list, list2));
    }

    @Override
    public Response<Long> sadd(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.sadd(byArray, byArray2));
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] byArray) {
        return this.appendCommand(this.commandObjects.smembers(byArray));
    }

    @Override
    public Response<Long> srem(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.srem(byArray, byArray2));
    }

    @Override
    public Response<byte[]> spop(byte[] byArray) {
        return this.appendCommand(this.commandObjects.spop(byArray));
    }

    @Override
    public Response<Set<byte[]>> spop(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.spop(byArray, l2));
    }

    @Override
    public Response<Long> scard(byte[] byArray) {
        return this.appendCommand(this.commandObjects.scard(byArray));
    }

    @Override
    public Response<Boolean> sismember(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.sismember(byArray, byArray2));
    }

    @Override
    public Response<List<Boolean>> smismember(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.smismember(byArray, byArray2));
    }

    @Override
    public Response<byte[]> srandmember(byte[] byArray) {
        return this.appendCommand(this.commandObjects.srandmember(byArray));
    }

    @Override
    public Response<List<byte[]>> srandmember(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.srandmember(byArray, n2));
    }

    @Override
    public Response<ScanResult<byte[]>> sscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.sscan(byArray, byArray2, scanParams));
    }

    @Override
    public Response<Set<byte[]>> sdiff(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.sdiff(byArray));
    }

    @Override
    public Response<Long> sdiffstore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.sdiffstore(byArray, byArray2));
    }

    @Override
    public Response<Set<byte[]>> sinter(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.sinter(byArray));
    }

    @Override
    public Response<Long> sinterstore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.sinterstore(byArray, byArray2));
    }

    @Override
    public Response<Long> sintercard(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.sintercard(byArray));
    }

    @Override
    public Response<Long> sintercard(int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.sintercard(n2, byArray));
    }

    @Override
    public Response<Set<byte[]>> sunion(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.sunion(byArray));
    }

    @Override
    public Response<Long> sunionstore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.sunionstore(byArray, byArray2));
    }

    @Override
    public Response<Long> smove(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.smove(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> zadd(byte[] byArray, double d2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.zadd(byArray, d2, byArray2));
    }

    @Override
    public Response<Long> zadd(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zadd(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public Response<Long> zadd(byte[] byArray, Map<byte[], Double> map) {
        return this.appendCommand(this.commandObjects.zadd(byArray, map));
    }

    @Override
    public Response<Long> zadd(byte[] byArray, Map<byte[], Double> map, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zadd(byArray, map, zAddParams));
    }

    @Override
    public Response<Double> zaddIncr(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return this.appendCommand(this.commandObjects.zaddIncr(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public Response<Long> zrem(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zrem(byArray, byArray2));
    }

    @Override
    public Response<Double> zincrby(byte[] byArray, double d2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.zincrby(byArray, d2, byArray2));
    }

    @Override
    public Response<Double> zincrby(byte[] byArray, double d2, byte[] byArray2, ZIncrByParams zIncrByParams) {
        return this.appendCommand(this.commandObjects.zincrby(byArray, d2, byArray2, zIncrByParams));
    }

    @Override
    public Response<Long> zrank(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.zrank(byArray, byArray2));
    }

    @Override
    public Response<Long> zrevrank(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.zrevrank(byArray, byArray2));
    }

    @Override
    public Response<List<byte[]>> zrange(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrange(byArray, l2, l3));
    }

    @Override
    public Response<List<byte[]>> zrevrange(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrevrange(byArray, l2, l3));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(byArray, l2, l3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeWithScores(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zrevrangeWithScores(byArray, l2, l3));
    }

    @Override
    public Response<List<byte[]>> zrange(byte[] byArray, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrange(byArray, zRangeParams));
    }

    @Override
    public Response<List<Tuple>> zrangeWithScores(byte[] byArray, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangeWithScores(byArray, zRangeParams));
    }

    @Override
    public Response<Long> zrangestore(byte[] byArray, byte[] byArray2, ZRangeParams zRangeParams) {
        return this.appendCommand(this.commandObjects.zrangestore(byArray, byArray2, zRangeParams));
    }

    @Override
    public Response<byte[]> zrandmember(byte[] byArray) {
        return this.appendCommand(this.commandObjects.zrandmember(byArray));
    }

    @Override
    public Response<List<byte[]>> zrandmember(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.zrandmember(byArray, l2));
    }

    @Override
    public Response<List<Tuple>> zrandmemberWithScores(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.zrandmemberWithScores(byArray, l2));
    }

    @Override
    public Response<Long> zcard(byte[] byArray) {
        return this.appendCommand(this.commandObjects.zcard(byArray));
    }

    @Override
    public Response<Double> zscore(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.zscore(byArray, byArray2));
    }

    @Override
    public Response<List<Double>> zmscore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zmscore(byArray, byArray2));
    }

    @Override
    public Response<Tuple> zpopmax(byte[] byArray) {
        return this.appendCommand(this.commandObjects.zpopmax(byArray));
    }

    @Override
    public Response<List<Tuple>> zpopmax(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.zpopmax(byArray, n2));
    }

    @Override
    public Response<Tuple> zpopmin(byte[] byArray) {
        return this.appendCommand(this.commandObjects.zpopmin(byArray));
    }

    @Override
    public Response<List<Tuple>> zpopmin(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.zpopmin(byArray, n2));
    }

    @Override
    public Response<Long> zcount(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zcount(byArray, d2, d3));
    }

    @Override
    public Response<Long> zcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zcount(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(byArray, d2, d3));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(byArray, d3, d2));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(byArray, d2, d3, n2, n3));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(byArray, byArray3, byArray2));
    }

    @Override
    public Response<List<byte[]>> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(byArray, d3, d2, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScore(byArray, byArray3, byArray2, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public Response<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.zremrangeByRank(byArray, l2, l3));
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] byArray, double d2, double d3) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(byArray, d2, d3));
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zremrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> zlexcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zlexcount(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(byArray, byArray3, byArray2));
    }

    @Override
    public Response<List<byte[]>> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return this.appendCommand(this.commandObjects.zrevrangeByLex(byArray, byArray3, byArray2, n2, n3));
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.zremrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public Response<ScanResult<Tuple>> zscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return this.appendCommand(this.commandObjects.zscan(byArray, byArray2, scanParams));
    }

    @Override
    public Response<List<byte[]>> bzpopmax(double d2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.bzpopmax(d2, byArray));
    }

    @Override
    public Response<List<byte[]>> bzpopmin(double d2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.bzpopmin(d2, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption sortedSetOption, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zmpop(sortedSetOption, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zmpop(sortedSetOption, n2, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.bzmpop(l2, sortedSetOption, byArray));
    }

    @Override
    public Response<KeyValue<byte[], List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, byArray));
    }

    @Override
    public Response<Set<byte[]>> zdiff(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zdiff(byArray));
    }

    @Override
    public Response<Set<Tuple>> zdiffWithScores(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zdiffWithScores(byArray));
    }

    @Override
    public Response<Long> zdiffStore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zdiffStore(byArray, byArray2));
    }

    @Override
    public Response<Set<byte[]>> zinter(ZParams zParams, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zinter(zParams, byArray));
    }

    @Override
    public Response<Set<Tuple>> zinterWithScores(ZParams zParams, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zinterWithScores(zParams, byArray));
    }

    @Override
    public Response<Long> zinterstore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zinterstore(byArray, byArray2));
    }

    @Override
    public Response<Long> zinterstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zinterstore(byArray, zParams, byArray2));
    }

    @Override
    public Response<Long> zintercard(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zintercard(byArray));
    }

    @Override
    public Response<Long> zintercard(long l2, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zintercard(l2, byArray));
    }

    @Override
    public Response<Set<byte[]>> zunion(ZParams zParams, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zunion(zParams, byArray));
    }

    @Override
    public Response<Set<Tuple>> zunionWithScores(ZParams zParams, byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.zunionWithScores(zParams, byArray));
    }

    @Override
    public Response<Long> zunionstore(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zunionstore(byArray, byArray2));
    }

    @Override
    public Response<Long> zunionstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.zunionstore(byArray, zParams, byArray2));
    }

    @Override
    public Response<byte[]> xadd(byte[] byArray, XAddParams xAddParams, Map<byte[], byte[]> map) {
        return this.appendCommand(this.commandObjects.xadd(byArray, xAddParams, map));
    }

    @Override
    public Response<Long> xlen(byte[] byArray) {
        return this.appendCommand(this.commandObjects.xlen(byArray));
    }

    @Override
    public Response<List<byte[]>> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.xrange(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return this.appendCommand(this.commandObjects.xrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public Response<List<byte[]>> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3));
    }

    @Override
    public Response<List<byte[]>> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return this.appendCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public Response<Long> xack(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        return this.appendCommand(this.commandObjects.xack(byArray, byArray2, byArray3));
    }

    @Override
    public Response<String> xgroupCreate(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        return this.appendCommand(this.commandObjects.xgroupCreate(byArray, byArray2, byArray3, bl));
    }

    @Override
    public Response<String> xgroupSetID(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.xgroupSetID(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> xgroupDestroy(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.xgroupDestroy(byArray, byArray2));
    }

    @Override
    public Response<Boolean> xgroupCreateConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.xgroupCreateConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> xgroupDelConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return this.appendCommand(this.commandObjects.xgroupDelConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public Response<Long> xdel(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.xdel(byArray, byArray2));
    }

    @Override
    public Response<Long> xtrim(byte[] byArray, long l2, boolean bl) {
        return this.appendCommand(this.commandObjects.xtrim(byArray, l2, bl));
    }

    @Override
    public Response<Long> xtrim(byte[] byArray, XTrimParams xTrimParams) {
        return this.appendCommand(this.commandObjects.xtrim(byArray, xTrimParams));
    }

    @Override
    public Response<Object> xpending(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.xpending(byArray, byArray2));
    }

    @Override
    public Response<List<Object>> xpending(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, byte[] byArray5) {
        return this.appendCommand(this.commandObjects.xpending(byArray, byArray2, byArray3, byArray4, n2, byArray5));
    }

    @Override
    public Response<List<Object>> xpending(byte[] byArray, byte[] byArray2, XPendingParams xPendingParams) {
        return this.appendCommand(this.commandObjects.xpending(byArray, byArray2, xPendingParams));
    }

    @Override
    public Response<List<byte[]>> xclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return this.appendCommand(this.commandObjects.xclaim(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public Response<List<byte[]>> xclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return this.appendCommand(this.commandObjects.xclaimJustId(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public Response<List<Object>> xautoclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return this.appendCommand(this.commandObjects.xautoclaim(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public Response<List<Object>> xautoclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return this.appendCommand(this.commandObjects.xautoclaimJustId(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public Response<Object> xinfoStream(byte[] byArray) {
        return this.appendCommand(this.commandObjects.xinfoStream(byArray));
    }

    @Override
    public Response<Object> xinfoStreamFull(byte[] byArray) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(byArray));
    }

    @Override
    public Response<Object> xinfoStreamFull(byte[] byArray, int n2) {
        return this.appendCommand(this.commandObjects.xinfoStreamFull(byArray, n2));
    }

    @Override
    @Deprecated
    public Response<List<Object>> xinfoGroup(byte[] byArray) {
        return this.appendCommand(this.commandObjects.xinfoGroup(byArray));
    }

    @Override
    public Response<List<Object>> xinfoGroups(byte[] byArray) {
        return this.appendCommand(this.commandObjects.xinfoGroups(byArray));
    }

    @Override
    public Response<List<Object>> xinfoConsumers(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.xinfoConsumers(byArray, byArray2));
    }

    @Override
    public Response<List<byte[]>> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... entryArray) {
        return this.appendCommand(this.commandObjects.xread(xReadParams, entryArray));
    }

    @Override
    public Response<List<byte[]>> xreadGroup(byte[] byArray, byte[] byArray2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... entryArray) {
        return this.appendCommand(this.commandObjects.xreadGroup(byArray, byArray2, xReadGroupParams, entryArray));
    }

    @Override
    public Response<String> set(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.set(byArray, byArray2));
    }

    @Override
    public Response<String> set(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return this.appendCommand(this.commandObjects.set(byArray, byArray2, setParams));
    }

    @Override
    public Response<byte[]> get(byte[] byArray) {
        return this.appendCommand(this.commandObjects.get(byArray));
    }

    @Override
    public Response<byte[]> setGet(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return this.appendCommand(this.commandObjects.setGet(byArray, byArray2, setParams));
    }

    @Override
    public Response<byte[]> getDel(byte[] byArray) {
        return this.appendCommand(this.commandObjects.getDel(byArray));
    }

    @Override
    public Response<byte[]> getEx(byte[] byArray, GetExParams getExParams) {
        return this.appendCommand(this.commandObjects.getEx(byArray, getExParams));
    }

    @Override
    public Response<Boolean> setbit(byte[] byArray, long l2, boolean bl) {
        return this.appendCommand(this.commandObjects.setbit(byArray, l2, bl));
    }

    @Override
    public Response<Boolean> getbit(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.getbit(byArray, l2));
    }

    @Override
    public Response<Long> setrange(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.setrange(byArray, l2, byArray2));
    }

    @Override
    public Response<byte[]> getrange(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.getrange(byArray, l2, l3));
    }

    @Override
    public Response<byte[]> getSet(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.getSet(byArray, byArray2));
    }

    @Override
    public Response<Long> setnx(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.setnx(byArray, byArray2));
    }

    @Override
    public Response<String> setex(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.setex(byArray, l2, byArray2));
    }

    @Override
    public Response<String> psetex(byte[] byArray, long l2, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.psetex(byArray, l2, byArray2));
    }

    @Override
    public Response<List<byte[]>> mget(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.mget(byArray));
    }

    @Override
    public Response<String> mset(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.mset(byArray));
    }

    @Override
    public Response<Long> msetnx(byte[] ... byArray) {
        return this.appendCommand(this.commandObjects.msetnx(byArray));
    }

    @Override
    public Response<Long> incr(byte[] byArray) {
        return this.appendCommand(this.commandObjects.incr(byArray));
    }

    @Override
    public Response<Long> incrBy(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.incrBy(byArray, l2));
    }

    @Override
    public Response<Double> incrByFloat(byte[] byArray, double d2) {
        return this.appendCommand(this.commandObjects.incrByFloat(byArray, d2));
    }

    @Override
    public Response<Long> decr(byte[] byArray) {
        return this.appendCommand(this.commandObjects.decr(byArray));
    }

    @Override
    public Response<Long> decrBy(byte[] byArray, long l2) {
        return this.appendCommand(this.commandObjects.decrBy(byArray, l2));
    }

    @Override
    public Response<Long> append(byte[] byArray, byte[] byArray2) {
        return this.appendCommand(this.commandObjects.append(byArray, byArray2));
    }

    @Override
    public Response<byte[]> substr(byte[] byArray, int n2, int n3) {
        return this.appendCommand(this.commandObjects.substr(byArray, n2, n3));
    }

    @Override
    public Response<Long> strlen(byte[] byArray) {
        return this.appendCommand(this.commandObjects.strlen(byArray));
    }

    @Override
    public Response<Long> bitcount(byte[] byArray) {
        return this.appendCommand(this.commandObjects.bitcount(byArray));
    }

    @Override
    public Response<Long> bitcount(byte[] byArray, long l2, long l3) {
        return this.appendCommand(this.commandObjects.bitcount(byArray, l2, l3));
    }

    @Override
    public Response<Long> bitcount(byte[] byArray, long l2, long l3, BitCountOption bitCountOption) {
        return this.appendCommand(this.commandObjects.bitcount(byArray, l2, l3, bitCountOption));
    }

    @Override
    public Response<Long> bitpos(byte[] byArray, boolean bl) {
        return this.appendCommand(this.commandObjects.bitpos(byArray, bl));
    }

    @Override
    public Response<Long> bitpos(byte[] byArray, boolean bl, BitPosParams bitPosParams) {
        return this.appendCommand(this.commandObjects.bitpos(byArray, bl, bitPosParams));
    }

    @Override
    public Response<List<Long>> bitfield(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.bitfield(byArray, byArray2));
    }

    @Override
    public Response<List<Long>> bitfieldReadonly(byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.bitfieldReadonly(byArray, byArray2));
    }

    @Override
    public Response<Long> bitop(BitOP bitOP, byte[] byArray, byte[] ... byArray2) {
        return this.appendCommand(this.commandObjects.bitop(bitOP, byArray, byArray2));
    }

    @Override
    public Response<LCSMatchResult> strAlgoLCSKeys(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return this.appendCommand(this.commandObjects.strAlgoLCSKeys(byArray, byArray2, strAlgoLCSParams));
    }

    @Override
    public Response<String> ftCreate(String string, IndexOptions indexOptions, Schema schema) {
        return this.appendCommand(this.commandObjects.ftCreate(string, indexOptions, schema));
    }

    @Override
    public Response<String> ftCreate(String string, FTCreateParams fTCreateParams, Iterable<SchemaField> iterable) {
        return this.appendCommand(this.commandObjects.ftCreate(string, fTCreateParams, iterable));
    }

    @Override
    public Response<String> ftAlter(String string, Schema schema) {
        return this.appendCommand(this.commandObjects.ftAlter(string, schema));
    }

    @Override
    public Response<String> ftAlter(String string, Iterable<SchemaField> iterable) {
        return this.appendCommand(this.commandObjects.ftAlter(string, iterable));
    }

    @Override
    public Response<SearchResult> ftSearch(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftSearch(string, string2));
    }

    @Override
    public Response<SearchResult> ftSearch(String string, String string2, FTSearchParams fTSearchParams) {
        return this.appendCommand(this.commandObjects.ftSearch(string, string2, fTSearchParams));
    }

    @Override
    public Response<SearchResult> ftSearch(String string, Query query) {
        return this.appendCommand(this.commandObjects.ftSearch(string, query));
    }

    @Override
    public Response<SearchResult> ftSearch(byte[] byArray, Query query) {
        return this.appendCommand(this.commandObjects.ftSearch(byArray, query));
    }

    @Override
    public Response<String> ftExplain(String string, Query query) {
        return this.appendCommand(this.commandObjects.ftExplain(string, query));
    }

    @Override
    public Response<List<String>> ftExplainCLI(String string, Query query) {
        return this.appendCommand(this.commandObjects.ftExplainCLI(string, query));
    }

    @Override
    public Response<AggregationResult> ftAggregate(String string, AggregationBuilder aggregationBuilder) {
        return this.appendCommand(this.commandObjects.ftAggregate(string, aggregationBuilder));
    }

    @Override
    public Response<AggregationResult> ftCursorRead(String string, long l2, int n2) {
        return this.appendCommand(this.commandObjects.ftCursorRead(string, l2, n2));
    }

    @Override
    public Response<String> ftCursorDel(String string, long l2) {
        return this.appendCommand(this.commandObjects.ftCursorDel(string, l2));
    }

    @Override
    public Response<String> ftDropIndex(String string) {
        return this.appendCommand(this.commandObjects.ftDropIndex(string));
    }

    @Override
    public Response<String> ftDropIndexDD(String string) {
        return this.appendCommand(this.commandObjects.ftDropIndexDD(string));
    }

    @Override
    public Response<String> ftSynUpdate(String string, String string2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.ftSynUpdate(string, string2, stringArray));
    }

    @Override
    public Response<Map<String, List<String>>> ftSynDump(String string) {
        return this.appendCommand(this.commandObjects.ftSynDump(string));
    }

    @Override
    public Response<Long> ftDictAdd(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.ftDictAdd(string, stringArray));
    }

    @Override
    public Response<Long> ftDictDel(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.ftDictDel(string, stringArray));
    }

    @Override
    public Response<Set<String>> ftDictDump(String string) {
        return this.appendCommand(this.commandObjects.ftDictDump(string));
    }

    @Override
    public Response<Long> ftDictAddBySampleKey(String string, String string2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.ftDictAddBySampleKey(string, string2, stringArray));
    }

    @Override
    public Response<Long> ftDictDelBySampleKey(String string, String string2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.ftDictDelBySampleKey(string, string2, stringArray));
    }

    @Override
    public Response<Set<String>> ftDictDumpBySampleKey(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftDictDumpBySampleKey(string, string2));
    }

    @Override
    public Response<Map<String, Object>> ftInfo(String string) {
        return this.appendCommand(this.commandObjects.ftInfo(string));
    }

    @Override
    public Response<Set<String>> ftTagVals(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftTagVals(string, string2));
    }

    @Override
    public Response<String> ftAliasAdd(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftAliasAdd(string, string2));
    }

    @Override
    public Response<String> ftAliasUpdate(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftAliasUpdate(string, string2));
    }

    @Override
    public Response<String> ftAliasDel(String string) {
        return this.appendCommand(this.commandObjects.ftAliasDel(string));
    }

    @Override
    public Response<Map<String, String>> ftConfigGet(String string) {
        return this.appendCommand(this.commandObjects.ftConfigGet(string));
    }

    @Override
    public Response<Map<String, String>> ftConfigGet(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftConfigGet(string, string2));
    }

    @Override
    public Response<String> ftConfigSet(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftConfigSet(string, string2));
    }

    @Override
    public Response<String> ftConfigSet(String string, String string2, String string3) {
        return this.appendCommand(this.commandObjects.ftConfigSet(string, string2, string3));
    }

    @Override
    public Response<Long> ftSugAdd(String string, String string2, double d2) {
        return this.appendCommand(this.commandObjects.ftSugAdd(string, string2, d2));
    }

    @Override
    public Response<Long> ftSugAddIncr(String string, String string2, double d2) {
        return this.appendCommand(this.commandObjects.ftSugAddIncr(string, string2, d2));
    }

    @Override
    public Response<List<String>> ftSugGet(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftSugGet(string, string2));
    }

    @Override
    public Response<List<String>> ftSugGet(String string, String string2, boolean bl, int n2) {
        return this.appendCommand(this.commandObjects.ftSugGet(string, string2, bl, n2));
    }

    @Override
    public Response<List<Tuple>> ftSugGetWithScores(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftSugGetWithScores(string, string2));
    }

    @Override
    public Response<List<Tuple>> ftSugGetWithScores(String string, String string2, boolean bl, int n2) {
        return this.appendCommand(this.commandObjects.ftSugGetWithScores(string, string2, bl, n2));
    }

    @Override
    public Response<Boolean> ftSugDel(String string, String string2) {
        return this.appendCommand(this.commandObjects.ftSugDel(string, string2));
    }

    @Override
    public Response<Long> ftSugLen(String string) {
        return this.appendCommand(this.commandObjects.ftSugLen(string));
    }

    @Override
    public Response<LCSMatchResult> lcs(byte[] byArray, byte[] byArray2, LCSParams lCSParams) {
        return this.appendCommand(this.commandObjects.lcs(byArray, byArray2, lCSParams));
    }

    @Override
    public Response<String> jsonSet(String string, Path2 path2, Object object) {
        return this.appendCommand(this.commandObjects.jsonSet(string, path2, object));
    }

    @Override
    public Response<String> jsonSetWithEscape(String string, Path2 path2, Object object) {
        return this.appendCommand(this.commandObjects.jsonSetWithEscape(string, path2, object));
    }

    @Override
    public Response<String> jsonSet(String string, Path path, Object object) {
        return this.appendCommand(this.commandObjects.jsonSet(string, path, object));
    }

    @Override
    public Response<String> jsonSet(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return this.appendCommand(this.commandObjects.jsonSet(string, path2, object, jsonSetParams));
    }

    @Override
    public Response<String> jsonSetWithEscape(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return this.appendCommand(this.commandObjects.jsonSetWithEscape(string, path2, object, jsonSetParams));
    }

    @Override
    public Response<String> jsonSet(String string, Path path, Object object, JsonSetParams jsonSetParams) {
        return this.appendCommand(this.commandObjects.jsonSet(string, path, object, jsonSetParams));
    }

    @Override
    public Response<Object> jsonGet(String string) {
        return this.appendCommand(this.commandObjects.jsonGet(string));
    }

    @Override
    public <T> Response<T> jsonGet(String string, Class<T> clazz) {
        return this.appendCommand(this.commandObjects.jsonGet(string, clazz));
    }

    @Override
    public Response<Object> jsonGet(String string, Path2 ... path2Array) {
        return this.appendCommand(this.commandObjects.jsonGet(string, path2Array));
    }

    @Override
    public Response<Object> jsonGet(String string, Path ... pathArray) {
        return this.appendCommand(this.commandObjects.jsonGet(string, pathArray));
    }

    @Override
    public <T> Response<T> jsonGet(String string, Class<T> clazz, Path ... pathArray) {
        return this.appendCommand(this.commandObjects.jsonGet(string, clazz, pathArray));
    }

    @Override
    public Response<List<JSONArray>> jsonMGet(Path2 path2, String ... stringArray) {
        return this.appendCommand(this.commandObjects.jsonMGet(path2, stringArray));
    }

    @Override
    public <T> Response<List<T>> jsonMGet(Path path, Class<T> clazz, String ... stringArray) {
        return this.appendCommand(this.commandObjects.jsonMGet(path, clazz, stringArray));
    }

    @Override
    public Response<Long> jsonDel(String string) {
        return this.appendCommand(this.commandObjects.jsonDel(string));
    }

    @Override
    public Response<Long> jsonDel(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonDel(string, path2));
    }

    @Override
    public Response<Long> jsonDel(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonDel(string, path));
    }

    @Override
    public Response<Long> jsonClear(String string) {
        return this.appendCommand(this.commandObjects.jsonClear(string));
    }

    @Override
    public Response<Long> jsonClear(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonClear(string, path2));
    }

    @Override
    public Response<Long> jsonClear(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonClear(string, path));
    }

    @Override
    public Response<List<Boolean>> jsonToggle(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonToggle(string, path2));
    }

    @Override
    public Response<String> jsonToggle(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonToggle(string, path));
    }

    @Override
    public Response<Class<?>> jsonType(String string) {
        return this.appendCommand(this.commandObjects.jsonType(string));
    }

    @Override
    public Response<List<Class<?>>> jsonType(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonType(string, path2));
    }

    @Override
    public Response<Class<?>> jsonType(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonType(string, path));
    }

    @Override
    public Response<Long> jsonStrAppend(String string, Object object) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(string, object));
    }

    @Override
    public Response<List<Long>> jsonStrAppend(String string, Path2 path2, Object object) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(string, path2, object));
    }

    @Override
    public Response<Long> jsonStrAppend(String string, Path path, Object object) {
        return this.appendCommand(this.commandObjects.jsonStrAppend(string, path, object));
    }

    @Override
    public Response<Long> jsonStrLen(String string) {
        return this.appendCommand(this.commandObjects.jsonStrLen(string));
    }

    @Override
    public Response<List<Long>> jsonStrLen(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonStrLen(string, path2));
    }

    @Override
    public Response<Long> jsonStrLen(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonStrLen(string, path));
    }

    @Override
    public Response<JSONArray> jsonNumIncrBy(String string, Path2 path2, double d2) {
        return this.appendCommand(this.commandObjects.jsonNumIncrBy(string, path2, d2));
    }

    @Override
    public Response<Double> jsonNumIncrBy(String string, Path path, double d2) {
        return this.appendCommand(this.commandObjects.jsonNumIncrBy(string, path, d2));
    }

    @Override
    public Response<List<Long>> jsonArrAppend(String string, Path2 path2, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrAppend(string, path2, objectArray));
    }

    @Override
    public Response<List<Long>> jsonArrAppendWithEscape(String string, Path2 path2, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrAppendWithEscape(string, path2, objectArray));
    }

    @Override
    public Response<Long> jsonArrAppend(String string, Path path, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrAppend(string, path, objectArray));
    }

    @Override
    public Response<List<Long>> jsonArrIndex(String string, Path2 path2, Object object) {
        return this.appendCommand(this.commandObjects.jsonArrIndex(string, path2, object));
    }

    @Override
    public Response<List<Long>> jsonArrIndexWithEscape(String string, Path2 path2, Object object) {
        return this.appendCommand(this.commandObjects.jsonArrIndexWithEscape(string, path2, object));
    }

    @Override
    public Response<Long> jsonArrIndex(String string, Path path, Object object) {
        return this.appendCommand(this.commandObjects.jsonArrIndex(string, path, object));
    }

    @Override
    public Response<List<Long>> jsonArrInsert(String string, Path2 path2, int n2, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrInsert(string, path2, n2, objectArray));
    }

    @Override
    public Response<List<Long>> jsonArrInsertWithEscape(String string, Path2 path2, int n2, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrInsertWithEscape(string, path2, n2, objectArray));
    }

    @Override
    public Response<Long> jsonArrInsert(String string, Path path, int n2, Object ... objectArray) {
        return this.appendCommand(this.commandObjects.jsonArrInsert(string, path, n2, objectArray));
    }

    @Override
    public Response<Object> jsonArrPop(String string) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string));
    }

    @Override
    public Response<Long> jsonArrLen(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrLen(string, path));
    }

    @Override
    public Response<List<Long>> jsonArrTrim(String string, Path2 path2, int n2, int n3) {
        return this.appendCommand(this.commandObjects.jsonArrTrim(string, path2, n2, n3));
    }

    @Override
    public Response<Long> jsonArrTrim(String string, Path path, int n2, int n3) {
        return this.appendCommand(this.commandObjects.jsonArrTrim(string, path, n2, n3));
    }

    @Override
    public <T> Response<T> jsonArrPop(String string, Class<T> clazz, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, clazz, path));
    }

    @Override
    public Response<List<Object>> jsonArrPop(String string, Path2 path2, int n2) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, path2, n2));
    }

    @Override
    public Response<Object> jsonArrPop(String string, Path path, int n2) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, path, n2));
    }

    @Override
    public <T> Response<T> jsonArrPop(String string, Class<T> clazz, Path path, int n2) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, clazz, path, n2));
    }

    @Override
    public Response<Long> jsonArrLen(String string) {
        return this.appendCommand(this.commandObjects.jsonArrLen(string));
    }

    @Override
    public Response<List<Long>> jsonArrLen(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonArrLen(string, path2));
    }

    @Override
    public <T> Response<T> jsonArrPop(String string, Class<T> clazz) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, clazz));
    }

    @Override
    public Response<List<Object>> jsonArrPop(String string, Path2 path2) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, path2));
    }

    @Override
    public Response<Object> jsonArrPop(String string, Path path) {
        return this.appendCommand(this.commandObjects.jsonArrPop(string, path));
    }

    @Override
    public Response<String> tsCreate(String string) {
        return this.appendCommand(this.commandObjects.tsCreate(string));
    }

    @Override
    public Response<String> tsCreate(String string, TSCreateParams tSCreateParams) {
        return this.appendCommand(this.commandObjects.tsCreate(string, tSCreateParams));
    }

    @Override
    public Response<Long> tsDel(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.tsDel(string, l2, l3));
    }

    @Override
    public Response<String> tsAlter(String string, TSAlterParams tSAlterParams) {
        return this.appendCommand(this.commandObjects.tsAlter(string, tSAlterParams));
    }

    @Override
    public Response<Long> tsAdd(String string, double d2) {
        return this.appendCommand(this.commandObjects.tsAdd(string, d2));
    }

    @Override
    public Response<Long> tsAdd(String string, long l2, double d2) {
        return this.appendCommand(this.commandObjects.tsAdd(string, l2, d2));
    }

    @Override
    public Response<Long> tsAdd(String string, long l2, double d2, TSCreateParams tSCreateParams) {
        return this.appendCommand(this.commandObjects.tsAdd(string, l2, d2, tSCreateParams));
    }

    @Override
    public Response<List<Long>> tsMAdd(Map.Entry<String, TSElement> ... entryArray) {
        return this.appendCommand(this.commandObjects.tsMAdd(entryArray));
    }

    @Override
    public Response<Long> tsIncrBy(String string, double d2) {
        return this.appendCommand(this.commandObjects.tsIncrBy(string, d2));
    }

    @Override
    public Response<Long> tsIncrBy(String string, double d2, long l2) {
        return this.appendCommand(this.commandObjects.tsIncrBy(string, d2, l2));
    }

    @Override
    public Response<Long> tsDecrBy(String string, double d2) {
        return this.appendCommand(this.commandObjects.tsDecrBy(string, d2));
    }

    @Override
    public Response<Long> tsDecrBy(String string, double d2, long l2) {
        return this.appendCommand(this.commandObjects.tsDecrBy(string, d2, l2));
    }

    @Override
    public Response<List<TSElement>> tsRange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.tsRange(string, l2, l3));
    }

    @Override
    public Response<List<TSElement>> tsRange(String string, TSRangeParams tSRangeParams) {
        return this.appendCommand(this.commandObjects.tsRange(string, tSRangeParams));
    }

    @Override
    public Response<List<TSElement>> tsRevRange(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.tsRevRange(string, l2, l3));
    }

    @Override
    public Response<List<TSElement>> tsRevRange(String string, TSRangeParams tSRangeParams) {
        return this.appendCommand(this.commandObjects.tsRevRange(string, tSRangeParams));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRange(long l2, long l3, String ... stringArray) {
        return this.appendCommand(this.commandObjects.tsMRange(l2, l3, stringArray));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRange(TSMRangeParams tSMRangeParams) {
        return this.appendCommand(this.commandObjects.tsMRange(tSMRangeParams));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRevRange(long l2, long l3, String ... stringArray) {
        return this.appendCommand(this.commandObjects.tsMRevRange(l2, l3, stringArray));
    }

    @Override
    public Response<List<TSKeyedElements>> tsMRevRange(TSMRangeParams tSMRangeParams) {
        return this.appendCommand(this.commandObjects.tsMRevRange(tSMRangeParams));
    }

    @Override
    public Response<TSElement> tsGet(String string) {
        return this.appendCommand(this.commandObjects.tsGet(string));
    }

    @Override
    public Response<TSElement> tsGet(String string, TSGetParams tSGetParams) {
        return this.appendCommand(this.commandObjects.tsGet(string, tSGetParams));
    }

    @Override
    public Response<List<TSKeyValue<TSElement>>> tsMGet(TSMGetParams tSMGetParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.tsMGet(tSMGetParams, stringArray));
    }

    @Override
    public Response<String> tsCreateRule(String string, String string2, AggregationType aggregationType, long l2) {
        return this.appendCommand(this.commandObjects.tsCreateRule(string, string2, aggregationType, l2));
    }

    @Override
    public Response<String> tsCreateRule(String string, String string2, AggregationType aggregationType, long l2, long l3) {
        return this.appendCommand(this.commandObjects.tsCreateRule(string, string2, aggregationType, l2, l3));
    }

    @Override
    public Response<String> tsDeleteRule(String string, String string2) {
        return this.appendCommand(this.commandObjects.tsDeleteRule(string, string2));
    }

    @Override
    public Response<List<String>> tsQueryIndex(String ... stringArray) {
        return this.appendCommand(this.commandObjects.tsQueryIndex(stringArray));
    }

    @Override
    public Response<String> bfReserve(String string, double d2, long l2) {
        return this.appendCommand(this.commandObjects.bfReserve(string, d2, l2));
    }

    @Override
    public Response<String> bfReserve(String string, double d2, long l2, BFReserveParams bFReserveParams) {
        return this.appendCommand(this.commandObjects.bfReserve(string, d2, l2, bFReserveParams));
    }

    @Override
    public Response<Boolean> bfAdd(String string, String string2) {
        return this.appendCommand(this.commandObjects.bfAdd(string, string2));
    }

    @Override
    public Response<List<Boolean>> bfMAdd(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bfMAdd(string, stringArray));
    }

    @Override
    public Response<List<Boolean>> bfInsert(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bfInsert(string, stringArray));
    }

    @Override
    public Response<List<Boolean>> bfInsert(String string, BFInsertParams bFInsertParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bfInsert(string, bFInsertParams, stringArray));
    }

    @Override
    public Response<Boolean> bfExists(String string, String string2) {
        return this.appendCommand(this.commandObjects.bfExists(string, string2));
    }

    @Override
    public Response<List<Boolean>> bfMExists(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.bfMExists(string, stringArray));
    }

    @Override
    public Response<Map.Entry<Long, byte[]>> bfScanDump(String string, long l2) {
        return this.appendCommand(this.commandObjects.bfScanDump(string, l2));
    }

    @Override
    public Response<String> bfLoadChunk(String string, long l2, byte[] byArray) {
        return this.appendCommand(this.commandObjects.bfLoadChunk(string, l2, byArray));
    }

    @Override
    public Response<Map<String, Object>> bfInfo(String string) {
        return this.appendCommand(this.commandObjects.bfInfo(string));
    }

    @Override
    public Response<String> cfReserve(String string, long l2) {
        return this.appendCommand(this.commandObjects.cfReserve(string, l2));
    }

    @Override
    public Response<String> cfReserve(String string, long l2, CFReserveParams cFReserveParams) {
        return this.appendCommand(this.commandObjects.cfReserve(string, l2, cFReserveParams));
    }

    @Override
    public Response<Boolean> cfAdd(String string, String string2) {
        return this.appendCommand(this.commandObjects.cfAdd(string, string2));
    }

    @Override
    public Response<Boolean> cfAddNx(String string, String string2) {
        return this.appendCommand(this.commandObjects.cfAddNx(string, string2));
    }

    @Override
    public Response<List<Boolean>> cfInsert(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cfInsert(string, stringArray));
    }

    @Override
    public Response<List<Boolean>> cfInsert(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cfInsert(string, cFInsertParams, stringArray));
    }

    @Override
    public Response<List<Boolean>> cfInsertNx(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cfInsertNx(string, stringArray));
    }

    @Override
    public Response<List<Boolean>> cfInsertNx(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cfInsertNx(string, cFInsertParams, stringArray));
    }

    @Override
    public Response<Boolean> cfExists(String string, String string2) {
        return this.appendCommand(this.commandObjects.cfExists(string, string2));
    }

    @Override
    public Response<Boolean> cfDel(String string, String string2) {
        return this.appendCommand(this.commandObjects.cfDel(string, string2));
    }

    @Override
    public Response<Long> cfCount(String string, String string2) {
        return this.appendCommand(this.commandObjects.cfCount(string, string2));
    }

    @Override
    public Response<Map.Entry<Long, byte[]>> cfScanDump(String string, long l2) {
        return this.appendCommand(this.commandObjects.cfScanDump(string, l2));
    }

    @Override
    public Response<String> cfLoadChunk(String string, long l2, byte[] byArray) {
        return this.appendCommand(this.commandObjects.cfLoadChunk(string, l2, byArray));
    }

    @Override
    public Response<Map<String, Object>> cfInfo(String string) {
        return this.appendCommand(this.commandObjects.cfInfo(string));
    }

    @Override
    public Response<String> cmsInitByDim(String string, long l2, long l3) {
        return this.appendCommand(this.commandObjects.cmsInitByDim(string, l2, l3));
    }

    @Override
    public Response<String> cmsInitByProb(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.cmsInitByProb(string, d2, d3));
    }

    @Override
    public Response<List<Long>> cmsIncrBy(String string, Map<String, Long> map) {
        return this.appendCommand(this.commandObjects.cmsIncrBy(string, map));
    }

    @Override
    public Response<List<Long>> cmsQuery(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cmsQuery(string, stringArray));
    }

    @Override
    public Response<String> cmsMerge(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.cmsMerge(string, stringArray));
    }

    @Override
    public Response<String> cmsMerge(String string, Map<String, Long> map) {
        return this.appendCommand(this.commandObjects.cmsMerge(string, map));
    }

    @Override
    public Response<Map<String, Object>> cmsInfo(String string) {
        return this.appendCommand(this.commandObjects.cmsInfo(string));
    }

    @Override
    public Response<String> topkReserve(String string, long l2) {
        return this.appendCommand(this.commandObjects.topkReserve(string, l2));
    }

    @Override
    public Response<String> topkReserve(String string, long l2, long l3, long l4, double d2) {
        return this.appendCommand(this.commandObjects.topkReserve(string, l2, l3, l4, d2));
    }

    @Override
    public Response<List<String>> topkAdd(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.topkAdd(string, stringArray));
    }

    @Override
    public Response<List<String>> topkIncrBy(String string, Map<String, Long> map) {
        return this.appendCommand(this.commandObjects.topkIncrBy(string, map));
    }

    @Override
    public Response<List<Boolean>> topkQuery(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.topkQuery(string, stringArray));
    }

    @Override
    public Response<List<Long>> topkCount(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.topkCount(string, stringArray));
    }

    @Override
    public Response<List<String>> topkList(String string) {
        return this.appendCommand(this.commandObjects.topkList(string));
    }

    @Override
    public Response<Map<String, Object>> topkInfo(String string) {
        return this.appendCommand(this.commandObjects.topkInfo(string));
    }

    @Override
    public Response<String> tdigestCreate(String string) {
        return this.appendCommand(this.commandObjects.tdigestCreate(string));
    }

    @Override
    public Response<String> tdigestCreate(String string, int n2) {
        return this.appendCommand(this.commandObjects.tdigestCreate(string, n2));
    }

    @Override
    public Response<String> tdigestReset(String string) {
        return this.appendCommand(this.commandObjects.tdigestReset(string));
    }

    @Override
    public Response<String> tdigestMerge(String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.tdigestMerge(string, stringArray));
    }

    @Override
    public Response<String> tdigestMerge(TDigestMergeParams tDigestMergeParams, String string, String ... stringArray) {
        return this.appendCommand(this.commandObjects.tdigestMerge(tDigestMergeParams, string, stringArray));
    }

    @Override
    public Response<Map<String, Object>> tdigestInfo(String string) {
        return this.appendCommand(this.commandObjects.tdigestInfo(string));
    }

    @Override
    public Response<String> tdigestAdd(String string, double ... dArray) {
        return this.appendCommand(this.commandObjects.tdigestAdd(string, dArray));
    }

    @Override
    public Response<List<Double>> tdigestCDF(String string, double ... dArray) {
        return this.appendCommand(this.commandObjects.tdigestCDF(string, dArray));
    }

    @Override
    public Response<List<Double>> tdigestQuantile(String string, double ... dArray) {
        return this.appendCommand(this.commandObjects.tdigestQuantile(string, dArray));
    }

    @Override
    public Response<Double> tdigestMin(String string) {
        return this.appendCommand(this.commandObjects.tdigestMin(string));
    }

    @Override
    public Response<Double> tdigestMax(String string) {
        return this.appendCommand(this.commandObjects.tdigestMax(string));
    }

    @Override
    public Response<Double> tdigestTrimmedMean(String string, double d2, double d3) {
        return this.appendCommand(this.commandObjects.tdigestTrimmedMean(string, d2, d3));
    }

    @Override
    public Response<List<Long>> tdigestRank(String string, double ... dArray) {
        return this.appendCommand(this.commandObjects.tdigestRank(string, dArray));
    }

    @Override
    public Response<List<Long>> tdigestRevRank(String string, double ... dArray) {
        return this.appendCommand(this.commandObjects.tdigestRevRank(string, dArray));
    }

    @Override
    public Response<List<Double>> tdigestByRank(String string, long ... lArray) {
        return this.appendCommand(this.commandObjects.tdigestByRank(string, lArray));
    }

    @Override
    public Response<List<Double>> tdigestByRevRank(String string, long ... lArray) {
        return this.appendCommand(this.commandObjects.tdigestByRevRank(string, lArray));
    }

    @Override
    public Response<ResultSet> graphQuery(String string, String string2) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(string, string2));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String string, String string2) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2));
    }

    @Override
    public Response<ResultSet> graphQuery(String string, String string2, long l2) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(string, string2, l2));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String string, String string2, long l2) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, l2));
    }

    @Override
    public Response<ResultSet> graphQuery(String string, String string2, Map<String, Object> map) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(string, string2, map));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String string, String string2, Map<String, Object> map) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, map));
    }

    @Override
    public Response<ResultSet> graphQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.appendCommand(this.graphCommandObjects.graphQuery(string, string2, map, l2));
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String string, String string2, Map<String, Object> map, long l2) {
        return this.appendCommand(this.graphCommandObjects.graphReadonlyQuery(string, string2, map, l2));
    }

    @Override
    public Response<String> graphDelete(String string) {
        return this.appendCommand(this.graphCommandObjects.graphDelete(string));
    }

    @Override
    public Response<List<String>> graphProfile(String string, String string2) {
        return this.appendCommand(this.commandObjects.graphProfile(string, string2));
    }

    public Response<Long> waitReplicas(int n2, long l2) {
        return this.appendCommand(this.commandObjects.waitReplicas(n2, l2));
    }
}

