/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.Jedis;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisFactory;
import me.ulrich.clans.library.redis.jedis.JedisPubSub;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.util.Pool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JedisSentinelPool
extends Pool<Jedis> {
    private static final Logger LOG = LoggerFactory.getLogger(JedisSentinelPool.class);
    private final JedisFactory factory;
    private final JedisClientConfig sentinelClientConfig;
    protected final Collection<MasterListener> masterListeners = new ArrayList<MasterListener>();
    private volatile HostAndPort currentHostMaster;
    private final Object initPoolLock = new Object();

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig) {
        this(string, set, genericObjectPoolConfig, 2000, null, 0);
    }

    public JedisSentinelPool(String string, Set<String> set) {
        this(string, set, new GenericObjectPoolConfig<Jedis>(), 2000, null, 0);
    }

    public JedisSentinelPool(String string, Set<String> set, String string2) {
        this(string, set, new GenericObjectPoolConfig<Jedis>(), 2000, string2);
    }

    public JedisSentinelPool(String string, Set<String> set, String string2, String string3) {
        this(string, set, new GenericObjectPoolConfig<Jedis>(), 2000, 2000, string2, 0, null, 2000, 2000, string3, null);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, String string2) {
        this(string, set, genericObjectPoolConfig, n2, string2, 0);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2) {
        this(string, set, genericObjectPoolConfig, n2, null, 0);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, String string2) {
        this(string, set, genericObjectPoolConfig, 2000, string2);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, String string2, int n3) {
        this(string, set, genericObjectPoolConfig, n2, n2, null, string2, n3);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, String string2, String string3, int n3) {
        this(string, set, genericObjectPoolConfig, n2, n2, string2, string3, n3);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, String string2, int n3, String string3) {
        this(string, set, genericObjectPoolConfig, n2, n2, string2, n3, string3);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, String string2, String string3, int n3, String string4) {
        this(string, set, genericObjectPoolConfig, n2, n2, string2, string3, n3, string4);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, int n4) {
        this(string, set, genericObjectPoolConfig, n2, n3, null, string2, n4, null);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, String string3, int n4) {
        this(string, set, genericObjectPoolConfig, n2, n3, string2, string3, n4, null);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, int n4, String string3) {
        this(string, set, genericObjectPoolConfig, n2, n3, null, string2, n4, string3);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, String string3, int n4, String string4) {
        this(string, set, genericObjectPoolConfig, n2, n3, string2, string3, n4, string4, 2000, 2000, null, null, null);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, int n4, String string2, String string3, int n5, String string4) {
        this(string, set, genericObjectPoolConfig, n2, n3, n4, string2, string3, n5, string4, 2000, 2000, null, null, null);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, int n4, String string3, int n5, int n6, String string4, String string5) {
        this(string, set, genericObjectPoolConfig, n2, n3, null, string2, n4, string3, n5, n6, null, string4, string5);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, String string2, String string3, int n4, String string4, int n5, int n6, String string5, String string6, String string7) {
        this(string, set, genericObjectPoolConfig, n2, n3, 0, string2, string3, n4, string4, n5, n6, string5, string6, string7);
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, int n2, int n3, int n4, String string2, String string3, int n5, String string4, int n6, int n7, String string5, String string6, String string7) {
        this(string, JedisSentinelPool.parseHostAndPorts(set), genericObjectPoolConfig, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).blockingSocketTimeoutMillis(n4).user(string2).password(string3).database(n5).clientName(string4).build(), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n6).socketTimeoutMillis(n7).user(string5).password(string6).clientName(string7).build());
    }

    public JedisSentinelPool(String string, Set<String> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, JedisFactory jedisFactory) {
        this(string, JedisSentinelPool.parseHostAndPorts(set), genericObjectPoolConfig, jedisFactory, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public JedisSentinelPool(String string, Set<HostAndPort> set, JedisClientConfig jedisClientConfig, JedisClientConfig jedisClientConfig2) {
        this(string, set, new GenericObjectPoolConfig<Jedis>(), jedisClientConfig, jedisClientConfig2);
    }

    public JedisSentinelPool(String string, Set<HostAndPort> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, JedisClientConfig jedisClientConfig, JedisClientConfig jedisClientConfig2) {
        this(string, set, genericObjectPoolConfig, new JedisFactory(jedisClientConfig), jedisClientConfig2);
    }

    public JedisSentinelPool(String string, Set<HostAndPort> set, GenericObjectPoolConfig<Jedis> genericObjectPoolConfig, JedisFactory jedisFactory, JedisClientConfig jedisClientConfig) {
        super(genericObjectPoolConfig, jedisFactory);
        this.factory = jedisFactory;
        this.sentinelClientConfig = jedisClientConfig;
        HostAndPort hostAndPort = this.initSentinels(set, string);
        this.initMaster(hostAndPort);
    }

    private static Set<HostAndPort> parseHostAndPorts(Set<String> set) {
        return set.stream().map(HostAndPort::from).collect(Collectors.toSet());
    }

    @Override
    public void destroy() {
        for (MasterListener masterListener : this.masterListeners) {
            masterListener.shutdown();
        }
        super.destroy();
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMaster(HostAndPort hostAndPort) {
        Object object = this.initPoolLock;
        synchronized (object) {
            if (!hostAndPort.equals(this.currentHostMaster)) {
                this.currentHostMaster = hostAndPort;
                this.factory.setHostAndPort(this.currentHostMaster);
                super.clear();
                LOG.info("Created JedisSentinelPool to master at {}", (Object)hostAndPort);
            }
        }
    }

    private HostAndPort initSentinels(Set<HostAndPort> set, String string) {
        Object object;
        HostAndPort hostAndPort = null;
        boolean bl = false;
        LOG.info("Trying to find master from available Sentinels...");
        for (HostAndPort hostAndPort2 : set) {
            LOG.debug("Connecting to Sentinel {}", (Object)hostAndPort2);
            try {
                object = new Jedis(hostAndPort2, this.sentinelClientConfig);
                Throwable throwable = null;
                try {
                    List<String> list = ((Jedis)object).sentinelGetMasterAddrByName(string);
                    bl = true;
                    if (list == null || list.size() != 2) {
                        LOG.warn("Can not get master addr, master name: {}. Sentinel: {}", (Object)string, (Object)hostAndPort2);
                        continue;
                    }
                    hostAndPort = this.toHostAndPort(list);
                    LOG.debug("Found Redis master at {}", (Object)hostAndPort);
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object == null) continue;
                    if (throwable != null) {
                        try {
                            ((Jedis)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Jedis)object).close();
                }
            }
            catch (JedisException jedisException) {
                LOG.warn("Cannot get master address from sentinel running @ {}. Reason: {}. Trying next one.", (Object)hostAndPort2, (Object)jedisException);
            }
        }
        if (hostAndPort == null) {
            if (bl) {
                throw new JedisException("Can connect to sentinel, but " + string + " seems to be not monitored...");
            }
            throw new JedisConnectionException("All sentinels down, cannot determine where is " + string + " master is running...");
        }
        LOG.info("Redis master running at {}, starting Sentinel listeners...", (Object)hostAndPort);
        for (HostAndPort hostAndPort2 : set) {
            object = new MasterListener(string, hostAndPort2.getHost(), hostAndPort2.getPort());
            ((Thread)object).setDaemon(true);
            this.masterListeners.add((MasterListener)object);
            ((Thread)object).start();
        }
        return hostAndPort;
    }

    private HostAndPort toHostAndPort(List<String> list) {
        String string = list.get(0);
        int n2 = Integer.parseInt(list.get(1));
        return new HostAndPort(string, n2);
    }

    @Override
    public Jedis getResource() {
        while (true) {
            Jedis jedis = (Jedis)super.getResource();
            jedis.setDataSource(this);
            HostAndPort hostAndPort = this.currentHostMaster;
            HostAndPort hostAndPort2 = jedis.getClient().getHostAndPort();
            if (hostAndPort.equals(hostAndPort2)) {
                return jedis;
            }
            this.returnBrokenResource(jedis);
        }
    }

    @Override
    public void returnResource(Jedis jedis) {
        if (jedis != null) {
            try {
                jedis.resetState();
                super.returnResource(jedis);
            }
            catch (RuntimeException runtimeException) {
                this.returnBrokenResource(jedis);
                LOG.debug("Resource is returned to the pool as broken", runtimeException);
            }
        }
    }

    protected class MasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis;
        protected volatile Jedis j;
        protected AtomicBoolean running;

        protected MasterListener() {
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
        }

        public MasterListener(String string, String string2, int n2) {
            super(String.format("MasterListener-%s-[%s:%d]", string, string2, n2));
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
            this.masterName = string;
            this.host = string2;
            this.port = n2;
        }

        public MasterListener(String string, String string2, int n2, long l2) {
            this(string, string2, n2);
            this.subscribeRetryWaitTimeMillis = l2;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                try {
                    if (!this.running.get()) break;
                    final HostAndPort hostAndPort = new HostAndPort(this.host, this.port);
                    this.j = new Jedis(hostAndPort, JedisSentinelPool.this.sentinelClientConfig);
                    List<String> list = this.j.sentinelGetMasterAddrByName(this.masterName);
                    if (list == null || list.size() != 2) {
                        LOG.warn("Can not get master addr, master name: {}. Sentinel: {}.", (Object)this.masterName, (Object)hostAndPort);
                    } else {
                        JedisSentinelPool.this.initMaster(JedisSentinelPool.this.toHostAndPort(list));
                    }
                    this.j.subscribe(new JedisPubSub(){

                        @Override
                        public void onMessage(String string, String string2) {
                            LOG.debug("Sentinel {} published: {}.", (Object)hostAndPort, (Object)string2);
                            String[] stringArray = string2.split(" ");
                            if (stringArray.length > 3) {
                                if (MasterListener.this.masterName.equals(stringArray[0])) {
                                    JedisSentinelPool.this.initMaster(JedisSentinelPool.this.toHostAndPort(Arrays.asList(stringArray[3], stringArray[4])));
                                } else {
                                    LOG.debug("Ignoring message on +switch-master for master name {}, our master name is {}", (Object)stringArray[0], (Object)MasterListener.this.masterName);
                                }
                            } else {
                                LOG.error("Invalid message received on Sentinel {} on channel +switch-master: {}", (Object)hostAndPort, (Object)string2);
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisException jedisException) {
                    if (this.running.get()) {
                        LOG.error("Lost connection to Sentinel at {}:{}. Sleeping 5000ms and retrying.", this.host, this.port, jedisException);
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.error("Sleep interrupted: ", interruptedException);
                        }
                        continue;
                    }
                    LOG.debug("Unsubscribing from Sentinel at {}:{}", (Object)this.host, (Object)this.port);
                }
                finally {
                    if (this.j == null) continue;
                    this.j.close();
                }
            }
        }

        public void shutdown() {
            try {
                LOG.debug("Shutting down listener on {}:{}", (Object)this.host, (Object)this.port);
                this.running.set(false);
                if (this.j != null) {
                    this.j.close();
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.error("Caught exception while shutting down: ", runtimeException);
            }
        }
    }
}

