/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.Arrays;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public abstract class JedisPubSub {
    private static final String JEDIS_SUBSCRIPTION_MESSAGE = "JedisPubSub is not subscribed to a Jedis instance.";
    private int subscribedChannels = 0;
    private volatile Connection client;

    public void onMessage(String string, String string2) {
    }

    public void onPMessage(String string, String string2, String string3) {
    }

    public void onSubscribe(String string, int n2) {
    }

    public void onUnsubscribe(String string, int n2) {
    }

    public void onPUnsubscribe(String string, int n2) {
    }

    public void onPSubscribe(String string, int n2) {
    }

    public void onPong(String string) {
    }

    public void unsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.UNSUBSCRIBE);
        this.client.flush();
    }

    public void unsubscribe(String ... stringArray) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, stringArray);
        this.client.flush();
    }

    public void subscribe(String ... stringArray) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, stringArray);
        this.client.flush();
    }

    public void psubscribe(String ... stringArray) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, stringArray);
        this.client.flush();
    }

    public void punsubscribe() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.PUNSUBSCRIBE);
        this.client.flush();
    }

    public void punsubscribe(String ... stringArray) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, stringArray);
        this.client.flush();
    }

    public void ping() {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand(Protocol.Command.PING);
        this.client.flush();
    }

    public void ping(String string) {
        if (this.client == null) {
            throw new JedisConnectionException(JEDIS_SUBSCRIPTION_MESSAGE);
        }
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PING, string);
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Connection connection, String ... stringArray) {
        this.client = connection;
        this.client.setTimeoutInfinite();
        try {
            this.psubscribe(stringArray);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    public void proceed(Connection connection, String ... stringArray) {
        this.client = connection;
        this.client.setTimeoutInfinite();
        try {
            this.subscribe(stringArray);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    private void process() {
        do {
            String string;
            Object object;
            Object object2;
            byte[] byArray;
            List<Object> list;
            Object object3;
            if (!((object3 = (list = this.client.getUnflushedObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + object3);
            }
            byte[] byArray2 = (byte[])object3;
            if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), byArray2)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray = (byte[])list.get(1);
                object2 = byArray == null ? null : SafeEncoder.encode(byArray);
                this.onSubscribe((String)object2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), byArray2)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray = (byte[])list.get(1);
                object2 = byArray == null ? null : SafeEncoder.encode(byArray);
                this.onUnsubscribe((String)object2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), byArray2)) {
                byArray = (byte[])list.get(1);
                object2 = (byte[])list.get(2);
                object = byArray == null ? null : SafeEncoder.encode(byArray);
                string = object2 == null ? null : SafeEncoder.encode((byte[])object2);
                this.onMessage((String)object, string);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), byArray2)) {
                byArray = (byte[])list.get(1);
                object2 = (byte[])list.get(2);
                object = (byte[])list.get(3);
                string = byArray == null ? null : SafeEncoder.encode(byArray);
                String string2 = object2 == null ? null : SafeEncoder.encode((byte[])object2);
                String string3 = object == null ? null : SafeEncoder.encode((byte[])object);
                this.onPMessage(string, string2, string3);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), byArray2)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray = (byte[])list.get(1);
                object2 = byArray == null ? null : SafeEncoder.encode(byArray);
                this.onPSubscribe((String)object2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), byArray2)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray = (byte[])list.get(1);
                object2 = byArray == null ? null : SafeEncoder.encode(byArray);
                this.onPUnsubscribe((String)object2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), byArray2)) {
                byArray = (byte[])list.get(1);
                object2 = byArray == null ? null : SafeEncoder.encode(byArray);
                this.onPong((String)object2);
                continue;
            }
            throw new JedisException("Unknown message type: " + object3);
        } while (this.isSubscribed());
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

