/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.DefaultJedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.Jedis;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.exceptions.InvalidURIException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.util.JedisURIHelper;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JedisFactory
implements PooledObjectFactory<Jedis> {
    private static final Logger logger = LoggerFactory.getLogger(JedisFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    protected JedisFactory(String string, int n2, int n3, int n4, String string2, int n5, String string3) {
        this(string, n2, n3, n4, string2, n5, string3, false, null, null, null);
    }

    protected JedisFactory(String string, int n2, int n3, int n4, String string2, String string3, int n5, String string4) {
        this(string, n2, n3, n4, 0, string2, string3, n5, string4);
    }

    protected JedisFactory(String string, int n2, int n3, int n4, int n5, String string2, String string3, int n6, String string4) {
        this(string, n2, n3, n4, n5, string2, string3, n6, string4, false, null, null, null);
    }

    JedisFactory(int n2, int n3, int n4, String string, String string2, int n5, String string3) {
        this(n2, n3, n4, string, string2, n5, string3, false, null, null, null);
    }

    protected JedisFactory(String string, int n2, int n3, int n4, String string2, int n5, String string3, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, n3, n4, null, string2, n5, string3, bl, sSLSocketFactory, sSLParameters, hostnameVerifier);
    }

    protected JedisFactory(String string, int n2, int n3, int n4, String string2, String string3, int n5, String string4, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, n3, n4, 0, string2, string3, n5, string4, bl, sSLSocketFactory, sSLParameters, hostnameVerifier);
    }

    protected JedisFactory(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(jedisClientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    protected JedisFactory(String string, int n2, int n3, int n4, int n5, String string2, String string3, int n6, String string4, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this.clientConfig = DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).blockingSocketTimeoutMillis(n5).user(string2).password(string3).database(n6).clientName(string4).ssl(bl).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(new HostAndPort(string, n2), this.clientConfig);
    }

    protected JedisFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig jedisClientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(jedisClientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    JedisFactory(int n2, int n3, int n4, String string, String string2, int n5, String string3, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).blockingSocketTimeoutMillis(n4).user(string).password(string2).database(n5).clientName(string3).ssl(bl).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    JedisFactory(JedisClientConfig jedisClientConfig) {
        this.clientConfig = jedisClientConfig;
        this.jedisSocketFactory = new DefaultJedisSocketFactory(jedisClientConfig);
    }

    protected JedisFactory(URI uRI, int n2, int n3, String string) {
        this(uRI, n2, n3, string, null, null, null);
    }

    protected JedisFactory(URI uRI, int n2, int n3, String string, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(uRI, n2, n3, 0, string, sSLSocketFactory, sSLParameters, hostnameVerifier);
    }

    protected JedisFactory(URI uRI, int n2, int n3, int n4, String string, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        if (!JedisURIHelper.isValid(uRI)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uRI.toString()));
        }
        this.clientConfig = DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).blockingSocketTimeoutMillis(n4).user(JedisURIHelper.getUser(uRI)).password(JedisURIHelper.getPassword(uRI)).database(JedisURIHelper.getDBIndex(uRI)).clientName(string).ssl(JedisURIHelper.isRedisSSLScheme(uRI)).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(new HostAndPort(uRI.getHost(), uRI.getPort()), this.clientConfig);
    }

    void setHostAndPort(HostAndPort hostAndPort) {
        if (!(this.jedisSocketFactory instanceof DefaultJedisSocketFactory)) {
            throw new IllegalStateException("setHostAndPort method has limited capability.");
        }
        ((DefaultJedisSocketFactory)this.jedisSocketFactory).updateHostAndPort(hostAndPort);
    }

    public void setPassword(String string) {
        this.clientConfig.updatePassword(string);
    }

    @Override
    public void activateObject(PooledObject<Jedis> pooledObject) {
        Jedis jedis = pooledObject.getObject();
        if (jedis.getDB() != this.clientConfig.getDatabase()) {
            jedis.select(this.clientConfig.getDatabase());
        }
    }

    @Override
    public void destroyObject(PooledObject<Jedis> pooledObject) {
        Jedis jedis = pooledObject.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.debug("Error while QUIT", runtimeException);
            }
            try {
                jedis.close();
            }
            catch (RuntimeException runtimeException) {
                logger.debug("Error while close", runtimeException);
            }
        }
    }

    @Override
    public PooledObject<Jedis> makeObject() {
        Jedis jedis = null;
        try {
            jedis = new Jedis(this.jedisSocketFactory, this.clientConfig);
            jedis.connect();
            return new DefaultPooledObject<Jedis>(jedis);
        }
        catch (JedisException jedisException) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (RuntimeException runtimeException) {
                    logger.debug("Error while QUIT", runtimeException);
                }
                try {
                    jedis.close();
                }
                catch (RuntimeException runtimeException) {
                    logger.debug("Error while close", runtimeException);
                }
            }
            throw jedisException;
        }
    }

    @Override
    public void passivateObject(PooledObject<Jedis> pooledObject) {
    }

    @Override
    public boolean validateObject(PooledObject<Jedis> pooledObject) {
        Jedis jedis = pooledObject.getObject();
        try {
            boolean bl = true;
            if (this.jedisSocketFactory instanceof DefaultJedisSocketFactory) {
                HostAndPort hostAndPort = ((DefaultJedisSocketFactory)this.jedisSocketFactory).getHostAndPort();
                HostAndPort hostAndPort2 = jedis.getConnection().getHostAndPort();
                bl = hostAndPort.getHost().equals(hostAndPort2.getHost()) && hostAndPort.getPort() == hostAndPort2.getPort();
            }
            return bl && jedis.getConnection().isConnected() && jedis.ping().equals("PONG");
        }
        catch (Exception exception) {
            logger.error("Error while validating pooled Jedis object.", exception);
            return false;
        }
    }
}

