/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.util.Pool;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JedisClusterInfoCache {
    private final Map<String, ConnectionPool> nodes = new HashMap<String, ConnectionPool>();
    private final Map<Integer, ConnectionPool> slots = new HashMap<Integer, ConnectionPool>();
    private final Map<Integer, HostAndPort> slotNodes = new HashMap<Integer, HostAndPort>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock rediscoverLock = new ReentrantLock();
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final JedisClientConfig clientConfig;
    private final Set<HostAndPort> startNodes;
    private static final int MASTER_NODE_INDEX = 2;

    @Deprecated
    public JedisClusterInfoCache(JedisClientConfig jedisClientConfig) {
        this(jedisClientConfig, new GenericObjectPoolConfig<Connection>());
    }

    @Deprecated
    public JedisClusterInfoCache(JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(jedisClientConfig, genericObjectPoolConfig, null);
    }

    public JedisClusterInfoCache(JedisClientConfig jedisClientConfig, Set<HostAndPort> set) {
        this(jedisClientConfig, new GenericObjectPoolConfig<Connection>(), set);
    }

    public JedisClusterInfoCache(JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, Set<HostAndPort> set) {
        this.poolConfig = genericObjectPoolConfig;
        this.clientConfig = jedisClientConfig;
        this.startNodes = set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterNodesAndSlots(Connection connection) {
        List<Object> list = this.executeClusterSlots(connection);
        this.w.lock();
        try {
            this.reset();
            for (Object object : list) {
                List list2 = (List)object;
                if (list2.size() <= 2) continue;
                List<Integer> list3 = this.getAssignedSlotArray(list2);
                int n2 = list2.size();
                for (int i2 = 2; i2 < n2; ++i2) {
                    List list4 = (List)list2.get(i2);
                    if (list4.isEmpty()) continue;
                    HostAndPort hostAndPort = this.generateHostAndPort(list4);
                    this.setupNodeIfNotExist(hostAndPort);
                    if (i2 != 2) continue;
                    this.assignSlotsToNode(list3, hostAndPort);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void renewClusterSlots(Connection var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 32[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverClusterSlots(Connection connection) {
        List<Object> list = this.executeClusterSlots(connection);
        this.w.lock();
        try {
            Object object;
            this.slots.clear();
            this.slotNodes.clear();
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object2 : list) {
                object = (List)object2;
                if (object.size() <= 2) continue;
                List<Integer> list2 = this.getAssignedSlotArray((List<Object>)object);
                int n2 = object.size();
                for (int i2 = 2; i2 < n2; ++i2) {
                    List list3 = (List)object.get(i2);
                    if (list3.isEmpty()) continue;
                    HostAndPort hostAndPort = this.generateHostAndPort(list3);
                    hashSet.add(JedisClusterInfoCache.getNodeKey(hostAndPort));
                    this.setupNodeIfNotExist(hostAndPort);
                    if (i2 != 2) continue;
                    this.assignSlotsToNode(list2, hostAndPort);
                }
            }
            Iterator<Object> iterator = this.nodes.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2;
                object2 = (Map.Entry)iterator.next();
                if (hashSet.contains(object2.getKey())) continue;
                object = (ConnectionPool)object2.getValue();
                try {
                    if (object != null) {
                        ((Pool)object).destroy();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iterator.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private HostAndPort generateHostAndPort(List<Object> list) {
        String string = SafeEncoder.encode((byte[])list.get(0));
        int n2 = ((Long)list.get(1)).intValue();
        return new HostAndPort(string, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool setupNodeIfNotExist(HostAndPort hostAndPort) {
        this.w.lock();
        try {
            String string = JedisClusterInfoCache.getNodeKey(hostAndPort);
            ConnectionPool connectionPool = this.nodes.get(string);
            if (connectionPool != null) {
                ConnectionPool connectionPool2 = connectionPool;
                return connectionPool2;
            }
            ConnectionPool connectionPool3 = new ConnectionPool(hostAndPort, this.clientConfig, this.poolConfig);
            this.nodes.put(string, connectionPool3);
            ConnectionPool connectionPool4 = connectionPool3;
            return connectionPool4;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotToNode(int n2, HostAndPort hostAndPort) {
        this.w.lock();
        try {
            ConnectionPool connectionPool = this.setupNodeIfNotExist(hostAndPort);
            this.slots.put(n2, connectionPool);
            this.slotNodes.put(n2, hostAndPort);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToNode(List<Integer> list, HostAndPort hostAndPort) {
        this.w.lock();
        try {
            ConnectionPool connectionPool = this.setupNodeIfNotExist(hostAndPort);
            for (Integer n2 : list) {
                this.slots.put(n2, connectionPool);
                this.slotNodes.put(n2, hostAndPort);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public ConnectionPool getNode(String string) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.nodes.get(string);
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public ConnectionPool getNode(HostAndPort hostAndPort) {
        return this.getNode(JedisClusterInfoCache.getNodeKey(hostAndPort));
    }

    public ConnectionPool getSlotPool(int n2) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.slots.get(n2);
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public HostAndPort getSlotNode(int n2) {
        this.r.lock();
        try {
            HostAndPort hostAndPort = this.slotNodes.get(n2);
            return hostAndPort;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<String, ConnectionPool> getNodes() {
        this.r.lock();
        try {
            HashMap<String, ConnectionPool> hashMap = new HashMap<String, ConnectionPool>(this.nodes);
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<ConnectionPool> getShuffledNodesPool() {
        this.r.lock();
        try {
            ArrayList<ConnectionPool> arrayList = new ArrayList<ConnectionPool>(this.nodes.values());
            Collections.shuffle(arrayList);
            ArrayList<ConnectionPool> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.w.lock();
        try {
            for (ConnectionPool connectionPool : this.nodes.values()) {
                try {
                    if (connectionPool == null) continue;
                    connectionPool.destroy();
                }
                catch (RuntimeException runtimeException) {}
            }
            this.nodes.clear();
            this.slots.clear();
            this.slotNodes.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    public static String getNodeKey(HostAndPort hostAndPort) {
        return hostAndPort.toString();
    }

    private List<Object> executeClusterSlots(Connection connection) {
        connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "SLOTS");
        return connection.getObjectMultiBulkReply();
    }

    private List<Integer> getAssignedSlotArray(List<Object> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = ((Long)list.get(0)).intValue(); i2 <= ((Long)list.get(1)).intValue(); ++i2) {
            arrayList.add(i2);
        }
        return arrayList;
    }
}

