/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.UnifiedJedis;
import me.ulrich.clans.library.redis.jedis.executors.ClusterCommandExecutor;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JedisCluster
extends UnifiedJedis {
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;

    public JedisCluster(HostAndPort hostAndPort) {
        this(Collections.singleton(hostAndPort));
    }

    public JedisCluster(HostAndPort hostAndPort, int n2) {
        this(Collections.singleton(hostAndPort), n2);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3) {
        this(Collections.singleton(hostAndPort), n2, n3);
    }

    public JedisCluster(HostAndPort hostAndPort, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, n3, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, String string, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, string, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, String string, String string2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, string, string2, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, String string, String string2, String string3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, string, string2, string3, genericObjectPoolConfig);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, String string, String string2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, boolean bl) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, string, string2, genericObjectPoolConfig, bl);
    }

    public JedisCluster(HostAndPort hostAndPort, int n2, int n3, int n4, String string, String string2, String string3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, boolean bl) {
        this(Collections.singleton(hostAndPort), n2, n3, n4, string, string2, string3, genericObjectPoolConfig, bl);
    }

    public JedisCluster(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig, int n2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(Collections.singleton(hostAndPort), jedisClientConfig, n2, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set) {
        this(set, 2000);
    }

    public JedisCluster(Set<HostAndPort> set, int n2) {
        this(set, (JedisClientConfig)DefaultJedisClientConfig.builder().timeoutMillis(n2).build());
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3) {
        this(set, DefaultJedisClientConfig.builder().timeoutMillis(n2).build(), n3);
    }

    public JedisCluster(Set<HostAndPort> set, String string, String string2) {
        this(set, (JedisClientConfig)DefaultJedisClientConfig.builder().user(string).password(string2).build());
    }

    public JedisCluster(Set<HostAndPort> set, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, 2000, 5, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, n2, 5, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, n2, n2, n3, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, n2, n3, n4, null, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, String string, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, n2, n3, n4, string, null, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, String string, String string2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, n2, n3, n4, null, string, string2, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, String string, String string2, String string3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).user(string).password(string2).clientName(string3).build(), n4, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, int n5, String string, String string2, String string3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).blockingSocketTimeoutMillis(n4).user(string).password(string2).clientName(string3).build(), n5, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, String string, String string2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, boolean bl) {
        this(set, n2, n3, n4, null, string, string2, genericObjectPoolConfig, bl);
    }

    public JedisCluster(Set<HostAndPort> set, int n2, int n3, int n4, String string, String string2, String string3, GenericObjectPoolConfig<Connection> genericObjectPoolConfig, boolean bl) {
        this(set, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).user(string).password(string2).clientName(string3).ssl(bl).build(), n4, genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(set, jedisClientConfig, n2, Duration.ofMillis((long)jedisClientConfig.getSocketTimeoutMillis() * (long)n2), genericObjectPoolConfig);
    }

    public JedisCluster(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2, Duration duration, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        super(set, jedisClientConfig, genericObjectPoolConfig, n2, duration);
    }

    public JedisCluster(Set<HostAndPort> set, JedisClientConfig jedisClientConfig) {
        this(set, jedisClientConfig, 5);
    }

    public JedisCluster(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2) {
        super(set, jedisClientConfig, n2);
    }

    public JedisCluster(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, int n2, Duration duration) {
        super(set, jedisClientConfig, n2, duration);
    }

    public Map<String, ConnectionPool> getClusterNodes() {
        return ((ClusterCommandExecutor)this.executor).provider.getNodes();
    }

    public Connection getConnectionFromSlot(int n2) {
        return ((ClusterCommandExecutor)this.executor).provider.getConnectionFromSlot(n2);
    }
}

