/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.Closeable;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.ulrich.clans.library.redis.jedis.BinaryJedisPubSub;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.ClusterCommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObjects;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisMonitor;
import me.ulrich.clans.library.redis.jedis.JedisPubSub;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.Module;
import me.ulrich.clans.library.redis.jedis.Pipeline;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.Transaction;
import me.ulrich.clans.library.redis.jedis.args.BitCountOption;
import me.ulrich.clans.library.redis.jedis.args.BitOP;
import me.ulrich.clans.library.redis.jedis.args.ClientPauseMode;
import me.ulrich.clans.library.redis.jedis.args.ClientType;
import me.ulrich.clans.library.redis.jedis.args.ClusterFailoverOption;
import me.ulrich.clans.library.redis.jedis.args.ClusterResetType;
import me.ulrich.clans.library.redis.jedis.args.ExpiryOption;
import me.ulrich.clans.library.redis.jedis.args.FlushMode;
import me.ulrich.clans.library.redis.jedis.args.FunctionRestorePolicy;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.ListDirection;
import me.ulrich.clans.library.redis.jedis.args.ListPosition;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.args.SaveMode;
import me.ulrich.clans.library.redis.jedis.args.SortedSetOption;
import me.ulrich.clans.library.redis.jedis.args.UnblockType;
import me.ulrich.clans.library.redis.jedis.commands.ClusterCommands;
import me.ulrich.clans.library.redis.jedis.commands.ControlBinaryCommands;
import me.ulrich.clans.library.redis.jedis.commands.ControlCommands;
import me.ulrich.clans.library.redis.jedis.commands.DatabaseCommands;
import me.ulrich.clans.library.redis.jedis.commands.GenericControlCommands;
import me.ulrich.clans.library.redis.jedis.commands.JedisBinaryCommands;
import me.ulrich.clans.library.redis.jedis.commands.JedisCommands;
import me.ulrich.clans.library.redis.jedis.commands.ModuleCommands;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.commands.SentinelCommands;
import me.ulrich.clans.library.redis.jedis.commands.ServerCommands;
import me.ulrich.clans.library.redis.jedis.exceptions.InvalidURIException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.params.BitPosParams;
import me.ulrich.clans.library.redis.jedis.params.ClientKillParams;
import me.ulrich.clans.library.redis.jedis.params.CommandListFilterByParams;
import me.ulrich.clans.library.redis.jedis.params.FailoverParams;
import me.ulrich.clans.library.redis.jedis.params.GeoAddParams;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusParam;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusStoreParam;
import me.ulrich.clans.library.redis.jedis.params.GeoSearchParam;
import me.ulrich.clans.library.redis.jedis.params.GetExParams;
import me.ulrich.clans.library.redis.jedis.params.LCSParams;
import me.ulrich.clans.library.redis.jedis.params.LPosParams;
import me.ulrich.clans.library.redis.jedis.params.LolwutParams;
import me.ulrich.clans.library.redis.jedis.params.MigrateParams;
import me.ulrich.clans.library.redis.jedis.params.RestoreParams;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.params.SetParams;
import me.ulrich.clans.library.redis.jedis.params.ShutdownParams;
import me.ulrich.clans.library.redis.jedis.params.SortingParams;
import me.ulrich.clans.library.redis.jedis.params.StrAlgoLCSParams;
import me.ulrich.clans.library.redis.jedis.params.XAddParams;
import me.ulrich.clans.library.redis.jedis.params.XAutoClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XPendingParams;
import me.ulrich.clans.library.redis.jedis.params.XReadGroupParams;
import me.ulrich.clans.library.redis.jedis.params.XReadParams;
import me.ulrich.clans.library.redis.jedis.params.XTrimParams;
import me.ulrich.clans.library.redis.jedis.params.ZAddParams;
import me.ulrich.clans.library.redis.jedis.params.ZIncrByParams;
import me.ulrich.clans.library.redis.jedis.params.ZParams;
import me.ulrich.clans.library.redis.jedis.params.ZRangeParams;
import me.ulrich.clans.library.redis.jedis.resps.AccessControlLogEntry;
import me.ulrich.clans.library.redis.jedis.resps.AccessControlUser;
import me.ulrich.clans.library.redis.jedis.resps.CommandDocument;
import me.ulrich.clans.library.redis.jedis.resps.CommandInfo;
import me.ulrich.clans.library.redis.jedis.resps.FunctionStats;
import me.ulrich.clans.library.redis.jedis.resps.GeoRadiusResponse;
import me.ulrich.clans.library.redis.jedis.resps.KeyedListElement;
import me.ulrich.clans.library.redis.jedis.resps.KeyedZSetElement;
import me.ulrich.clans.library.redis.jedis.resps.LCSMatchResult;
import me.ulrich.clans.library.redis.jedis.resps.LibraryInfo;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.resps.Slowlog;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumersInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingSummary;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.util.JedisURIHelper;
import me.ulrich.clans.library.redis.jedis.util.KeyValue;
import me.ulrich.clans.library.redis.jedis.util.Pool;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class Jedis
implements Closeable,
ClusterCommands,
ControlBinaryCommands,
ControlCommands,
DatabaseCommands,
GenericControlCommands,
JedisBinaryCommands,
JedisCommands,
ModuleCommands,
SentinelCommands,
ServerCommands {
    protected final Connection connection;
    private final CommandObjects commandObjects = new CommandObjects();
    private int db = 0;
    private Transaction transaction = null;
    private boolean isInMulti = false;
    private boolean isInWatch = false;
    private Pipeline pipeline = null;
    protected static final byte[][] DUMMY_ARRAY = new byte[0][];
    private Pool<Jedis> dataSource = null;

    public Jedis() {
        this.connection = new Connection();
    }

    public Jedis(String string) {
        this(URI.create(string));
    }

    public Jedis(HostAndPort hostAndPort) {
        this.connection = new Connection(hostAndPort);
    }

    public Jedis(String string, int n2) {
        this.connection = new Connection(string, n2);
    }

    public Jedis(String string, int n2, JedisClientConfig jedisClientConfig) {
        this(new HostAndPort(string, n2), jedisClientConfig);
    }

    public Jedis(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this.connection = new Connection(hostAndPort, jedisClientConfig);
    }

    public Jedis(String string, int n2, boolean bl) {
        this(string, n2, DefaultJedisClientConfig.builder().ssl(bl).build());
    }

    public Jedis(String string, int n2, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, DefaultJedisClientConfig.builder().ssl(bl).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(String string, int n2, int n3) {
        this(string, n2, n3, n3);
    }

    public Jedis(String string, int n2, int n3, boolean bl) {
        this(string, n2, n3, n3, bl);
    }

    public Jedis(String string, int n2, int n3, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, n3, n3, bl, sSLSocketFactory, sSLParameters, hostnameVerifier);
    }

    public Jedis(String string, int n2, int n3, int n4) {
        this(string, n2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).build());
    }

    public Jedis(String string, int n2, int n3, int n4, int n5) {
        this(string, n2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).blockingSocketTimeoutMillis(n5).build());
    }

    public Jedis(String string, int n2, int n3, int n4, boolean bl) {
        this(string, n2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).ssl(bl).build());
    }

    public Jedis(String string, int n2, int n3, int n4, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).ssl(bl).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(String string, int n2, int n3, int n4, int n5, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(string, n2, DefaultJedisClientConfig.builder().connectionTimeoutMillis(n3).socketTimeoutMillis(n4).blockingSocketTimeoutMillis(n5).ssl(bl).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uRI) {
        if (!JedisURIHelper.isValid(uRI)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uRI.toString()));
        }
        this.connection = new Connection(new HostAndPort(uRI.getHost(), uRI.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().user(JedisURIHelper.getUser(uRI)).password(JedisURIHelper.getPassword(uRI)).database(JedisURIHelper.getDBIndex(uRI)).ssl(JedisURIHelper.isRedisSSLScheme(uRI)).build());
    }

    public Jedis(URI uRI, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(uRI, (JedisClientConfig)DefaultJedisClientConfig.builder().sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uRI, int n2) {
        this(uRI, n2, n2);
    }

    public Jedis(URI uRI, int n2, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(uRI, n2, n2, sSLSocketFactory, sSLParameters, hostnameVerifier);
    }

    public Jedis(URI uRI, int n2, int n3) {
        this(uRI, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).build());
    }

    public Jedis(URI uRI, int n2, int n3, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(uRI, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uRI, int n2, int n3, int n4, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier) {
        this(uRI, (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(n2).socketTimeoutMillis(n3).blockingSocketTimeoutMillis(n4).sslSocketFactory(sSLSocketFactory).sslParameters(sSLParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(URI uRI, JedisClientConfig jedisClientConfig) {
        if (!JedisURIHelper.isValid(uRI)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI \"%s\".", uRI.toString()));
        }
        this.connection = new Connection(new HostAndPort(uRI.getHost(), uRI.getPort()), (JedisClientConfig)DefaultJedisClientConfig.builder().connectionTimeoutMillis(jedisClientConfig.getConnectionTimeoutMillis()).socketTimeoutMillis(jedisClientConfig.getSocketTimeoutMillis()).blockingSocketTimeoutMillis(jedisClientConfig.getBlockingSocketTimeoutMillis()).user(JedisURIHelper.getUser(uRI)).password(JedisURIHelper.getPassword(uRI)).database(JedisURIHelper.getDBIndex(uRI)).clientName(jedisClientConfig.getClientName()).ssl(JedisURIHelper.isRedisSSLScheme(uRI)).sslSocketFactory(jedisClientConfig.getSslSocketFactory()).sslParameters(jedisClientConfig.getSslParameters()).hostnameVerifier(jedisClientConfig.getHostnameVerifier()).build());
    }

    public Jedis(JedisSocketFactory jedisSocketFactory) {
        this.connection = new Connection(jedisSocketFactory);
    }

    public Jedis(JedisSocketFactory jedisSocketFactory, JedisClientConfig jedisClientConfig) {
        this.connection = new Connection(jedisSocketFactory, jedisClientConfig);
    }

    public Jedis(Connection connection) {
        this.connection = connection;
    }

    public String toString() {
        return "Jedis{" + this.connection + '}';
    }

    public Connection getClient() {
        return this.getConnection();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void connect() {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public boolean isBroken() {
        return this.connection.isBroken();
    }

    public void resetState() {
        if (this.isConnected()) {
            if (this.transaction != null) {
                this.transaction.close();
            }
            if (this.pipeline != null) {
                this.pipeline.close();
            }
            if (this.isInWatch) {
                this.connection.sendCommand(Protocol.Command.UNWATCH);
                this.connection.getStatusCodeReply();
                this.isInWatch = false;
            }
        }
        this.transaction = null;
        this.pipeline = null;
    }

    protected void setDataSource(Pool<Jedis> pool) {
        this.dataSource = pool;
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            Pool<Jedis> pool = this.dataSource;
            this.dataSource = null;
            if (this.isBroken()) {
                pool.returnBrokenResource(this);
            } else {
                pool.returnResource(this);
            }
        } else {
            this.connection.close();
        }
    }

    public Transaction multi() {
        this.transaction = new Transaction(this);
        return this.transaction;
    }

    public Pipeline pipelined() {
        this.pipeline = new Pipeline(this);
        return this.pipeline;
    }

    protected void checkIsInMultiOrPipeline() {
        if (this.transaction != null) {
            throw new IllegalStateException("Cannot use Jedis when in Multi. Please use Transaction or reset jedis state.");
        }
        if (this.pipeline != null && this.pipeline.hasPipelinedResponse()) {
            throw new IllegalStateException("Cannot use Jedis when in Pipeline. Please use Pipeline or reset jedis state.");
        }
    }

    public int getDB() {
        return this.db;
    }

    @Override
    public boolean copy(byte[] byArray, byte[] byArray2, int n2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(byArray, byArray2, n2, bl));
    }

    @Override
    public boolean copy(byte[] byArray, byte[] byArray2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(byArray, byArray2, bl));
    }

    @Override
    public String ping() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.PING);
        return this.connection.getStatusCodeReply();
    }

    public byte[] ping(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{byArray});
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String set(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(byArray, byArray2));
    }

    @Override
    public String set(byte[] byArray, byte[] byArray2, SetParams setParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(byArray, byArray2, setParams));
    }

    @Override
    public byte[] get(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.get(byArray));
    }

    @Override
    public byte[] setGet(byte[] byArray, byte[] byArray2, SetParams setParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(byArray, byArray2, setParams));
    }

    @Override
    public byte[] getDel(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getDel(byArray));
    }

    @Override
    public byte[] getEx(byte[] byArray, GetExParams getExParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getEx(byArray, getExParams));
    }

    @Override
    public String quit() {
        this.checkIsInMultiOrPipeline();
        return this.connection.quit();
    }

    @Override
    public long exists(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public boolean exists(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(byArray));
    }

    @Override
    public long del(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(byArray));
    }

    @Override
    public long del(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(byArray));
    }

    @Override
    public long unlink(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public long unlink(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(byArray));
    }

    @Override
    public String type(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.type(byArray));
    }

    @Override
    public String flushDB() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.FLUSHDB);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String flushDB(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FLUSHDB, new byte[][]{flushMode.getRaw()});
        return this.connection.getStatusCodeReply();
    }

    @Override
    public Set<byte[]> keys(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.keys(byArray));
    }

    @Override
    public byte[] randomBinaryKey() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.randomBinaryKey());
    }

    @Override
    public String rename(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rename(byArray, byArray2));
    }

    @Override
    public long renamenx(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.renamenx(byArray, byArray2));
    }

    @Override
    public long dbSize() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.DBSIZE);
        return this.connection.getIntegerReply();
    }

    @Override
    public long expire(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(byArray, l2));
    }

    @Override
    public long expire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(byArray, l2, expiryOption));
    }

    @Override
    public long pexpire(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(byArray, l2));
    }

    @Override
    public long pexpire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(byArray, l2, expiryOption));
    }

    @Override
    public long expireTime(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireTime(byArray));
    }

    @Override
    public long pexpireTime(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireTime(byArray));
    }

    @Override
    public long expireAt(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(byArray, l2));
    }

    @Override
    public long expireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(byArray, l2, expiryOption));
    }

    @Override
    public long pexpireAt(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(byArray, l2));
    }

    @Override
    public long pexpireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(byArray, l2, expiryOption));
    }

    @Override
    public long ttl(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ttl(byArray));
    }

    @Override
    public long touch(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public long touch(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(byArray));
    }

    @Override
    public String select(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(n2)});
        String string = this.connection.getStatusCodeReply();
        this.db = n2;
        return string;
    }

    @Override
    public String swapDB(int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SWAPDB, Protocol.toByteArray(n2), Protocol.toByteArray(n3));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long move(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MOVE, byArray, Protocol.toByteArray(n2));
        return this.connection.getIntegerReply();
    }

    @Override
    public String flushAll() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.FLUSHALL);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String flushAll(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FLUSHALL, new byte[][]{flushMode.getRaw()});
        return this.connection.getStatusCodeReply();
    }

    @Override
    public byte[] getSet(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getSet(byArray, byArray2));
    }

    @Override
    public List<byte[]> mget(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mget(byArray));
    }

    @Override
    public long setnx(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setnx(byArray, byArray2));
    }

    @Override
    public String setex(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setex(byArray, l2, byArray2));
    }

    @Override
    public String mset(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mset(byArray));
    }

    @Override
    public long msetnx(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.msetnx(byArray));
    }

    @Override
    public long decrBy(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decrBy(byArray, l2));
    }

    @Override
    public long decr(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decr(byArray));
    }

    @Override
    public long incrBy(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrBy(byArray, l2));
    }

    @Override
    public double incrByFloat(byte[] byArray, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrByFloat(byArray, d2));
    }

    @Override
    public long incr(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incr(byArray));
    }

    @Override
    public long append(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.append(byArray, byArray2));
    }

    @Override
    public byte[] substr(byte[] byArray, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.substr(byArray, n2, n3));
    }

    @Override
    public long hset(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(byArray, byArray2, byArray3));
    }

    @Override
    public long hset(byte[] byArray, Map<byte[], byte[]> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(byArray, map));
    }

    @Override
    public byte[] hget(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hget(byArray, byArray2));
    }

    @Override
    public long hsetnx(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hsetnx(byArray, byArray2, byArray3));
    }

    @Override
    public String hmset(byte[] byArray, Map<byte[], byte[]> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmset(byArray, map));
    }

    @Override
    public List<byte[]> hmget(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmget(byArray, byArray2));
    }

    @Override
    public long hincrBy(byte[] byArray, byte[] byArray2, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrBy(byArray, byArray2, l2));
    }

    @Override
    public double hincrByFloat(byte[] byArray, byte[] byArray2, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrByFloat(byArray, byArray2, d2));
    }

    @Override
    public boolean hexists(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexists(byArray, byArray2));
    }

    @Override
    public long hdel(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hdel(byArray, byArray2));
    }

    @Override
    public long hlen(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hlen(byArray));
    }

    @Override
    public Set<byte[]> hkeys(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hkeys(byArray));
    }

    @Override
    public List<byte[]> hvals(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hvals(byArray));
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hgetAll(byArray));
    }

    @Override
    public byte[] hrandfield(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(byArray));
    }

    @Override
    public List<byte[]> hrandfield(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(byArray, l2));
    }

    @Override
    public Map<byte[], byte[]> hrandfieldWithValues(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfieldWithValues(byArray, l2));
    }

    @Override
    public long rpush(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpush(byArray, byArray2));
    }

    @Override
    public long lpush(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpush(byArray, byArray2));
    }

    @Override
    public long llen(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.llen(byArray));
    }

    @Override
    public List<byte[]> lrange(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrange(byArray, l2, l3));
    }

    @Override
    public String ltrim(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ltrim(byArray, l2, l3));
    }

    @Override
    public byte[] lindex(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lindex(byArray, l2));
    }

    @Override
    public String lset(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lset(byArray, l2, byArray2));
    }

    @Override
    public long lrem(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrem(byArray, l2, byArray2));
    }

    @Override
    public byte[] lpop(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(byArray));
    }

    @Override
    public List<byte[]> lpop(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(byArray, n2));
    }

    @Override
    public Long lpos(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(byArray, byArray2));
    }

    @Override
    public Long lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams));
    }

    @Override
    public List<Long> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(byArray, byArray2, lPosParams, l2));
    }

    @Override
    public byte[] rpop(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(byArray));
    }

    @Override
    public List<byte[]> rpop(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(byArray, n2));
    }

    @Override
    public byte[] rpoplpush(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpoplpush(byArray, byArray2));
    }

    @Override
    public long sadd(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sadd(byArray, byArray2));
    }

    @Override
    public Set<byte[]> smembers(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smembers(byArray));
    }

    @Override
    public long srem(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srem(byArray, byArray2));
    }

    @Override
    public byte[] spop(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(byArray));
    }

    @Override
    public Set<byte[]> spop(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(byArray, l2));
    }

    @Override
    public long smove(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smove(byArray, byArray2, byArray3));
    }

    @Override
    public long scard(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scard(byArray));
    }

    @Override
    public boolean sismember(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sismember(byArray, byArray2));
    }

    @Override
    public List<Boolean> smismember(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smismember(byArray, byArray2));
    }

    @Override
    public Set<byte[]> sinter(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinter(byArray));
    }

    @Override
    public long sinterstore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinterstore(byArray, byArray2));
    }

    @Override
    public long sintercard(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(byArray));
    }

    @Override
    public long sintercard(int n2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(n2, byArray));
    }

    @Override
    public Set<byte[]> sunion(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunion(byArray));
    }

    @Override
    public long sunionstore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunionstore(byArray, byArray2));
    }

    @Override
    public Set<byte[]> sdiff(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiff(byArray));
    }

    @Override
    public long sdiffstore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiffstore(byArray, byArray2));
    }

    @Override
    public byte[] srandmember(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(byArray));
    }

    @Override
    public List<byte[]> srandmember(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(byArray, n2));
    }

    @Override
    public long zadd(byte[] byArray, double d2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(byArray, d2, byArray2));
    }

    @Override
    public long zadd(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public long zadd(byte[] byArray, Map<byte[], Double> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(byArray, map));
    }

    @Override
    public long zadd(byte[] byArray, Map<byte[], Double> map, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(byArray, map, zAddParams));
    }

    @Override
    public Double zaddIncr(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zaddIncr(byArray, d2, byArray2, zAddParams));
    }

    @Override
    public List<byte[]> zrange(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(byArray, l2, l3));
    }

    @Override
    public long zrem(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrem(byArray, byArray2));
    }

    @Override
    public double zincrby(byte[] byArray, double d2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(byArray, d2, byArray2));
    }

    @Override
    public Double zincrby(byte[] byArray, double d2, byte[] byArray2, ZIncrByParams zIncrByParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(byArray, d2, byArray2, zIncrByParams));
    }

    @Override
    public Long zrank(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrank(byArray, byArray2));
    }

    @Override
    public Long zrevrank(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrank(byArray, byArray2));
    }

    @Override
    public List<byte[]> zrevrange(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrange(byArray, l2, l3));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(byArray, l2, l3));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeWithScores(byArray, l2, l3));
    }

    @Override
    public List<byte[]> zrange(byte[] byArray, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(byArray, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(byte[] byArray, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(byArray, zRangeParams));
    }

    @Override
    public long zrangestore(byte[] byArray, byte[] byArray2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangestore(byArray, byArray2, zRangeParams));
    }

    @Override
    public byte[] zrandmember(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(byArray));
    }

    @Override
    public List<byte[]> zrandmember(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(byArray, l2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmemberWithScores(byArray, l2));
    }

    @Override
    public long zcard(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcard(byArray));
    }

    @Override
    public Double zscore(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscore(byArray, byArray2));
    }

    @Override
    public List<Double> zmscore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmscore(byArray, byArray2));
    }

    @Override
    public Tuple zpopmax(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(byArray));
    }

    @Override
    public List<Tuple> zpopmax(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(byArray, n2));
    }

    @Override
    public Tuple zpopmin(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(byArray));
    }

    @Override
    public List<Tuple> zpopmin(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(byArray, n2));
    }

    public String watch(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WATCH, byArray);
        String string = this.connection.getStatusCodeReply();
        this.isInWatch = true;
        return string;
    }

    public String unwatch() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.UNWATCH);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<byte[]> sort(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(byArray));
    }

    @Override
    public List<byte[]> sort(byte[] byArray, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(byArray, sortingParams));
    }

    @Override
    public long sort(byte[] byArray, SortingParams sortingParams, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(byArray, sortingParams, byArray2));
    }

    @Override
    public long sort(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(byArray, byArray2));
    }

    @Override
    public List<byte[]> sortReadonly(byte[] byArray, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sortReadonly(byArray, sortingParams));
    }

    @Override
    public byte[] lmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmove(byArray, byArray2, listDirection, listDirection2));
    }

    @Override
    public byte[] blmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmove(byArray, byArray2, listDirection, listDirection2, d2));
    }

    @Override
    public List<byte[]> blpop(int n2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.blpop(n2, byArray));
    }

    @Override
    public List<byte[]> blpop(double d2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.blpop(d2, byArray));
    }

    @Override
    public List<byte[]> brpop(int n2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.brpop(n2, byArray));
    }

    @Override
    public List<byte[]> brpop(double d2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.brpop(d2, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection listDirection, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(listDirection, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection listDirection, int n2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(listDirection, n2, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(long l2, ListDirection listDirection, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(l2, listDirection, byArray));
    }

    @Override
    public KeyValue<byte[], List<byte[]>> blmpop(long l2, ListDirection listDirection, int n2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(l2, listDirection, n2, byArray));
    }

    @Override
    public List<byte[]> bzpopmax(double d2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.bzpopmax(d2, byArray));
    }

    @Override
    public List<byte[]> bzpopmin(double d2, byte[] ... byArray) {
        return this.connection.executeCommand(this.commandObjects.bzpopmin(d2, byArray));
    }

    @Override
    public String auth(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.AUTH, string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String auth(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.AUTH, string, string2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long zcount(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(byArray, d2, d3));
    }

    @Override
    public long zcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(byArray, byArray2, byArray3));
    }

    @Override
    public Set<byte[]> zdiff(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiff(byArray));
    }

    @Override
    public Set<Tuple> zdiffWithScores(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffWithScores(byArray));
    }

    @Override
    public long zdiffStore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffStore(byArray, byArray2));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(byArray, d2, d3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<byte[]> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(byArray, d2, d3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public long zremrangeByRank(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByRank(byArray, l2, l3));
    }

    @Override
    public long zremrangeByScore(byte[] byArray, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(byArray, d2, d3));
    }

    @Override
    public long zremrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(byArray, byArray2, byArray3));
    }

    @Override
    public Set<byte[]> zunion(ZParams zParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunion(zParams, byArray));
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams zParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionWithScores(zParams, byArray));
    }

    @Override
    public long zunionstore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(byArray, byArray2));
    }

    @Override
    public long zunionstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(byArray, zParams, byArray2));
    }

    @Override
    public Set<byte[]> zinter(ZParams zParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinter(zParams, byArray));
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams zParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterWithScores(zParams, byArray));
    }

    @Override
    public long zinterstore(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(byArray, byArray2));
    }

    @Override
    public long zinterstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(byArray, zParams, byArray2));
    }

    @Override
    public long zintercard(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(byArray));
    }

    @Override
    public long zintercard(long l2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(l2, byArray));
    }

    @Override
    public long zlexcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zlexcount(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(byArray, byArray2, byArray3, n2, n3));
    }

    @Override
    public long zremrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByLex(byArray, byArray2, byArray3));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption sortedSetOption, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(sortedSetOption, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> zmpop(SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(sortedSetOption, n2, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, byArray));
    }

    @Override
    public KeyValue<byte[], List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, byArray));
    }

    @Override
    public String save() {
        this.connection.sendCommand(Protocol.Command.SAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.connection.sendCommand(Protocol.Command.BGSAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgsaveSchedule() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.BGSAVE, Protocol.Keyword.SCHEDULE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.connection.sendCommand(Protocol.Command.BGREWRITEAOF);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long lastsave() {
        this.connection.sendCommand(Protocol.Command.LASTSAVE);
        return this.connection.getIntegerReply();
    }

    @Override
    public void shutdown() {
        this.connection.sendCommand(Protocol.Command.SHUTDOWN);
        try {
            throw new JedisException(this.connection.getStatusCodeReply());
        }
        catch (JedisConnectionException jedisConnectionException) {
            this.connection.setBroken();
            return;
        }
    }

    @Override
    @Deprecated
    public void shutdown(SaveMode saveMode) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN, new byte[][]{saveMode.getRaw()});
        try {
            throw new JedisException(this.connection.getStatusCodeReply());
        }
        catch (JedisConnectionException jedisConnectionException) {
            this.connection.setBroken();
            return;
        }
    }

    @Override
    public void shutdown(ShutdownParams shutdownParams) {
        this.connection.sendCommand(new CommandArguments(Protocol.Command.SHUTDOWN).addParams(shutdownParams));
        try {
            throw new JedisException(this.connection.getStatusCodeReply());
        }
        catch (JedisConnectionException jedisConnectionException) {
            this.connection.setBroken();
            return;
        }
    }

    @Override
    public String shutdownAbort() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SHUTDOWN, Protocol.Keyword.ABORT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String info() {
        this.connection.sendCommand(Protocol.Command.INFO);
        return this.connection.getBulkReply();
    }

    @Override
    public String info(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.INFO, string);
        return this.connection.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.connection.sendCommand(Protocol.Command.MONITOR);
        this.connection.getStatusCodeReply();
        jedisMonitor.proceed(this.connection);
    }

    @Override
    @Deprecated
    public String slaveof(String string, int n2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, SafeEncoder.encode(string), Protocol.toByteArray(n2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public String slaveofNoOne() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLAVEOF, Protocol.Keyword.NO.getRaw(), Protocol.Keyword.ONE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String replicaof(String string, int n2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, SafeEncoder.encode(string), Protocol.toByteArray(n2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String replicaofNoOne() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, Protocol.Keyword.NO.getRaw(), Protocol.Keyword.ONE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<Object> roleBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ROLE);
        return BuilderFactory.RAW_OBJECT_LIST.build(this.connection.getOne());
    }

    @Override
    public List<byte[]> configGet(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.getRaw(), byArray);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> configGet(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.GET.getRaw(), byArray));
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public String configResetStat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configRewrite() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.REWRITE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.getRaw(), byArray, byArray2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.SET.getRaw(), byArray));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long strlen(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strlen(byArray));
    }

    @Override
    @Deprecated
    public LCSMatchResult strAlgoLCSKeys(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strAlgoLCSKeys(byArray, byArray2, strAlgoLCSParams));
    }

    @Deprecated
    public LCSMatchResult strAlgoLCSStrings(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strAlgoLCSStrings(byArray, byArray2, strAlgoLCSParams));
    }

    @Override
    public LCSMatchResult lcs(byte[] byArray, byte[] byArray2, LCSParams lCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lcs(byArray, byArray2, lCSParams));
    }

    @Override
    public long lpushx(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpushx(byArray, byArray2));
    }

    @Override
    public long persist(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.persist(byArray));
    }

    @Override
    public long rpushx(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpushx(byArray, byArray2));
    }

    @Override
    public byte[] echo(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ECHO, new byte[][]{byArray});
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public long linsert(byte[] byArray, ListPosition listPosition, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.linsert(byArray, listPosition, byArray2, byArray3));
    }

    @Override
    public byte[] brpoplpush(byte[] byArray, byte[] byArray2, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpoplpush(byArray, byArray2, n2));
    }

    @Override
    public boolean setbit(byte[] byArray, long l2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setbit(byArray, l2, bl));
    }

    @Override
    public boolean getbit(byte[] byArray, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getbit(byArray, l2));
    }

    @Override
    public long bitpos(byte[] byArray, boolean bl) {
        return this.bitpos(byArray, bl, new BitPosParams());
    }

    @Override
    public long bitpos(byte[] byArray, boolean bl, BitPosParams bitPosParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(byArray, bl, bitPosParams));
    }

    @Override
    public long setrange(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setrange(byArray, l2, byArray2));
    }

    @Override
    public byte[] getrange(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getrange(byArray, l2, l3));
    }

    public long publish(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.publish(byArray, byArray2));
    }

    public void subscribe(BinaryJedisPubSub binaryJedisPubSub, byte[] ... byArray) {
        binaryJedisPubSub.proceed(this.connection, byArray);
    }

    public void psubscribe(BinaryJedisPubSub binaryJedisPubSub, byte[] ... byArray) {
        binaryJedisPubSub.proceedWithPatterns(this.connection, byArray);
    }

    @Override
    public Object eval(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(byArray, list, list2));
    }

    @Override
    public Object evalReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalReadonly(byArray, list, list2));
    }

    protected static byte[][] getParamsWithBinary(List<byte[]> list, List<byte[]> list2) {
        int n2;
        int n3 = list.size();
        int n4 = list2.size();
        byte[][] byArrayArray = new byte[n3 + n4][];
        for (n2 = 0; n2 < n3; ++n2) {
            byArrayArray[n2] = list.get(n2);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            byArrayArray[n3 + n2] = list2.get(n2);
        }
        return byArrayArray;
    }

    @Override
    public Object eval(byte[] byArray, int n2, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(byArray, n2, byArray2));
    }

    @Override
    public Object eval(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(byArray));
    }

    @Override
    public Object evalsha(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(byArray));
    }

    @Override
    public Object evalsha(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(byArray, list, list2));
    }

    @Override
    public Object evalshaReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalshaReadonly(byArray, list, list2));
    }

    @Override
    public Object evalsha(byte[] byArray, int n2, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(byArray, n2, byArray2));
    }

    @Override
    public String scriptFlush() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.FLUSH);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String scriptFlush(FlushMode flushMode) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.FLUSH.getRaw(), flushMode.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public Boolean scriptExists(byte[] byArray) {
        byte[][] byArrayArray = new byte[][]{byArray};
        return this.scriptExists(byArrayArray).get(0);
    }

    @Override
    public List<Boolean> scriptExists(byte[] ... byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Jedis.joinParameters(Protocol.Keyword.EXISTS.getRaw(), byArray));
        return BuilderFactory.BOOLEAN_LIST.build(this.connection.getOne());
    }

    @Override
    public byte[] scriptLoad(byte[] byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.getRaw(), byArray);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String scriptKill() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.KILL);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String slowlogReset() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.RESET);
        return this.connection.getBulkReply();
    }

    @Override
    public long slowlogLen() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.LEN);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<Object> slowlogGetBinary() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET);
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public List<Object> slowlogGetBinary(long l2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.getRaw(), Protocol.toByteArray(l2));
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public Long objectRefcount(byte[] byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.getRaw(), byArray);
        return this.connection.getIntegerReply();
    }

    @Override
    public byte[] objectEncoding(byte[] byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.getRaw(), byArray);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public Long objectIdletime(byte[] byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.getRaw(), byArray);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<byte[]> objectHelpBinary() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.HELP);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public Long objectFreq(byte[] byArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.FREQ.getRaw(), byArray);
        return this.connection.getIntegerReply();
    }

    @Override
    public long bitcount(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(byArray));
    }

    @Override
    public long bitcount(byte[] byArray, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(byArray, l2, l3));
    }

    @Override
    public long bitcount(byte[] byArray, long l2, long l3, BitCountOption bitCountOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(byArray, l2, l3, bitCountOption));
    }

    @Override
    public long bitop(BitOP bitOP, byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitop(bitOP, byArray, byArray2));
    }

    @Override
    public byte[] dump(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.dump(byArray));
    }

    @Override
    public String restore(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(byArray, l2, byArray2));
    }

    @Override
    public String restore(byte[] byArray, long l2, byte[] byArray2, RestoreParams restoreParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(byArray, l2, byArray2, restoreParams));
    }

    @Override
    public long pttl(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pttl(byArray));
    }

    @Override
    public String psetex(byte[] byArray, long l2, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.psetex(byArray, l2, byArray2));
    }

    @Override
    public byte[] memoryDoctorBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.DOCTOR);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public Long memoryUsage(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), byArray);
        return this.connection.getIntegerReply();
    }

    @Override
    public Long memoryUsage(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), byArray, Protocol.Keyword.SAMPLES.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getIntegerReply();
    }

    @Override
    public String failover() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.FAILOVER);
        this.connection.setTimeoutInfinite();
        try {
            String string = this.connection.getStatusCodeReply();
            return string;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String failover(FailoverParams failoverParams) {
        this.checkIsInMultiOrPipeline();
        CommandArguments commandArguments = new ClusterCommandArguments(Protocol.Command.FAILOVER).addParams(failoverParams);
        this.connection.sendCommand(commandArguments);
        this.connection.setTimeoutInfinite();
        try {
            String string = this.connection.getStatusCodeReply();
            return string;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    @Override
    public String failoverAbort() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.FAILOVER, Protocol.Keyword.ABORT);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public byte[] aclWhoAmIBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.WHOAMI);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclGenPassBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclGenPassBinary(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public List<byte[]> aclListBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LIST);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclUsersBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.USERS);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public AccessControlUser aclGetUser(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GETUSER.getRaw(), byArray);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public String aclSetUser(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SETUSER.getRaw(), byArray);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.SETUSER.getRaw(), byArray, byArray2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long aclDelUser(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.DELUSER.getRaw(), byArray);
        return this.connection.getIntegerReply();
    }

    @Override
    public long aclDelUser(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.DELUSER.getRaw(), byArray, byArray2));
        return this.connection.getIntegerReply();
    }

    @Override
    public List<byte[]> aclCatBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclCat(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT.getRaw(), byArray);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG);
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public List<byte[]> aclLogBinary(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public String aclLogReset() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.Keyword.RESET.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientKill(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.getRaw(), byArray);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientKill(String string, int n2) {
        return this.clientKill(string + ':' + n2);
    }

    @Override
    public long clientKill(ClientKillParams clientKillParams) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Jedis.joinParameters(Protocol.Keyword.KILL.getRaw(), clientKillParams.getByteParams()));
        return this.connection.getIntegerReply();
    }

    @Override
    public byte[] clientGetnameBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.GETNAME);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(ClientType clientType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST.getRaw(), clientType.getRaw());
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] clientListBinary(long ... lArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.clientListParams(lArray));
        return this.connection.getBinaryBulkReply();
    }

    private byte[][] clientListParams(long ... lArray) {
        byte[][] byArrayArray = new byte[2 + lArray.length][];
        int n2 = 0;
        byArrayArray[n2++] = Protocol.Keyword.LIST.getRaw();
        byArrayArray[n2++] = Protocol.Keyword.ID.getRaw();
        for (long l2 : lArray) {
            byArrayArray[n2++] = Protocol.toByteArray(l2);
        }
        return byArrayArray;
    }

    @Override
    public byte[] clientInfoBinary() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.INFO);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String clientSetname(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.getRaw(), byArray);
        return this.connection.getBulkReply();
    }

    @Override
    public long clientId() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.ID);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clientUnblock(long l2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray(l2));
        return this.connection.getIntegerReply();
    }

    @Override
    public long clientUnblock(long l2, UnblockType unblockType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.UNBLOCK.getRaw(), Protocol.toByteArray(l2), unblockType.getRaw());
        return this.connection.getIntegerReply();
    }

    @Override
    public String clientPause(long l2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray(l2));
        return this.connection.getBulkReply();
    }

    @Override
    public String clientPause(long l2, ClientPauseMode clientPauseMode) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.PAUSE.getRaw(), Protocol.toByteArray(l2), clientPauseMode.getRaw());
        return this.connection.getBulkReply();
    }

    @Override
    public String clientNoEvictOn() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-EVICT", "ON");
        return this.connection.getBulkReply();
    }

    @Override
    public String clientNoEvictOff() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, "NO-EVICT", "OFF");
        return this.connection.getBulkReply();
    }

    public List<String> time() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.TIME);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String migrate(String string, int n2, byte[] byArray, int n3, int n4) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, byArray, n3, n4));
    }

    @Override
    public String migrate(String string, int n2, int n3, int n4, MigrateParams migrateParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, n3, n4, migrateParams, byArray));
    }

    @Override
    public String migrate(String string, int n2, byte[] byArray, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, byArray, n3));
    }

    @Override
    public String migrate(String string, int n2, int n3, MigrateParams migrateParams, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, byArray));
    }

    @Override
    public long waitReplicas(int n2, long l2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WAIT, Protocol.toByteArray(n2), Protocol.toByteArray(l2));
        return this.connection.getIntegerReply();
    }

    @Override
    public long pfadd(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfadd(byArray, byArray2));
    }

    @Override
    public long pfcount(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public String pfmerge(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfmerge(byArray, byArray2));
    }

    @Override
    public long pfcount(byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(byArray));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(byArray));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(byArray, scanParams));
    }

    @Override
    public ScanResult<byte[]> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(byArray, scanParams, byArray2));
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] byArray, byte[] byArray2) {
        return this.hscan(byArray, byArray2, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscan(byArray, byArray2, scanParams));
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] byArray, byte[] byArray2) {
        return this.sscan(byArray, byArray2, new ScanParams());
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sscan(byArray, byArray2, scanParams));
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] byArray, byte[] byArray2) {
        return this.zscan(byArray, byArray2, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscan(byArray, byArray2, scanParams));
    }

    @Override
    public long geoadd(byte[] byArray, double d2, double d3, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(byArray, d2, d3, byArray2));
    }

    @Override
    public long geoadd(byte[] byArray, Map<byte[], GeoCoordinate> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(byArray, map));
    }

    @Override
    public long geoadd(byte[] byArray, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(byArray, geoAddParams, map));
    }

    @Override
    public Double geodist(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(byArray, byArray2, byArray3));
    }

    @Override
    public Double geodist(byte[] byArray, byte[] byArray2, byte[] byArray3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(byArray, byArray2, byArray3, geoUnit));
    }

    @Override
    public List<byte[]> geohash(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geohash(byArray, byArray2));
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geopos(byArray, byArray2));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusStore(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusStore(byArray, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(byArray, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusByMemberStore(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberStore(byArray, byArray2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(byArray, byArray2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, byte[] byArray2, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(byArray, byArray2, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(byArray, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(byte[] byArray, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(byArray, geoSearchParam));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, byArray3, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(byArray, byArray2, geoSearchParam));
    }

    @Override
    public long geosearchStoreStoreDist(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStoreStoreDist(byArray, byArray2, geoSearchParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(byArray, byArray2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public List<Long> bitfield(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfield(byArray, byArray2));
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfieldReadonly(byArray, byArray2));
    }

    @Override
    public long hstrlen(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hstrlen(byArray, byArray2));
    }

    @Override
    public List<byte[]> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... entryArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xread(xReadParams, entryArray));
    }

    @Override
    public List<byte[]> xreadGroup(byte[] byArray, byte[] byArray2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... entryArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadGroup(byArray, byArray2, xReadGroupParams, entryArray));
    }

    @Override
    public byte[] xadd(byte[] byArray, XAddParams xAddParams, Map<byte[], byte[]> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(byArray, xAddParams, map));
    }

    @Override
    public long xlen(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xlen(byArray));
    }

    @Override
    public List<byte[]> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public List<byte[]> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3));
    }

    @Override
    public List<byte[]> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(byArray, byArray2, byArray3, n2));
    }

    @Override
    public long xack(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xack(byArray, byArray2, byArray3));
    }

    @Override
    public String xgroupCreate(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreate(byArray, byArray2, byArray3, bl));
    }

    @Override
    public String xgroupSetID(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupSetID(byArray, byArray2, byArray3));
    }

    @Override
    public long xgroupDestroy(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDestroy(byArray, byArray2));
    }

    @Override
    public boolean xgroupCreateConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreateConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public long xgroupDelConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDelConsumer(byArray, byArray2, byArray3));
    }

    @Override
    public long xdel(byte[] byArray, byte[] ... byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xdel(byArray, byArray2));
    }

    @Override
    public long xtrim(byte[] byArray, long l2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(byArray, l2, bl));
    }

    @Override
    public long xtrim(byte[] byArray, XTrimParams xTrimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(byArray, xTrimParams));
    }

    @Override
    @Deprecated
    public List<Object> xpending(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, byte[] byArray5) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(byArray, byArray2, byArray3, byArray4, n2, byArray5));
    }

    @Override
    public Object xpending(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(byArray, byArray2));
    }

    @Override
    public List<Object> xpending(byte[] byArray, byte[] byArray2, XPendingParams xPendingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(byArray, byArray2, xPendingParams));
    }

    @Override
    public List<byte[]> xclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaim(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public List<byte[]> xclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaimJustId(byArray, byArray2, byArray3, l2, xClaimParams, byArray4));
    }

    @Override
    public List<Object> xautoclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaim(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public List<Object> xautoclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaimJustId(byArray, byArray2, byArray3, l2, byArray4, xAutoClaimParams));
    }

    @Override
    public Object xinfoStream(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStream(byArray));
    }

    @Override
    public Object xinfoStreamFull(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(byArray));
    }

    @Override
    public Object xinfoStreamFull(byte[] byArray, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(byArray, n2));
    }

    @Override
    @Deprecated
    public List<Object> xinfoGroup(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoGroup(byArray));
    }

    @Override
    public List<Object> xinfoGroups(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoGroups(byArray));
    }

    @Override
    public List<Object> xinfoConsumers(byte[] byArray, byte[] byArray2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoConsumers(byArray, byArray2));
    }

    public Object sendCommand(ProtocolCommand protocolCommand, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(protocolCommand, byArray);
        return this.connection.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand protocolCommand, byte[] ... byArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(protocolCommand, byArray);
        this.connection.setTimeoutInfinite();
        try {
            Object object = this.connection.getOne();
            return object;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    public Object sendCommand(ProtocolCommand protocolCommand) {
        return this.sendCommand(protocolCommand, DUMMY_ARRAY);
    }

    @Override
    public boolean copy(String string, String string2, int n2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(string, string2, n2, bl));
    }

    @Override
    public boolean copy(String string, String string2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.copy(string, string2, bl));
    }

    @Override
    public String ping(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PING, string);
        return this.connection.getBulkReply();
    }

    @Override
    public String set(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(string, string2));
    }

    @Override
    public String set(String string, String string2, SetParams setParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.set(string, string2, setParams));
    }

    @Override
    public String get(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.get(string));
    }

    @Override
    public String setGet(String string, String string2, SetParams setParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setGet(string, string2, setParams));
    }

    @Override
    public String getDel(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getDel(string));
    }

    @Override
    public String getEx(String string, GetExParams getExParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getEx(string, getExParams));
    }

    @Override
    public long exists(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(stringArray));
    }

    @Override
    public boolean exists(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.exists(string));
    }

    @Override
    public long del(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(stringArray));
    }

    @Override
    public long del(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.del(string));
    }

    @Override
    public long unlink(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(stringArray));
    }

    @Override
    public long unlink(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.unlink(string));
    }

    @Override
    public String type(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.type(string));
    }

    @Override
    public Set<String> keys(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.keys(string));
    }

    @Override
    public String randomKey() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.randomKey());
    }

    @Override
    public String rename(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rename(string, string2));
    }

    @Override
    public long renamenx(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.renamenx(string, string2));
    }

    @Override
    public long expire(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(string, l2));
    }

    @Override
    public long expire(String string, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expire(string, l2, expiryOption));
    }

    @Override
    public long pexpire(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(string, l2));
    }

    @Override
    public long pexpire(String string, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpire(string, l2, expiryOption));
    }

    @Override
    public long expireTime(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireTime(string));
    }

    @Override
    public long pexpireTime(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireTime(string));
    }

    @Override
    public long expireAt(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(string, l2));
    }

    @Override
    public long expireAt(String string, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.expireAt(string, l2, expiryOption));
    }

    @Override
    public long pexpireAt(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(string, l2));
    }

    @Override
    public long pexpireAt(String string, long l2, ExpiryOption expiryOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pexpireAt(string, l2, expiryOption));
    }

    @Override
    public long ttl(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ttl(string));
    }

    @Override
    public long touch(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(stringArray));
    }

    @Override
    public long touch(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.touch(string));
    }

    @Override
    public long move(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MOVE, SafeEncoder.encode(string), Protocol.toByteArray(n2));
        return this.connection.getIntegerReply();
    }

    @Override
    public String getSet(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getSet(string, string2));
    }

    @Override
    public List<String> mget(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mget(stringArray));
    }

    @Override
    public long setnx(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setnx(string, string2));
    }

    @Override
    public String setex(String string, long l2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setex(string, l2, string2));
    }

    @Override
    public String mset(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.mset(stringArray));
    }

    @Override
    public long msetnx(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.msetnx(stringArray));
    }

    @Override
    public long decrBy(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decrBy(string, l2));
    }

    @Override
    public long decr(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.decr(string));
    }

    @Override
    public long incrBy(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrBy(string, l2));
    }

    @Override
    public double incrByFloat(String string, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incrByFloat(string, d2));
    }

    @Override
    public long incr(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.incr(string));
    }

    @Override
    public long append(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.append(string, string2));
    }

    @Override
    public String substr(String string, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.substr(string, n2, n3));
    }

    @Override
    public long hset(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(string, string2, string3));
    }

    @Override
    public long hset(String string, Map<String, String> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hset(string, map));
    }

    @Override
    public String hget(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hget(string, string2));
    }

    @Override
    public long hsetnx(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hsetnx(string, string2, string3));
    }

    @Override
    public String hmset(String string, Map<String, String> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmset(string, map));
    }

    @Override
    public List<String> hmget(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hmget(string, stringArray));
    }

    @Override
    public long hincrBy(String string, String string2, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrBy(string, string2, l2));
    }

    @Override
    public double hincrByFloat(String string, String string2, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hincrByFloat(string, string2, d2));
    }

    @Override
    public boolean hexists(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hexists(string, string2));
    }

    @Override
    public long hdel(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hdel(string, stringArray));
    }

    @Override
    public long hlen(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hlen(string));
    }

    @Override
    public Set<String> hkeys(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hkeys(string));
    }

    @Override
    public List<String> hvals(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hvals(string));
    }

    @Override
    public Map<String, String> hgetAll(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hgetAll(string));
    }

    @Override
    public String hrandfield(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(string));
    }

    @Override
    public List<String> hrandfield(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfield(string, l2));
    }

    @Override
    public Map<String, String> hrandfieldWithValues(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hrandfieldWithValues(string, l2));
    }

    @Override
    public long rpush(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpush(string, stringArray));
    }

    @Override
    public long lpush(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpush(string, stringArray));
    }

    @Override
    public long llen(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.llen(string));
    }

    @Override
    public List<String> lrange(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrange(string, l2, l3));
    }

    @Override
    public String ltrim(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.ltrim(string, l2, l3));
    }

    @Override
    public String lindex(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lindex(string, l2));
    }

    @Override
    public String lset(String string, long l2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lset(string, l2, string2));
    }

    @Override
    public long lrem(String string, long l2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lrem(string, l2, string2));
    }

    @Override
    public String lpop(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(string));
    }

    @Override
    public List<String> lpop(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpop(string, n2));
    }

    @Override
    public Long lpos(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(string, string2));
    }

    @Override
    public Long lpos(String string, String string2, LPosParams lPosParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(string, string2, lPosParams));
    }

    @Override
    public List<Long> lpos(String string, String string2, LPosParams lPosParams, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpos(string, string2, lPosParams, l2));
    }

    @Override
    public String rpop(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(string));
    }

    @Override
    public List<String> rpop(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpop(string, n2));
    }

    @Override
    public String rpoplpush(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpoplpush(string, string2));
    }

    @Override
    public long sadd(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sadd(string, stringArray));
    }

    @Override
    public Set<String> smembers(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smembers(string));
    }

    @Override
    public long srem(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srem(string, stringArray));
    }

    @Override
    public String spop(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(string));
    }

    @Override
    public Set<String> spop(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.spop(string, l2));
    }

    @Override
    public long smove(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smove(string, string2, string3));
    }

    @Override
    public long scard(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scard(string));
    }

    @Override
    public boolean sismember(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sismember(string, string2));
    }

    @Override
    public List<Boolean> smismember(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.smismember(string, stringArray));
    }

    @Override
    public Set<String> sinter(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinter(stringArray));
    }

    @Override
    public long sinterstore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sinterstore(string, stringArray));
    }

    @Override
    public long sintercard(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(stringArray));
    }

    @Override
    public long sintercard(int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sintercard(n2, stringArray));
    }

    @Override
    public Set<String> sunion(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunion(stringArray));
    }

    @Override
    public long sunionstore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sunionstore(string, stringArray));
    }

    @Override
    public Set<String> sdiff(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiff(stringArray));
    }

    @Override
    public long sdiffstore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sdiffstore(string, stringArray));
    }

    @Override
    public String srandmember(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(string));
    }

    @Override
    public List<String> srandmember(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.srandmember(string, n2));
    }

    @Override
    public long zadd(String string, double d2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(string, d2, string2));
    }

    @Override
    public long zadd(String string, double d2, String string2, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(string, d2, string2, zAddParams));
    }

    @Override
    public long zadd(String string, Map<String, Double> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(string, map));
    }

    @Override
    public long zadd(String string, Map<String, Double> map, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zadd(string, map, zAddParams));
    }

    @Override
    public Double zaddIncr(String string, double d2, String string2, ZAddParams zAddParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zaddIncr(string, d2, string2, zAddParams));
    }

    @Override
    public Set<String> zdiff(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiff(stringArray));
    }

    @Override
    public Set<Tuple> zdiffWithScores(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffWithScores(stringArray));
    }

    @Override
    public long zdiffStore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zdiffStore(string, stringArray));
    }

    @Override
    public List<String> zrange(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(string, l2, l3));
    }

    @Override
    public long zrem(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrem(string, stringArray));
    }

    @Override
    public double zincrby(String string, double d2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(string, d2, string2));
    }

    @Override
    public Double zincrby(String string, double d2, String string2, ZIncrByParams zIncrByParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zincrby(string, d2, string2, zIncrByParams));
    }

    @Override
    public Long zrank(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrank(string, string2));
    }

    @Override
    public Long zrevrank(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrank(string, string2));
    }

    @Override
    public List<String> zrevrange(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrange(string, l2, l3));
    }

    @Override
    public List<Tuple> zrangeWithScores(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(string, l2, l3));
    }

    @Override
    public List<Tuple> zrevrangeWithScores(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeWithScores(string, l2, l3));
    }

    @Override
    public List<String> zrange(String string, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrange(string, zRangeParams));
    }

    @Override
    public List<Tuple> zrangeWithScores(String string, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeWithScores(string, zRangeParams));
    }

    @Override
    public long zrangestore(String string, String string2, ZRangeParams zRangeParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangestore(string, string2, zRangeParams));
    }

    @Override
    public String zrandmember(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(string));
    }

    @Override
    public List<String> zrandmember(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmember(string, l2));
    }

    @Override
    public List<Tuple> zrandmemberWithScores(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrandmemberWithScores(string, l2));
    }

    @Override
    public long zcard(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcard(string));
    }

    @Override
    public Double zscore(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscore(string, string2));
    }

    @Override
    public List<Double> zmscore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmscore(string, stringArray));
    }

    @Override
    public Tuple zpopmax(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(string));
    }

    @Override
    public List<Tuple> zpopmax(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmax(string, n2));
    }

    @Override
    public Tuple zpopmin(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(string));
    }

    @Override
    public List<Tuple> zpopmin(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zpopmin(string, n2));
    }

    public String watch(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.WATCH, stringArray);
        String string = this.connection.getStatusCodeReply();
        this.isInWatch = true;
        return string;
    }

    @Override
    public List<String> sort(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(string));
    }

    @Override
    public List<String> sort(String string, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(string, sortingParams));
    }

    @Override
    public long sort(String string, SortingParams sortingParams, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(string, sortingParams, string2));
    }

    @Override
    public List<String> sortReadonly(String string, SortingParams sortingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sortReadonly(string, sortingParams));
    }

    @Override
    public long sort(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sort(string, string2));
    }

    @Override
    public String lmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmove(string, string2, listDirection, listDirection2));
    }

    @Override
    public String blmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmove(string, string2, listDirection, listDirection2, d2));
    }

    @Override
    public List<String> blpop(int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(n2, stringArray));
    }

    @Override
    public KeyedListElement blpop(double d2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(d2, stringArray));
    }

    @Override
    public List<String> brpop(int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(n2, stringArray));
    }

    @Override
    public KeyedListElement brpop(double d2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(d2, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection listDirection, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(listDirection, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> lmpop(ListDirection listDirection, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lmpop(listDirection, n2, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(long l2, ListDirection listDirection, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(l2, listDirection, stringArray));
    }

    @Override
    public KeyValue<String, List<String>> blmpop(long l2, ListDirection listDirection, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blmpop(l2, listDirection, n2, stringArray));
    }

    @Override
    public KeyedZSetElement bzpopmax(double d2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzpopmax(d2, stringArray));
    }

    @Override
    public KeyedZSetElement bzpopmin(double d2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzpopmin(d2, stringArray));
    }

    @Override
    public List<String> blpop(int n2, String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(n2, string));
    }

    @Override
    public KeyedListElement blpop(double d2, String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.blpop(d2, string));
    }

    @Override
    public List<String> brpop(int n2, String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(n2, string));
    }

    @Override
    public KeyedListElement brpop(double d2, String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpop(d2, string));
    }

    @Override
    public long zcount(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(string, d2, d3));
    }

    @Override
    public long zcount(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zcount(string, string2, string3));
    }

    @Override
    public List<String> zrangeByScore(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(string, d2, d3));
    }

    @Override
    public List<String> zrangeByScore(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(string, string2, string3));
    }

    @Override
    public List<String> zrangeByScore(String string, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public List<String> zrangeByScore(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(string, d2, d3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(string, string2, string3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(string, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, d2, d3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByScore(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScore(string, string2, string3, n2, n3));
    }

    @Override
    public List<Tuple> zrevrangeByScoreWithScores(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByScoreWithScores(string, string2, string3));
    }

    @Override
    public long zremrangeByRank(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByRank(string, l2, l3));
    }

    @Override
    public long zremrangeByScore(String string, double d2, double d3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(string, d2, d3));
    }

    @Override
    public long zremrangeByScore(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByScore(string, string2, string3));
    }

    @Override
    public Set<String> zunion(ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunion(zParams, stringArray));
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionWithScores(zParams, stringArray));
    }

    @Override
    public long zunionstore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(string, stringArray));
    }

    @Override
    public long zunionstore(String string, ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zunionstore(string, zParams, stringArray));
    }

    @Override
    public Set<String> zinter(ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinter(zParams, stringArray));
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterWithScores(zParams, stringArray));
    }

    @Override
    public long zintercard(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(stringArray));
    }

    @Override
    public long zintercard(long l2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zintercard(l2, stringArray));
    }

    @Override
    public long zinterstore(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(string, stringArray));
    }

    @Override
    public long zinterstore(String string, ZParams zParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zinterstore(string, zParams, stringArray));
    }

    @Override
    public long zlexcount(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zlexcount(string, string2, string3));
    }

    @Override
    public List<String> zrangeByLex(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(string, string2, string3));
    }

    @Override
    public List<String> zrangeByLex(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public List<String> zrevrangeByLex(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(string, string2, string3));
    }

    @Override
    public List<String> zrevrangeByLex(String string, String string2, String string3, int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zrevrangeByLex(string, string2, string3, n2, n3));
    }

    @Override
    public long zremrangeByLex(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zremrangeByLex(string, string2, string3));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption sortedSetOption, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(sortedSetOption, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> zmpop(SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zmpop(sortedSetOption, n2, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, stringArray));
    }

    @Override
    public KeyValue<String, List<Tuple>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bzmpop(l2, sortedSetOption, n2, stringArray));
    }

    @Override
    public long strlen(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strlen(string));
    }

    @Override
    @Deprecated
    public LCSMatchResult strAlgoLCSKeys(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strAlgoLCSKeys(string, string2, strAlgoLCSParams));
    }

    @Deprecated
    public LCSMatchResult strAlgoLCSStrings(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.strAlgoLCSStrings(string, string2, strAlgoLCSParams));
    }

    @Override
    public LCSMatchResult lcs(String string, String string2, LCSParams lCSParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lcs(string, string2, lCSParams));
    }

    @Override
    public long lpushx(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.lpushx(string, stringArray));
    }

    @Override
    public long persist(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.persist(string));
    }

    @Override
    public long rpushx(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.rpushx(string, stringArray));
    }

    @Override
    public String echo(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ECHO, string);
        return this.connection.getBulkReply();
    }

    @Override
    public long linsert(String string, ListPosition listPosition, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.linsert(string, listPosition, string2, string3));
    }

    @Override
    public String brpoplpush(String string, String string2, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.brpoplpush(string, string2, n2));
    }

    @Override
    public boolean setbit(String string, long l2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setbit(string, l2, bl));
    }

    @Override
    public boolean getbit(String string, long l2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getbit(string, l2));
    }

    @Override
    public long setrange(String string, long l2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.setrange(string, l2, string2));
    }

    @Override
    public String getrange(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.getrange(string, l2, l3));
    }

    @Override
    public long bitpos(String string, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(string, bl));
    }

    @Override
    public long bitpos(String string, boolean bl, BitPosParams bitPosParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitpos(string, bl, bitPosParams));
    }

    @Override
    public List<Object> role() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ROLE);
        return BuilderFactory.ENCODED_OBJECT_LIST.build(this.connection.getOne());
    }

    @Override
    public List<String> configGet(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.GET.name(), string);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public List<String> configGet(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.GET.name(), stringArray));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String configSet(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Protocol.Keyword.SET.name(), string, string2);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String configSet(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CONFIG, Jedis.joinParameters(Protocol.Keyword.SET.name(), stringArray));
        return this.connection.getStatusCodeReply();
    }

    public long publish(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBLISH, string, string2);
        return this.connection.getIntegerReply();
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... stringArray) {
        jedisPubSub.proceed(this.connection, stringArray);
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... stringArray) {
        jedisPubSub.proceedWithPatterns(this.connection, stringArray);
    }

    public List<String> pubsubChannels() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.CHANNELS);
        return this.connection.getMultiBulkReply();
    }

    public List<String> pubsubChannels(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.CHANNELS.name(), string);
        return this.connection.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Protocol.Keyword.NUMPAT);
        return this.connection.getIntegerReply();
    }

    public Map<String, Long> pubsubNumSub(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.PUBSUB, Jedis.joinParameters(Protocol.Keyword.NUMSUB.name(), stringArray));
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.connection.getOne());
    }

    @Override
    public Object eval(String string, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(string, n2, stringArray));
    }

    @Override
    public Object eval(String string, List<String> list, List<String> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(string, list, list2));
    }

    @Override
    public Object evalReadonly(String string, List<String> list, List<String> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalReadonly(string, list, list2));
    }

    @Override
    public Object eval(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.eval(string));
    }

    @Override
    public Object evalsha(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(string));
    }

    @Override
    public Object evalsha(String string, List<String> list, List<String> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(string, list, list2));
    }

    @Override
    public Object evalshaReadonly(String string, List<String> list, List<String> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalshaReadonly(string, list, list2));
    }

    @Override
    public Object evalsha(String string, int n2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.evalsha(string, n2, stringArray));
    }

    @Override
    public Boolean scriptExists(String string) {
        String[] stringArray = new String[]{string};
        return this.scriptExists(stringArray).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... stringArray) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Jedis.joinParameters(Protocol.Keyword.EXISTS.name(), stringArray));
        return BuilderFactory.BOOLEAN_LIST.build(this.connection.getOne());
    }

    @Override
    public String scriptLoad(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SCRIPT, Protocol.Keyword.LOAD.name(), string);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET);
        return Slowlog.from(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long l2) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SLOWLOG, Protocol.Keyword.GET.getRaw(), Protocol.toByteArray(l2));
        return Slowlog.from(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public String objectEncoding(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.ENCODING.name(), string);
        return this.connection.getBulkReply();
    }

    @Override
    public Long objectIdletime(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public List<String> objectHelp() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.HELP);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public Long objectFreq(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.OBJECT, Protocol.Keyword.FREQ.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public long bitcount(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(string));
    }

    @Override
    public long bitcount(String string, long l2, long l3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(string, l2, l3));
    }

    @Override
    public long bitcount(String string, long l2, long l3, BitCountOption bitCountOption) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitcount(string, l2, l3, bitCountOption));
    }

    @Override
    public long bitop(BitOP bitOP, String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitop(bitOP, string, stringArray));
    }

    public long commandCount() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Protocol.Keyword.COUNT);
        return this.connection.getIntegerReply();
    }

    public Map<String, CommandDocument> commandDocs(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.DOCS.name(), stringArray));
        return BuilderFactory.COMMAND_DOCS_RESPONSE.build(this.connection.getOne());
    }

    public List<String> commandGetKeys(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.GETKEYS.name(), stringArray));
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    public List<KeyValue<String, List<String>>> commandGetKeysAndFlags(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.GETKEYSANDFLAGS.name(), stringArray));
        return BuilderFactory.KEYED_STRING_LIST_LIST.build(this.connection.getOne());
    }

    public Map<String, CommandInfo> commandInfo(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Jedis.joinParameters(Protocol.Keyword.INFO.name(), stringArray));
        return BuilderFactory.COMMAND_INFO_RESPONSE.build(this.connection.getOne());
    }

    public List<String> commandList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.COMMAND, Protocol.Keyword.LIST);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    public List<String> commandListFilterBy(CommandListFilterByParams commandListFilterByParams) {
        this.checkIsInMultiOrPipeline();
        CommandArguments commandArguments = new CommandArguments(Protocol.Command.COMMAND).add(Protocol.Keyword.LIST).addParams(commandListFilterByParams);
        this.connection.sendCommand(commandArguments);
        return BuilderFactory.STRING_LIST.build(this.connection.getOne());
    }

    @Override
    public String sentinelMyId() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MYID);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTERS);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> sentinelMaster(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.MASTER.name(), string);
        return BuilderFactory.STRING_MAP.build(this.connection.getOne());
    }

    @Override
    public List<Map<String, String>> sentinelSentinels(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SENTINELS.name(), string);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.GET_MASTER_ADDR_BY_NAME.getRaw(), SafeEncoder.encode(string));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public Long sentinelReset(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.RESET.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    @Deprecated
    public List<Map<String, String>> sentinelSlaves(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.SLAVES.name(), string);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<Map<String, String>> sentinelReplicas(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REPLICAS.name(), string);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String sentinelFailover(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.FAILOVER.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String string, String string2, int n2, int n3) {
        CommandArguments commandArguments = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.MONITOR).add(string).add(string2).add(n2).add(n3);
        this.connection.sendCommand(commandArguments);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String string) {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.SENTINEL, Protocol.SentinelKeyword.REMOVE.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String string, Map<String, String> map) {
        CommandArguments commandArguments = new CommandArguments(Protocol.Command.SENTINEL).add(Protocol.SentinelKeyword.SET).add(string);
        map.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        this.connection.sendCommand(commandArguments);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public byte[] dump(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.dump(string));
    }

    @Override
    public String restore(String string, long l2, byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(string, l2, byArray));
    }

    @Override
    public String restore(String string, long l2, byte[] byArray, RestoreParams restoreParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.restore(string, l2, byArray, restoreParams));
    }

    @Override
    public long pttl(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pttl(string));
    }

    @Override
    public String psetex(String string, long l2, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.psetex(string, l2, string2));
    }

    @Override
    public String aclSetUser(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SETUSER.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.SETUSER.name(), string, stringArray));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long aclDelUser(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.DELUSER.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public long aclDelUser(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Jedis.joinParameters(Protocol.Keyword.DELUSER.name(), string, stringArray));
        return this.connection.getIntegerReply();
    }

    @Override
    public AccessControlUser aclGetUser(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GETUSER.name(), string);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclUsers() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.USERS);
        return BuilderFactory.STRING_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LIST);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String aclWhoAmI() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.WHOAMI);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<String> aclCat() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT);
        return BuilderFactory.STRING_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclCat(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.CAT.name(), string);
        return BuilderFactory.STRING_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<AccessControlLogEntry> aclLog() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG);
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<AccessControlLogEntry> aclLog(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOG.getRaw(), Protocol.toByteArray(n2));
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public String aclLoad() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.LOAD);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclSave() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.SAVE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String aclGenPass() {
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS);
        return this.connection.getBulkReply();
    }

    @Override
    public String aclGenPass(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, Protocol.Keyword.GENPASS.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getBulkReply();
    }

    @Override
    public String aclDryRun(String string, String string2, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        String[] stringArray2 = new String[3 + stringArray.length];
        stringArray2[0] = Protocol.Keyword.DRYRUN.name();
        stringArray2[1] = string;
        stringArray2[2] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 3, stringArray.length);
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, stringArray2);
        return this.connection.getBulkReply();
    }

    @Override
    public String aclDryRun(String string, CommandArguments commandArguments) {
        this.checkIsInMultiOrPipeline();
        CommandArguments commandArguments2 = new CommandArguments(Protocol.Command.ACL).add(Protocol.Keyword.DRYRUN).add(string);
        Iterator<Rawable> iterator = commandArguments.iterator();
        while (iterator.hasNext()) {
            commandArguments2.add(iterator.next());
        }
        this.connection.sendCommand(commandArguments2);
        return this.connection.getBulkReply();
    }

    @Override
    public byte[] aclDryRunBinary(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        this.checkIsInMultiOrPipeline();
        byte[][] byArrayArray = new byte[3 + byArray3.length][];
        byArrayArray[0] = Protocol.Keyword.DRYRUN.getRaw();
        byArrayArray[1] = byArray;
        byArrayArray[2] = byArray2;
        System.arraycopy(byArray3, 0, byArrayArray, 3, byArray3.length);
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.ACL, byArrayArray);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public byte[] aclDryRunBinary(byte[] byArray, CommandArguments commandArguments) {
        this.checkIsInMultiOrPipeline();
        CommandArguments commandArguments2 = new CommandArguments(Protocol.Command.ACL).add(Protocol.Keyword.DRYRUN).add(byArray);
        Iterator<Rawable> iterator = commandArguments.iterator();
        while (iterator.hasNext()) {
            commandArguments2.add(iterator.next());
        }
        this.connection.sendCommand(commandArguments2);
        return this.connection.getBinaryBulkReply();
    }

    @Override
    public String clientKill(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.KILL.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clientGetname() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.GETNAME);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList(ClientType clientType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.LIST.getRaw(), Protocol.Keyword.TYPE.getRaw(), clientType.getRaw());
        return this.connection.getBulkReply();
    }

    @Override
    public String clientList(long ... lArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, this.clientListParams(lArray));
        return this.connection.getBulkReply();
    }

    @Override
    public String clientInfo() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.INFO);
        return this.connection.getBulkReply();
    }

    @Override
    public String clientSetname(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String migrate(String string, int n2, String string2, int n3, int n4) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, string2, n3, n4));
    }

    @Override
    public String migrate(String string, int n2, int n3, int n4, MigrateParams migrateParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, n3, n4, migrateParams, stringArray));
    }

    @Override
    public String migrate(String string, int n2, String string2, int n3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, string2, n3));
    }

    @Override
    public String migrate(String string, int n2, int n3, MigrateParams migrateParams, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.migrate(string, n2, n3, migrateParams, stringArray));
    }

    @Override
    public ScanResult<String> scan(String string) {
        return this.connection.executeCommand(this.commandObjects.scan(string));
    }

    @Override
    public ScanResult<String> scan(String string, ScanParams scanParams) {
        return this.connection.executeCommand(this.commandObjects.scan(string, scanParams));
    }

    @Override
    public ScanResult<String> scan(String string, ScanParams scanParams, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.scan(string, scanParams, string2));
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String string, String string2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hscan(string, string2, scanParams));
    }

    @Override
    public ScanResult<String> sscan(String string, String string2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.sscan(string, string2, scanParams));
    }

    @Override
    public ScanResult<Tuple> zscan(String string, String string2, ScanParams scanParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.zscan(string, string2, scanParams));
    }

    @Override
    public String readonly() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.READONLY);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String readwrite() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.READWRITE);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.NODES);
        return this.connection.getBulkReply();
    }

    @Override
    public String clusterMeet(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.MEET.name(), string, Integer.toString(n2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterReset() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.RESET);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterReset(ClusterResetType clusterResetType) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.RESET.getRaw(), clusterResetType.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... nArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.ADDSLOTS.getRaw(), Jedis.joinParameters(nArray)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... nArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.DELSLOTS.getRaw(), Jedis.joinParameters(nArray)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.INFO);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.GETKEYSINSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.toByteArray(n3));
        return this.connection.getMultiBulkReply();
    }

    @Override
    public List<byte[]> clusterGetKeysInSlotBinary(int n2, int n3) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.GETKEYSINSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.toByteArray(n3));
        return this.connection.getBinaryMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int n2, String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.ClusterKeyword.NODE.getRaw(), SafeEncoder.encode(string));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int n2, String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.ClusterKeyword.MIGRATING.getRaw(), SafeEncoder.encode(string));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int n2, String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.ClusterKeyword.IMPORTING.getRaw(), SafeEncoder.encode(string));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SETSLOT.getRaw(), Protocol.toByteArray(n2), Protocol.ClusterKeyword.STABLE.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FORGET.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FLUSHSLOTS);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long clusterKeySlot(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.KEYSLOT.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clusterCountFailureReports(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "COUNT-FAILURE-REPORTS", string);
        return this.connection.getIntegerReply();
    }

    @Override
    public long clusterCountKeysInSlot(int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.COUNTKEYSINSLOT.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SAVECONFIG);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterSetConfigEpoch(long l2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "SET-CONFIG-EPOCH", Long.toString(l2));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterBumpEpoch() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.BUMPEPOCH);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterReplicate(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.REPLICATE.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    @Deprecated
    public List<String> clusterSlaves(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SLAVES.name(), string);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public List<String> clusterReplicas(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.REPLICAS.name(), string);
        return this.connection.getMultiBulkReply();
    }

    @Override
    public String clusterFailover() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FAILOVER);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterFailover(ClusterFailoverOption clusterFailoverOption) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.FAILOVER.getRaw(), clusterFailoverOption.getRaw());
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<Object> clusterSlots() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.SLOTS);
        return this.connection.getObjectMultiBulkReply();
    }

    @Override
    public String clusterMyId() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.MYID);
        return this.connection.getBulkReply();
    }

    @Override
    public List<Map<String, Object>> clusterLinks() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Protocol.ClusterKeyword.LINKS);
        return this.connection.getObjectMultiBulkReply().stream().map(BuilderFactory.ENCODED_OBJECT_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String clusterAddSlotsRange(int ... nArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.ADDSLOTSRANGE.getRaw(), Jedis.joinParameters(nArray)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlotsRange(int ... nArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, Jedis.joinParameters(Protocol.ClusterKeyword.DELSLOTSRANGE.getRaw(), Jedis.joinParameters(nArray)));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String asking() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.ASKING);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public long pfadd(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfadd(string, stringArray));
    }

    @Override
    public long pfcount(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(string));
    }

    @Override
    public long pfcount(String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfcount(stringArray));
    }

    @Override
    public String pfmerge(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.pfmerge(string, stringArray));
    }

    @Override
    public Object fcall(String string, List<String> list, List<String> list2) {
        return this.connection.executeCommand(this.commandObjects.fcall(string, list, list2));
    }

    @Override
    public Object fcallReadonly(String string, List<String> list, List<String> list2) {
        return this.connection.executeCommand(this.commandObjects.fcallReadonly(string, list, list2));
    }

    @Override
    public String functionDelete(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDelete(string));
    }

    @Override
    public String functionLoad(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoad(string));
    }

    @Override
    public String functionLoadReplace(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoadReplace(string));
    }

    @Override
    public FunctionStats functionStats() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionStats());
    }

    @Override
    public String functionFlush() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionFlush());
    }

    @Override
    public String functionFlush(FlushMode flushMode) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionFlush(flushMode));
    }

    @Override
    public String functionKill() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionKill());
    }

    @Override
    public List<LibraryInfo> functionList() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList());
    }

    @Override
    public List<LibraryInfo> functionList(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList(string));
    }

    @Override
    public List<LibraryInfo> functionListWithCode() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode());
    }

    @Override
    public List<LibraryInfo> functionListWithCode(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode(string));
    }

    @Override
    public long geoadd(String string, double d2, double d3, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(string, d2, d3, string2));
    }

    @Override
    public long geoadd(String string, Map<String, GeoCoordinate> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(string, map));
    }

    @Override
    public long geoadd(String string, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geoadd(string, geoAddParams, map));
    }

    @Override
    public Double geodist(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(string, string2, string3));
    }

    @Override
    public Double geodist(String string, String string2, String string3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geodist(string, string2, string3, geoUnit));
    }

    @Override
    public List<String> geohash(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geohash(string, stringArray));
    }

    @Override
    public List<GeoCoordinate> geopos(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geopos(string, stringArray));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadius(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusStore(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusStore(string, d2, d3, d4, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusReadonly(string, d2, d3, d4, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMember(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public long georadiusByMemberStore(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberStore(string, string2, d2, geoUnit, geoRadiusParam, geoRadiusStoreParam));
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.georadiusByMemberReadonly(string, string2, d2, geoUnit, geoRadiusParam));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, String string2, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(string, string2, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, String string2, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(string, string2, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(string, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public List<GeoRadiusResponse> geosearch(String string, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearch(string, geoSearchParam));
    }

    @Override
    public long geosearchStore(String string, String string2, String string3, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, String string3, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(string, string2, string3, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(string, string2, geoCoordinate, d2, d3, geoUnit));
    }

    @Override
    public long geosearchStore(String string, String string2, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStore(string, string2, geoSearchParam));
    }

    @Override
    public long geosearchStoreStoreDist(String string, String string2, GeoSearchParam geoSearchParam) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.geosearchStoreStoreDist(string, string2, geoSearchParam));
    }

    @Override
    public String moduleLoad(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LOAD.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String moduleLoad(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Jedis.joinParameters(Protocol.Keyword.LOAD.name(), string, stringArray));
        return this.connection.getStatusCodeReply();
    }

    @Override
    public String moduleUnload(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.UNLOAD.name(), string);
        return this.connection.getStatusCodeReply();
    }

    @Override
    public List<Module> moduleList() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MODULE, Protocol.Keyword.LIST);
        return BuilderFactory.MODULE_LIST.build(this.connection.getObjectMultiBulkReply());
    }

    @Override
    public List<Long> bitfield(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfield(string, stringArray));
    }

    @Override
    public List<Long> bitfieldReadonly(String string, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.bitfieldReadonly(string, stringArray));
    }

    @Override
    public long hstrlen(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.hstrlen(string, string2));
    }

    @Override
    public String memoryDoctor() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.DOCTOR);
        return this.connection.getBulkReply();
    }

    @Override
    public Long memoryUsage(String string) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.name(), string);
        return this.connection.getIntegerReply();
    }

    @Override
    public Long memoryUsage(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.USAGE.getRaw(), SafeEncoder.encode(string), Protocol.Keyword.SAMPLES.getRaw(), Protocol.toByteArray(n2));
        return this.connection.getIntegerReply();
    }

    @Override
    public String memoryPurge() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.PURGE);
        return this.connection.getBulkReply();
    }

    @Override
    public Map<String, Object> memoryStats() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand((ProtocolCommand)Protocol.Command.MEMORY, Protocol.Keyword.STATS);
        return BuilderFactory.ENCODED_OBJECT_MAP.build(this.connection.getOne());
    }

    @Override
    public String lolwut() {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(Protocol.Command.LOLWUT);
        return this.connection.getBulkReply();
    }

    @Override
    public String lolwut(LolwutParams lolwutParams) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(new CommandArguments(Protocol.Command.LOLWUT).addParams(lolwutParams));
        return this.connection.getBulkReply();
    }

    @Override
    public StreamEntryID xadd(String string, StreamEntryID streamEntryID, Map<String, String> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(string, streamEntryID, map));
    }

    @Override
    public StreamEntryID xadd(String string, XAddParams xAddParams, Map<String, String> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xadd(string, xAddParams, map));
    }

    @Override
    public long xlen(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xlen(string));
    }

    @Override
    public List<StreamEntry> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2));
    }

    @Override
    public List<StreamEntry> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(string, streamEntryID, streamEntryID2, n2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(string, streamEntryID, streamEntryID2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(string, streamEntryID, streamEntryID2, n2));
    }

    @Override
    public List<StreamEntry> xrange(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(string, string2, string3));
    }

    @Override
    public List<StreamEntry> xrange(String string, String string2, String string3, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrange(string, string2, string3, n2));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(string, string2, string3));
    }

    @Override
    public List<StreamEntry> xrevrange(String string, String string2, String string3, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xrevrange(string, string2, string3, n2));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xread(xReadParams, map));
    }

    @Override
    public long xack(String string, String string2, StreamEntryID ... streamEntryIDArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xack(string, string2, streamEntryIDArray));
    }

    @Override
    public String xgroupCreate(String string, String string2, StreamEntryID streamEntryID, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreate(string, string2, streamEntryID, bl));
    }

    @Override
    public String xgroupSetID(String string, String string2, StreamEntryID streamEntryID) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupSetID(string, string2, streamEntryID));
    }

    @Override
    public long xgroupDestroy(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDestroy(string, string2));
    }

    @Override
    public boolean xgroupCreateConsumer(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupCreateConsumer(string, string2, string3));
    }

    @Override
    public long xgroupDelConsumer(String string, String string2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xgroupDelConsumer(string, string2, string3));
    }

    @Override
    public long xdel(String string, StreamEntryID ... streamEntryIDArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xdel(string, streamEntryIDArray));
    }

    @Override
    public long xtrim(String string, long l2, boolean bl) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(string, l2, bl));
    }

    @Override
    public long xtrim(String string, XTrimParams xTrimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xtrim(string, xTrimParams));
    }

    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String string, String string2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> map) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xreadGroup(string, string2, xReadGroupParams, map));
    }

    @Override
    public StreamPendingSummary xpending(String string, String string2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(string, string2));
    }

    @Override
    @Deprecated
    public List<StreamPendingEntry> xpending(String string, String string2, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2, String string3) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(string, string2, streamEntryID, streamEntryID2, n2, string3));
    }

    @Override
    public List<StreamPendingEntry> xpending(String string, String string2, XPendingParams xPendingParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xpending(string, string2, xPendingParams));
    }

    @Override
    public List<StreamEntry> xclaim(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaim(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public List<StreamEntryID> xclaimJustId(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xclaimJustId(string, string2, string3, l2, xClaimParams, streamEntryIDArray));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaim(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xautoclaimJustId(string, string2, string3, l2, streamEntryID, xAutoClaimParams));
    }

    @Override
    public StreamInfo xinfoStream(String string) {
        return this.connection.executeCommand(this.commandObjects.xinfoStream(string));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String string) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(string));
    }

    @Override
    public StreamFullInfo xinfoStreamFull(String string, int n2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.xinfoStreamFull(string, n2));
    }

    @Override
    @Deprecated
    public List<StreamGroupInfo> xinfoGroup(String string) {
        return this.connection.executeCommand(this.commandObjects.xinfoGroup(string));
    }

    @Override
    public List<StreamGroupInfo> xinfoGroups(String string) {
        return this.connection.executeCommand(this.commandObjects.xinfoGroups(string));
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(String string, String string2) {
        return this.connection.executeCommand(this.commandObjects.xinfoConsumers(string, string2));
    }

    @Override
    public Object fcall(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.fcall(byArray, list, list2));
    }

    @Override
    public Object fcallReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.fcallReadonly(byArray, list, list2));
    }

    @Override
    public String functionDelete(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDelete(byArray));
    }

    @Override
    public byte[] functionDump() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionDump());
    }

    @Override
    public List<Object> functionListBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListBinary());
    }

    @Override
    public List<Object> functionList(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionList(byArray));
    }

    @Override
    public List<Object> functionListWithCodeBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCodeBinary());
    }

    @Override
    public List<Object> functionListWithCode(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionListWithCode(byArray));
    }

    @Override
    public String functionLoad(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoad(byArray));
    }

    @Override
    public String functionLoadReplace(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionLoadReplace(byArray));
    }

    @Override
    public String functionRestore(byte[] byArray) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionRestore(byArray));
    }

    @Override
    public String functionRestore(byte[] byArray, FunctionRestorePolicy functionRestorePolicy) {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionRestore(byArray, functionRestorePolicy));
    }

    @Override
    public Object functionStatsBinary() {
        this.checkIsInMultiOrPipeline();
        return this.connection.executeCommand(this.commandObjects.functionStatsBinary());
    }

    public Object sendCommand(ProtocolCommand protocolCommand, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(protocolCommand, stringArray);
        return this.connection.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand protocolCommand, String ... stringArray) {
        this.checkIsInMultiOrPipeline();
        this.connection.sendCommand(protocolCommand, stringArray);
        this.connection.setTimeoutInfinite();
        try {
            Object object = this.connection.getOne();
            return object;
        }
        finally {
            this.connection.rollbackTimeout();
        }
    }

    private static byte[][] joinParameters(int ... nArray) {
        byte[][] byArrayArray = new byte[nArray.length][];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byArrayArray[i2] = Protocol.toByteArray(nArray[i2]);
        }
        return byArrayArray;
    }

    private static byte[][] joinParameters(byte[] byArray, byte[][] byArray2) {
        byte[][] byArrayArray = new byte[byArray2.length + 1][];
        byArrayArray[0] = byArray;
        System.arraycopy(byArray2, 0, byArrayArray, 1, byArray2.length);
        return byArrayArray;
    }

    private static byte[][] joinParameters(byte[] byArray, byte[] byArray2, byte[][] byArray3) {
        byte[][] byArrayArray = new byte[byArray3.length + 2][];
        byArrayArray[0] = byArray;
        byArrayArray[1] = byArray2;
        System.arraycopy(byArray3, 0, byArrayArray, 2, byArray3.length);
        return byArrayArray;
    }

    private static String[] joinParameters(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    private static String[] joinParameters(String string, String string2, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        return stringArray2;
    }
}

