/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.HostAndPortMapper;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;

public class DefaultJedisSocketFactory
implements JedisSocketFactory {
    protected static final HostAndPort DEFAULT_HOST_AND_PORT = new HostAndPort("127.0.0.1", 6379);
    private volatile HostAndPort hostAndPort = DEFAULT_HOST_AND_PORT;
    private int connectionTimeout = 2000;
    private int socketTimeout = 2000;
    private boolean ssl = false;
    private SSLSocketFactory sslSocketFactory = null;
    private SSLParameters sslParameters = null;
    private HostnameVerifier hostnameVerifier = null;
    private HostAndPortMapper hostAndPortMapper = null;

    public DefaultJedisSocketFactory() {
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort) {
        this(hostAndPort, null);
    }

    public DefaultJedisSocketFactory(JedisClientConfig jedisClientConfig) {
        this(null, jedisClientConfig);
    }

    public DefaultJedisSocketFactory(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        if (hostAndPort != null) {
            this.hostAndPort = hostAndPort;
        }
        if (jedisClientConfig != null) {
            this.connectionTimeout = jedisClientConfig.getConnectionTimeoutMillis();
            this.socketTimeout = jedisClientConfig.getSocketTimeoutMillis();
            this.ssl = jedisClientConfig.isSsl();
            this.sslSocketFactory = jedisClientConfig.getSslSocketFactory();
            this.sslParameters = jedisClientConfig.getSslParameters();
            this.hostnameVerifier = jedisClientConfig.getHostnameVerifier();
            this.hostAndPortMapper = jedisClientConfig.getHostAndPortMapper();
        }
    }

    private Socket connectToFirstSuccessfulHost(HostAndPort hostAndPort) {
        List<InetAddress> list = Arrays.asList(InetAddress.getAllByName(hostAndPort.getHost()));
        if (list.size() > 1) {
            Collections.shuffle(list);
        }
        JedisConnectionException jedisConnectionException = new JedisConnectionException("Failed to connect to any host resolved for DNS name.");
        for (InetAddress inetAddress : list) {
            try {
                Socket socket = new Socket();
                socket.setReuseAddress(true);
                socket.setKeepAlive(true);
                socket.setTcpNoDelay(true);
                socket.setSoLinger(true, 0);
                socket.connect(new InetSocketAddress(inetAddress.getHostAddress(), hostAndPort.getPort()), this.connectionTimeout);
                return socket;
            }
            catch (Exception exception) {
                jedisConnectionException.addSuppressed(exception);
            }
        }
        throw jedisConnectionException;
    }

    @Override
    public Socket createSocket() {
        Socket socket = null;
        try {
            HostAndPort hostAndPort = this.getSocketHostAndPort();
            socket = this.connectToFirstSuccessfulHost(hostAndPort);
            socket.setSoTimeout(this.socketTimeout);
            if (this.ssl) {
                SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
                if (null == sSLSocketFactory) {
                    sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                }
                socket = sSLSocketFactory.createSocket(socket, hostAndPort.getHost(), hostAndPort.getPort(), true);
                if (null != this.sslParameters) {
                    ((SSLSocket)socket).setSSLParameters(this.sslParameters);
                }
                if (null != this.hostnameVerifier && !this.hostnameVerifier.verify(hostAndPort.getHost(), ((SSLSocket)socket).getSession())) {
                    String string = String.format("The connection to '%s' failed ssl/tls hostname verification.", hostAndPort.getHost());
                    throw new JedisConnectionException(string);
                }
            }
            return socket;
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(socket);
            if (exception instanceof JedisConnectionException) {
                throw (JedisConnectionException)exception;
            }
            throw new JedisConnectionException("Failed to create socket.", exception);
        }
    }

    public void updateHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    protected HostAndPort getSocketHostAndPort() {
        HostAndPort hostAndPort;
        HostAndPortMapper hostAndPortMapper = this.hostAndPortMapper;
        HostAndPort hostAndPort2 = this.hostAndPort;
        if (hostAndPortMapper != null && (hostAndPort = hostAndPortMapper.getHostAndPort(hostAndPort2)) != null) {
            return hostAndPort;
        }
        return hostAndPort2;
    }

    public String toString() {
        return "DefaultJedisSocketFactory{" + this.hostAndPort.toString() + "}";
    }
}

