/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import me.ulrich.clans.library.redis.jedis.HostAndPortMapper;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;

public final class DefaultJedisClientConfig
implements JedisClientConfig {
    private final int connectionTimeoutMillis;
    private final int socketTimeoutMillis;
    private final int blockingSocketTimeoutMillis;
    private final String user;
    private volatile String password;
    private final int database;
    private final String clientName;
    private final boolean ssl;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLParameters sslParameters;
    private final HostnameVerifier hostnameVerifier;
    private final HostAndPortMapper hostAndPortMapper;

    private DefaultJedisClientConfig(int n2, int n3, int n4, String string, String string2, int n5, String string3, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMapper) {
        this.connectionTimeoutMillis = n2;
        this.socketTimeoutMillis = n3;
        this.blockingSocketTimeoutMillis = n4;
        this.user = string;
        this.password = string2;
        this.database = n5;
        this.clientName = string3;
        this.ssl = bl;
        this.sslSocketFactory = sSLSocketFactory;
        this.sslParameters = sSLParameters;
        this.hostnameVerifier = hostnameVerifier;
        this.hostAndPortMapper = hostAndPortMapper;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    @Override
    public int getBlockingSocketTimeoutMillis() {
        return this.blockingSocketTimeoutMillis;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public synchronized void updatePassword(String string) {
        if (!Objects.equals(this.password, string)) {
            this.password = string;
        }
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public HostAndPortMapper getHostAndPortMapper() {
        return this.hostAndPortMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultJedisClientConfig create(int n2, int n3, int n4, String string, String string2, int n5, String string3, boolean bl, SSLSocketFactory sSLSocketFactory, SSLParameters sSLParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMapper) {
        return new DefaultJedisClientConfig(n2, n3, n4, string, string2, n5, string3, bl, sSLSocketFactory, sSLParameters, hostnameVerifier, hostAndPortMapper);
    }

    public static DefaultJedisClientConfig copyConfig(JedisClientConfig jedisClientConfig) {
        return new DefaultJedisClientConfig(jedisClientConfig.getConnectionTimeoutMillis(), jedisClientConfig.getSocketTimeoutMillis(), jedisClientConfig.getBlockingSocketTimeoutMillis(), jedisClientConfig.getUser(), jedisClientConfig.getPassword(), jedisClientConfig.getDatabase(), jedisClientConfig.getClientName(), jedisClientConfig.isSsl(), jedisClientConfig.getSslSocketFactory(), jedisClientConfig.getSslParameters(), jedisClientConfig.getHostnameVerifier(), jedisClientConfig.getHostAndPortMapper());
    }

    public static class Builder {
        private int connectionTimeoutMillis = 2000;
        private int socketTimeoutMillis = 2000;
        private int blockingSocketTimeoutMillis = 0;
        private String user = null;
        private String password = null;
        private int database = 0;
        private String clientName = null;
        private boolean ssl = false;
        private SSLSocketFactory sslSocketFactory = null;
        private SSLParameters sslParameters = null;
        private HostnameVerifier hostnameVerifier = null;
        private HostAndPortMapper hostAndPortMapper = null;

        private Builder() {
        }

        public DefaultJedisClientConfig build() {
            return new DefaultJedisClientConfig(this.connectionTimeoutMillis, this.socketTimeoutMillis, this.blockingSocketTimeoutMillis, this.user, this.password, this.database, this.clientName, this.ssl, this.sslSocketFactory, this.sslParameters, this.hostnameVerifier, this.hostAndPortMapper);
        }

        public Builder timeoutMillis(int n2) {
            this.connectionTimeoutMillis = n2;
            this.socketTimeoutMillis = n2;
            return this;
        }

        public Builder connectionTimeoutMillis(int n2) {
            this.connectionTimeoutMillis = n2;
            return this;
        }

        public Builder socketTimeoutMillis(int n2) {
            this.socketTimeoutMillis = n2;
            return this;
        }

        public Builder blockingSocketTimeoutMillis(int n2) {
            this.blockingSocketTimeoutMillis = n2;
            return this;
        }

        public Builder user(String string) {
            this.user = string;
            return this;
        }

        public Builder password(String string) {
            this.password = string;
            return this;
        }

        public Builder database(int n2) {
            this.database = n2;
            return this;
        }

        public Builder clientName(String string) {
            this.clientName = string;
            return this;
        }

        public Builder ssl(boolean bl) {
            this.ssl = bl;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.sslSocketFactory = sSLSocketFactory;
            return this;
        }

        public Builder sslParameters(SSLParameters sSLParameters) {
            this.sslParameters = sSLParameters;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder hostAndPortMapper(HostAndPortMapper hostAndPortMapper) {
            this.hostAndPortMapper = hostAndPortMapper;
            return this;
        }
    }
}

