/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.DefaultJedisClientConfig;
import me.ulrich.clans.library.redis.jedis.DefaultJedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(jedisClientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig jedisClientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(jedisClientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    public void setPassword(String string) {
        this.clientConfig.updatePassword(string);
    }

    @Override
    public void activateObject(PooledObject<Connection> pooledObject) {
    }

    @Override
    public void destroyObject(PooledObject<Connection> pooledObject) {
        Connection connection = pooledObject.getObject();
        if (connection.isConnected()) {
            try {
                if (!connection.isBroken()) {
                    connection.quit();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.debug("Error while QUIT", runtimeException);
            }
            try {
                connection.close();
            }
            catch (RuntimeException runtimeException) {
                logger.debug("Error while close", runtimeException);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject() {
        Connection connection = null;
        try {
            connection = new Connection(this.jedisSocketFactory, this.clientConfig);
            connection.connect();
            return new DefaultPooledObject<Connection>(connection);
        }
        catch (JedisException jedisException) {
            if (connection != null) {
                try {
                    connection.quit();
                }
                catch (RuntimeException runtimeException) {
                    logger.debug("Error while QUIT", runtimeException);
                }
                try {
                    connection.close();
                }
                catch (RuntimeException runtimeException) {
                    logger.debug("Error while close", runtimeException);
                }
            }
            throw jedisException;
        }
    }

    @Override
    public void passivateObject(PooledObject<Connection> pooledObject) {
    }

    @Override
    public boolean validateObject(PooledObject<Connection> pooledObject) {
        Connection connection = pooledObject.getObject();
        try {
            return connection.isConnected() && connection.ping();
        }
        catch (Exception exception) {
            logger.error("Error while validating pooled Connection object.", exception);
            return false;
        }
    }
}

