/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.ConnectionPool;
import me.ulrich.clans.library.redis.jedis.DefaultJedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.JedisSocketFactory;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisConnectionException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisDataException;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import me.ulrich.clans.library.redis.jedis.util.RedisInputStream;
import me.ulrich.clans.library.redis.jedis.util.RedisOutputStream;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;

public class Connection
implements Closeable {
    private ConnectionPool memberOf;
    private final JedisSocketFactory socketFactory;
    private Socket socket;
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int soTimeout = 0;
    private int infiniteSoTimeout = 0;
    private boolean broken = false;

    public Connection() {
        this("127.0.0.1", 6379);
    }

    public Connection(String string, int n2) {
        this(new HostAndPort(string, n2));
    }

    public Connection(HostAndPort hostAndPort) {
        this(new DefaultJedisSocketFactory(hostAndPort));
    }

    public Connection(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this(new DefaultJedisSocketFactory(hostAndPort, jedisClientConfig));
        this.infiniteSoTimeout = jedisClientConfig.getBlockingSocketTimeoutMillis();
        this.initializeFromClientConfig(jedisClientConfig);
    }

    public Connection(JedisSocketFactory jedisSocketFactory, JedisClientConfig jedisClientConfig) {
        this.socketFactory = jedisSocketFactory;
        this.soTimeout = jedisClientConfig.getSocketTimeoutMillis();
        this.infiniteSoTimeout = jedisClientConfig.getBlockingSocketTimeoutMillis();
        this.initializeFromClientConfig(jedisClientConfig);
    }

    public Connection(JedisSocketFactory jedisSocketFactory) {
        this.socketFactory = jedisSocketFactory;
    }

    public String toString() {
        return "Connection{" + this.socketFactory + "}";
    }

    public final void setHandlingPool(ConnectionPool connectionPool) {
        this.memberOf = connectionPool;
    }

    final HostAndPort getHostAndPort() {
        return ((DefaultJedisSocketFactory)this.socketFactory).getHostAndPort();
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(n2);
            }
            catch (SocketException socketException) {
                this.broken = true;
                throw new JedisConnectionException(socketException);
            }
        }
    }

    public void setTimeoutInfinite() {
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.socket.setSoTimeout(this.infiniteSoTimeout);
        }
        catch (SocketException socketException) {
            this.broken = true;
            throw new JedisConnectionException(socketException);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.soTimeout);
        }
        catch (SocketException socketException) {
            this.broken = true;
            throw new JedisConnectionException(socketException);
        }
    }

    public Object executeCommand(ProtocolCommand protocolCommand) {
        return this.executeCommand(new CommandArguments(protocolCommand));
    }

    public Object executeCommand(CommandArguments commandArguments) {
        this.sendCommand(commandArguments);
        return this.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeCommand(CommandObject<T> commandObject) {
        CommandArguments commandArguments = commandObject.getArguments();
        this.sendCommand(commandArguments);
        if (!commandArguments.isBlocking()) {
            return commandObject.getBuilder().build(this.getOne());
        }
        try {
            this.setTimeoutInfinite();
            T t2 = commandObject.getBuilder().build(this.getOne());
            return t2;
        }
        finally {
            this.rollbackTimeout();
        }
    }

    public void sendCommand(ProtocolCommand protocolCommand) {
        this.sendCommand(new CommandArguments(protocolCommand));
    }

    public void sendCommand(ProtocolCommand protocolCommand, Rawable rawable) {
        this.sendCommand(new CommandArguments(protocolCommand).add(rawable));
    }

    public void sendCommand(ProtocolCommand protocolCommand, String ... stringArray) {
        this.sendCommand(new CommandArguments(protocolCommand).addObjects(stringArray));
    }

    public void sendCommand(ProtocolCommand protocolCommand, byte[] ... byArray) {
        this.sendCommand(new CommandArguments(protocolCommand).addObjects((Object[])byArray));
    }

    public void sendCommand(CommandArguments commandArguments) {
        try {
            this.connect();
            Protocol.sendCommand(this.outputStream, commandArguments);
        }
        catch (JedisConnectionException jedisConnectionException) {
            JedisConnectionException jedisConnectionException2;
            try {
                String string = Protocol.readErrorLineIfPossible(this.inputStream);
                if (string != null && string.length() > 0) {
                    jedisConnectionException2 = new JedisConnectionException(string, jedisConnectionException.getCause());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broken = true;
            throw jedisConnectionException2;
        }
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.socket = this.socketFactory.createSocket();
                this.soTimeout = this.socket.getSoTimeout();
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (JedisConnectionException jedisConnectionException) {
                this.broken = true;
                throw jedisConnectionException;
            }
            catch (IOException iOException) {
                this.broken = true;
                throw new JedisConnectionException("Failed to create input/output stream", iOException);
            }
            finally {
                if (this.broken) {
                    IOUtils.closeQuietly(this.socket);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.memberOf != null) {
            ConnectionPool connectionPool = this.memberOf;
            this.memberOf = null;
            if (this.isBroken()) {
                connectionPool.returnBrokenResource(this);
            } else {
                connectionPool.returnResource(this);
            }
        } else {
            this.disconnect();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.outputStream.flush();
                this.socket.close();
            }
            catch (IOException iOException) {
                this.broken = true;
                throw new JedisConnectionException(iOException);
            }
            finally {
                IOUtils.closeQuietly(this.socket);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken() {
        this.broken = true;
    }

    public String getStatusCodeReply() {
        this.flush();
        byte[] byArray = (byte[])this.readProtocolWithCheckingBroken();
        if (null == byArray) {
            return null;
        }
        return SafeEncoder.encode(byArray);
    }

    public String getBulkReply() {
        byte[] byArray = this.getBinaryBulkReply();
        if (null != byArray) {
            return SafeEncoder.encode(byArray);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        this.flush();
        return (byte[])this.readProtocolWithCheckingBroken();
    }

    public Long getIntegerReply() {
        this.flush();
        return (Long)this.readProtocolWithCheckingBroken();
    }

    public List<String> getMultiBulkReply() {
        return BuilderFactory.STRING_LIST.build(this.getBinaryMultiBulkReply());
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Object> getUnflushedObjectMultiBulkReply() {
        return (List)this.readProtocolWithCheckingBroken();
    }

    public List<Object> getObjectMultiBulkReply() {
        this.flush();
        return this.getUnflushedObjectMultiBulkReply();
    }

    public List<Long> getIntegerMultiBulkReply() {
        this.flush();
        return (List)this.readProtocolWithCheckingBroken();
    }

    public Object getOne() {
        this.flush();
        return this.readProtocolWithCheckingBroken();
    }

    protected void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            this.broken = true;
            throw new JedisConnectionException(iOException);
        }
    }

    protected Object readProtocolWithCheckingBroken() {
        if (this.broken) {
            throw new JedisConnectionException("Attempting to read from a broken connection");
        }
        try {
            return Protocol.read(this.inputStream);
        }
        catch (JedisConnectionException jedisConnectionException) {
            this.broken = true;
            throw jedisConnectionException;
        }
    }

    public List<Object> getMany(int n2) {
        this.flush();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                arrayList.add(this.readProtocolWithCheckingBroken());
                continue;
            }
            catch (JedisDataException jedisDataException) {
                arrayList.add(jedisDataException);
            }
        }
        return arrayList;
    }

    private void initializeFromClientConfig(JedisClientConfig jedisClientConfig) {
        try {
            String string;
            int n2;
            this.connect();
            String string2 = jedisClientConfig.getPassword();
            if (string2 != null) {
                String string3 = jedisClientConfig.getUser();
                if (string3 != null) {
                    this.auth(string3, string2);
                } else {
                    this.auth(string2);
                }
            }
            if ((n2 = jedisClientConfig.getDatabase()) > 0) {
                this.select(n2);
            }
            if ((string = jedisClientConfig.getClientName()) != null) {
                this.clientSetname(string);
            }
        }
        catch (JedisException jedisException) {
            try {
                if (this.isConnected()) {
                    this.quit();
                }
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw jedisException;
        }
    }

    private String auth(String string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, string);
        return this.getStatusCodeReply();
    }

    private String auth(String string, String string2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.AUTH, string, string2);
        return this.getStatusCodeReply();
    }

    public String select(int n2) {
        this.sendCommand((ProtocolCommand)Protocol.Command.SELECT, new byte[][]{Protocol.toByteArray(n2)});
        return this.getStatusCodeReply();
    }

    private String clientSetname(String string) {
        this.sendCommand((ProtocolCommand)Protocol.Command.CLIENT, Protocol.Keyword.SETNAME.name(), string);
        return this.getStatusCodeReply();
    }

    public String quit() {
        this.sendCommand(Protocol.Command.QUIT);
        String string = this.getStatusCodeReply();
        this.disconnect();
        this.setBroken();
        return string;
    }

    public boolean ping() {
        this.sendCommand(Protocol.Command.PING);
        String string = this.getStatusCodeReply();
        if (!"PONG".equals(string)) {
            throw new JedisException(string);
        }
        return true;
    }
}

