/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.args.BitCountOption;
import me.ulrich.clans.library.redis.jedis.args.BitOP;
import me.ulrich.clans.library.redis.jedis.args.ExpiryOption;
import me.ulrich.clans.library.redis.jedis.args.FlushMode;
import me.ulrich.clans.library.redis.jedis.args.FunctionRestorePolicy;
import me.ulrich.clans.library.redis.jedis.args.GeoUnit;
import me.ulrich.clans.library.redis.jedis.args.ListDirection;
import me.ulrich.clans.library.redis.jedis.args.ListPosition;
import me.ulrich.clans.library.redis.jedis.args.SortedSetOption;
import me.ulrich.clans.library.redis.jedis.bloom.BFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.BFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFInsertParams;
import me.ulrich.clans.library.redis.jedis.bloom.CFReserveParams;
import me.ulrich.clans.library.redis.jedis.bloom.RedisBloomProtocol;
import me.ulrich.clans.library.redis.jedis.bloom.TDigestMergeParams;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.graph.GraphProtocol;
import me.ulrich.clans.library.redis.jedis.json.JsonProtocol;
import me.ulrich.clans.library.redis.jedis.json.JsonSetParams;
import me.ulrich.clans.library.redis.jedis.json.Path;
import me.ulrich.clans.library.redis.jedis.json.Path2;
import me.ulrich.clans.library.redis.jedis.params.BitPosParams;
import me.ulrich.clans.library.redis.jedis.params.GeoAddParams;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusParam;
import me.ulrich.clans.library.redis.jedis.params.GeoRadiusStoreParam;
import me.ulrich.clans.library.redis.jedis.params.GeoSearchParam;
import me.ulrich.clans.library.redis.jedis.params.GetExParams;
import me.ulrich.clans.library.redis.jedis.params.IParams;
import me.ulrich.clans.library.redis.jedis.params.LCSParams;
import me.ulrich.clans.library.redis.jedis.params.LPosParams;
import me.ulrich.clans.library.redis.jedis.params.MigrateParams;
import me.ulrich.clans.library.redis.jedis.params.RestoreParams;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.params.SetParams;
import me.ulrich.clans.library.redis.jedis.params.SortingParams;
import me.ulrich.clans.library.redis.jedis.params.StrAlgoLCSParams;
import me.ulrich.clans.library.redis.jedis.params.XAddParams;
import me.ulrich.clans.library.redis.jedis.params.XAutoClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XClaimParams;
import me.ulrich.clans.library.redis.jedis.params.XPendingParams;
import me.ulrich.clans.library.redis.jedis.params.XReadGroupParams;
import me.ulrich.clans.library.redis.jedis.params.XReadParams;
import me.ulrich.clans.library.redis.jedis.params.XTrimParams;
import me.ulrich.clans.library.redis.jedis.params.ZAddParams;
import me.ulrich.clans.library.redis.jedis.params.ZIncrByParams;
import me.ulrich.clans.library.redis.jedis.params.ZParams;
import me.ulrich.clans.library.redis.jedis.params.ZRangeParams;
import me.ulrich.clans.library.redis.jedis.resps.FunctionStats;
import me.ulrich.clans.library.redis.jedis.resps.GeoRadiusResponse;
import me.ulrich.clans.library.redis.jedis.resps.KeyedListElement;
import me.ulrich.clans.library.redis.jedis.resps.KeyedZSetElement;
import me.ulrich.clans.library.redis.jedis.resps.LCSMatchResult;
import me.ulrich.clans.library.redis.jedis.resps.LibraryInfo;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumersInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingSummary;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.FTCreateParams;
import me.ulrich.clans.library.redis.jedis.search.FTSearchParams;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchProtocol;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.search.schemafields.SchemaField;
import me.ulrich.clans.library.redis.jedis.timeseries.AggregationType;
import me.ulrich.clans.library.redis.jedis.timeseries.TSAlterParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSCreateParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSElement;
import me.ulrich.clans.library.redis.jedis.timeseries.TSGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSInfo;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyValue;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyedElements;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMGetParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSMRangeParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TSRangeParams;
import me.ulrich.clans.library.redis.jedis.timeseries.TimeSeriesProtocol;
import me.ulrich.clans.library.redis.jedis.util.KeyValue;
import org.json.JSONArray;
import org.json.JSONObject;

public class CommandObjects {
    private static final Gson GSON = new Gson();

    protected CommandArguments commandArguments(ProtocolCommand protocolCommand) {
        return new CommandArguments(protocolCommand);
    }

    public final CommandObject<Boolean> exists(String string) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.EXISTS).key(string), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> exists(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXISTS).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> exists(byte[] byArray) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.EXISTS).key(byArray), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> exists(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXISTS).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> persist(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PERSIST).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> persist(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PERSIST).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<String> type(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.TYPE).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> type(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.TYPE).key(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> dump(String string) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.DUMP).key(string), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> dump(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.DUMP).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<String> restore(String string, long l2, byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(string).add(l2).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(String string, long l2, byte[] byArray, RestoreParams restoreParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(string).add(l2).add(byArray).addParams(restoreParams), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(byArray).add(l2).add(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<String> restore(byte[] byArray, long l2, byte[] byArray2, RestoreParams restoreParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RESTORE).key(byArray).add(l2).add(byArray2).addParams(restoreParams), BuilderFactory.STRING);
    }

    public final CommandObject<Long> expire(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(String string, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(string).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRE).key(byArray).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(String string, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(string).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpire(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRE).key(byArray).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireTime(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRETIME).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireTime(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIRETIME).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireTime(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRETIME).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireTime(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIRETIME).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(String string, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(string).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> expireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.EXPIREAT).key(byArray).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(String string, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(string).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pexpireAt(byte[] byArray, long l2, ExpiryOption expiryOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PEXPIREAT).key(byArray).add(l2).add(expiryOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ttl(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TTL).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ttl(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TTL).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pttl(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PTTL).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pttl(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PTTL).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> touch(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.TOUCH).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> sort(String string) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT).key(string), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> sort(String string, SortingParams sortingParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT).key(string).addParams(sortingParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> sort(byte[] byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT).key(byArray), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> sort(byte[] byArray, SortingParams sortingParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT).key(byArray).addParams(sortingParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> sort(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(string).add(Protocol.Keyword.STORE).key(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(String string, SortingParams sortingParams, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(string).addParams(sortingParams).add(Protocol.Keyword.STORE).key(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(byArray).add(Protocol.Keyword.STORE).key(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sort(byte[] byArray, SortingParams sortingParams, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SORT).key(byArray).addParams(sortingParams).add(Protocol.Keyword.STORE).key(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> sortReadonly(byte[] byArray, SortingParams sortingParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SORT_RO).key(byArray).addParams(sortingParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<String>> sortReadonly(String string, SortingParams sortingParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SORT_RO).key(string).addParams(sortingParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> del(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> del(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DEL).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> unlink(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.UNLINK).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> copy(String string, String string2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.COPY).key(string).key(string2);
        if (bl) {
            commandArguments.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(commandArguments, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> copy(byte[] byArray, byte[] byArray2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.COPY).key(byArray).key(byArray2);
        if (bl) {
            commandArguments.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(commandArguments, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<String> rename(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RENAME).key(string).key(string2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> renamenx(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RENAMENX).key(string).key(string2), BuilderFactory.LONG);
    }

    public final CommandObject<String> rename(byte[] byArray, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RENAME).key(byArray).key(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> renamenx(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RENAMENX).key(byArray).key(byArray2), BuilderFactory.LONG);
    }

    public CommandObject<Long> dbSize() {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DBSIZE), BuilderFactory.LONG);
    }

    public CommandObject<Set<String>> keys(String string) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.KEYS).key(string);
        return new CommandObject<Set<String>>(commandArguments, BuilderFactory.STRING_SET);
    }

    public CommandObject<Set<byte[]>> keys(byte[] byArray) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.KEYS).key(byArray);
        return new CommandObject<Set<byte[]>>(commandArguments, BuilderFactory.BINARY_SET);
    }

    public CommandObject<ScanResult<String>> scan(String string) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams, String string2) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams).add(Protocol.Keyword.TYPE).add(string2), BuilderFactory.SCAN_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] byArray) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams).add(Protocol.Keyword.TYPE).add(byArray2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    public final CommandObject<String> randomKey() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RANDOMKEY), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> randomBinaryKey() {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RANDOMKEY), BuilderFactory.BINARY);
    }

    public final CommandObject<String> set(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(string).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(String string, String string2, SetParams setParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(string).add(string2).addParams(setParams), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(byte[] byArray, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(byArray).add(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<String> set(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(byArray).add(byArray2).addParams(setParams), BuilderFactory.STRING);
    }

    public final CommandObject<String> get(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GET).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> setGet(String string, String string2, SetParams setParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SET).key(string).add(string2).addParams(setParams).add(Protocol.Keyword.GET), BuilderFactory.STRING);
    }

    public final CommandObject<String> getDel(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETDEL).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> getEx(String string, GetExParams getExParams) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETEX).key(string).addParams(getExParams), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> get(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GET).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> setGet(byte[] byArray, byte[] byArray2, SetParams setParams) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SET).key(byArray).add(byArray2).addParams(setParams).add(Protocol.Keyword.GET), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> getDel(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETDEL).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> getEx(byte[] byArray, GetExParams getExParams) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETEX).key(byArray).addParams(getExParams), BuilderFactory.BINARY);
    }

    public final CommandObject<String> getSet(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETSET).key(string).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> getSet(byte[] byArray, byte[] byArray2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETSET).key(byArray).add(byArray2), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> setnx(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETNX).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<String> setex(String string, long l2, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SETEX).key(string).add(l2).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> psetex(String string, long l2, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PSETEX).key(string).add(l2).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> setnx(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETNX).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> setex(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SETEX).key(byArray).add(l2).add(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<String> psetex(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PSETEX).key(byArray).add(l2).add(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> setbit(String string, long l2, boolean bl) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SETBIT).key(string).add(l2).add(bl), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> setbit(byte[] byArray, long l2, boolean bl) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SETBIT).key(byArray).add(l2).add(bl), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> getbit(String string, long l2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.GETBIT).key(string).add(l2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> getbit(byte[] byArray, long l2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.GETBIT).key(byArray).add(l2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> setrange(String string, long l2, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETRANGE).key(string).add(l2).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> setrange(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SETRANGE).key(byArray).add(l2).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> getrange(String string, long l2, long l3) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.GETRANGE).key(string).add(l2).add(l3), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> getrange(byte[] byArray, long l2, long l3) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.GETRANGE).key(byArray).add(l2).add(l3), BuilderFactory.BINARY);
    }

    public final CommandObject<List<String>> mget(String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.MGET).keys(stringArray), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> mget(byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.MGET).keys((Object[])byArray), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> mset(String ... stringArray) {
        return new CommandObject<String>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSET), stringArray), BuilderFactory.STRING);
    }

    public final CommandObject<Long> msetnx(String ... stringArray) {
        return new CommandObject<Long>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSETNX), stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<String> mset(byte[] ... byArray) {
        return new CommandObject<String>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSET), byArray), BuilderFactory.STRING);
    }

    public final CommandObject<Long> msetnx(byte[] ... byArray) {
        return new CommandObject<Long>(this.addFlatKeyValueArgs(this.commandArguments(Protocol.Command.MSETNX), byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incr(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCR).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incrBy(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCRBY).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> incrByFloat(String string, double d2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.INCRBYFLOAT).key(string).add(d2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> incr(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCR).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> incrBy(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.INCRBY).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> incrByFloat(byte[] byArray, double d2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.INCRBYFLOAT).key(byArray).add(d2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> decr(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECR).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decrBy(String string, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECRBY).key(string).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decr(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECR).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> decrBy(byte[] byArray, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.DECRBY).key(byArray).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> append(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.APPEND).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> append(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.APPEND).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> substr(String string, int n2, int n3) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SUBSTR).key(string).add(n2).add(n3), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> substr(byte[] byArray, int n2, int n3) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SUBSTR).key(byArray).add(n2).add(n3), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> strlen(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.STRLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> strlen(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.STRLEN).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String string, long l2, long l3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(string).add(l2).add(l3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(String string, long l2, long l3, BitCountOption bitCountOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(string).add(l2).add(l3).add(bitCountOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] byArray, long l2, long l3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(byArray).add(l2).add(l3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitcount(byte[] byArray, long l2, long l3, BitCountOption bitCountOption) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITCOUNT).key(byArray).add(l2).add(l3).add(bitCountOption), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(String string, boolean bl) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(string).add(bl ? 1 : 0), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(String string, boolean bl, BitPosParams bitPosParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(string).add(bl ? 1 : 0).addParams(bitPosParams), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(byte[] byArray, boolean bl) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(byArray).add(bl ? 1 : 0), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitpos(byte[] byArray, boolean bl, BitPosParams bitPosParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITPOS).key(byArray).add(bl ? 1 : 0).addParams(bitPosParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> bitfield(String string, String ... stringArray) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD).key(string).addObjects(stringArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfieldReadonly(String string, String ... stringArray) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD_RO).key(string).addObjects(stringArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfield(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> bitfieldReadonly(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.BITFIELD_RO).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> bitop(BitOP bitOP, String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITOP).add(bitOP).key(string).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> bitop(BitOP bitOP, byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.BITOP).add(bitOP).key(byArray).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    @Deprecated
    public final CommandObject<LCSMatchResult> strAlgoLCSKeys(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.STRALGO).add(Protocol.Keyword.LCS).add(Protocol.Keyword.KEYS).key(string).key(string2).addParams(strAlgoLCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    @Deprecated
    public final CommandObject<LCSMatchResult> strAlgoLCSKeys(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.STRALGO).add(Protocol.Keyword.LCS).add(Protocol.Keyword.KEYS).key(byArray).key(byArray2).addParams(strAlgoLCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<LCSMatchResult> lcs(String string, String string2, LCSParams lCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.LCS).key(string).key(string2).addParams(lCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<LCSMatchResult> lcs(byte[] byArray, byte[] byArray2, LCSParams lCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.LCS).key(byArray).key(byArray2).addParams(lCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<Long> rpush(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSH).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpush(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSH).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpush(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSH).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpush(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSH).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> llen(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> llen(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LLEN).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> lrange(String string, long l2, long l3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.LRANGE).key(string).add(l2).add(l3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> lrange(byte[] byArray, long l2, long l3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.LRANGE).key(byArray).add(l2).add(l3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> ltrim(String string, long l2, long l3) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LTRIM).key(string).add(l2).add(l3), BuilderFactory.STRING);
    }

    public final CommandObject<String> ltrim(byte[] byArray, long l2, long l3) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LTRIM).key(byArray).add(l2).add(l3), BuilderFactory.STRING);
    }

    public final CommandObject<String> lindex(String string, long l2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LINDEX).key(string).add(l2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> lindex(byte[] byArray, long l2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LINDEX).key(byArray).add(l2), BuilderFactory.BINARY);
    }

    public final CommandObject<String> lset(String string, long l2, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LSET).key(string).add(l2).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> lset(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LSET).key(byArray).add(l2).add(byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> lrem(String string, long l2, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LREM).key(string).add(l2).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lrem(byte[] byArray, long l2, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LREM).key(byArray).add(l2).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> lpop(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LPOP).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> lpop(String string, int n2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.LPOP).key(string).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<byte[]> lpop(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LPOP).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> lpop(byte[] byArray, int n2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.LPOP).key(byArray).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> rpop(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RPOP).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> rpop(String string, int n2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.RPOP).key(string).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<byte[]> rpop(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RPOP).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> rpop(byte[] byArray, int n2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.RPOP).key(byArray).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> lpos(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpos(String string, String string2, LPosParams lPosParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(string).add(string2).addParams(lPosParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> lpos(String string, String string2, LPosParams lPosParams, long l2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.LPOS).key(string).add(string2).addParams(lPosParams).add(Protocol.Keyword.COUNT).add(l2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> lpos(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPOS).key(byArray).add(byArray2).addParams(lPosParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> lpos(byte[] byArray, byte[] byArray2, LPosParams lPosParams, long l2) {
        return new CommandObject<List<Long>>(this.commandArguments(Protocol.Command.LPOS).key(byArray).add(byArray2).addParams(lPosParams).add(Protocol.Keyword.COUNT).add(l2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> linsert(String string, ListPosition listPosition, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LINSERT).key(string).add(listPosition).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> linsert(byte[] byArray, ListPosition listPosition, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LINSERT).key(byArray).add(listPosition).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpushx(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSHX).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpushx(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSHX).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> lpushx(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.LPUSHX).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> rpushx(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.RPUSHX).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> blpop(int n2, String string) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().key(string).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> blpop(int n2, String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys(stringArray).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<KeyedListElement> blpop(double d2, String string) {
        return new CommandObject<KeyedListElement>(this.commandArguments(Protocol.Command.BLPOP).blocking().key(string).add(d2), BuilderFactory.KEYED_LIST_ELEMENT);
    }

    public final CommandObject<KeyedListElement> blpop(double d2, String ... stringArray) {
        return new CommandObject<KeyedListElement>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys(stringArray).add(d2), BuilderFactory.KEYED_LIST_ELEMENT);
    }

    public final CommandObject<List<byte[]>> blpop(int n2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys((Object[])byArray).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> blpop(double d2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BLPOP).blocking().keys((Object[])byArray).add(d2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<String>> brpop(int n2, String string) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().key(string).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> brpop(int n2, String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys(stringArray).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<KeyedListElement> brpop(double d2, String string) {
        return new CommandObject<KeyedListElement>(this.commandArguments(Protocol.Command.BRPOP).blocking().key(string).add(d2), BuilderFactory.KEYED_LIST_ELEMENT);
    }

    public final CommandObject<KeyedListElement> brpop(double d2, String ... stringArray) {
        return new CommandObject<KeyedListElement>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys(stringArray).add(d2), BuilderFactory.KEYED_LIST_ELEMENT);
    }

    public final CommandObject<List<byte[]>> brpop(int n2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys((Object[])byArray).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> brpop(double d2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BRPOP).blocking().keys((Object[])byArray).add(d2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<String> rpoplpush(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.RPOPLPUSH).key(string).key(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> brpoplpush(String string, String string2, int n2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.BRPOPLPUSH).blocking().key(string).key(string2).add(n2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> rpoplpush(byte[] byArray, byte[] byArray2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.RPOPLPUSH).key(byArray).key(byArray2), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> brpoplpush(byte[] byArray, byte[] byArray2, int n2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.BRPOPLPUSH).blocking().key(byArray).key(byArray2).add(n2), BuilderFactory.BINARY);
    }

    public final CommandObject<String> lmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.LMOVE).key(string).key(string2).add(listDirection).add(listDirection2), BuilderFactory.STRING);
    }

    public final CommandObject<String> blmove(String string, String string2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.BLMOVE).blocking().key(string).key(string2).add(listDirection).add(listDirection2).add(d2), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> lmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.LMOVE).key(byArray).key(byArray2).add(listDirection).add(listDirection2), BuilderFactory.BINARY);
    }

    public final CommandObject<byte[]> blmove(byte[] byArray, byte[] byArray2, ListDirection listDirection, ListDirection listDirection2, double d2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.BLMOVE).blocking().key(byArray).key(byArray2).add(listDirection).add(listDirection2).add(d2), BuilderFactory.BINARY);
    }

    public final CommandObject<KeyValue<String, List<String>>> lmpop(ListDirection listDirection, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.LMPOP).add(stringArray.length).keys(stringArray).add(listDirection), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> lmpop(ListDirection listDirection, int n2, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.LMPOP).add(stringArray.length).keys(stringArray).add(listDirection).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> blmpop(long l2, ListDirection listDirection, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(l2).add(stringArray.length).keys(stringArray).add(listDirection), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<String, List<String>>> blmpop(long l2, ListDirection listDirection, int n2, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<String>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(l2).add(stringArray.length).keys(stringArray).add(listDirection).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_STRING_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection listDirection, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.LMPOP).add(byArray.length).keys((Object[])byArray).add(listDirection), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> lmpop(ListDirection listDirection, int n2, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.LMPOP).add(byArray.length).keys((Object[])byArray).add(listDirection).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> blmpop(long l2, ListDirection listDirection, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(l2).add(byArray.length).keys((Object[])byArray).add(listDirection), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<byte[]>>> blmpop(long l2, ListDirection listDirection, int n2, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<byte[]>>>(this.commandArguments(Protocol.Command.BLMPOP).blocking().add(l2).add(byArray.length).keys((Object[])byArray).add(listDirection).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_BINARY_LIST);
    }

    public final CommandObject<Long> hset(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSET).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hset(String string, Map<String, String> map) {
        return new CommandObject<Long>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HSET).key(string), map), BuilderFactory.LONG);
    }

    public final CommandObject<String> hget(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.HGET).key(string).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> hsetnx(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSETNX).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<String> hmset(String string, Map<String, String> map) {
        return new CommandObject<String>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HMSET).key(string), map), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> hmget(String string, String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HMGET).key(string).addObjects(stringArray), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> hset(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSET).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hset(byte[] byArray, Map<byte[], byte[]> map) {
        return new CommandObject<Long>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HSET).key(byArray), map), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> hget(byte[] byArray, byte[] byArray2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.HGET).key(byArray).add(byArray2), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> hsetnx(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSETNX).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<String> hmset(byte[] byArray, Map<byte[], byte[]> map) {
        return new CommandObject<String>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.HMSET).key(byArray), map), BuilderFactory.STRING);
    }

    public final CommandObject<List<byte[]>> hmget(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HMGET).key(byArray).addObjects((Object[])byArray2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> hincrBy(String string, String string2, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HINCRBY).key(string).add(string2).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> hincrByFloat(String string, String string2, double d2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.HINCRBYFLOAT).key(string).add(string2).add(d2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Boolean> hexists(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.HEXISTS).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> hdel(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HDEL).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hlen(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hincrBy(byte[] byArray, byte[] byArray2, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HINCRBY).key(byArray).add(byArray2).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Double> hincrByFloat(byte[] byArray, byte[] byArray2, double d2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.HINCRBYFLOAT).key(byArray).add(byArray2).add(d2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Boolean> hexists(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.HEXISTS).key(byArray).add(byArray2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> hdel(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HDEL).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> hlen(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HLEN).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> hkeys(String string) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.HKEYS).key(string), BuilderFactory.STRING_SET);
    }

    public final CommandObject<List<String>> hvals(String string) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HVALS).key(string), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Set<byte[]>> hkeys(byte[] byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.HKEYS).key(byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<List<byte[]>> hvals(byte[] byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HVALS).key(byArray), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Map<String, String>> hgetAll(String string) {
        return new CommandObject<Map<String, String>>(this.commandArguments(Protocol.Command.HGETALL).key(string), BuilderFactory.STRING_MAP);
    }

    public final CommandObject<String> hrandfield(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.HRANDFIELD).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> hrandfield(String string, long l2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(string).add(l2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Map<String, String>> hrandfieldWithValues(String string, long l2) {
        return new CommandObject<Map<String, String>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(string).add(l2).add(Protocol.Keyword.WITHVALUES), BuilderFactory.STRING_MAP);
    }

    public final CommandObject<Map<byte[], byte[]>> hgetAll(byte[] byArray) {
        return new CommandObject<Map<byte[], byte[]>>(this.commandArguments(Protocol.Command.HGETALL).key(byArray), BuilderFactory.BINARY_MAP);
    }

    public final CommandObject<byte[]> hrandfield(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.HRANDFIELD).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> hrandfield(byte[] byArray, long l2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(byArray).add(l2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Map<byte[], byte[]>> hrandfieldWithValues(byte[] byArray, long l2) {
        return new CommandObject<Map<byte[], byte[]>>(this.commandArguments(Protocol.Command.HRANDFIELD).key(byArray).add(l2).add(Protocol.Keyword.WITHVALUES), BuilderFactory.BINARY_MAP);
    }

    public final CommandObject<ScanResult<Map.Entry<String, String>>> hscan(String string, String string2, ScanParams scanParams) {
        return new CommandObject<ScanResult<Map.Entry<String, String>>>(this.commandArguments(Protocol.Command.HSCAN).key(string).add(string2).addParams(scanParams), BuilderFactory.HSCAN_RESPONSE);
    }

    public final CommandObject<Long> hstrlen(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSTRLEN).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<ScanResult<Map.Entry<byte[], byte[]>>> hscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return new CommandObject<ScanResult<Map.Entry<byte[], byte[]>>>(this.commandArguments(Protocol.Command.HSCAN).key(byArray).add(byArray2).addParams(scanParams), BuilderFactory.HSCAN_BINARY_RESPONSE);
    }

    public final CommandObject<Long> hstrlen(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.HSTRLEN).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sadd(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SADD).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sadd(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SADD).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> smembers(String string) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SMEMBERS).key(string), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Set<byte[]>> smembers(byte[] byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SMEMBERS).key(byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> srem(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SREM).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> srem(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SREM).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> spop(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SPOP).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> spop(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SPOP).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<Set<String>> spop(String string, long l2) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SPOP).key(string).add(l2), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Set<byte[]>> spop(byte[] byArray, long l2) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SPOP).key(byArray).add(l2), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> scard(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SCARD).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> scard(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SCARD).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> sismember(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SISMEMBER).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> sismember(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.SISMEMBER).key(byArray).add(byArray2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> smismember(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SMISMEMBER).key(string).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> smismember(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SMISMEMBER).key(byArray).addObjects((Object[])byArray2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<String> srandmember(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> srandmember(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<List<String>> srandmember(String string, int n2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(string).add(n2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<byte[]>> srandmember(byte[] byArray, int n2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.SRANDMEMBER).key(byArray).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<ScanResult<String>> sscan(String string, String string2, ScanParams scanParams) {
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SSCAN).key(string).add(string2).addParams(scanParams), BuilderFactory.SSCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<byte[]>> sscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SSCAN).key(byArray).add(byArray2).addParams(scanParams), BuilderFactory.SSCAN_BINARY_RESPONSE);
    }

    public final CommandObject<Set<String>> sdiff(String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SDIFF).keys(stringArray), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sdiffstore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SDIFFSTORE).key(string).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sdiff(byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SDIFF).keys((Object[])byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sdiffstore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SDIFFSTORE).key(byArray).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> sinter(String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SINTER).keys(stringArray), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sinterstore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERSTORE).key(string).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(stringArray.length).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(int n2, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(stringArray.length).keys(stringArray).add(Protocol.Keyword.LIMIT).add(n2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sinter(byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SINTER).keys((Object[])byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sinterstore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERSTORE).key(byArray).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(byArray.length).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> sintercard(int n2, byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SINTERCARD).add(byArray.length).keys((Object[])byArray).add(Protocol.Keyword.LIMIT).add(n2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> sunion(String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.SUNION).keys(stringArray), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> sunionstore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SUNIONSTORE).key(string).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> sunion(byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.SUNION).keys((Object[])byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Long> sunionstore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SUNIONSTORE).key(byArray).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> smove(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SMOVE).key(string).key(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> smove(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.SMOVE).key(byArray).key(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String string, double d2, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(string).add(d2).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String string, double d2, String string2, ZAddParams zAddParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(string).addParams(zAddParams).add(d2).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String string, Map<String, Double> map) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(string), map), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(String string, Map<String, Double> map, ZAddParams zAddParams) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(string).addParams(zAddParams), map), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zaddIncr(String string, double d2, String string2, ZAddParams zAddParams) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(string).add(Protocol.Keyword.INCR).addParams(zAddParams).add(d2).add(string2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> zadd(byte[] byArray, double d2, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(byArray).add(d2).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZADD).key(byArray).addParams(zAddParams).add(d2).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] byArray, Map<byte[], Double> map) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(byArray), map), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zadd(byte[] byArray, Map<byte[], Double> map, ZAddParams zAddParams) {
        return new CommandObject<Long>(this.addSortedSetFlatMapArgs(this.commandArguments(Protocol.Command.ZADD).key(byArray).addParams(zAddParams), map), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zaddIncr(byte[] byArray, double d2, byte[] byArray2, ZAddParams zAddParams) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(byArray).add(Protocol.Keyword.INCR).addParams(zAddParams).add(d2).add(byArray2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(String string, double d2, String string2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZINCRBY).key(string).add(d2).add(string2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(String string, double d2, String string2, ZIncrByParams zIncrByParams) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(string).addParams(zIncrByParams).add(d2).add(string2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(byte[] byArray, double d2, byte[] byArray2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZINCRBY).key(byArray).add(d2).add(byArray2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> zincrby(byte[] byArray, double d2, byte[] byArray2, ZIncrByParams zIncrByParams) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZADD).key(byArray).addParams(zIncrByParams).add(d2).add(byArray2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> zrem(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREM).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrem(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREM).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrank(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANK).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrevrank(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREVRANK).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrank(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANK).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zrevrank(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREVRANK).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> zrandmember(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> zrandmember(String string, long l2) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(string).add(l2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrandmemberWithScores(String string, long l2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(string).add(l2).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<byte[]> zrandmember(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<List<byte[]>> zrandmember(byte[] byArray, long l2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(byArray).add(l2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrandmemberWithScores(byte[] byArray, long l2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANDMEMBER).key(byArray).add(l2).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Long> zcard(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCARD).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zscore(String string, String string2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZSCORE).key(string).add(string2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Double>> zmscore(String string, String ... stringArray) {
        return new CommandObject<List<Double>>(this.commandArguments(Protocol.Command.ZMSCORE).key(string).addObjects(stringArray), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Long> zcard(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCARD).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Double> zscore(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.ZSCORE).key(byArray).add(byArray2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Double>> zmscore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<Double>>(this.commandArguments(Protocol.Command.ZMSCORE).key(byArray).addObjects((Object[])byArray2), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Tuple> zpopmax(String string) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMAX).key(string), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmax(String string, int n2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMAX).key(string).add(n2), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Tuple> zpopmin(String string) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMIN).key(string), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmin(String string, int n2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMIN).key(string).add(n2), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Tuple> zpopmax(byte[] byArray) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMAX).key(byArray), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmax(byte[] byArray, int n2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMAX).key(byArray).add(n2), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Tuple> zpopmin(byte[] byArray) {
        return new CommandObject<Tuple>(this.commandArguments(Protocol.Command.ZPOPMIN).key(byArray), BuilderFactory.TUPLE);
    }

    public final CommandObject<List<Tuple>> zpopmin(byte[] byArray, int n2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZPOPMIN).key(byArray).add(n2), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<KeyedZSetElement> bzpopmax(double d2, String ... stringArray) {
        return new CommandObject<KeyedZSetElement>(this.commandArguments(Protocol.Command.BZPOPMAX).blocking().keys(stringArray).add(d2), BuilderFactory.KEYED_ZSET_ELEMENT);
    }

    public final CommandObject<KeyedZSetElement> bzpopmin(double d2, String ... stringArray) {
        return new CommandObject<KeyedZSetElement>(this.commandArguments(Protocol.Command.BZPOPMIN).blocking().keys(stringArray).add(d2), BuilderFactory.KEYED_ZSET_ELEMENT);
    }

    public final CommandObject<List<byte[]>> bzpopmax(double d2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BZPOPMAX).blocking().keys((Object[])byArray).add(d2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> bzpopmin(double d2, byte[] ... byArray) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.BZPOPMIN).blocking().keys((Object[])byArray).add(d2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> zcount(String string, double d2, double d3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(string).add(d2).add(d3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(byte[] byArray, double d2, double d3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(byArray).add(d2).add(d3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZCOUNT).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrange(String string, long l2, long l3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGE).key(string).add(l2).add(l3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrange(String string, long l2, long l3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(string).add(l2).add(l3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(String string, long l2, long l3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(string).add(l2).add(l3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeWithScores(String string, long l2, long l3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(string).add(l2).add(l3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<String>> zrange(String string, ZRangeParams zRangeParams) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGE).key(string).addParams(zRangeParams), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(String string, ZRangeParams zRangeParams) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(string).addParams(zRangeParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Long> zrangestore(String string, String string2, ZRangeParams zRangeParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANGESTORE).key(string).add(string2).addParams(zRangeParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrangeByScore(String string, double d2, double d3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(d2).add(d3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String string, String string2, String string3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(string2).add(string3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String string, double d2, double d3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(d2).add(d3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String string, String string2, String string3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(string2).add(string3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String string, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByScore(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String string, double d2, double d3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String string, String string2, String string3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String string, double d2, double d3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String string, String string2, String string3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String string, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<byte[]>> zrange(byte[] byArray, long l2, long l3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGE).key(byArray).add(l2).add(l3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrange(byte[] byArray, long l2, long l3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(byArray).add(l2).add(l3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(byte[] byArray, long l2, long l3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(byArray).add(l2).add(l3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeWithScores(byte[] byArray, long l2, long l3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGE).key(byArray).add(l2).add(l3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<byte[]>> zrange(byte[] byArray, ZRangeParams zRangeParams) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGE).key(byArray).addParams(zRangeParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeWithScores(byte[] byArray, ZRangeParams zRangeParams) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGE).key(byArray).addParams(zRangeParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Long> zrangestore(byte[] byArray, byte[] byArray2, ZRangeParams zRangeParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZRANGESTORE).key(byArray).add(byArray2).addParams(zRangeParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] byArray, double d2, double d3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(d2).add(d3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] byArray, double d2, double d3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(d2).add(d3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] byArray, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, double d2, double d3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(d2).add(d3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> zrevrangeByScoreWithScores(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<Tuple>>(this.commandArguments(Protocol.Command.ZREVRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Long> zremrangeByRank(String string, long l2, long l3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYRANK).key(string).add(l2).add(l3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(String string, double d2, double d3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(string).add(d2).add(d3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByRank(byte[] byArray, long l2, long l3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYRANK).key(byArray).add(l2).add(l3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(byte[] byArray, double d2, double d3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(byArray).add(d2).add(d3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zremrangeByScore(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYSCORE).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zlexcount(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZLEXCOUNT).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> zrangeByLex(String string, String string2, String string3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(string).add(string2).add(string3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByLex(String string, String string2, String string3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(string).add(string2).add(string3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> zrevrangeByLex(String string, String string2, String string3, int n2, int n3) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(string).add(string2).add(string3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Long> zremrangeByLex(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYLEX).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zlexcount(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZLEXCOUNT).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<List<byte[]>> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(byArray).add(byArray2).add(byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZRANGEBYLEX).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(byArray).add(byArray2).add(byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> zrevrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.ZREVRANGEBYLEX).key(byArray).add(byArray2).add(byArray3).add(Protocol.Keyword.LIMIT).add(n2).add(n3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> zremrangeByLex(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZREMRANGEBYLEX).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<ScanResult<Tuple>> zscan(String string, String string2, ScanParams scanParams) {
        return new CommandObject<ScanResult<Tuple>>(this.commandArguments(Protocol.Command.ZSCAN).key(string).add(string2).addParams(scanParams), BuilderFactory.ZSCAN_RESPONSE);
    }

    public final CommandObject<ScanResult<Tuple>> zscan(byte[] byArray, byte[] byArray2, ScanParams scanParams) {
        return new CommandObject<ScanResult<Tuple>>(this.commandArguments(Protocol.Command.ZSCAN).key(byArray).add(byArray2).addParams(scanParams), BuilderFactory.ZSCAN_RESPONSE);
    }

    public final CommandObject<Set<String>> zdiff(String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.ZDIFF).add(stringArray.length).keys(stringArray), BuilderFactory.STRING_ORDERED_SET);
    }

    public final CommandObject<Set<Tuple>> zdiffWithScores(String ... stringArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZDIFF).add(stringArray.length).keys(stringArray).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<Long> zdiffStore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZDIFFSTORE).key(string).add(stringArray.length).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> zdiff(byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.ZDIFF).add(byArray.length).keys((Object[])byArray), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Set<Tuple>> zdiffWithScores(byte[] ... byArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZDIFF).add(byArray.length).keys((Object[])byArray).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<Long> zdiffStore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZDIFFSTORE).key(byArray).add(byArray2.length).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(string).add(stringArray.length).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(String string, ZParams zParams, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(string).add(stringArray.length).keys(stringArray).addParams(zParams), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> zinter(ZParams zParams, String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.ZINTER).add(stringArray.length).keys(stringArray).addParams(zParams), BuilderFactory.STRING_ORDERED_SET);
    }

    public final CommandObject<Set<Tuple>> zinterWithScores(ZParams zParams, String ... stringArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZINTER).add(stringArray.length).keys(stringArray).addParams(zParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<Long> zintercard(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(stringArray.length).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(long l2, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(stringArray.length).keys(stringArray).add(Protocol.Keyword.LIMIT).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(byArray).add(byArray2.length).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zinterstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERSTORE).key(byArray).add(byArray2.length).keys((Object[])byArray2).addParams(zParams), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(byArray.length).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zintercard(long l2, byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZINTERCARD).add(byArray.length).keys((Object[])byArray).add(Protocol.Keyword.LIMIT).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> zinter(ZParams zParams, byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.ZINTER).add(byArray.length).keys((Object[])byArray).addParams(zParams), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Set<Tuple>> zinterWithScores(ZParams zParams, byte[] ... byArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZINTER).add(byArray.length).keys((Object[])byArray).addParams(zParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<Long> zunionstore(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(string).add(stringArray.length).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zunionstore(String string, ZParams zParams, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(string).add(stringArray.length).keys(stringArray).addParams(zParams), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> zunion(ZParams zParams, String ... stringArray) {
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.ZUNION).add(stringArray.length).keys(stringArray).addParams(zParams), BuilderFactory.STRING_ORDERED_SET);
    }

    public final CommandObject<Set<Tuple>> zunionWithScores(ZParams zParams, String ... stringArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZUNION).add(stringArray.length).keys(stringArray).addParams(zParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<Long> zunionstore(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(byArray).add(byArray2.length).keys((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> zunionstore(byte[] byArray, ZParams zParams, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.ZUNIONSTORE).key(byArray).add(byArray2.length).keys((Object[])byArray2).addParams(zParams), BuilderFactory.LONG);
    }

    public final CommandObject<Set<byte[]>> zunion(ZParams zParams, byte[] ... byArray) {
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.ZUNION).add(byArray.length).keys((Object[])byArray).addParams(zParams), BuilderFactory.BINARY_SET);
    }

    public final CommandObject<Set<Tuple>> zunionWithScores(ZParams zParams, byte[] ... byArray) {
        return new CommandObject<Set<Tuple>>(this.commandArguments(Protocol.Command.ZUNION).add(byArray.length).keys((Object[])byArray).addParams(zParams).add(Protocol.Keyword.WITHSCORES), BuilderFactory.TUPLE_ZSET);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption sortedSetOption, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(stringArray.length).keys(stringArray).add(sortedSetOption), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> zmpop(SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(stringArray.length).keys(stringArray).add(sortedSetOption).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(l2).add(stringArray.length).keys(stringArray).add(sortedSetOption), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<String, List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, String ... stringArray) {
        return new CommandObject<KeyValue<String, List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(l2).add(stringArray.length).keys(stringArray).add(sortedSetOption).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption sortedSetOption, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(byArray.length).keys((Object[])byArray).add(sortedSetOption), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> zmpop(SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.ZMPOP).add(byArray.length).keys((Object[])byArray).add(sortedSetOption).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(l2).add(byArray.length).keys((Object[])byArray).add(sortedSetOption), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<KeyValue<byte[], List<Tuple>>> bzmpop(long l2, SortedSetOption sortedSetOption, int n2, byte[] ... byArray) {
        return new CommandObject<KeyValue<byte[], List<Tuple>>>(this.commandArguments(Protocol.Command.BZMPOP).blocking().add(l2).add(byArray.length).keys((Object[])byArray).add(sortedSetOption).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.BINARY_KEYED_TUPLE_LIST);
    }

    public final CommandObject<Long> geoadd(String string, double d2, double d3, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOADD).key(string).add(d2).add(d3).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(String string, Map<String, GeoCoordinate> map) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(string), map), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(String string, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(string).addParams(geoAddParams), map), BuilderFactory.LONG);
    }

    public final CommandObject<Double> geodist(String string, String string2, String string3) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(string).add(string2).add(string3), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> geodist(String string, String string2, String string3, GeoUnit geoUnit) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(string).add(string2).add(string3).add(geoUnit), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<String>> geohash(String string, String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(Protocol.Command.GEOHASH).key(string).addObjects(stringArray), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<GeoCoordinate>> geopos(String string, String ... stringArray) {
        return new CommandObject<List<GeoCoordinate>>(this.commandArguments(Protocol.Command.GEOPOS).key(string).addObjects(stringArray), BuilderFactory.GEO_COORDINATE_LIST);
    }

    public final CommandObject<Long> geoadd(byte[] byArray, double d2, double d3, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOADD).key(byArray).add(d2).add(d3).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(byte[] byArray, Map<byte[], GeoCoordinate> map) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(byArray), map), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geoadd(byte[] byArray, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        return new CommandObject<Long>(this.addGeoCoordinateFlatMapArgs(this.commandArguments(Protocol.Command.GEOADD).key(byArray).addParams(geoAddParams), map), BuilderFactory.LONG);
    }

    public final CommandObject<Double> geodist(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(byArray).add(byArray2).add(byArray3), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> geodist(byte[] byArray, byte[] byArray2, byte[] byArray3, GeoUnit geoUnit) {
        return new CommandObject<Double>(this.commandArguments(Protocol.Command.GEODIST).key(byArray).add(byArray2).add(byArray3).add(geoUnit), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<byte[]>> geohash(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.GEOHASH).key(byArray).addObjects((Object[])byArray2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<GeoCoordinate>> geopos(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<GeoCoordinate>>(this.commandArguments(Protocol.Command.GEOPOS).key(byArray).addObjects((Object[])byArray2), BuilderFactory.GEO_COORDINATE_LIST);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(string).add(d2).add(d3).add(d4).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(string).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(string).add(d2).add(d3).add(d4).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(string).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusStore(String string, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUS).key(string).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam).addParams(geoRadiusStoreParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(string).add(string2).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(string).add(string2).add(d2).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(string).add(string2).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(string).add(string2).add(d2).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusByMemberStore(String string, String string2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(string).add(string2).add(d2).add(geoUnit).addParams(geoRadiusParam).addParams(geoRadiusStoreParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(byArray).add(d2).add(d3).add(d4).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadius(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS).key(byArray).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(byArray).add(d2).add(d3).add(d4).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusReadonly(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUS_RO).key(byArray).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusStore(byte[] byArray, double d2, double d3, double d4, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUS).key(byArray).add(d2).add(d3).add(d4).add(geoUnit).addParams(geoRadiusParam).addParams(geoRadiusStoreParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(byArray).add(byArray2).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMember(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(byArray).add(byArray2).add(d2).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(byArray).add(byArray2).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> georadiusByMemberReadonly(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER_RO).key(byArray).add(byArray2).add(d2).add(geoUnit).addParams(geoRadiusParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> georadiusByMemberStore(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam, GeoRadiusStoreParam geoRadiusStoreParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEORADIUSBYMEMBER).key(byArray).add(byArray2).add(d2).add(geoUnit).addParams(geoRadiusParam).addParams(geoRadiusStoreParam), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String string, String string2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(string).add(Protocol.Keyword.FROMMEMBER).add(string2).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String string, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(string).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String string, String string2, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(string).add(Protocol.Keyword.FROMMEMBER).add(string2).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String string, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(string).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(String string, GeoSearchParam geoSearchParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(string).addParams(geoSearchParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> geosearchStore(String string, String string2, String string3, double d2, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).add(Protocol.Keyword.FROMMEMBER).add(string3).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String string, String string2, String string3, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).add(Protocol.Keyword.FROMMEMBER).add(string3).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String string, String string2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(String string, String string2, GeoSearchParam geoSearchParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).addParams(geoSearchParam), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStoreStoreDist(String string, String string2, GeoSearchParam geoSearchParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(string).add(string2).addParams(geoSearchParam).add(Protocol.Keyword.STOREDIST), BuilderFactory.LONG);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] byArray, byte[] byArray2, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(byArray).add(Protocol.Keyword.FROMMEMBER).add(byArray2).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(byArray).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] byArray, byte[] byArray2, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(byArray).add(Protocol.Keyword.FROMMEMBER).add(byArray2).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(byArray).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<List<GeoRadiusResponse>> geosearch(byte[] byArray, GeoSearchParam geoSearchParam) {
        return new CommandObject<List<GeoRadiusResponse>>(this.commandArguments(Protocol.Command.GEOSEARCH).key(byArray).addParams(geoSearchParam), BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT);
    }

    public final CommandObject<Long> geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).add(Protocol.Keyword.FROMMEMBER).add(byArray3).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYRADIUS).add(d2).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] byArray, byte[] byArray2, byte[] byArray3, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).add(Protocol.Keyword.FROMMEMBER).add(byArray3).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoCoordinate geoCoordinate, double d2, double d3, GeoUnit geoUnit) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).add(Protocol.Keyword.FROMLONLAT).add(geoCoordinate.getLongitude()).add(geoCoordinate.getLatitude()).add(Protocol.Keyword.BYBOX).add(d2).add(d3).add(geoUnit), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStore(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).addParams(geoSearchParam), BuilderFactory.LONG);
    }

    public final CommandObject<Long> geosearchStoreStoreDist(byte[] byArray, byte[] byArray2, GeoSearchParam geoSearchParam) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.GEOSEARCHSTORE).key(byArray).add(byArray2).addParams(geoSearchParam).add(Protocol.Keyword.STOREDIST), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfadd(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFADD).key(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<String> pfmerge(String string, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PFMERGE).key(string).keys(stringArray), BuilderFactory.STRING);
    }

    public final CommandObject<Long> pfadd(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFADD).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<String> pfmerge(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.PFMERGE).key(byArray).keys((Object[])byArray2), BuilderFactory.STRING);
    }

    public final CommandObject<Long> pfcount(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).keys(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> pfcount(byte[] ... byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PFCOUNT).keys((Object[])byArray), BuilderFactory.LONG);
    }

    public final CommandObject<StreamEntryID> xadd(String string, StreamEntryID streamEntryID, Map<String, String> map) {
        return new CommandObject<StreamEntryID>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(string).add(streamEntryID == null ? StreamEntryID.NEW_ENTRY : streamEntryID), map), BuilderFactory.STREAM_ENTRY_ID);
    }

    public final CommandObject<StreamEntryID> xadd(String string, XAddParams xAddParams, Map<String, String> map) {
        return new CommandObject<StreamEntryID>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(string).addParams(xAddParams), map), BuilderFactory.STREAM_ENTRY_ID);
    }

    public final CommandObject<Long> xlen(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> xadd(byte[] byArray, XAddParams xAddParams, Map<byte[], byte[]> map) {
        return new CommandObject<byte[]>(this.addFlatMapArgs(this.commandArguments(Protocol.Command.XADD).key(byArray).addParams(xAddParams), map), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> xlen(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XLEN).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<List<StreamEntry>> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(string).add(streamEntryID == null ? "-" : streamEntryID).add(streamEntryID2 == null ? "+" : streamEntryID2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(string).add(streamEntryID == null ? "-" : streamEntryID).add(streamEntryID2 == null ? "+" : streamEntryID2).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(string).add(streamEntryID == null ? "+" : streamEntryID).add(streamEntryID2 == null ? "-" : streamEntryID2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String string, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(string).add(streamEntryID == null ? "+" : streamEntryID).add(streamEntryID2 == null ? "-" : streamEntryID2).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String string, String string2, String string3) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(string).add(string2).add(string3), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrange(String string, String string2, String string3, int n2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XRANGE).key(string).add(string2).add(string3).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String string, String string2, String string3) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(string).add(string2).add(string3), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntry>> xrevrange(String string, String string2, String string3, int n2) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XREVRANGE).key(string).add(string2).add(string3).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<byte[]>> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XRANGE).key(byArray).add(byArray2 == null ? "-" : (Object)byArray2).add(byArray3 == null ? "+" : (Object)byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XRANGE).key(byArray).add(byArray2 == null ? "-" : (Object)byArray2).add(byArray3 == null ? "+" : (Object)byArray3).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XREVRANGE).key(byArray).add(byArray2 == null ? "+" : (Object)byArray2).add(byArray3 == null ? "-" : (Object)byArray3), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xrevrange(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XREVRANGE).key(byArray).add(byArray2 == null ? "+" : (Object)byArray2).add(byArray3 == null ? "-" : (Object)byArray3).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Long> xack(String string, String string2, StreamEntryID ... streamEntryIDArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XACK).key(string).add(string2).addObjects(streamEntryIDArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xack(byte[] byArray, byte[] byArray2, byte[] ... byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XACK).key(byArray).add(byArray2).addObjects((Object[])byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<String> xgroupCreate(String string, String string2, StreamEntryID streamEntryID, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATE).key(string).add(string2).add(streamEntryID == null ? "0-0" : streamEntryID);
        if (bl) {
            commandArguments.add(Protocol.Keyword.MKSTREAM);
        }
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public final CommandObject<String> xgroupSetID(String string, String string2, StreamEntryID streamEntryID) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.SETID).key(string).add(string2).add(streamEntryID), BuilderFactory.STRING);
    }

    public final CommandObject<Long> xgroupDestroy(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DESTROY).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> xgroupCreateConsumer(String string, String string2, String string3) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATECONSUMER).key(string).add(string2).add(string3), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> xgroupDelConsumer(String string, String string2, String string3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DELCONSUMER).key(string).add(string2).add(string3), BuilderFactory.LONG);
    }

    public final CommandObject<String> xgroupCreate(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATE).key(byArray).add(byArray2).add(byArray3);
        if (bl) {
            commandArguments.add(Protocol.Keyword.MKSTREAM);
        }
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public final CommandObject<String> xgroupSetID(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.SETID).key(byArray).add(byArray2).add(byArray3), BuilderFactory.STRING);
    }

    public final CommandObject<Long> xgroupDestroy(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DESTROY).key(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Boolean> xgroupCreateConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Boolean>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.CREATECONSUMER).key(byArray).add(byArray2).add(byArray3), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> xgroupDelConsumer(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XGROUP).add(Protocol.Keyword.DELCONSUMER).key(byArray).add(byArray2).add(byArray3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xdel(String string, StreamEntryID ... streamEntryIDArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XDEL).key(string).addObjects(streamEntryIDArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(String string, long l2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XTRIM).key(string).add(Protocol.Keyword.MAXLEN);
        if (bl) {
            commandArguments.add(Protocol.BYTES_TILDE);
        }
        commandArguments.add(l2);
        return new CommandObject<Long>(commandArguments, BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(String string, XTrimParams xTrimParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XTRIM).key(string).addParams(xTrimParams), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xdel(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XDEL).key(byArray).addObjects((Object[])byArray2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(byte[] byArray, long l2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XTRIM).key(byArray).add(Protocol.Keyword.MAXLEN);
        if (bl) {
            commandArguments.add(Protocol.BYTES_TILDE);
        }
        commandArguments.add(l2);
        return new CommandObject<Long>(commandArguments, BuilderFactory.LONG);
    }

    public final CommandObject<Long> xtrim(byte[] byArray, XTrimParams xTrimParams) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.XTRIM).key(byArray).addParams(xTrimParams), BuilderFactory.LONG);
    }

    public final CommandObject<StreamPendingSummary> xpending(String string, String string2) {
        return new CommandObject<StreamPendingSummary>(this.commandArguments(Protocol.Command.XPENDING).key(string).add(string2), BuilderFactory.STREAM_PENDING_SUMMARY);
    }

    @Deprecated
    public final CommandObject<List<StreamPendingEntry>> xpending(String string, String string2, StreamEntryID streamEntryID, StreamEntryID streamEntryID2, int n2, String string3) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XPENDING).key(string).add(string2).add(streamEntryID == null ? "-" : streamEntryID).add(streamEntryID2 == null ? "+" : streamEntryID2).add(n2);
        if (string3 != null) {
            commandArguments.add(string3);
        }
        return new CommandObject<List<StreamPendingEntry>>(commandArguments, BuilderFactory.STREAM_PENDING_ENTRY_LIST);
    }

    public final CommandObject<List<StreamPendingEntry>> xpending(String string, String string2, XPendingParams xPendingParams) {
        return new CommandObject<List<StreamPendingEntry>>(this.commandArguments(Protocol.Command.XPENDING).key(string).add(string2).addParams(xPendingParams), BuilderFactory.STREAM_PENDING_ENTRY_LIST);
    }

    public final CommandObject<Object> xpending(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XPENDING).key(byArray).add(byArray2), BuilderFactory.RAW_OBJECT);
    }

    @Deprecated
    public final CommandObject<List<Object>> xpending(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, byte[] byArray5) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XPENDING).key(byArray).add(byArray2).add(byArray3 == null ? "-" : (Object)byArray3).add(byArray4 == null ? "+" : (Object)byArray4).add(n2);
        if (byArray5 != null) {
            commandArguments.add(byArray5);
        }
        return new CommandObject<List<Object>>(commandArguments, BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xpending(byte[] byArray, byte[] byArray2, XPendingParams xPendingParams) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XPENDING).key(byArray).add(byArray2).addParams(xPendingParams), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<StreamEntry>> xclaim(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return new CommandObject<List<StreamEntry>>(this.commandArguments(Protocol.Command.XCLAIM).key(string).add(string2).add(string3).add(l2).addObjects(streamEntryIDArray).addParams(xClaimParams), BuilderFactory.STREAM_ENTRY_LIST);
    }

    public final CommandObject<List<StreamEntryID>> xclaimJustId(String string, String string2, String string3, long l2, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDArray) {
        return new CommandObject<List<StreamEntryID>>(this.commandArguments(Protocol.Command.XCLAIM).key(string).add(string2).add(string3).add(l2).addObjects(streamEntryIDArray).addParams(xClaimParams).add(Protocol.Keyword.JUSTID), BuilderFactory.STREAM_ENTRY_ID_LIST);
    }

    public final CommandObject<Map.Entry<StreamEntryID, List<StreamEntry>>> xautoclaim(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return new CommandObject<Map.Entry<StreamEntryID, List<StreamEntry>>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(string).add(string2).add(string3).add(l2).add(streamEntryID).addParams(xAutoClaimParams), BuilderFactory.STREAM_AUTO_CLAIM_RESPONSE);
    }

    public final CommandObject<Map.Entry<StreamEntryID, List<StreamEntryID>>> xautoclaimJustId(String string, String string2, String string3, long l2, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return new CommandObject<Map.Entry<StreamEntryID, List<StreamEntryID>>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(string).add(string2).add(string3).add(l2).add(streamEntryID).addParams(xAutoClaimParams).add(Protocol.Keyword.JUSTID), BuilderFactory.STREAM_AUTO_CLAIM_ID_RESPONSE);
    }

    public final CommandObject<List<byte[]>> xclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XCLAIM).key(byArray).add(byArray2).add(byArray3).add(l2).addObjects((Object[])byArray4).addParams(xClaimParams), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, XClaimParams xClaimParams, byte[] ... byArray4) {
        return new CommandObject<List<byte[]>>(this.commandArguments(Protocol.Command.XCLAIM).key(byArray).add(byArray2).add(byArray3).add(l2).addObjects((Object[])byArray4).addParams(xClaimParams).add(Protocol.Keyword.JUSTID), BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<Object>> xautoclaim(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(byArray).add(byArray2).add(byArray3).add(l2).add(byArray4).addParams(xAutoClaimParams), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xautoclaimJustId(byte[] byArray, byte[] byArray2, byte[] byArray3, long l2, byte[] byArray4, XAutoClaimParams xAutoClaimParams) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XAUTOCLAIM).key(byArray).add(byArray2).add(byArray3).add(l2).add(byArray4).addParams(xAutoClaimParams).add(Protocol.Keyword.JUSTID), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<StreamInfo> xinfoStream(String string) {
        return new CommandObject<StreamInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(string), BuilderFactory.STREAM_INFO);
    }

    public final CommandObject<Object> xinfoStream(byte[] byArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(byArray), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<StreamFullInfo> xinfoStreamFull(String string) {
        return new CommandObject<StreamFullInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(string).add(Protocol.Keyword.FULL), BuilderFactory.STREAM_INFO_FULL);
    }

    public final CommandObject<StreamFullInfo> xinfoStreamFull(String string, int n2) {
        return new CommandObject<StreamFullInfo>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(string).add(Protocol.Keyword.FULL).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.STREAM_INFO_FULL);
    }

    public final CommandObject<Object> xinfoStreamFull(byte[] byArray, int n2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(byArray).add(Protocol.Keyword.FULL).add(Protocol.Keyword.COUNT).add(n2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> xinfoStreamFull(byte[] byArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.STREAM).key(byArray).add(Protocol.Keyword.FULL), BuilderFactory.RAW_OBJECT);
    }

    @Deprecated
    public final CommandObject<List<StreamGroupInfo>> xinfoGroup(String string) {
        return new CommandObject<List<StreamGroupInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(string), BuilderFactory.STREAM_GROUP_INFO_LIST);
    }

    public final CommandObject<List<StreamGroupInfo>> xinfoGroups(String string) {
        return new CommandObject<List<StreamGroupInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(string), BuilderFactory.STREAM_GROUP_INFO_LIST);
    }

    @Deprecated
    public final CommandObject<List<Object>> xinfoGroup(byte[] byArray) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(byArray), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> xinfoGroups(byte[] byArray) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.GROUPS).key(byArray), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<StreamConsumersInfo>> xinfoConsumers(String string, String string2) {
        return new CommandObject<List<StreamConsumersInfo>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.CONSUMERS).key(string).add(string2), BuilderFactory.STREAM_CONSUMERS_INFO_LIST);
    }

    public final CommandObject<List<Object>> xinfoConsumers(byte[] byArray, byte[] byArray2) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.XINFO).add(Protocol.Keyword.CONSUMERS).key(byArray).add(byArray2), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Map.Entry<String, List<StreamEntry>>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> map) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XREAD).addParams(xReadParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> set = map.entrySet();
        set.forEach(entry -> commandArguments.key(entry.getKey()));
        set.forEach(entry -> commandArguments.add(entry.getValue()));
        return new CommandObject<List<Map.Entry<String, List<StreamEntry>>>>(commandArguments, BuilderFactory.STREAM_READ_RESPONSE);
    }

    public final CommandObject<List<Map.Entry<String, List<StreamEntry>>>> xreadGroup(String string, String string2, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> map) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XREADGROUP).add(Protocol.Keyword.GROUP).add(string).add(string2).addParams(xReadGroupParams).add(Protocol.Keyword.STREAMS);
        Set<Map.Entry<String, StreamEntryID>> set = map.entrySet();
        set.forEach(entry -> commandArguments.key(entry.getKey()));
        set.forEach(entry -> commandArguments.add(entry.getValue()));
        return new CommandObject<List<Map.Entry<String, List<StreamEntry>>>>(commandArguments, BuilderFactory.STREAM_READ_RESPONSE);
    }

    public final CommandObject<List<byte[]>> xread(XReadParams xReadParams, Map.Entry<byte[], byte[]> ... entryArray) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XREAD).addParams(xReadParams).add(Protocol.Keyword.STREAMS);
        for (Map.Entry<byte[], byte[]> entry : entryArray) {
            commandArguments.key(entry.getKey());
        }
        for (Map.Entry<byte[], byte[]> entry : entryArray) {
            commandArguments.add(entry.getValue());
        }
        return new CommandObject<List<byte[]>>(commandArguments, BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<List<byte[]>> xreadGroup(byte[] byArray, byte[] byArray2, XReadGroupParams xReadGroupParams, Map.Entry<byte[], byte[]> ... entryArray) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.XREADGROUP).add(Protocol.Keyword.GROUP).add(byArray).add(byArray2).addParams(xReadGroupParams).add(Protocol.Keyword.STREAMS);
        for (Map.Entry<byte[], byte[]> entry : entryArray) {
            commandArguments.key(entry.getKey());
        }
        for (Map.Entry<byte[], byte[]> entry : entryArray) {
            commandArguments.add(entry.getValue());
        }
        return new CommandObject<List<byte[]>>(commandArguments, BuilderFactory.BINARY_LIST);
    }

    public final CommandObject<Object> eval(String string) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(string).add(0), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String string, String string2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(string).add(0).processKey(string2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String string, int n2, String ... stringArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(string).add(n2).addObjects(stringArray).processKeys(Arrays.copyOf(stringArray, n2)), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalReadonly(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL_RO).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] byArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(byArray).add(0), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(byArray).add(0).processKey(byArray2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] byArray, int n2, byte[] ... byArray2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(byArray).add(n2).addObjects((Object[])byArray2).processKeys((byte[][])Arrays.copyOf(byArray2, n2)), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> eval(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVAL_RO).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(String string) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(string).add(0), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String string, String string2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(string).add(0).processKey(string2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String string, int n2, String ... stringArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(string).add(n2).addObjects(stringArray).processKeys(Arrays.copyOf(stringArray, n2)), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalshaReadonly(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA_RO).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] byArray) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(byArray).add(0), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(byArray).add(0).processKey(byArray2), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] byArray, int n2, byte[] ... byArray2) {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(byArray).add(n2).addObjects((Object[])byArray2).processKeys((byte[][])Arrays.copyOf(byArray2, n2)), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalsha(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> evalshaReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.EVALSHA_RO).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<List<Boolean>> scriptExists(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects(stringArray).processKey(string), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<String> scriptLoad(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(string).processKey(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).processKey(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush(String string, FlushMode flushMode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).add(flushMode).processKey(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptKill(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL).processKey(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<Boolean>> scriptExists(byte[] byArray, byte[] ... byArray2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects((Object[])byArray2).processKey(byArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<byte[]> scriptLoad(byte[] byArray, byte[] byArray2) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(byArray).processKey(byArray2), BuilderFactory.BINARY);
    }

    public final CommandObject<String> scriptFlush(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).processKey(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptFlush(byte[] byArray, FlushMode flushMode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).add(flushMode).processKey(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> scriptKill(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL).processKey(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<Object> fcall(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<Object> fcallReadonly(String string, List<String> list, List<String> list2) {
        String[] stringArray = list.toArray(new String[list.size()]);
        String[] stringArray2 = list2.toArray(new String[list2.size()]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL_RO).add(string).add(stringArray.length).keys(stringArray).addObjects(stringArray2), BuilderFactory.ENCODED_OBJECT);
    }

    public final CommandObject<String> functionDelete(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DELETE).add(string), BuilderFactory.STRING);
    }

    public final CommandObject<List<LibraryInfo>> functionList() {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST), BuilderFactory.LIBRARY_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionList(String string) {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(string), BuilderFactory.LIBRARY_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionListWithCode() {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.WITHCODE), BuilderFactory.LIBRARY_LIST);
    }

    public final CommandObject<List<LibraryInfo>> functionListWithCode(String string) {
        return new CommandObject<List<LibraryInfo>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(string).add(Protocol.Keyword.WITHCODE), BuilderFactory.LIBRARY_LIST);
    }

    public final CommandObject<String> functionLoad(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionLoadReplace(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(Protocol.Keyword.REPLACE).add(string), BuilderFactory.STRING);
    }

    public final CommandObject<FunctionStats> functionStats() {
        return new CommandObject<FunctionStats>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.STATS), FunctionStats.FUNCTION_STATS_BUILDER);
    }

    public final CommandObject<Object> functionStatsBinary() {
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.STATS), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<String> functionFlush() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.FLUSH), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionFlush(FlushMode flushMode) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.FLUSH).add(flushMode), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionKill() {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.KILL), BuilderFactory.STRING);
    }

    public final CommandObject<Object> fcall(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<Object> fcallReadonly(byte[] byArray, List<byte[]> list, List<byte[]> list2) {
        byte[][] byArray2 = (byte[][])list.toArray((T[])new byte[list.size()][]);
        byte[][] byArray3 = (byte[][])list2.toArray((T[])new byte[list2.size()][]);
        return new CommandObject<Object>(this.commandArguments(Protocol.Command.FCALL_RO).add(byArray).add(byArray2.length).keys((Object[])byArray2).addObjects((Object[])byArray3), BuilderFactory.RAW_OBJECT);
    }

    public final CommandObject<String> functionDelete(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DELETE).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<byte[]> functionDump() {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.DUMP), BuilderFactory.BINARY);
    }

    public final CommandObject<List<Object>> functionListBinary() {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionList(byte[] byArray) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(byArray), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionListWithCodeBinary() {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.WITHCODE), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> functionListWithCode(byte[] byArray) {
        return new CommandObject<List<Object>>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LIST).add(Protocol.Keyword.LIBRARYNAME).add(byArray).add(Protocol.Keyword.WITHCODE), BuilderFactory.RAW_OBJECT_LIST);
    }

    public final CommandObject<String> functionLoad(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionLoadReplace(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Keyword.LOAD).add(Protocol.Keyword.REPLACE).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionRestore(byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Command.RESTORE).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> functionRestore(byte[] byArray, FunctionRestorePolicy functionRestorePolicy) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.FUNCTION).add(Protocol.Command.RESTORE).add(byArray).add(functionRestorePolicy.getRaw()), BuilderFactory.STRING);
    }

    @Deprecated
    public final CommandObject<LCSMatchResult> strAlgoLCSStrings(String string, String string2, StrAlgoLCSParams strAlgoLCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.STRALGO).add(Protocol.Keyword.LCS).add(Protocol.Keyword.STRINGS).add(string).add(string2).addParams(strAlgoLCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    @Deprecated
    public final CommandObject<LCSMatchResult> strAlgoLCSStrings(byte[] byArray, byte[] byArray2, StrAlgoLCSParams strAlgoLCSParams) {
        return new CommandObject<LCSMatchResult>(this.commandArguments(Protocol.Command.STRALGO).add(Protocol.Keyword.LCS).add(Protocol.Keyword.STRINGS).add(byArray).add(byArray2).addParams(strAlgoLCSParams), BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER);
    }

    public final CommandObject<Boolean> copy(String string, String string2, int n2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.COPY).key(string).key(string2).add(Protocol.Keyword.DB).add(n2);
        if (bl) {
            commandArguments.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(commandArguments, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> copy(byte[] byArray, byte[] byArray2, int n2, boolean bl) {
        CommandArguments commandArguments = this.commandArguments(Protocol.Command.COPY).key(byArray).key(byArray2).add(Protocol.Keyword.DB).add(n2);
        if (bl) {
            commandArguments.add(Protocol.Keyword.REPLACE);
        }
        return new CommandObject<Boolean>(commandArguments, BuilderFactory.BOOLEAN);
    }

    public final CommandObject<String> migrate(String string, int n2, String string2, int n3) {
        return this.migrate(string, n2, string2, 0, n3);
    }

    public final CommandObject<String> migrate(String string, int n2, String string2, int n3, int n4) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(string).add(n2).key(string2).add(n3).add(n4), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String string, int n2, int n3, MigrateParams migrateParams, String ... stringArray) {
        return this.migrate(string, n2, 0, n3, migrateParams, stringArray);
    }

    public final CommandObject<String> migrate(String string, int n2, int n3, int n4, MigrateParams migrateParams, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(string).add(n2).add(new byte[0]).add(n3).add(n4).addParams(migrateParams).add(Protocol.Keyword.KEYS).keys(stringArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String string, int n2, byte[] byArray, int n3) {
        return this.migrate(string, n2, byArray, 0, n3);
    }

    public final CommandObject<String> migrate(String string, int n2, byte[] byArray, int n3, int n4) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(string).add(n2).key(byArray).add(n3).add(n4), BuilderFactory.STRING);
    }

    public final CommandObject<String> migrate(String string, int n2, int n3, MigrateParams migrateParams, byte[] ... byArray) {
        return this.migrate(string, n2, 0, n3, migrateParams, byArray);
    }

    public final CommandObject<String> migrate(String string, int n2, int n3, int n4, MigrateParams migrateParams, byte[] ... byArray) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.MIGRATE).add(string).add(n2).add(new byte[0]).add(n3).add(n4).addParams(migrateParams).add(Protocol.Keyword.KEYS).keys((Object[])byArray), BuilderFactory.STRING);
    }

    public final CommandObject<Long> memoryUsage(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(String string, int n2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(string).add(Protocol.Keyword.SAMPLES).add(n2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> memoryUsage(byte[] byArray, int n2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.MEMORY).add(Protocol.Keyword.USAGE).key(byArray).add(Protocol.Keyword.SAMPLES).add(n2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectRefcount(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.REFCOUNT).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<String> objectEncoding(String string) {
        return new CommandObject<String>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.ENCODING).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<Long> objectIdletime(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.IDLETIME).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectFreq(String string) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.FREQ).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectRefcount(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.REFCOUNT).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<byte[]> objectEncoding(byte[] byArray) {
        return new CommandObject<byte[]>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.ENCODING).key(byArray), BuilderFactory.BINARY);
    }

    public final CommandObject<Long> objectIdletime(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.IDLETIME).key(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> objectFreq(byte[] byArray) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.OBJECT).add(Protocol.Keyword.FREQ).key(byArray), BuilderFactory.LONG);
    }

    public CommandObject<Long> waitReplicas(int n2, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(n2).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> waitReplicas(String string, int n2, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(n2).add(l2).processKey(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> waitReplicas(byte[] byArray, int n2, long l2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.WAIT).add(n2).add(l2).processKey(byArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> publish(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PUBLISH).add(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> publish(byte[] byArray, byte[] byArray2) {
        return new CommandObject<Long>(this.commandArguments(Protocol.Command.PUBLISH).add(byArray).add(byArray2), BuilderFactory.LONG);
    }

    public CommandObject<String> ftCreate(String string, IndexOptions indexOptions, Schema schema) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.CREATE).add(string).addParams(indexOptions).add(SearchProtocol.SearchKeyword.SCHEMA);
        schema.fields.forEach(field -> commandArguments.addParams((IParams)field));
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public CommandObject<String> ftCreate(String string, FTCreateParams fTCreateParams, Iterable<SchemaField> iterable) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.CREATE).add(string).addParams(fTCreateParams).add(SearchProtocol.SearchKeyword.SCHEMA);
        iterable.forEach(schemaField -> commandArguments.addParams((IParams)schemaField));
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public CommandObject<String> ftAlter(String string, Schema schema) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.ALTER).add(string).add(SearchProtocol.SearchKeyword.SCHEMA).add(SearchProtocol.SearchKeyword.ADD);
        schema.fields.forEach(field -> commandArguments.addParams((IParams)field));
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public CommandObject<String> ftAlter(String string, Iterable<SchemaField> iterable) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.ALTER).add(string).add(SearchProtocol.SearchKeyword.SCHEMA).add(SearchProtocol.SearchKeyword.ADD);
        iterable.forEach(schemaField -> commandArguments.addParams((IParams)schemaField));
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public CommandObject<SearchResult> ftSearch(String string, String string2) {
        return new CommandObject<SearchResult>(this.commandArguments(SearchProtocol.SearchCommand.SEARCH).add(string).add(string2), new SearchResult.SearchResultBuilder(true, false, false, true));
    }

    public CommandObject<SearchResult> ftSearch(String string, String string2, FTSearchParams fTSearchParams) {
        return new CommandObject<SearchResult>(this.commandArguments(SearchProtocol.SearchCommand.SEARCH).add(string).add(string2).addParams(fTSearchParams), new SearchResult.SearchResultBuilder(!fTSearchParams.getNoContent(), fTSearchParams.getWithScores(), false, true));
    }

    public CommandObject<SearchResult> ftSearch(String string, Query query) {
        return new CommandObject<SearchResult>(this.commandArguments(SearchProtocol.SearchCommand.SEARCH).add(string).addParams(query), new SearchResult.SearchResultBuilder(!query.getNoContent(), query.getWithScores(), query.getWithPayloads(), true));
    }

    public CommandObject<SearchResult> ftSearch(byte[] byArray, Query query) {
        return new CommandObject<SearchResult>(this.commandArguments(SearchProtocol.SearchCommand.SEARCH).add(byArray).addParams(query), new SearchResult.SearchResultBuilder(!query.getNoContent(), query.getWithScores(), query.getWithPayloads(), false));
    }

    public CommandObject<String> ftExplain(String string, Query query) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.EXPLAIN).add(string).addParams(query), BuilderFactory.STRING);
    }

    public CommandObject<List<String>> ftExplainCLI(String string, Query query) {
        return new CommandObject<List<String>>(this.commandArguments(SearchProtocol.SearchCommand.EXPLAINCLI).add(string).addParams(query), BuilderFactory.STRING_LIST);
    }

    public CommandObject<AggregationResult> ftAggregate(String string, AggregationBuilder aggregationBuilder) {
        return new CommandObject<AggregationResult>(this.commandArguments(SearchProtocol.SearchCommand.AGGREGATE).add(string).addObjects(aggregationBuilder.getArgs()), !aggregationBuilder.isWithCursor() ? BuilderFactory.SEARCH_AGGREGATION_RESULT : BuilderFactory.SEARCH_AGGREGATION_RESULT_WITH_CURSOR);
    }

    public CommandObject<AggregationResult> ftCursorRead(String string, long l2, int n2) {
        return new CommandObject<AggregationResult>(this.commandArguments(SearchProtocol.SearchCommand.CURSOR).add(SearchProtocol.SearchKeyword.READ).add(string).add(l2).add(n2), BuilderFactory.SEARCH_AGGREGATION_RESULT_WITH_CURSOR);
    }

    public CommandObject<String> ftCursorDel(String string, long l2) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.CURSOR).add(SearchProtocol.SearchKeyword.DEL).add(string).add(l2), BuilderFactory.STRING);
    }

    public CommandObject<String> ftDropIndex(String string) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.DROPINDEX).add(string), BuilderFactory.STRING);
    }

    public CommandObject<String> ftDropIndexDD(String string) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.DROPINDEX).add(string).add(SearchProtocol.SearchKeyword.DD), BuilderFactory.STRING);
    }

    public CommandObject<String> ftSynUpdate(String string, String string2, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.SYNUPDATE).add(string).add(string2).addObjects(stringArray), BuilderFactory.STRING);
    }

    public CommandObject<Map<String, List<String>>> ftSynDump(String string) {
        return new CommandObject<Map<String, List<String>>>(this.commandArguments(SearchProtocol.SearchCommand.SYNDUMP).add(string), BuilderFactory.SEARCH_SYNONYM_GROUPS);
    }

    public final CommandObject<Long> ftDictAdd(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.DICTADD).add(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ftDictDel(String string, String ... stringArray) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.DICTDEL).add(string).addObjects(stringArray), BuilderFactory.LONG);
    }

    public final CommandObject<Set<String>> ftDictDump(String string) {
        return new CommandObject<Set<String>>(this.commandArguments(SearchProtocol.SearchCommand.DICTDUMP).add(string), BuilderFactory.STRING_SET);
    }

    public final CommandObject<Long> ftDictAddBySampleKey(String string, String string2, String ... stringArray) {
        return this.addProcessKey(this.ftDictAdd(string2, stringArray), string);
    }

    public final CommandObject<Long> ftDictDelBySampleKey(String string, String string2, String ... stringArray) {
        return this.addProcessKey(this.ftDictDel(string2, stringArray), string);
    }

    public final CommandObject<Set<String>> ftDictDumpBySampleKey(String string, String string2) {
        return this.addProcessKey(this.ftDictDump(string2), string);
    }

    public CommandObject<Map<String, Object>> ftInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(SearchProtocol.SearchCommand.INFO).add(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public CommandObject<Set<String>> ftTagVals(String string, String string2) {
        return new CommandObject<Set<String>>(this.commandArguments(SearchProtocol.SearchCommand.TAGVALS).add(string).add(string2), BuilderFactory.STRING_SET);
    }

    public CommandObject<String> ftAliasAdd(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.ALIASADD).add(string).add(string2), BuilderFactory.STRING);
    }

    public CommandObject<String> ftAliasUpdate(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.ALIASUPDATE).add(string).add(string2), BuilderFactory.STRING);
    }

    public CommandObject<String> ftAliasDel(String string) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.ALIASDEL).add(string), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, String>> ftConfigGet(String string) {
        return new CommandObject<Map<String, String>>(this.commandArguments(SearchProtocol.SearchCommand.CONFIG).add(SearchProtocol.SearchKeyword.GET).add(string), BuilderFactory.STRING_MAP_FROM_PAIRS);
    }

    public CommandObject<Map<String, String>> ftConfigGet(String string, String string2) {
        return this.ftConfigGet(string2);
    }

    public final CommandObject<String> ftConfigSet(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(SearchProtocol.SearchCommand.CONFIG).add(SearchProtocol.SearchKeyword.SET).add(string).add(string2), BuilderFactory.STRING);
    }

    public CommandObject<String> ftConfigSet(String string, String string2, String string3) {
        return this.ftConfigSet(string2, string3);
    }

    public final CommandObject<Long> ftSugAdd(String string, String string2, double d2) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGADD).key(string).add(string2).add(d2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> ftSugAddIncr(String string, String string2, double d2) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGADD).key(string).add(string2).add(d2).add(SearchProtocol.SearchKeyword.INCR), BuilderFactory.LONG);
    }

    public final CommandObject<List<String>> ftSugGet(String string, String string2) {
        return new CommandObject<List<String>>(this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(string).add(string2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> ftSugGet(String string, String string2, boolean bl, int n2) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(string).add(string2);
        if (bl) {
            commandArguments.add(SearchProtocol.SearchKeyword.FUZZY);
        }
        commandArguments.add(SearchProtocol.SearchKeyword.MAX).add(n2);
        return new CommandObject<List<String>>(commandArguments, BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Tuple>> ftSugGetWithScores(String string, String string2) {
        return new CommandObject<List<Tuple>>(this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(string).add(string2).add(SearchProtocol.SearchKeyword.WITHSCORES), BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<List<Tuple>> ftSugGetWithScores(String string, String string2, boolean bl, int n2) {
        CommandArguments commandArguments = this.commandArguments(SearchProtocol.SearchCommand.SUGGET).key(string).add(string2);
        if (bl) {
            commandArguments.add(SearchProtocol.SearchKeyword.FUZZY);
        }
        commandArguments.add(SearchProtocol.SearchKeyword.MAX).add(n2);
        commandArguments.add(SearchProtocol.SearchKeyword.WITHSCORES);
        return new CommandObject<List<Tuple>>(commandArguments, BuilderFactory.TUPLE_LIST);
    }

    public final CommandObject<Boolean> ftSugDel(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(SearchProtocol.SearchCommand.SUGDEL).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> ftSugLen(String string) {
        return new CommandObject<Long>(this.commandArguments(SearchProtocol.SearchCommand.SUGLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<String> jsonSet(String string, Path2 path2, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path2).add(object), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSetWithEscape(String string, Path2 path2, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path2).add(GSON.toJson(object)), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSet(String string, Path path, Object object) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path).add(GSON.toJson(object)), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSetWithPlainString(String string, Path path, String string2) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path).add(string2), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSet(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path2).add(object).addParams(jsonSetParams), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSetWithEscape(String string, Path2 path2, Object object, JsonSetParams jsonSetParams) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path2).add(GSON.toJson(object)).addParams(jsonSetParams), BuilderFactory.STRING);
    }

    public final CommandObject<String> jsonSet(String string, Path path, Object object, JsonSetParams jsonSetParams) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.SET).key(string).add(path).add(GSON.toJson(object)).addParams(jsonSetParams), BuilderFactory.STRING);
    }

    public final CommandObject<Object> jsonGet(String string) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string), new GsonObjectBuilder<Object>(Object.class));
    }

    public final <T> CommandObject<T> jsonGet(String string, Class<T> clazz) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string), new GsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<Object> jsonGet(String string, Path2 ... path2Array) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string).addObjects(path2Array), BuilderFactory.JSON_OBJECT);
    }

    public final CommandObject<Object> jsonGet(String string, Path ... pathArray) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string).addObjects(pathArray), new GsonObjectBuilder<Object>(Object.class));
    }

    public final CommandObject<String> jsonGetAsPlainString(String string, Path path) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string).add(path), BuilderFactory.STRING);
    }

    public final <T> CommandObject<T> jsonGet(String string, Class<T> clazz, Path ... pathArray) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.GET).key(string).addObjects(pathArray), new GsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<JSONArray>> jsonMGet(Path2 path2, String ... stringArray) {
        return new CommandObject<List<JSONArray>>(this.commandArguments(JsonProtocol.JsonCommand.MGET).keys(stringArray).add(path2), BuilderFactory.JSON_ARRAY_LIST);
    }

    public final <T> CommandObject<List<T>> jsonMGet(Path path, Class<T> clazz, String ... stringArray) {
        return new CommandObject<List<T>>(this.commandArguments(JsonProtocol.JsonCommand.MGET).keys(stringArray).add(path), new GsonObjectListBuilder<T>(clazz));
    }

    public final CommandObject<Long> jsonDel(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonDel(String string, Path2 path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(string).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonDel(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEL).key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonClear(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonClear(String string, Path2 path2) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(string).add(path2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonClear(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.CLEAR).key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<List<Boolean>> jsonToggle(String string, Path2 path2) {
        return new CommandObject<List<Boolean>>(this.commandArguments(JsonProtocol.JsonCommand.TOGGLE).key(string).add(path2), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<String> jsonToggle(String string, Path path) {
        return new CommandObject<String>(this.commandArguments(JsonProtocol.JsonCommand.TOGGLE).key(string).add(path), BuilderFactory.STRING);
    }

    public final CommandObject<Class<?>> jsonType(String string) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(string), BuilderFactory.JSON_TYPE);
    }

    public final CommandObject<List<Class<?>>> jsonType(String string, Path2 path2) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(string).add(path2), BuilderFactory.JSON_TYPE_LIST);
    }

    public final CommandObject<Class<?>> jsonType(String string, Path path) {
        return new CommandObject(this.commandArguments(JsonProtocol.JsonCommand.TYPE).key(string).add(path), BuilderFactory.JSON_TYPE);
    }

    public final CommandObject<Long> jsonStrAppend(String string, Object object) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(string).add(GSON.toJson(object)), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonStrAppend(String string, Path2 path2, Object object) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(string).add(path2).add(GSON.toJson(object)), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonStrAppend(String string, Path path, Object object) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRAPPEND).key(string).add(path).add(GSON.toJson(object)), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonStrLen(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonStrLen(String string, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(string).add(path2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonStrLen(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.STRLEN).key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<JSONArray> jsonNumIncrBy(String string, Path2 path2, double d2) {
        return new CommandObject<JSONArray>(this.commandArguments(JsonProtocol.JsonCommand.NUMINCRBY).key(string).add(path2).add(d2), BuilderFactory.JSON_ARRAY);
    }

    public final CommandObject<Double> jsonNumIncrBy(String string, Path path, double d2) {
        return new CommandObject<Double>(this.commandArguments(JsonProtocol.JsonCommand.NUMINCRBY).key(string).add(path).add(d2), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Long> jsonArrAppend(String string, String string2, JSONObject ... jSONObjectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(string).add(string2);
        for (JSONObject jSONObject : jSONObjectArray) {
            commandArguments.add(jSONObject);
        }
        return new CommandObject<Long>(commandArguments, BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrAppend(String string, Path2 path2, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(string).add(path2).addObjects(objectArray);
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrAppendWithEscape(String string, Path2 path2, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(string).add(path2);
        for (Object object : objectArray) {
            commandArguments.add(GSON.toJson(object));
        }
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonArrAppend(String string, Path path, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRAPPEND).key(string).add(path);
        for (Object object : objectArray) {
            commandArguments.add(GSON.toJson(object));
        }
        return new CommandObject<Long>(commandArguments, BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrIndex(String string, Path2 path2, Object object) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(string).add(path2).add(object), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrIndexWithEscape(String string, Path2 path2, Object object) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(string).add(path2).add(GSON.toJson(object)), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonArrIndex(String string, Path path, Object object) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRINDEX).key(string).add(path).add(GSON.toJson(object)), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrInsert(String string, Path2 path2, int n2, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(string).add(path2).add(n2).addObjects(objectArray);
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> jsonArrInsertWithEscape(String string, Path2 path2, int n2, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(string).add(path2).add(n2);
        for (Object object : objectArray) {
            commandArguments.add(GSON.toJson(object));
        }
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonArrInsert(String string, Path path, int n2, Object ... objectArray) {
        CommandArguments commandArguments = this.commandArguments(JsonProtocol.JsonCommand.ARRINSERT).key(string).add(path).add(n2);
        for (Object object : objectArray) {
            commandArguments.add(GSON.toJson(object));
        }
        return new CommandObject<Long>(commandArguments, BuilderFactory.LONG);
    }

    public final CommandObject<Object> jsonArrPop(String string) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string), new GsonObjectBuilder<Object>(Object.class));
    }

    public final <T> CommandObject<T> jsonArrPop(String string, Class<T> clazz) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string), new GsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<Object>> jsonArrPop(String string, Path2 path2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path2), new GsonObjectListBuilder<Object>(Object.class));
    }

    public final CommandObject<Object> jsonArrPop(String string, Path path) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path), new GsonObjectBuilder<Object>(Object.class));
    }

    public final <T> CommandObject<T> jsonArrPop(String string, Class<T> clazz, Path path) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path), new GsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<List<Object>> jsonArrPop(String string, Path2 path2, int n2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path2).add(n2), new GsonObjectListBuilder<Object>(Object.class));
    }

    public final CommandObject<Object> jsonArrPop(String string, Path path, int n2) {
        return new CommandObject<Object>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path).add(n2), new GsonObjectBuilder<Object>(Object.class));
    }

    public final <T> CommandObject<T> jsonArrPop(String string, Class<T> clazz, Path path, int n2) {
        return new CommandObject<T>(this.commandArguments(JsonProtocol.JsonCommand.ARRPOP).key(string).add(path).add(n2), new GsonObjectBuilder<T>(clazz));
    }

    public final CommandObject<Long> jsonArrLen(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrLen(String string, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(string).add(path2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonArrLen(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRLEN).key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonArrTrim(String string, Path2 path2, int n2, int n3) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.ARRTRIM).key(string).add(path2).add(n2).add(n3), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> jsonArrTrim(String string, Path path, int n2, int n3) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.ARRTRIM).key(string).add(path).add(n2).add(n3), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonObjLen(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonObjLen(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonObjLen(String string, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.OBJLEN).key(string).add(path2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<String>> jsonObjKeys(String string) {
        return new CommandObject<List<String>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(string), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> jsonObjKeys(String string, Path path) {
        return new CommandObject<List<String>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(string).add(path), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<List<String>>> jsonObjKeys(String string, Path2 path2) {
        return new CommandObject<List<List<String>>>(this.commandArguments(JsonProtocol.JsonCommand.OBJKEYS).key(string).add(path2), BuilderFactory.STRING_LIST_LIST);
    }

    public final CommandObject<Long> jsonDebugMemory(String string) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(string), BuilderFactory.LONG);
    }

    public final CommandObject<Long> jsonDebugMemory(String string, Path path) {
        return new CommandObject<Long>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(string).add(path), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> jsonDebugMemory(String string, Path2 path2) {
        return new CommandObject<List<Long>>(this.commandArguments(JsonProtocol.JsonCommand.DEBUG).add("MEMORY").key(string).add(path2), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Object>> jsonResp(String string) {
        return new CommandObject<List<Object>>(this.commandArguments(JsonProtocol.JsonCommand.RESP).key(string), BuilderFactory.ENCODED_OBJECT_LIST);
    }

    public final CommandObject<List<Object>> jsonResp(String string, Path path) {
        return new CommandObject<List<Object>>(this.commandArguments(JsonProtocol.JsonCommand.RESP).key(string).add(path), BuilderFactory.ENCODED_OBJECT_LIST);
    }

    public final CommandObject<List<List<Object>>> jsonResp(String string, Path2 path2) {
        return new CommandObject<List<List<Object>>>(this.commandArguments(JsonProtocol.JsonCommand.RESP).key(string).add(path2), BuilderFactory.ENCODED_OBJECT_LIST_LIST);
    }

    public final CommandObject<String> tsCreate(String string) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATE).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsCreate(String string, TSCreateParams tSCreateParams) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATE).key(string).addParams(tSCreateParams), BuilderFactory.STRING);
    }

    public final CommandObject<Long> tsDel(String string, long l2, long l3) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DEL).key(string).add(l2).add(l3), BuilderFactory.LONG);
    }

    public final CommandObject<String> tsAlter(String string, TSAlterParams tSAlterParams) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ALTER).key(string).addParams(tSAlterParams), BuilderFactory.STRING);
    }

    public final CommandObject<Long> tsAdd(String string, double d2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(string).add(Protocol.BYTES_ASTERISK).add(d2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsAdd(String string, long l2, double d2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(string).add(l2).add(d2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsAdd(String string, long l2, double d2, TSCreateParams tSCreateParams) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.ADD).key(string).add(l2).add(d2).addParams(tSCreateParams), BuilderFactory.LONG);
    }

    public final CommandObject<List<Long>> tsMAdd(Map.Entry<String, TSElement> ... entryArray) {
        CommandArguments commandArguments = this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MADD);
        for (Map.Entry<String, TSElement> entry : entryArray) {
            commandArguments.key(entry.getKey()).add(entry.getValue().getTimestamp()).add(entry.getValue().getValue());
        }
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<Long> tsIncrBy(String string, double d2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INCRBY).key(string).add(d2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsIncrBy(String string, double d2, long l2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INCRBY).key(string).add(d2).add(TimeSeriesProtocol.TimeSeriesKeyword.TIMESTAMP).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsDecrBy(String string, double d2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DECRBY).key(string).add(d2), BuilderFactory.LONG);
    }

    public final CommandObject<Long> tsDecrBy(String string, double d2, long l2) {
        return new CommandObject<Long>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DECRBY).key(string).add(d2).add(TimeSeriesProtocol.TimeSeriesKeyword.TIMESTAMP).add(l2), BuilderFactory.LONG);
    }

    public final CommandObject<List<TSElement>> tsRange(String string, long l2, long l3) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.RANGE).key(string).add(l2).add(l3), BuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRange(String string, TSRangeParams tSRangeParams) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.RANGE).key(string).addParams(tSRangeParams), BuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRevRange(String string, long l2, long l3) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.REVRANGE).key(string).add(l2).add(l3), BuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSElement>> tsRevRange(String string, TSRangeParams tSRangeParams) {
        return new CommandObject<List<TSElement>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.REVRANGE).key(string).addParams(tSRangeParams), BuilderFactory.TIMESERIES_ELEMENT_LIST);
    }

    public final CommandObject<List<TSKeyedElements>> tsMRange(long l2, long l3, String ... stringArray) {
        return new CommandObject<List<TSKeyedElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MRANGE).add(l2).add(l3).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(stringArray), BuilderFactory.TIMESERIES_MRANGE_RESPONSE);
    }

    public final CommandObject<List<TSKeyedElements>> tsMRange(TSMRangeParams tSMRangeParams) {
        return new CommandObject<List<TSKeyedElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MRANGE).addParams(tSMRangeParams), BuilderFactory.TIMESERIES_MRANGE_RESPONSE);
    }

    public final CommandObject<List<TSKeyedElements>> tsMRevRange(long l2, long l3, String ... stringArray) {
        return new CommandObject<List<TSKeyedElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MREVRANGE).add(l2).add(l3).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(stringArray), BuilderFactory.TIMESERIES_MRANGE_RESPONSE);
    }

    public final CommandObject<List<TSKeyedElements>> tsMRevRange(TSMRangeParams tSMRangeParams) {
        return new CommandObject<List<TSKeyedElements>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MREVRANGE).addParams(tSMRangeParams), BuilderFactory.TIMESERIES_MRANGE_RESPONSE);
    }

    public final CommandObject<TSElement> tsGet(String string) {
        return new CommandObject<TSElement>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.GET).key(string), BuilderFactory.TIMESERIES_ELEMENT);
    }

    public final CommandObject<TSElement> tsGet(String string, TSGetParams tSGetParams) {
        return new CommandObject<TSElement>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.GET).key(string).addParams(tSGetParams), BuilderFactory.TIMESERIES_ELEMENT);
    }

    public final CommandObject<List<TSKeyValue<TSElement>>> tsMGet(TSMGetParams tSMGetParams, String ... stringArray) {
        return new CommandObject<List<TSKeyValue<TSElement>>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.MGET).addParams(tSMGetParams).add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER).addObjects(stringArray), BuilderFactory.TIMESERIES_MGET_RESPONSE);
    }

    public final CommandObject<String> tsCreateRule(String string, String string2, AggregationType aggregationType, long l2) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATERULE).key(string).key(string2).add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(aggregationType).add(l2), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsCreateRule(String string, String string2, AggregationType aggregationType, long l2, long l3) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.CREATERULE).key(string).key(string2).add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(aggregationType).add(l2).add(l3), BuilderFactory.STRING);
    }

    public final CommandObject<String> tsDeleteRule(String string, String string2) {
        return new CommandObject<String>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.DELETERULE).key(string).key(string2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> tsQueryIndex(String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.QUERYINDEX).addObjects(stringArray), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<TSInfo> tsInfo(String string) {
        return new CommandObject<TSInfo>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INFO).key(string), TSInfo.TIMESERIES_INFO);
    }

    public final CommandObject<TSInfo> tsInfoDebug(String string) {
        return new CommandObject<TSInfo>(this.commandArguments(TimeSeriesProtocol.TimeSeriesCommand.INFO).key(string).add(TimeSeriesProtocol.TimeSeriesKeyword.DEBUG), TSInfo.TIMESERIES_INFO);
    }

    public final CommandObject<String> bfReserve(String string, double d2, long l2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.RESERVE).key(string).add(d2).add(l2), BuilderFactory.STRING);
    }

    public final CommandObject<String> bfReserve(String string, double d2, long l2, BFReserveParams bFReserveParams) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.RESERVE).key(string).add(d2).add(l2).addParams(bFReserveParams), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> bfAdd(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.ADD).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> bfMAdd(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.MADD).key(string).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> bfInsert(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INSERT).key(string).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_WITH_ERROR_LIST);
    }

    public final CommandObject<List<Boolean>> bfInsert(String string, BFInsertParams bFInsertParams, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INSERT).key(string).addParams(bFInsertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_WITH_ERROR_LIST);
    }

    public final CommandObject<Boolean> bfExists(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.EXISTS).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> bfMExists(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.MEXISTS).key(string).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Map.Entry<Long, byte[]>> bfScanDump(String string, long l2) {
        return new CommandObject<Map.Entry<Long, byte[]>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.SCANDUMP).key(string).add(l2), BuilderFactory.BLOOM_SCANDUMP_RESPONSE);
    }

    public final CommandObject<String> bfLoadChunk(String string, long l2, byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.LOADCHUNK).key(string).add(l2).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> bfInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.BloomFilterCommand.INFO).key(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> cfReserve(String string, long l2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.RESERVE).key(string).add(l2), BuilderFactory.STRING);
    }

    public final CommandObject<String> cfReserve(String string, long l2, CFReserveParams cFReserveParams) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.RESERVE).key(string).add(l2).addParams(cFReserveParams), BuilderFactory.STRING);
    }

    public final CommandObject<Boolean> cfAdd(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.ADD).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Boolean> cfAddNx(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.ADDNX).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> cfInsert(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERT).key(string).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsert(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERT).key(string).addParams(cFInsertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsertNx(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERTNX).key(string).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Boolean>> cfInsertNx(String string, CFInsertParams cFInsertParams, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INSERTNX).key(string).addParams(cFInsertParams).add(RedisBloomProtocol.RedisBloomKeyword.ITEMS).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Boolean> cfExists(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.EXISTS).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<List<Boolean>> cfMExists(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.MEXISTS).key(string).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<Boolean> cfDel(String string, String string2) {
        return new CommandObject<Boolean>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.DEL).key(string).add(string2), BuilderFactory.BOOLEAN);
    }

    public final CommandObject<Long> cfCount(String string, String string2) {
        return new CommandObject<Long>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.COUNT).key(string).add(string2), BuilderFactory.LONG);
    }

    public final CommandObject<Map.Entry<Long, byte[]>> cfScanDump(String string, long l2) {
        return new CommandObject<Map.Entry<Long, byte[]>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.SCANDUMP).key(string).add(l2), BuilderFactory.BLOOM_SCANDUMP_RESPONSE);
    }

    public final CommandObject<String> cfLoadChunk(String string, long l2, byte[] byArray) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.LOADCHUNK).key(string).add(l2).add(byArray), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> cfInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.CuckooFilterCommand.INFO).key(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> cmsInitByDim(String string, long l2, long l3) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INITBYDIM).key(string).add(l2).add(l3), BuilderFactory.STRING);
    }

    public final CommandObject<String> cmsInitByProb(String string, double d2, double d3) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INITBYPROB).key(string).add(d2).add(d3), BuilderFactory.STRING);
    }

    public final CommandObject<List<Long>> cmsIncrBy(String string, Map<String, Long> map) {
        CommandArguments commandArguments = this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INCRBY).key(string);
        map.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        return new CommandObject<List<Long>>(commandArguments, BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> cmsQuery(String string, String ... stringArray) {
        return new CommandObject<List<Long>>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.QUERY).key(string).addObjects(stringArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<String> cmsMerge(String string, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.MERGE).key(string).add(stringArray.length).keys(stringArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> cmsMerge(String string, Map<String, Long> map) {
        CommandArguments commandArguments = this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.MERGE).key(string);
        commandArguments.add(map.size());
        map.entrySet().forEach(entry -> commandArguments.key(entry.getKey()));
        commandArguments.add(RedisBloomProtocol.RedisBloomKeyword.WEIGHTS);
        map.entrySet().forEach(entry -> commandArguments.add(entry.getValue()));
        return new CommandObject<String>(commandArguments, BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> cmsInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.CountMinSketchCommand.INFO).key(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> topkReserve(String string, long l2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TopKCommand.RESERVE).key(string).add(l2), BuilderFactory.STRING);
    }

    public final CommandObject<String> topkReserve(String string, long l2, long l3, long l4, double d2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TopKCommand.RESERVE).key(string).add(l2).add(l3).add(l4).add(d2), BuilderFactory.STRING);
    }

    public final CommandObject<List<String>> topkAdd(String string, String ... stringArray) {
        return new CommandObject<List<String>>(this.commandArguments(RedisBloomProtocol.TopKCommand.ADD).key(string).addObjects(stringArray), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> topkIncrBy(String string, Map<String, Long> map) {
        CommandArguments commandArguments = this.commandArguments(RedisBloomProtocol.TopKCommand.INCRBY).key(string);
        map.entrySet().forEach(entry -> commandArguments.add(entry.getKey()).add(entry.getValue()));
        return new CommandObject<List<String>>(commandArguments, BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<Boolean>> topkQuery(String string, String ... stringArray) {
        return new CommandObject<List<Boolean>>(this.commandArguments(RedisBloomProtocol.TopKCommand.QUERY).key(string).addObjects(stringArray), BuilderFactory.BOOLEAN_LIST);
    }

    public final CommandObject<List<Long>> topkCount(String string, String ... stringArray) {
        return new CommandObject<List<Long>>(this.commandArguments(RedisBloomProtocol.TopKCommand.COUNT).key(string).addObjects(stringArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<String>> topkList(String string) {
        return new CommandObject<List<String>>(this.commandArguments(RedisBloomProtocol.TopKCommand.LIST).key(string), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<Map<String, Object>> topkInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.TopKCommand.INFO).key(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> tdigestCreate(String string) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.CREATE).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestCreate(String string, int n2) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.CREATE).key(string).add(RedisBloomProtocol.RedisBloomKeyword.COMPRESSION).add(n2), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestReset(String string) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.RESET).key(string), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestMerge(String string, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MERGE).key(string).add(stringArray.length).keys(stringArray), BuilderFactory.STRING);
    }

    public final CommandObject<String> tdigestMerge(TDigestMergeParams tDigestMergeParams, String string, String ... stringArray) {
        return new CommandObject<String>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MERGE).key(string).add(stringArray.length).keys(stringArray).addParams(tDigestMergeParams), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> tdigestInfo(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(RedisBloomProtocol.TDigestCommand.INFO).key(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    public final CommandObject<String> tdigestAdd(String string, double ... dArray) {
        return new CommandObject<String>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.ADD).key(string), dArray), BuilderFactory.STRING);
    }

    public final CommandObject<List<Double>> tdigestCDF(String string, double ... dArray) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.CDF).key(string), dArray), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<List<Double>> tdigestQuantile(String string, double ... dArray) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.QUANTILE).key(string), dArray), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<Double> tdigestMin(String string) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MIN).key(string), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> tdigestMax(String string) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.MAX).key(string), BuilderFactory.DOUBLE);
    }

    public final CommandObject<Double> tdigestTrimmedMean(String string, double d2, double d3) {
        return new CommandObject<Double>(this.commandArguments(RedisBloomProtocol.TDigestCommand.TRIMMED_MEAN).key(string).add(d2).add(d3), BuilderFactory.DOUBLE);
    }

    public final CommandObject<List<Long>> tdigestRank(String string, double ... dArray) {
        return new CommandObject<List<Long>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.RANK).key(string), dArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Long>> tdigestRevRank(String string, double ... dArray) {
        return new CommandObject<List<Long>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.REVRANK).key(string), dArray), BuilderFactory.LONG_LIST);
    }

    public final CommandObject<List<Double>> tdigestByRank(String string, long ... lArray) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.BYRANK).key(string), lArray), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<List<Double>> tdigestByRevRank(String string, long ... lArray) {
        return new CommandObject<List<Double>>(this.addFlatArgs(this.commandArguments(RedisBloomProtocol.TDigestCommand.BYREVRANK).key(string), lArray), BuilderFactory.DOUBLE_LIST);
    }

    public final CommandObject<List<String>> graphList() {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.LIST), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> graphProfile(String string, String string2) {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.PROFILE).key(string).add(string2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<String>> graphExplain(String string, String string2) {
        return new CommandObject<List<String>>(this.commandArguments(GraphProtocol.GraphCommand.EXPLAIN).key(string).add(string2), BuilderFactory.STRING_LIST);
    }

    public final CommandObject<List<List<String>>> graphSlowlog(String string) {
        return new CommandObject<List<List<String>>>(this.commandArguments(GraphProtocol.GraphCommand.SLOWLOG).key(string), BuilderFactory.STRING_LIST_LIST);
    }

    public final CommandObject<String> graphConfigSet(String string, Object object) {
        return new CommandObject<String>(this.commandArguments(GraphProtocol.GraphCommand.CONFIG).add(GraphProtocol.GraphKeyword.SET).add(string).add(object), BuilderFactory.STRING);
    }

    public final CommandObject<Map<String, Object>> graphConfigGet(String string) {
        return new CommandObject<Map<String, Object>>(this.commandArguments(GraphProtocol.GraphCommand.CONFIG).add(GraphProtocol.GraphKeyword.GET).add(string), BuilderFactory.ENCODED_OBJECT_MAP);
    }

    private CommandArguments addFlatArgs(CommandArguments commandArguments, long ... lArray) {
        for (long l2 : lArray) {
            commandArguments.add(l2);
        }
        return commandArguments;
    }

    private CommandArguments addFlatArgs(CommandArguments commandArguments, double ... dArray) {
        for (double d2 : dArray) {
            commandArguments.add(d2);
        }
        return commandArguments;
    }

    private CommandArguments addFlatKeyValueArgs(CommandArguments commandArguments, String ... stringArray) {
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            commandArguments.key(stringArray[i2]).add(stringArray[i2 + 1]);
        }
        return commandArguments;
    }

    private CommandArguments addFlatKeyValueArgs(CommandArguments commandArguments, byte[] ... byArray) {
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            commandArguments.key(byArray[i2]).add(byArray[i2 + 1]);
        }
        return commandArguments;
    }

    private CommandArguments addFlatMapArgs(CommandArguments commandArguments, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            commandArguments.add(entry.getKey());
            commandArguments.add(entry.getValue());
        }
        return commandArguments;
    }

    private CommandArguments addSortedSetFlatMapArgs(CommandArguments commandArguments, Map<?, Double> map) {
        for (Map.Entry<?, Double> entry : map.entrySet()) {
            commandArguments.add(entry.getValue());
            commandArguments.add(entry.getKey());
        }
        return commandArguments;
    }

    private CommandArguments addGeoCoordinateFlatMapArgs(CommandArguments commandArguments, Map<?, GeoCoordinate> map) {
        for (Map.Entry<?, GeoCoordinate> entry : map.entrySet()) {
            GeoCoordinate geoCoordinate = entry.getValue();
            commandArguments.add(geoCoordinate.getLongitude());
            commandArguments.add(geoCoordinate.getLatitude());
            commandArguments.add(entry.getKey());
        }
        return commandArguments;
    }

    private <T> CommandObject<T> addProcessKey(CommandObject<T> commandObject, String string) {
        commandObject.getArguments().processKey(string);
        return commandObject;
    }

    private class GsonObjectListBuilder<T>
    extends Builder<List<T>> {
        private final Class<T> clazz;

        public GsonObjectListBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public List<T> build(Object object) {
            if (object == null) {
                return null;
            }
            List<String> list = BuilderFactory.STRING_LIST.build(object);
            return list.stream().map(string -> GSON.fromJson((String)string, this.clazz)).collect(Collectors.toList());
        }
    }

    private class GsonObjectBuilder<T>
    extends Builder<T> {
        private final Class<T> clazz;

        public GsonObjectBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T build(Object object) {
            return GSON.fromJson(BuilderFactory.STRING.build(object), this.clazz);
        }
    }
}

