/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import me.ulrich.clans.library.redis.jedis.args.Rawable;
import me.ulrich.clans.library.redis.jedis.args.RawableFactory;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.params.IParams;

public class CommandArguments
implements Iterable<Rawable> {
    private final ArrayList<Rawable> args;
    private boolean blocking;

    private CommandArguments() {
        throw new InstantiationError();
    }

    public CommandArguments(ProtocolCommand protocolCommand) {
        this.args = new ArrayList();
        this.args.add(protocolCommand);
    }

    public ProtocolCommand getCommand() {
        return (ProtocolCommand)this.args.get(0);
    }

    public CommandArguments add(Object object) {
        if (object instanceof Rawable) {
            this.args.add((Rawable)object);
        } else if (object instanceof byte[]) {
            this.args.add(RawableFactory.from((byte[])object));
        } else if (object instanceof String) {
            this.args.add(RawableFactory.from((String)object));
        } else if (object instanceof Boolean) {
            this.args.add(RawableFactory.from(Integer.toString((Boolean)object != false ? 1 : 0)));
        } else {
            if (object == null) {
                throw new IllegalArgumentException("null is not a valid argument.");
            }
            this.args.add(RawableFactory.from(String.valueOf(object)));
        }
        return this;
    }

    public CommandArguments addObjects(Object ... objectArray) {
        for (Object object : objectArray) {
            this.add(object);
        }
        return this;
    }

    public CommandArguments addObjects(Collection collection) {
        collection.forEach(object -> this.add(object));
        return this;
    }

    @Deprecated
    public CommandArguments addObjects(int[] nArray) {
        for (int n2 : nArray) {
            this.add(n2);
        }
        return this;
    }

    public CommandArguments key(Object object) {
        if (object instanceof Rawable) {
            Rawable rawable = (Rawable)object;
            this.processKey(rawable.getRaw());
            this.args.add(rawable);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.processKey(byArray);
            this.args.add(RawableFactory.from(byArray));
        } else if (object instanceof String) {
            String string = (String)object;
            this.processKey(string);
            this.args.add(RawableFactory.from(string));
        } else {
            throw new IllegalArgumentException("\"" + object.toString() + "\" is not a valid argument.");
        }
        return this;
    }

    public final CommandArguments keys(Object ... objectArray) {
        for (Object object : objectArray) {
            this.key(object);
        }
        return this;
    }

    public final CommandArguments addParams(IParams iParams) {
        iParams.addParams(this);
        return this;
    }

    protected CommandArguments processKey(byte[] byArray) {
        return this;
    }

    protected final CommandArguments processKeys(byte[] ... byArray) {
        for (byte[] byArray2 : byArray) {
            this.processKey(byArray2);
        }
        return this;
    }

    protected CommandArguments processKey(String string) {
        return this;
    }

    protected final CommandArguments processKeys(String ... stringArray) {
        for (String string : stringArray) {
            this.processKey(string);
        }
        return this;
    }

    public int size() {
        return this.args.size();
    }

    @Override
    public Iterator<Rawable> iterator() {
        return this.args.iterator();
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public CommandArguments blocking() {
        this.blocking = true;
        return this;
    }
}

