/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.Set;
import me.ulrich.clans.library.redis.jedis.ClusterCommandArguments;
import me.ulrich.clans.library.redis.jedis.ClusterCommandObjects;
import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.HostAndPort;
import me.ulrich.clans.library.redis.jedis.JedisClientConfig;
import me.ulrich.clans.library.redis.jedis.MultiNodePipelineBase;
import me.ulrich.clans.library.redis.jedis.providers.ClusterConnectionProvider;
import me.ulrich.clans.library.redis.jedis.util.IOUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ClusterPipeline
extends MultiNodePipelineBase {
    private final ClusterConnectionProvider provider;
    private AutoCloseable closeable = null;

    public ClusterPipeline(Set<HostAndPort> set, JedisClientConfig jedisClientConfig) {
        this(new ClusterConnectionProvider(set, jedisClientConfig));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> set, JedisClientConfig jedisClientConfig, GenericObjectPoolConfig<Connection> genericObjectPoolConfig) {
        this(new ClusterConnectionProvider(set, jedisClientConfig, genericObjectPoolConfig));
        this.closeable = this.provider;
    }

    public ClusterPipeline(ClusterConnectionProvider clusterConnectionProvider) {
        super(new ClusterCommandObjects());
        this.provider = clusterConnectionProvider;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            IOUtils.closeQuietly(this.closeable);
        }
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments commandArguments) {
        return this.provider.getNode(((ClusterCommandArguments)commandArguments).getCommandHashSlot());
    }

    @Override
    protected Connection getConnection(HostAndPort hostAndPort) {
        return this.provider.getConnection(hostAndPort);
    }

    public void prepareGraphCommands() {
        super.prepareGraphCommands(this.provider);
    }
}

