/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.ulrich.clans.library.redis.jedis.BuilderFactory;
import me.ulrich.clans.library.redis.jedis.ClusterCommandArguments;
import me.ulrich.clans.library.redis.jedis.CommandObject;
import me.ulrich.clans.library.redis.jedis.CommandObjects;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.params.ScanParams;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.search.IndexOptions;
import me.ulrich.clans.library.redis.jedis.search.Query;
import me.ulrich.clans.library.redis.jedis.search.Schema;
import me.ulrich.clans.library.redis.jedis.search.SearchResult;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationBuilder;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.util.JedisClusterHashTag;

public class ClusterCommandObjects
extends CommandObjects {
    private static final String CLUSTER_UNSUPPORTED_MESSAGE = "Not supported in cluster mode.";
    private static final String KEYS_PATTERN_MESSAGE = "Cluster mode only supports KEYS command with pattern containing hash-tag ( curly-brackets enclosed string )";
    private static final String SCAN_PATTERN_MESSAGE = "Cluster mode only supports SCAN command with MATCH pattern containing hash-tag ( curly-brackets enclosed string )";

    @Override
    protected ClusterCommandArguments commandArguments(ProtocolCommand protocolCommand) {
        return new ClusterCommandArguments(protocolCommand);
    }

    @Override
    public CommandObject<Long> dbSize() {
        throw new UnsupportedOperationException(CLUSTER_UNSUPPORTED_MESSAGE);
    }

    @Override
    public final CommandObject<Set<String>> keys(String string) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(string)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<String>>(this.commandArguments(Protocol.Command.KEYS).key(string).processKey(string), BuilderFactory.STRING_SET);
    }

    @Override
    public final CommandObject<Set<byte[]>> keys(byte[] byArray) {
        if (!JedisClusterHashTag.isClusterCompliantMatchPattern(byArray)) {
            throw new IllegalArgumentException(KEYS_PATTERN_MESSAGE);
        }
        return new CommandObject<Set<byte[]>>(this.commandArguments(Protocol.Command.KEYS).key(byArray).processKey(byArray), BuilderFactory.BINARY_SET);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams) {
        String string2 = scanParams.match();
        if (string2 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(string2)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams).processKey(string2), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<String>> scan(String string, ScanParams scanParams, String string2) {
        String string3 = scanParams.match();
        if (string3 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(string3)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<String>>(this.commandArguments(Protocol.Command.SCAN).add(string).addParams(scanParams).processKey(string3).add(Protocol.Keyword.TYPE).add(string2), BuilderFactory.SCAN_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray) {
        throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams) {
        byte[] byArray2 = scanParams.binaryMatch();
        if (byArray2 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(byArray2)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams).processKey(byArray2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    @Override
    public final CommandObject<ScanResult<byte[]>> scan(byte[] byArray, ScanParams scanParams, byte[] byArray2) {
        byte[] byArray3 = scanParams.binaryMatch();
        if (byArray3 == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(byArray3)) {
            throw new IllegalArgumentException(SCAN_PATTERN_MESSAGE);
        }
        return new CommandObject<ScanResult<byte[]>>(this.commandArguments(Protocol.Command.SCAN).add(byArray).addParams(scanParams).processKey(byArray3).add(Protocol.Keyword.TYPE).add(byArray2), BuilderFactory.SCAN_BINARY_RESPONSE);
    }

    @Override
    public final CommandObject<Long> waitReplicas(int n2, long l2) {
        throw new UnsupportedOperationException(CLUSTER_UNSUPPORTED_MESSAGE);
    }

    private <T> CommandObject<T> processSearchCommand(String string, CommandObject<T> commandObject) {
        commandObject.getArguments().processKey(string);
        return commandObject;
    }

    @Override
    public final CommandObject<String> ftCreate(String string, IndexOptions indexOptions, Schema schema) {
        return this.processSearchCommand(string, super.ftCreate(string, indexOptions, schema));
    }

    @Override
    public final CommandObject<String> ftAlter(String string, Schema schema) {
        return this.processSearchCommand(string, super.ftAlter(string, schema));
    }

    @Override
    public final CommandObject<SearchResult> ftSearch(String string, Query query) {
        return this.processSearchCommand(string, super.ftSearch(string, query));
    }

    @Override
    public final CommandObject<SearchResult> ftSearch(byte[] byArray, Query query) {
        CommandObject<SearchResult> commandObject = super.ftSearch(byArray, query);
        commandObject.getArguments().processKey(byArray);
        return commandObject;
    }

    @Override
    public CommandObject<String> ftExplain(String string, Query query) {
        return this.processSearchCommand(string, super.ftExplain(string, query));
    }

    @Override
    public CommandObject<List<String>> ftExplainCLI(String string, Query query) {
        return this.processSearchCommand(string, super.ftExplainCLI(string, query));
    }

    @Override
    public CommandObject<AggregationResult> ftAggregate(String string, AggregationBuilder aggregationBuilder) {
        return this.processSearchCommand(string, super.ftAggregate(string, aggregationBuilder));
    }

    @Override
    public CommandObject<AggregationResult> ftCursorRead(String string, long l2, int n2) {
        return this.processSearchCommand(string, super.ftCursorRead(string, l2, n2));
    }

    @Override
    public CommandObject<String> ftCursorDel(String string, long l2) {
        return this.processSearchCommand(string, super.ftCursorDel(string, l2));
    }

    @Override
    public CommandObject<String> ftDropIndex(String string) {
        return this.processSearchCommand(string, super.ftDropIndex(string));
    }

    @Override
    public CommandObject<String> ftDropIndexDD(String string) {
        return this.processSearchCommand(string, super.ftDropIndexDD(string));
    }

    @Override
    public CommandObject<String> ftSynUpdate(String string, String string2, String ... stringArray) {
        return this.processSearchCommand(string, super.ftSynUpdate(string, string2, stringArray));
    }

    @Override
    public CommandObject<Map<String, List<String>>> ftSynDump(String string) {
        return this.processSearchCommand(string, super.ftSynDump(string));
    }

    @Override
    public CommandObject<Map<String, Object>> ftInfo(String string) {
        return this.processSearchCommand(string, super.ftInfo(string));
    }

    @Override
    public CommandObject<Set<String>> ftTagVals(String string, String string2) {
        return this.processSearchCommand(string, super.ftTagVals(string, string2));
    }

    @Override
    public CommandObject<String> ftAliasAdd(String string, String string2) {
        return this.processSearchCommand(string2, super.ftAliasAdd(string, string2));
    }

    @Override
    public CommandObject<String> ftAliasUpdate(String string, String string2) {
        return this.processSearchCommand(string2, super.ftAliasUpdate(string, string2));
    }

    @Override
    public CommandObject<String> ftAliasDel(String string) {
        return this.processSearchCommand(string, super.ftAliasDel(string));
    }

    @Override
    public CommandObject<Map<String, String>> ftConfigGet(String string, String string2) {
        return this.processSearchCommand(string, super.ftConfigGet(string, string2));
    }

    @Override
    public CommandObject<String> ftConfigSet(String string, String string2, String string3) {
        return this.processSearchCommand(string, super.ftConfigSet(string, string2, string3));
    }
}

