/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import me.ulrich.clans.library.redis.jedis.CommandArguments;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisClusterOperationException;
import me.ulrich.clans.library.redis.jedis.util.JedisClusterCRC16;

public class ClusterCommandArguments
extends CommandArguments {
    private int commandHashSlot = -1;

    public ClusterCommandArguments(ProtocolCommand protocolCommand) {
        super(protocolCommand);
    }

    public int getCommandHashSlot() {
        return this.commandHashSlot;
    }

    @Override
    protected CommandArguments processKey(byte[] byArray) {
        int n2 = JedisClusterCRC16.getSlot(byArray);
        if (this.commandHashSlot < 0) {
            this.commandHashSlot = n2;
        } else if (this.commandHashSlot != n2) {
            throw new JedisClusterOperationException("Keys must belong to same hashslot.");
        }
        return this;
    }

    @Override
    protected CommandArguments processKey(String string) {
        int n2 = JedisClusterCRC16.getSlot(string);
        if (this.commandHashSlot < 0) {
            this.commandHashSlot = n2;
        } else if (this.commandHashSlot != n2) {
            throw new JedisClusterOperationException("Keys must belong to same hashslot.");
        }
        return this;
    }
}

