/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.ulrich.clans.library.redis.jedis.Builder;
import me.ulrich.clans.library.redis.jedis.GeoCoordinate;
import me.ulrich.clans.library.redis.jedis.Module;
import me.ulrich.clans.library.redis.jedis.StreamEntryID;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;
import me.ulrich.clans.library.redis.jedis.resps.AccessControlLogEntry;
import me.ulrich.clans.library.redis.jedis.resps.AccessControlUser;
import me.ulrich.clans.library.redis.jedis.resps.CommandDocument;
import me.ulrich.clans.library.redis.jedis.resps.CommandInfo;
import me.ulrich.clans.library.redis.jedis.resps.GeoRadiusResponse;
import me.ulrich.clans.library.redis.jedis.resps.KeyedListElement;
import me.ulrich.clans.library.redis.jedis.resps.KeyedZSetElement;
import me.ulrich.clans.library.redis.jedis.resps.LCSMatchResult;
import me.ulrich.clans.library.redis.jedis.resps.LibraryInfo;
import me.ulrich.clans.library.redis.jedis.resps.ScanResult;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumerFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamConsumersInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupFullInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamGroupInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamInfo;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingEntry;
import me.ulrich.clans.library.redis.jedis.resps.StreamPendingSummary;
import me.ulrich.clans.library.redis.jedis.resps.Tuple;
import me.ulrich.clans.library.redis.jedis.search.aggr.AggregationResult;
import me.ulrich.clans.library.redis.jedis.timeseries.TSElement;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyValue;
import me.ulrich.clans.library.redis.jedis.timeseries.TSKeyedElements;
import me.ulrich.clans.library.redis.jedis.util.DoublePrecision;
import me.ulrich.clans.library.redis.jedis.util.JedisByteHashMap;
import me.ulrich.clans.library.redis.jedis.util.KeyValue;
import me.ulrich.clans.library.redis.jedis.util.SafeEncoder;
import org.json.JSONArray;
import org.json.JSONObject;

public final class BuilderFactory {
    public static final Builder<Object> RAW_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object object) {
            return object;
        }

        public String toString() {
            return "Object";
        }
    };
    public static final Builder<List<Object>> RAW_OBJECT_LIST = new Builder<List<Object>>(){

        @Override
        public List<Object> build(Object object) {
            return (List)object;
        }

        public String toString() {
            return "List<Object>";
        }
    };
    public static final Builder<Object> ENCODED_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object object) {
            return SafeEncoder.encodeObject(object);
        }

        public String toString() {
            return "Object";
        }
    };
    public static final Builder<List<Object>> ENCODED_OBJECT_LIST = new Builder<List<Object>>(){

        @Override
        public List<Object> build(Object object) {
            return (List)SafeEncoder.encodeObject(object);
        }

        public String toString() {
            return "List<Object>";
        }
    };
    public static final Builder<Map<String, Object>> ENCODED_OBJECT_MAP = new Builder<Map<String, Object>>(){

        @Override
        public Map<String, Object> build(Object object) {
            List list = (List)object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashMap.put(STRING.build(iterator.next()), ENCODED_OBJECT.build(iterator.next()));
            }
            return hashMap;
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        @Override
        public Long build(Object object) {
            return (Long)object;
        }

        public String toString() {
            return "Long";
        }
    };
    public static final Builder<List<Long>> LONG_LIST = new Builder<List<Long>>(){

        @Override
        public List<Long> build(Object object) {
            if (null == object) {
                return null;
            }
            return (List)object;
        }

        public String toString() {
            return "List<Long>";
        }
    };
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        @Override
        public Double build(Object object) {
            return DoublePrecision.parseFloatingPointNumber(STRING.build(object));
        }

        public String toString() {
            return "Double";
        }
    };
    public static final Builder<List<Double>> DOUBLE_LIST = new Builder<List<Double>>(){

        @Override
        public List<Double> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
            for (byte[] byArray : list) {
                arrayList.add(DOUBLE.build(byArray));
            }
            return arrayList;
        }

        public String toString() {
            return "List<Double>";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        @Override
        public Boolean build(Object object) {
            if (object == null) {
                return null;
            }
            return (Long)object == 1L;
        }

        public String toString() {
            return "Boolean";
        }
    };
    public static final Builder<List<Boolean>> BOOLEAN_LIST = new Builder<List<Boolean>>(){

        @Override
        public List<Boolean> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(list.size());
            for (Long l2 : list) {
                arrayList.add(l2 == null ? null : Boolean.valueOf(l2 == 1L));
            }
            return arrayList;
        }

        public String toString() {
            return "List<Boolean>";
        }
    };
    public static final Builder<List<Boolean>> BOOLEAN_WITH_ERROR_LIST = new Builder<List<Boolean>>(){

        @Override
        public List<Boolean> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(list.size());
            for (Object e2 : list) {
                Boolean bl = null;
                if (e2 != null && e2 instanceof Long) {
                    long l2 = (Long)e2;
                    if (l2 == 1L) {
                        bl = Boolean.TRUE;
                    } else if (l2 == 0L) {
                        bl = Boolean.FALSE;
                    }
                }
                arrayList.add(bl);
            }
            return arrayList;
        }

        public String toString() {
            return "List<Boolean>";
        }
    };
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object object) {
            return (byte[])object;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object object) {
            if (null == object) {
                return null;
            }
            return (List)object;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<byte[]> BINARY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object object) {
            return (byte[])object;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<List<byte[]>> BINARY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object object) {
            return (List)object;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BINARY_SET = new Builder<Set<byte[]>>(){

        @Override
        public Set<byte[]> build(Object object) {
            if (null == object) {
                return null;
            }
            List<byte[]> list = BINARY_LIST.build(object);
            return SetFromList.of(list);
        }

        public String toString() {
            return "Set<byte[]>";
        }
    };
    public static final Builder<Map<byte[], byte[]>> BINARY_MAP = new Builder<Map<byte[], byte[]>>(){

        @Override
        public Map<byte[], byte[]> build(Object object) {
            List list = (List)object;
            JedisByteHashMap jedisByteHashMap = new JedisByteHashMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                jedisByteHashMap.put(iterator.next(), iterator.next());
            }
            return jedisByteHashMap;
        }

        public String toString() {
            return "Map<byte[], byte[]>";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        @Override
        public String build(Object object) {
            return object == null ? null : SafeEncoder.encode((byte[])object);
        }

        public String toString() {
            return "String";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        @Override
        public List<String> build(Object object) {
            if (null == object) {
                return null;
            }
            return ((List)object).stream().map(STRING::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object object) {
            if (null == object) {
                return null;
            }
            return ((List)object).stream().map(STRING::build).collect(Collectors.toSet());
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<Set<String>> STRING_ORDERED_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object object) {
            if (null == object) {
                return null;
            }
            return ((List)object).stream().map(STRING::build).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object object) {
            List list = (List)object;
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashMap.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
            }
            return hashMap;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<KeyedListElement> KEYED_LIST_ELEMENT = new Builder<KeyedListElement>(){

        @Override
        public KeyedListElement build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return new KeyedListElement((byte[])list.get(0), (byte[])list.get(1));
        }

        public String toString() {
            return "KeyedListElement";
        }
    };
    public static final Builder<KeyValue<String, List<String>>> KEYED_STRING_LIST = new Builder<KeyValue<String, List<String>>>(){

        @Override
        public KeyValue<String, List<String>> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return new KeyValue<String, List<String>>(STRING.build(list.get(0)), STRING_LIST.build(list.get(1)));
        }

        public String toString() {
            return "KeyValue<String, List<String>>";
        }
    };
    public static final Builder<List<KeyValue<String, List<String>>>> KEYED_STRING_LIST_LIST = new Builder<List<KeyValue<String, List<String>>>>(){

        @Override
        public List<KeyValue<String, List<String>>> build(Object object) {
            List list = (List)object;
            return list.stream().map(KEYED_STRING_LIST::build).collect(Collectors.toList());
        }
    };
    public static final Builder<KeyValue<byte[], List<byte[]>>> KEYED_BINARY_LIST = new Builder<KeyValue<byte[], List<byte[]>>>(){

        @Override
        public KeyValue<byte[], List<byte[]>> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return new KeyValue<byte[], List<byte[]>>(BINARY.build(list.get(0)), BINARY_LIST.build(list.get(1)));
        }

        public String toString() {
            return "KeyValue<byte[], List<byte[]>>";
        }
    };
    public static final Builder<Tuple> TUPLE = new Builder<Tuple>(){

        @Override
        public Tuple build(Object object) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            return new Tuple((byte[])list.get(0), DOUBLE.build(list.get(1)));
        }

        public String toString() {
            return "Tuple";
        }
    };
    public static final Builder<KeyedZSetElement> KEYED_ZSET_ELEMENT = new Builder<KeyedZSetElement>(){

        @Override
        public KeyedZSetElement build(Object object) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            return new KeyedZSetElement((byte[])list.get(0), (byte[])list.get(1), DOUBLE.build(list.get(2)));
        }

        public String toString() {
            return "KeyedZSetElement";
        }
    };
    public static final Builder<List<Tuple>> TUPLE_LIST = new Builder<List<Tuple>>(){

        @Override
        public List<Tuple> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>(list.size() / 2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return arrayList;
        }

        public String toString() {
            return "List<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            LinkedHashSet<Tuple> linkedHashSet = new LinkedHashSet<Tuple>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                linkedHashSet.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    private static final Builder<List<Tuple>> TUPLE_LIST_FROM_PAIRS = new Builder<List<Tuple>>(){

        @Override
        public List<Tuple> build(Object object2) {
            if (object2 == null) {
                return null;
            }
            return ((List)object2).stream().map(object -> (List)object).map(list -> TUPLE.build(list)).collect(Collectors.toList());
        }

        public String toString() {
            return "List<Tuple>";
        }
    };
    public static final Builder<KeyValue<String, List<Tuple>>> KEYED_TUPLE_LIST = new Builder<KeyValue<String, List<Tuple>>>(){

        @Override
        public KeyValue<String, List<Tuple>> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return new KeyValue<String, List<Tuple>>(STRING.build(list.get(0)), (List<Tuple>)TUPLE_LIST_FROM_PAIRS.build(list.get(1)));
        }

        public String toString() {
            return "KeyValue<String, List<Tuple>>";
        }
    };
    public static final Builder<KeyValue<byte[], List<Tuple>>> BINARY_KEYED_TUPLE_LIST = new Builder<KeyValue<byte[], List<Tuple>>>(){

        @Override
        public KeyValue<byte[], List<Tuple>> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return new KeyValue<byte[], List<Tuple>>(BINARY.build(list.get(0)), (List<Tuple>)TUPLE_LIST_FROM_PAIRS.build(list.get(1)));
        }

        public String toString() {
            return "KeyValue<byte[], List<Tuple>>";
        }
    };
    public static final Builder<ScanResult<String>> SCAN_RESPONSE = new Builder<ScanResult<String>>(){

        @Override
        public ScanResult<String> build(Object object) {
            List list = (List)object;
            String string = new String((byte[])list.get(0));
            List list2 = (List)list.get(1);
            ArrayList<String> arrayList = new ArrayList<String>(list2.size());
            for (byte[] byArray : list2) {
                arrayList.add(SafeEncoder.encode(byArray));
            }
            return new ScanResult<String>(string, arrayList);
        }
    };
    public static final Builder<ScanResult<Map.Entry<String, String>>> HSCAN_RESPONSE = new Builder<ScanResult<Map.Entry<String, String>>>(){

        @Override
        public ScanResult<Map.Entry<String, String>> build(Object object) {
            List list = (List)object;
            String string = new String((byte[])list.get(0));
            List list2 = (List)list.get(1);
            ArrayList<AbstractMap.SimpleEntry<String, String>> arrayList = new ArrayList<AbstractMap.SimpleEntry<String, String>>(list2.size() / 2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
            }
            return new ScanResult<Map.Entry<String, String>>(string, arrayList);
        }
    };
    public static final Builder<ScanResult<String>> SSCAN_RESPONSE = new Builder<ScanResult<String>>(){

        @Override
        public ScanResult<String> build(Object object) {
            List list = (List)object;
            String string = new String((byte[])list.get(0));
            List list2 = (List)list.get(1);
            ArrayList<String> arrayList = new ArrayList<String>(list2.size());
            for (byte[] byArray : list2) {
                arrayList.add(SafeEncoder.encode(byArray));
            }
            return new ScanResult<String>(string, arrayList);
        }
    };
    public static final Builder<ScanResult<Tuple>> ZSCAN_RESPONSE = new Builder<ScanResult<Tuple>>(){

        @Override
        public ScanResult<Tuple> build(Object object) {
            List list = (List)object;
            String string = new String((byte[])list.get(0));
            List list2 = (List)list.get(1);
            ArrayList<Tuple> arrayList = new ArrayList<Tuple>(list2.size() / 2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return new ScanResult<Tuple>(string, arrayList);
        }
    };
    public static final Builder<ScanResult<byte[]>> SCAN_BINARY_RESPONSE = new Builder<ScanResult<byte[]>>(){

        @Override
        public ScanResult<byte[]> build(Object object) {
            List list = (List)object;
            byte[] byArray = (byte[])list.get(0);
            List list2 = (List)list.get(1);
            return new ScanResult<byte[]>(byArray, list2);
        }
    };
    public static final Builder<ScanResult<Map.Entry<byte[], byte[]>>> HSCAN_BINARY_RESPONSE = new Builder<ScanResult<Map.Entry<byte[], byte[]>>>(){

        @Override
        public ScanResult<Map.Entry<byte[], byte[]>> build(Object object) {
            List list = (List)object;
            byte[] byArray = (byte[])list.get(0);
            List list2 = (List)list.get(1);
            ArrayList arrayList = new ArrayList(list2.size() / 2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new AbstractMap.SimpleEntry(iterator.next(), iterator.next()));
            }
            return new ScanResult<Map.Entry<byte[], byte[]>>(byArray, arrayList);
        }
    };
    public static final Builder<ScanResult<byte[]>> SSCAN_BINARY_RESPONSE = new Builder<ScanResult<byte[]>>(){

        @Override
        public ScanResult<byte[]> build(Object object) {
            List list = (List)object;
            byte[] byArray = (byte[])list.get(0);
            List list2 = (List)list.get(1);
            return new ScanResult<byte[]>(byArray, list2);
        }
    };
    public static final Builder<Map<String, Long>> PUBSUB_NUMSUB_MAP = new Builder<Map<String, Long>>(){

        @Override
        public Map<String, Long> build(Object object) {
            List list = (List)object;
            HashMap<String, Long> hashMap = new HashMap<String, Long>(list.size() / 2, 1.0f);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashMap.put(SafeEncoder.encode((byte[])iterator.next()), (Long)iterator.next());
            }
            return hashMap;
        }

        public String toString() {
            return "PUBSUB_NUMSUB_MAP<String, String>";
        }
    };
    public static final Builder<List<GeoCoordinate>> GEO_COORDINATE_LIST = new Builder<List<GeoCoordinate>>(){

        @Override
        public List<GeoCoordinate> build(Object object) {
            if (null == object) {
                return null;
            }
            return this.interpretGeoposResult((List)object);
        }

        public String toString() {
            return "List<GeoCoordinate>";
        }

        private List<GeoCoordinate> interpretGeoposResult(List<Object> list) {
            ArrayList<GeoCoordinate> arrayList = new ArrayList<GeoCoordinate>(list.size());
            for (Object object : list) {
                if (object == null) {
                    arrayList.add(null);
                    continue;
                }
                List list2 = (List)object;
                GeoCoordinate geoCoordinate = new GeoCoordinate(DOUBLE.build(list2.get(0)), DOUBLE.build(list2.get(1)));
                arrayList.add(geoCoordinate);
            }
            return arrayList;
        }
    };
    public static final Builder<List<GeoRadiusResponse>> GEORADIUS_WITH_PARAMS_RESULT = new Builder<List<GeoRadiusResponse>>(){

        @Override
        public List<GeoRadiusResponse> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            ArrayList<GeoRadiusResponse> arrayList = new ArrayList<GeoRadiusResponse>(list.size());
            if (list.isEmpty()) {
                return arrayList;
            }
            if (list.get(0) instanceof List) {
                for (Object e2 : list) {
                    List list2 = (List)e2;
                    GeoRadiusResponse geoRadiusResponse = new GeoRadiusResponse((byte[])list2.get(0));
                    int n2 = list2.size();
                    for (int i2 = 1; i2 < n2; ++i2) {
                        Object e3 = list2.get(i2);
                        if (e3 instanceof List) {
                            List list3 = (List)e3;
                            geoRadiusResponse.setCoordinate(new GeoCoordinate(DOUBLE.build(list3.get(0)), DOUBLE.build(list3.get(1))));
                            continue;
                        }
                        if (e3 instanceof Long) {
                            geoRadiusResponse.setRawScore(LONG.build(e3));
                            continue;
                        }
                        geoRadiusResponse.setDistance(DOUBLE.build(e3));
                    }
                    arrayList.add(geoRadiusResponse);
                }
            } else {
                for (Object e4 : list) {
                    arrayList.add(new GeoRadiusResponse((byte[])e4));
                }
            }
            return arrayList;
        }

        public String toString() {
            return "GeoRadiusWithParamsResult";
        }
    };
    public static final Builder<Map<String, CommandDocument>> COMMAND_DOCS_RESPONSE = new Builder<Map<String, CommandDocument>>(){

        @Override
        public Map<String, CommandDocument> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            HashMap<String, CommandDocument> hashMap = new HashMap<String, CommandDocument>(list.size() / 2, 1.0f);
            int n2 = 0;
            while (n2 < list.size()) {
                String string = STRING.build(list.get(n2++));
                CommandDocument commandDocument = CommandDocument.COMMAND_DOCUMENT_BUILDER.build(list.get(n2++));
                hashMap.put(string, commandDocument);
            }
            return hashMap;
        }
    };
    public static final Builder<Map<String, CommandInfo>> COMMAND_INFO_RESPONSE = new Builder<Map<String, CommandInfo>>(){

        @Override
        public Map<String, CommandInfo> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            HashMap<String, CommandInfo> hashMap = new HashMap<String, CommandInfo>(list.size());
            for (Object e2 : list) {
                if (e2 == null) continue;
                List list2 = (List)e2;
                String string = STRING.build(list2.get(0));
                CommandInfo commandInfo = CommandInfo.COMMAND_INFO_BUILDER.build(list2);
                hashMap.put(string, commandInfo);
            }
            return hashMap;
        }
    };
    public static final Builder<List<Module>> MODULE_LIST = new Builder<List<Module>>(){

        @Override
        public List<Module> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            ArrayList<Module> arrayList = new ArrayList<Module>(list.size());
            if (list.isEmpty()) {
                return arrayList;
            }
            for (List list2 : list) {
                Module module = new Module(SafeEncoder.encode((byte[])list2.get(1)), ((Long)list2.get(3)).intValue());
                arrayList.add(module);
            }
            return arrayList;
        }

        public String toString() {
            return "List<Module>";
        }
    };
    public static final Builder<AccessControlUser> ACCESS_CONTROL_USER = new Builder<AccessControlUser>(){

        @Override
        public AccessControlUser build(Object object) {
            boolean bl;
            Object object2;
            Object object32;
            if (object == null) {
                return null;
            }
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            AccessControlUser accessControlUser = new AccessControlUser();
            List list2 = (List)list.get(1);
            for (Object object32 : list2) {
                accessControlUser.addFlag(SafeEncoder.encode((byte[])object32));
            }
            List list3 = (List)list.get(3);
            object32 = list3.iterator();
            while (object32.hasNext()) {
                object2 = object32.next();
                accessControlUser.addPassword(SafeEncoder.encode((byte[])object2));
            }
            accessControlUser.setCommands(SafeEncoder.encode((byte[])list.get(5)));
            boolean bl2 = bl = list.size() >= 12;
            if (!bl) {
                Object object4;
                object2 = (List)list.get(7);
                Object object5 = object2.iterator();
                while (object5.hasNext()) {
                    object4 = object5.next();
                    accessControlUser.addKey(SafeEncoder.encode((byte[])object4));
                }
                if (list.size() >= 10) {
                    object5 = (List)list.get(9);
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        Object e2 = object4.next();
                        accessControlUser.addChannel(SafeEncoder.encode((byte[])e2));
                    }
                }
            } else {
                accessControlUser.addKeys(SafeEncoder.encode((byte[])list.get(7)));
                accessControlUser.addChannels(SafeEncoder.encode((byte[])list.get(9)));
            }
            return accessControlUser;
        }

        public String toString() {
            return "AccessControlUser";
        }
    };
    public static final Builder<List<AccessControlLogEntry>> ACCESS_CONTROL_LOG_ENTRY_LIST = new Builder<List<AccessControlLogEntry>>(){
        private final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("count", LONG);
            hashMap.put("reason", STRING);
            hashMap.put("context", STRING);
            hashMap.put("object", STRING);
            hashMap.put("username", STRING);
            hashMap.put("age-seconds", STRING);
            hashMap.put("client-info", STRING);
            return hashMap;
        }

        @Override
        public List<AccessControlLogEntry> build(Object object) {
            if (null == object) {
                return null;
            }
            ArrayList<AccessControlLogEntry> arrayList = new ArrayList<AccessControlLogEntry>();
            List list = (List)object;
            for (List list2 : list) {
                Iterator iterator = list2.iterator();
                AccessControlLogEntry accessControlLogEntry = new AccessControlLogEntry(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
                arrayList.add(accessControlLogEntry);
            }
            return arrayList;
        }

        public String toString() {
            return "List<AccessControlLogEntry>";
        }
    };
    public static final Builder<StreamEntryID> STREAM_ENTRY_ID = new Builder<StreamEntryID>(){

        @Override
        public StreamEntryID build(Object object) {
            if (null == object) {
                return null;
            }
            String string = SafeEncoder.encode((byte[])object);
            return new StreamEntryID(string);
        }

        public String toString() {
            return "StreamEntryID";
        }
    };
    public static final Builder<List<StreamEntryID>> STREAM_ENTRY_ID_LIST = new Builder<List<StreamEntryID>>(){

        @Override
        public List<StreamEntryID> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<StreamEntryID> arrayList = new ArrayList<StreamEntryID>(list.size());
            if (!list.isEmpty()) {
                for (Object e2 : list) {
                    arrayList.add(STREAM_ENTRY_ID.build(e2));
                }
            }
            return arrayList;
        }
    };
    public static final Builder<StreamEntry> STREAM_ENTRY = new Builder<StreamEntry>(){

        @Override
        public StreamEntry build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            String string = SafeEncoder.encode((byte[])list.get(0));
            StreamEntryID streamEntryID = new StreamEntryID(string);
            List list2 = (List)list.get(1);
            Iterator iterator = list2.iterator();
            HashMap<String, String> hashMap = new HashMap<String, String>(list2.size() / 2, 1.0f);
            while (iterator.hasNext()) {
                hashMap.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
            }
            return new StreamEntry(streamEntryID, hashMap);
        }

        public String toString() {
            return "StreamEntry";
        }
    };
    public static final Builder<List<StreamEntry>> STREAM_ENTRY_LIST = new Builder<List<StreamEntry>>(){

        @Override
        public List<StreamEntry> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<StreamEntry> arrayList = new ArrayList<StreamEntry>(list.size() / 2);
            if (list.isEmpty()) {
                return arrayList;
            }
            for (ArrayList arrayList2 : list) {
                if (arrayList2 == null) {
                    arrayList.add(null);
                    continue;
                }
                String string = SafeEncoder.encode((byte[])arrayList2.get(0));
                StreamEntryID streamEntryID = new StreamEntryID(string);
                List list2 = (List)arrayList2.get(1);
                if (list2 == null) {
                    arrayList.add(new StreamEntry(streamEntryID, null));
                    continue;
                }
                Iterator iterator = list2.iterator();
                HashMap<String, String> hashMap = new HashMap<String, String>(list2.size() / 2, 1.0f);
                while (iterator.hasNext()) {
                    hashMap.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
                }
                arrayList.add(new StreamEntry(streamEntryID, hashMap));
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamEntry>";
        }
    };
    public static final Builder<Map.Entry<StreamEntryID, List<StreamEntry>>> STREAM_AUTO_CLAIM_RESPONSE = new Builder<Map.Entry<StreamEntryID, List<StreamEntry>>>(){

        @Override
        public Map.Entry<StreamEntryID, List<StreamEntry>> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            return new AbstractMap.SimpleEntry<StreamEntryID, List<StreamEntry>>(STREAM_ENTRY_ID.build(list.get(0)), STREAM_ENTRY_LIST.build(list.get(1)));
        }

        public String toString() {
            return "Map.Entry<StreamEntryID, List<StreamEntry>>";
        }
    };
    public static final Builder<Map.Entry<StreamEntryID, List<StreamEntryID>>> STREAM_AUTO_CLAIM_ID_RESPONSE = new Builder<Map.Entry<StreamEntryID, List<StreamEntryID>>>(){

        @Override
        public Map.Entry<StreamEntryID, List<StreamEntryID>> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            return new AbstractMap.SimpleEntry<StreamEntryID, List<StreamEntryID>>(STREAM_ENTRY_ID.build(list.get(0)), STREAM_ENTRY_ID_LIST.build(list.get(1)));
        }

        public String toString() {
            return "Map.Entry<StreamEntryID, List<StreamEntryID>>";
        }
    };
    public static final Builder<List<Map.Entry<String, List<StreamEntry>>>> STREAM_READ_RESPONSE = new Builder<List<Map.Entry<String, List<StreamEntry>>>>(){

        @Override
        public List<Map.Entry<String, List<StreamEntry>>> build(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            ArrayList<Map.Entry<String, List<StreamEntry>>> arrayList = new ArrayList<Map.Entry<String, List<StreamEntry>>>(list.size());
            for (Object e2 : list) {
                List list2 = (List)e2;
                String string = SafeEncoder.encode((byte[])list2.get(0));
                List<StreamEntry> list3 = STREAM_ENTRY_LIST.build(list2.get(1));
                arrayList.add(new AbstractMap.SimpleEntry<String, List<StreamEntry>>(string, list3));
            }
            return arrayList;
        }

        public String toString() {
            return "List<Entry<String, List<StreamEntry>>>";
        }
    };
    public static final Builder<List<StreamPendingEntry>> STREAM_PENDING_ENTRY_LIST = new Builder<List<StreamPendingEntry>>(){

        @Override
        public List<StreamPendingEntry> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<StreamPendingEntry> arrayList = new ArrayList<StreamPendingEntry>(list.size());
            for (Object e2 : list) {
                List list2 = (List)e2;
                String string = SafeEncoder.encode((byte[])list2.get(0));
                String string2 = SafeEncoder.encode((byte[])list2.get(1));
                long l2 = LONG.build(list2.get(2));
                long l3 = LONG.build(list2.get(3));
                arrayList.add(new StreamPendingEntry(new StreamEntryID(string), string2, l2, l3));
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamPendingEntry>";
        }
    };
    public static final Builder<StreamInfo> STREAM_INFO = new Builder<StreamInfo>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("last-generated-id", STREAM_ENTRY_ID);
            hashMap.put("first-entry", STREAM_ENTRY);
            hashMap.put("length", LONG);
            hashMap.put("radix-tree-keys", LONG);
            hashMap.put("radix-tree-nodes", LONG);
            hashMap.put("last-entry", STREAM_ENTRY);
            hashMap.put("groups", LONG);
            return hashMap;
        }

        @Override
        public StreamInfo build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            return new StreamInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
        }

        public String toString() {
            return "StreamInfo";
        }
    };
    public static final Builder<List<StreamGroupInfo>> STREAM_GROUP_INFO_LIST = new Builder<List<StreamGroupInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("name", STRING);
            hashMap.put("consumers", LONG);
            hashMap.put("pending", LONG);
            hashMap.put("last-delivered-id", STREAM_ENTRY_ID);
            return hashMap;
        }

        @Override
        public List<StreamGroupInfo> build(Object object) {
            if (null == object) {
                return null;
            }
            ArrayList<StreamGroupInfo> arrayList = new ArrayList<StreamGroupInfo>();
            List list = (List)object;
            for (List list2 : list) {
                Iterator iterator = list2.iterator();
                StreamGroupInfo streamGroupInfo = new StreamGroupInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
                arrayList.add(streamGroupInfo);
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamGroupInfo>";
        }
    };
    public static final Builder<List<StreamConsumersInfo>> STREAM_CONSUMERS_INFO_LIST = new Builder<List<StreamConsumersInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("name", STRING);
            hashMap.put("idle", LONG);
            hashMap.put("pending", LONG);
            hashMap.put("last-delivered-id", STRING);
            return hashMap;
        }

        @Override
        public List<StreamConsumersInfo> build(Object object) {
            if (null == object) {
                return null;
            }
            ArrayList<StreamConsumersInfo> arrayList = new ArrayList<StreamConsumersInfo>();
            List list = (List)object;
            for (List list2 : list) {
                Iterator iterator = list2.iterator();
                StreamConsumersInfo streamConsumersInfo = new StreamConsumersInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
                arrayList.add(streamConsumersInfo);
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamConsumersInfo>";
        }
    };
    private static final Builder<List<StreamConsumerFullInfo>> STREAM_CONSUMER_FULL_INFO_LIST = new Builder<List<StreamConsumerFullInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("name", STRING);
            hashMap.put("seen-time", LONG);
            hashMap.put("pel-count", LONG);
            hashMap.put("pending", ENCODED_OBJECT_LIST);
            return hashMap;
        }

        @Override
        public List<StreamConsumerFullInfo> build(Object object) {
            if (null == object) {
                return null;
            }
            ArrayList<StreamConsumerFullInfo> arrayList = new ArrayList<StreamConsumerFullInfo>();
            List list = (List)object;
            for (Object e2 : list) {
                List list2 = (List)e2;
                Iterator iterator = list2.iterator();
                StreamConsumerFullInfo streamConsumerFullInfo = new StreamConsumerFullInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
                arrayList.add(streamConsumerFullInfo);
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamConsumerFullInfo>";
        }
    };
    private static final Builder<List<StreamGroupFullInfo>> STREAM_GROUP_FULL_INFO_LIST = new Builder<List<StreamGroupFullInfo>>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("name", STRING);
            hashMap.put("consumers", STREAM_CONSUMER_FULL_INFO_LIST);
            hashMap.put("pending", ENCODED_OBJECT_LIST);
            hashMap.put("last-delivered-id", STREAM_ENTRY_ID);
            hashMap.put("pel-count", LONG);
            return hashMap;
        }

        @Override
        public List<StreamGroupFullInfo> build(Object object) {
            if (null == object) {
                return null;
            }
            ArrayList<StreamGroupFullInfo> arrayList = new ArrayList<StreamGroupFullInfo>();
            List list = (List)object;
            for (Object e2 : list) {
                List list2 = (List)e2;
                Iterator iterator = list2.iterator();
                StreamGroupFullInfo streamGroupFullInfo = new StreamGroupFullInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
                arrayList.add(streamGroupFullInfo);
            }
            return arrayList;
        }

        public String toString() {
            return "List<StreamGroupFullInfo>";
        }
    };
    public static final Builder<StreamFullInfo> STREAM_INFO_FULL = new Builder<StreamFullInfo>(){
        final Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> hashMap = new HashMap<String, Builder>();
            hashMap.put("last-generated-id", STREAM_ENTRY_ID);
            hashMap.put("length", LONG);
            hashMap.put("radix-tree-keys", LONG);
            hashMap.put("radix-tree-nodes", LONG);
            hashMap.put("groups", STREAM_GROUP_FULL_INFO_LIST);
            hashMap.put("entries", STREAM_ENTRY_LIST);
            return hashMap;
        }

        @Override
        public StreamFullInfo build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            Iterator iterator = list.iterator();
            return new StreamFullInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
        }

        public String toString() {
            return "StreamFullInfo";
        }
    };
    public static final Builder<StreamPendingSummary> STREAM_PENDING_SUMMARY = new Builder<StreamPendingSummary>(){

        @Override
        public StreamPendingSummary build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            long l2 = LONG.build(list.get(0));
            String string = SafeEncoder.encode((byte[])list.get(1));
            String string2 = SafeEncoder.encode((byte[])list.get(2));
            List list2 = (List)list.get(3);
            HashMap<String, Long> hashMap = new HashMap<String, Long>(list2.size());
            for (List list3 : list2) {
                hashMap.put(SafeEncoder.encode((byte[])list3.get(0)), Long.parseLong(SafeEncoder.encode((byte[])list3.get(1))));
            }
            return new StreamPendingSummary(l2, new StreamEntryID(string), new StreamEntryID(string2), hashMap);
        }

        public String toString() {
            return "StreamPendingSummary";
        }
    };
    public static final Builder<LCSMatchResult> STR_ALGO_LCS_RESULT_BUILDER = new Builder<LCSMatchResult>(){

        @Override
        public LCSMatchResult build(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return new LCSMatchResult(STRING.build(object));
            }
            if (object instanceof Long) {
                return new LCSMatchResult(LONG.build(object));
            }
            long l2 = 0L;
            ArrayList<LCSMatchResult.MatchedPosition> arrayList = new ArrayList<LCSMatchResult.MatchedPosition>();
            List list = (List)object;
            if ("matches".equalsIgnoreCase(STRING.build(list.get(0)))) {
                List list2 = (List)list.get(1);
                for (Object e2 : list2) {
                    if (!(e2 instanceof List)) continue;
                    List list3 = (List)e2;
                    LCSMatchResult.Position position = new LCSMatchResult.Position(LONG.build(((List)list3.get(0)).get(0)), LONG.build(((List)list3.get(0)).get(1)));
                    LCSMatchResult.Position position2 = new LCSMatchResult.Position(LONG.build(((List)list3.get(1)).get(0)), LONG.build(((List)list3.get(1)).get(1)));
                    long l3 = 0L;
                    if (list3.size() >= 3) {
                        l3 = LONG.build(list3.get(2));
                    }
                    arrayList.add(new LCSMatchResult.MatchedPosition(position, position2, l3));
                }
            }
            if ("len".equalsIgnoreCase(STRING.build(list.get(2)))) {
                l2 = LONG.build(list.get(3));
            }
            return new LCSMatchResult(arrayList, l2);
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP_FROM_PAIRS = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object object) {
            List list = (List)object;
            HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
            for (Object e2 : list) {
                List list2 = (List)e2;
                hashMap.put(SafeEncoder.encode((byte[])list2.get(0)), list2.get(1) != null ? SafeEncoder.encode((byte[])list2.get(1)) : null);
            }
            return hashMap;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<List<LibraryInfo>> LIBRARY_LIST = new Builder<List<LibraryInfo>>(){

        @Override
        public List<LibraryInfo> build(Object object2) {
            List list = (List)object2;
            return list.stream().map(object -> LibraryInfo.LIBRARY_BUILDER.build(object)).collect(Collectors.toList());
        }
    };
    public static final Builder<Class<?>> JSON_TYPE = new Builder<Class<?>>(){

        @Override
        public Class<?> build(Object object) {
            String string;
            if (object == null) {
                return null;
            }
            switch (string = STRING.build(object)) {
                case "null": {
                    return null;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "integer": {
                    return Integer.TYPE;
                }
                case "number": {
                    return Float.TYPE;
                }
                case "string": {
                    return String.class;
                }
                case "object": {
                    return Object.class;
                }
                case "array": {
                    return List.class;
                }
            }
            throw new JedisException("Unknown type: " + string);
        }

        public String toString() {
            return "Class<?>";
        }
    };
    public static final Builder<List<Class<?>>> JSON_TYPE_LIST = new Builder<List<Class<?>>>(){

        @Override
        public List<Class<?>> build(Object object) {
            List list = (List)object;
            ArrayList arrayList = new ArrayList(list.size());
            for (Object e2 : list) {
                try {
                    arrayList.add(JSON_TYPE.build(e2));
                }
                catch (JedisException jedisException) {
                    arrayList.add(null);
                }
            }
            return arrayList;
        }
    };
    public static final Builder<Object> JSON_OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof byte[])) {
                return object;
            }
            String string = STRING.build(object);
            if (string.charAt(0) == '{') {
                try {
                    return new JSONObject(string);
                }
                catch (Exception exception) {
                }
            } else if (string.charAt(0) == '[') {
                try {
                    return new JSONArray(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string;
        }
    };
    public static final Builder<JSONArray> JSON_ARRAY = new Builder<JSONArray>(){

        @Override
        public JSONArray build(Object object) {
            if (object == null) {
                return null;
            }
            return new JSONArray(STRING.build(object));
        }
    };
    public static final Builder<List<JSONArray>> JSON_ARRAY_LIST = new Builder<List<JSONArray>>(){

        @Override
        public List<JSONArray> build(Object object2) {
            if (object2 == null) {
                return null;
            }
            List list = (List)object2;
            return list.stream().map(object -> JSON_ARRAY.build(object)).collect(Collectors.toList());
        }
    };
    public static final Builder<List<List<String>>> STRING_LIST_LIST = new Builder<List<List<String>>>(){

        @Override
        public List<List<String>> build(Object object) {
            if (null == object) {
                return null;
            }
            return ((List)object).stream().map(STRING_LIST::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<List<String>>";
        }
    };
    public static final Builder<List<List<Object>>> ENCODED_OBJECT_LIST_LIST = new Builder<List<List<Object>>>(){

        @Override
        public List<List<Object>> build(Object object) {
            if (null == object) {
                return null;
            }
            return ((List)object).stream().map(ENCODED_OBJECT_LIST::build).collect(Collectors.toList());
        }

        public String toString() {
            return "List<List<Object>>";
        }
    };
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT = new Builder<AggregationResult>(){

        @Override
        public AggregationResult build(Object object) {
            return new AggregationResult(object);
        }
    };
    public static final Builder<AggregationResult> SEARCH_AGGREGATION_RESULT_WITH_CURSOR = new Builder<AggregationResult>(){

        @Override
        public AggregationResult build(Object object) {
            List list = (List)object;
            return new AggregationResult(list.get(0), (Long)list.get(1));
        }
    };
    public static final Builder<Map<String, List<String>>> SEARCH_SYNONYM_GROUPS = new Builder<Map<String, List<String>>>(){

        @Override
        public Map<String, List<String>> build(Object object) {
            List list = (List)object;
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(list.size() / 2, 1.0f);
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                hashMap.put(STRING.build(list.get(i2)), STRING_LIST.build(list.get(i2 + 1)));
            }
            return hashMap;
        }
    };
    public static final Builder<TSElement> TIMESERIES_ELEMENT = new Builder<TSElement>(){

        @Override
        public TSElement build(Object object) {
            List list = (List)object;
            if (list == null || list.isEmpty()) {
                return null;
            }
            return new TSElement(LONG.build(list.get(0)), DOUBLE.build(list.get(1)));
        }
    };
    public static final Builder<List<TSElement>> TIMESERIES_ELEMENT_LIST = new Builder<List<TSElement>>(){

        @Override
        public List<TSElement> build(Object object2) {
            return ((List)object2).stream().map(object -> (List)object).map(list -> new TSElement(LONG.build(list.get(0)), DOUBLE.build(list.get(1)))).collect(Collectors.toList());
        }
    };
    public static final Builder<List<TSKeyedElements>> TIMESERIES_MRANGE_RESPONSE = new Builder<List<TSKeyedElements>>(){

        @Override
        public List<TSKeyedElements> build(Object object2) {
            return ((List)object2).stream().map(object -> (List)object).map(list -> new TSKeyedElements(STRING.build(list.get(0)), STRING_MAP_FROM_PAIRS.build(list.get(1)), TIMESERIES_ELEMENT_LIST.build(list.get(2)))).collect(Collectors.toList());
        }
    };
    public static final Builder<List<TSKeyValue<TSElement>>> TIMESERIES_MGET_RESPONSE = new Builder<List<TSKeyValue<TSElement>>>(){

        @Override
        public List<TSKeyValue<TSElement>> build(Object object2) {
            return ((List)object2).stream().map(object -> (List)object).map(list -> new TSKeyValue<TSElement>(STRING.build(list.get(0)), STRING_MAP_FROM_PAIRS.build(list.get(1)), TIMESERIES_ELEMENT.build(list.get(2)))).collect(Collectors.toList());
        }
    };
    public static final Builder<Map.Entry<Long, byte[]>> BLOOM_SCANDUMP_RESPONSE = new Builder<Map.Entry<Long, byte[]>>(){

        @Override
        public Map.Entry<Long, byte[]> build(Object object) {
            List list = (List)object;
            return new KeyValue<Long, byte[]>(LONG.build(list.get(0)), BINARY.build(list.get(1)));
        }
    };

    private static Map<String, Object> createMapFromDecodingFunctions(Iterator<Object> iterator, Map<String, Builder> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block2: while (iterator.hasNext()) {
            String string = STRING.build(iterator.next());
            if (map.containsKey(string)) {
                hashMap.put(string, map.get(string).build(iterator.next()));
                continue;
            }
            Object object = iterator.next();
            for (Builder builder : map.values()) {
                try {
                    hashMap.put(string, builder.build(object));
                    continue block2;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        return hashMap;
    }

    private BuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }

    protected static class SetFromList<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = -2850347066962734052L;
        private final List<E> list;

        private SetFromList(List<E> list) {
            this.list = list;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.list.remove(object);
        }

        @Override
        public boolean add(E e2) {
            return !this.contains(e2) && this.list.add(e2);
        }

        @Override
        public Iterator<E> iterator() {
            return this.list.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.list.toArray(TArray);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Set)) {
                return false;
            }
            Collection collection = (Collection)object;
            if (collection.size() != this.size()) {
                return false;
            }
            return this.containsAll(collection);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.list.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.list.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.list.retainAll(collection);
        }

        protected static <E> SetFromList<E> of(List<E> list) {
            if (list == null) {
                return null;
            }
            return new SetFromList<E>(list);
        }
    }
}

