/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.redis.jedis;

import java.util.Arrays;
import java.util.List;
import me.ulrich.clans.library.redis.jedis.Connection;
import me.ulrich.clans.library.redis.jedis.Protocol;
import me.ulrich.clans.library.redis.jedis.commands.ProtocolCommand;
import me.ulrich.clans.library.redis.jedis.exceptions.JedisException;

public abstract class BinaryJedisPubSub {
    private int subscribedChannels = 0;
    private Connection client;

    public void onMessage(byte[] byArray, byte[] byArray2) {
    }

    public void onPMessage(byte[] byArray, byte[] byArray2, byte[] byArray3) {
    }

    public void onSubscribe(byte[] byArray, int n2) {
    }

    public void onUnsubscribe(byte[] byArray, int n2) {
    }

    public void onPUnsubscribe(byte[] byArray, int n2) {
    }

    public void onPSubscribe(byte[] byArray, int n2) {
    }

    public void onPong(byte[] byArray) {
    }

    public void unsubscribe() {
        this.client.sendCommand(Protocol.Command.UNSUBSCRIBE);
        this.client.flush();
    }

    public void unsubscribe(byte[] ... byArray) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.UNSUBSCRIBE, byArray);
        this.client.flush();
    }

    public void subscribe(byte[] ... byArray) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.SUBSCRIBE, byArray);
        this.client.flush();
    }

    public void psubscribe(byte[] ... byArray) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PSUBSCRIBE, byArray);
        this.client.flush();
    }

    public void punsubscribe() {
        this.client.sendCommand(Protocol.Command.PUNSUBSCRIBE);
        this.client.flush();
    }

    public void punsubscribe(byte[] ... byArray) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PUNSUBSCRIBE, byArray);
        this.client.flush();
    }

    public void ping() {
        this.client.sendCommand(Protocol.Command.PING);
        this.client.flush();
    }

    public void ping(byte[] byArray) {
        this.client.sendCommand((ProtocolCommand)Protocol.Command.PING, new byte[][]{byArray});
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Connection connection, byte[] ... byArray) {
        this.client = connection;
        this.client.setTimeoutInfinite();
        try {
            this.psubscribe(byArray);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    public void proceed(Connection connection, byte[] ... byArray) {
        this.client = connection;
        this.client.setTimeoutInfinite();
        try {
            this.subscribe(byArray);
            this.process();
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    private void process() {
        do {
            byte[] byArray;
            byte[] byArray2;
            List<Object> list;
            Object object;
            if (!((object = (list = this.client.getUnflushedObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + object);
            }
            byte[] byArray3 = (byte[])object;
            if (Arrays.equals(Protocol.ResponseKeyword.SUBSCRIBE.getRaw(), byArray3)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray2 = (byte[])list.get(1);
                this.onSubscribe(byArray2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.UNSUBSCRIBE.getRaw(), byArray3)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray2 = (byte[])list.get(1);
                this.onUnsubscribe(byArray2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.MESSAGE.getRaw(), byArray3)) {
                byArray2 = (byte[])list.get(1);
                byArray = (byte[])list.get(2);
                this.onMessage(byArray2, byArray);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PMESSAGE.getRaw(), byArray3)) {
                byArray2 = (byte[])list.get(1);
                byArray = (byte[])list.get(2);
                byte[] byArray4 = (byte[])list.get(3);
                this.onPMessage(byArray2, byArray, byArray4);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PSUBSCRIBE.getRaw(), byArray3)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray2 = (byte[])list.get(1);
                this.onPSubscribe(byArray2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PUNSUBSCRIBE.getRaw(), byArray3)) {
                this.subscribedChannels = ((Long)list.get(2)).intValue();
                byArray2 = (byte[])list.get(1);
                this.onPUnsubscribe(byArray2, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.ResponseKeyword.PONG.getRaw(), byArray3)) {
                byArray2 = (byte[])list.get(1);
                this.onPong(byArray2);
                continue;
            }
            throw new JedisException("Unknown message type: " + object);
        } while (this.isSubscribed());
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

