/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.paperlib.environments;

import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ulrich.clans.library.paperlib.features.asyncchunks.AsyncChunks;
import me.ulrich.clans.library.paperlib.features.asyncchunks.AsyncChunksSync;
import me.ulrich.clans.library.paperlib.features.asyncteleport.AsyncTeleport;
import me.ulrich.clans.library.paperlib.features.asyncteleport.AsyncTeleportSync;
import me.ulrich.clans.library.paperlib.features.bedspawnlocation.BedSpawnLocation;
import me.ulrich.clans.library.paperlib.features.bedspawnlocation.BedSpawnLocationSync;
import me.ulrich.clans.library.paperlib.features.blockstatesnapshot.BlockStateSnapshot;
import me.ulrich.clans.library.paperlib.features.blockstatesnapshot.BlockStateSnapshotBeforeSnapshots;
import me.ulrich.clans.library.paperlib.features.blockstatesnapshot.BlockStateSnapshotNoOption;
import me.ulrich.clans.library.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import me.ulrich.clans.library.paperlib.features.chunkisgenerated.ChunkIsGenerated;
import me.ulrich.clans.library.paperlib.features.chunkisgenerated.ChunkIsGeneratedApiExists;
import me.ulrich.clans.library.paperlib.features.chunkisgenerated.ChunkIsGeneratedUnknown;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Environment {
    private final int minecraftVersion;
    private final int minecraftPatchVersion;
    private final int minecraftPreReleaseVersion;
    protected AsyncChunks asyncChunksHandler = new AsyncChunksSync();
    protected AsyncTeleport asyncTeleportHandler = new AsyncTeleportSync();
    protected ChunkIsGenerated isGeneratedHandler = new ChunkIsGeneratedUnknown();
    protected BlockStateSnapshot blockStateSnapshotHandler;
    protected BedSpawnLocation bedSpawnLocationHandler = new BedSpawnLocationSync();

    public Environment() {
        Pattern pattern = Pattern.compile("(?i)\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?(?: Pre-Release )?(\\d)?\\)");
        Matcher matcher = pattern.matcher(Bukkit.getVersion());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            try {
                n2 = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (matchResult.groupCount() >= 3) {
                try {
                    n3 = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (matchResult.groupCount() >= 4) {
                try {
                    n4 = Integer.parseInt(matcher.group(4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.minecraftVersion = n2;
        this.minecraftPatchVersion = n3;
        this.minecraftPreReleaseVersion = n4;
        if (this.isVersion(13, 1)) {
            this.isGeneratedHandler = new ChunkIsGeneratedApiExists();
        }
        this.blockStateSnapshotHandler = !this.isVersion(12) ? new BlockStateSnapshotBeforeSnapshots() : new BlockStateSnapshotNoOption();
    }

    public abstract String getName();

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, false);
    }

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl, boolean bl2) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, bl2);
    }

    public CompletableFuture<Chunk> getChunkAtAsyncUrgently(World world, int n2, int n3, boolean bl) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl, true);
    }

    public CompletableFuture<Boolean> teleport(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.asyncTeleportHandler.teleportAsync(entity, location, teleportCause);
    }

    public boolean isChunkGenerated(World world, int n2, int n3) {
        return this.isGeneratedHandler.isChunkGenerated(world, n2, n3);
    }

    public BlockStateSnapshotResult getBlockState(Block block, boolean bl) {
        return this.blockStateSnapshotHandler.getBlockState(block, bl);
    }

    public CompletableFuture<Location> getBedSpawnLocationAsync(Player player, boolean bl) {
        return this.bedSpawnLocationHandler.getBedSpawnLocationAsync(player, bl);
    }

    public boolean isVersion(int n2) {
        return this.isVersion(n2, 0);
    }

    public boolean isVersion(int n2, int n3) {
        return this.minecraftVersion > n2 || this.minecraftVersion >= n2 && this.minecraftPatchVersion >= n3;
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getMinecraftPatchVersion() {
        return this.minecraftPatchVersion;
    }

    public int getMinecraftPreReleaseVersion() {
        return this.minecraftPreReleaseVersion;
    }

    public boolean isSpigot() {
        return false;
    }

    public boolean isPaper() {
        return false;
    }
}

