/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.nbtapi.wrapper;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import me.ulrich.clans.library.nbtapi.iface.ReadWriteNBT;
import me.ulrich.clans.library.nbtapi.iface.ReadWriteNBTCompoundList;
import me.ulrich.clans.library.nbtapi.wrapper.NBTProxy;
import me.ulrich.clans.library.nbtapi.wrapper.ProxyBuilder;
import me.ulrich.clans.library.nbtapi.wrapper.ProxyList;

class ProxiedList<E extends NBTProxy>
implements ProxyList<E> {
    private final ReadWriteNBTCompoundList nbt;
    private final Class<E> proxy;

    public ProxiedList(ReadWriteNBTCompoundList readWriteNBTCompoundList, Class<E> clazz) {
        this.nbt = readWriteNBTCompoundList;
        this.proxy = clazz;
    }

    @Override
    public E get(int n2) {
        ReadWriteNBT readWriteNBT = (ReadWriteNBT)this.nbt.get(n2);
        return new ProxyBuilder<E>(readWriteNBT, this.proxy).build();
    }

    @Override
    public int size() {
        return this.nbt.size();
    }

    @Override
    public void remove(int n2) {
        this.nbt.remove(n2);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E addCompound() {
        ReadWriteNBT readWriteNBT = this.nbt.addCompound();
        return new ProxyBuilder<E>(readWriteNBT, this.proxy).build();
    }

    @Override
    public boolean isEmpty() {
        return this.nbt.isEmpty();
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ProxiedList.this.size();
        }

        @Override
        public E next() {
            try {
                int n2 = this.cursor;
                Object e2 = ProxiedList.this.get(n2);
                this.lastRet = n2;
                this.cursor = n2 + 1;
                return e2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            try {
                ProxiedList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

