/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.nbtapi.wrapper;

import java.util.function.UnaryOperator;

public enum Casing {
    camelCase(string -> {
        if (string.length() < 2) {
            return string.toLowerCase();
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }),
    snake_case(string -> {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase(string.charAt(0)));
        for (int i2 = 1; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isUpperCase(c2)) {
                stringBuilder.append('_').append(Character.toLowerCase(c2));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }),
    PascalCase(string -> {
        if (string.length() < 2) {
            return string.toUpperCase();
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }),
    lowercase(String::toLowerCase),
    UPPERCASE(String::toUpperCase);

    private UnaryOperator<String> convert;

    private Casing(UnaryOperator<String> unaryOperator) {
        this.convert = unaryOperator;
    }

    public String convertString(String string) {
        return (String)this.convert.apply(string);
    }
}

