/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.option.value;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.ulrich.clans.library.kyori.option.value.ValueType;
import org.jspecify.annotations.Nullable;

abstract class ValueTypeImpl<T>
implements ValueType<T> {
    private final Class<T> type;

    ValueTypeImpl(Class<T> clazz) {
        this.type = clazz;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    static IllegalArgumentException doNotKnowHowToTurn(String string, Class<?> clazz, @Nullable String string2) {
        throw new IllegalArgumentException("Do not know how to turn value '" + string + "' into a " + clazz.getName() + (string2 == null ? "" : ": " + string2));
    }

    static final class EnumType<E extends Enum<E>>
    extends ValueTypeImpl<E> {
        private final Map<String, E> values = new HashMap<String, E>();

        EnumType(Class<E> clazz) {
            super(clazz);
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                this.values.put(enum_.name().toLowerCase(Locale.ROOT), enum_);
            }
        }

        @Override
        public E parse(String string) {
            Enum enum_ = (Enum)this.values.get(string.toLowerCase(Locale.ROOT));
            if (enum_ == null) {
                throw EnumType.doNotKnowHowToTurn(string, this.type(), null);
            }
            return (E)enum_;
        }
    }

    static final class Types {
        static ValueType<String> STRING = new ValueTypeImpl<String>(String.class){

            @Override
            public String parse(String string) {
                return string;
            }
        };
        static ValueType<Boolean> BOOLEAN = new ValueTypeImpl<Boolean>(Boolean.class){

            @Override
            public Boolean parse(String string) {
                if (string.equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (string.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                throw 2.doNotKnowHowToTurn(string, Boolean.class, null);
            }
        };
        static ValueType<Integer> INT = new ValueTypeImpl<Integer>(Integer.class){

            @Override
            public Integer parse(String string) {
                try {
                    return Integer.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw 3.doNotKnowHowToTurn(string, Integer.class, numberFormatException.getMessage());
                }
            }
        };
        static ValueType<Double> DOUBLE = new ValueTypeImpl<Double>(Double.class){

            @Override
            public Double parse(String string) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw 4.doNotKnowHowToTurn(string, Double.class, numberFormatException.getMessage());
                }
            }
        };

        private Types() {
        }
    }
}

