/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.option.value;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ulrich.clans.library.kyori.option.Option;
import me.ulrich.clans.library.kyori.option.value.ValueSource;
import org.jspecify.annotations.Nullable;

final class ValueSources {
    static final ValueSource ENVIRONMENT = new EnvironmentVariable("");
    static final ValueSource SYSTEM_PROPERTIES = new SystemProperty("");

    private ValueSources() {
    }

    static final class EnvironmentVariable
    implements ValueSource {
        private static final Pattern ENVIRONMENT_SUBST_PATTERN = Pattern.compile("[:\\-/]");
        private static final String ENVIRONMENT_VAR_SEPARATOR = "_";
        private final String prefix;

        EnvironmentVariable(String string) {
            this.prefix = string.isEmpty() ? "" : string.toUpperCase(Locale.ROOT) + ENVIRONMENT_VAR_SEPARATOR;
        }

        @Override
        public <T> @Nullable T value(Option<T> option) {
            StringBuffer stringBuffer = new StringBuffer(option.id().length() + this.prefix.length());
            stringBuffer.append(this.prefix);
            Matcher matcher = ENVIRONMENT_SUBST_PATTERN.matcher(option.id());
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, ENVIRONMENT_VAR_SEPARATOR);
            }
            matcher.appendTail(stringBuffer);
            String string = System.getenv(stringBuffer.toString().toUpperCase(Locale.ROOT));
            if (string == null) {
                return null;
            }
            return option.valueType().parse(string);
        }
    }

    static final class SystemProperty
    implements ValueSource {
        private static final Pattern SYSTEM_PROP_SUBST_PATTERN = Pattern.compile("[:/]");
        private static final String SYSTEM_PROPERTY_SEPARATOR = ".";
        private final String prefix;

        SystemProperty(String string) {
            this.prefix = string.isEmpty() ? "" : string + SYSTEM_PROPERTY_SEPARATOR;
        }

        @Override
        public <T> @Nullable T value(Option<T> option) {
            StringBuffer stringBuffer = new StringBuffer(option.id().length() + this.prefix.length());
            stringBuffer.append(this.prefix);
            Matcher matcher = SYSTEM_PROP_SUBST_PATTERN.matcher(option.id());
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, SYSTEM_PROPERTY_SEPARATOR);
            }
            matcher.appendTail(stringBuffer);
            String string = System.getProperty(stringBuffer.toString());
            if (string == null) {
                return null;
            }
            return option.valueType().parse(string);
        }
    }
}

