/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.option;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import me.ulrich.clans.library.kyori.option.Option;
import me.ulrich.clans.library.kyori.option.OptionSchema;
import me.ulrich.clans.library.kyori.option.OptionState;
import me.ulrich.clans.library.kyori.option.value.ValueSource;
import org.jspecify.annotations.Nullable;

final class OptionStateImpl
implements OptionState {
    private final OptionSchema schema;
    private final IdentityHashMap<Option<?>, Object> values;

    OptionStateImpl(OptionSchema optionSchema, IdentityHashMap<Option<?>, Object> identityHashMap) {
        this.schema = optionSchema;
        this.values = new IdentityHashMap(identityHashMap);
    }

    @Override
    public OptionSchema schema() {
        return this.schema;
    }

    @Override
    public boolean has(Option<?> option) {
        return this.values.containsKey(Objects.requireNonNull(option, "flag"));
    }

    @Override
    public <V> @Nullable V value(Option<V> option) {
        V v2 = option.valueType().type().cast(this.values.get(Objects.requireNonNull(option, "flag")));
        return v2 == null ? option.defaultValue() : v2;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OptionStateImpl optionStateImpl = (OptionStateImpl)object;
        return Objects.equals(this.values, optionStateImpl.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{values=" + this.values + '}';
    }

    static final class VersionedBuilderImpl
    implements OptionState.VersionedBuilder {
        private final OptionSchema schema;
        private final Map<Integer, BuilderImpl> builders = new TreeMap<Integer, BuilderImpl>();

        VersionedBuilderImpl(OptionSchema optionSchema) {
            this.schema = optionSchema;
        }

        @Override
        public OptionState.Versioned build() {
            if (this.builders.isEmpty()) {
                return new VersionedImpl(this.schema, Collections.emptySortedMap(), 0, this.schema.emptyState());
            }
            TreeMap<Integer, OptionState> treeMap = new TreeMap<Integer, OptionState>();
            for (Map.Entry<Integer, BuilderImpl> entry : this.builders.entrySet()) {
                treeMap.put(entry.getKey(), entry.getValue().build());
            }
            return new VersionedImpl(this.schema, treeMap, (Integer)treeMap.lastKey(), VersionedImpl.flattened(this.schema, treeMap, (Integer)treeMap.lastKey()));
        }

        @Override
        public OptionState.VersionedBuilder version(int n3, Consumer<OptionState.Builder> consumer) {
            Objects.requireNonNull(consumer, "versionBuilder").accept(this.builders.computeIfAbsent(n3, n2 -> new BuilderImpl(this.schema)));
            return this;
        }
    }

    static final class BuilderImpl
    implements OptionState.Builder {
        private final OptionSchema schema;
        private final IdentityHashMap<Option<?>, Object> values = new IdentityHashMap();

        BuilderImpl(OptionSchema optionSchema) {
            this.schema = optionSchema;
        }

        @Override
        public OptionState build() {
            if (this.values.isEmpty()) {
                return this.schema.emptyState();
            }
            return new OptionStateImpl(this.schema, this.values);
        }

        @Override
        public <V> OptionState.Builder value(Option<V> option, @Nullable V v2) {
            if (!this.schema.has(Objects.requireNonNull(option, "option"))) {
                throw new IllegalStateException("Option '" + option.id() + "' was not present in active schema");
            }
            if (v2 == null) {
                this.values.remove(option);
            } else {
                this.values.put(option, v2);
            }
            return this;
        }

        private void putAll(Map<Option<?>, Object> map) {
            for (Map.Entry<Option<?>, Object> entry : map.entrySet()) {
                if (!this.schema.has(entry.getKey())) {
                    throw new IllegalStateException("Option '" + entry.getKey().id() + "' was not present in active schema");
                }
                this.values.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public OptionState.Builder values(OptionState optionState) {
            if (optionState instanceof OptionStateImpl) {
                this.putAll(((OptionStateImpl)optionState).values);
            } else if (optionState instanceof VersionedImpl) {
                this.putAll(((OptionStateImpl)((VersionedImpl)optionState).filtered).values);
            } else {
                throw new IllegalArgumentException("existing set " + optionState + " is of an unknown implementation type");
            }
            return this;
        }

        @Override
        public OptionState.Builder values(ValueSource valueSource) {
            for (Option<?> option : this.schema.knownOptions()) {
                Object obj = valueSource.value(option);
                if (obj == null) continue;
                this.values.put(option, obj);
            }
            return this;
        }
    }

    static final class VersionedImpl
    implements OptionState.Versioned {
        private final OptionSchema schema;
        private final SortedMap<Integer, OptionState> sets;
        private final int targetVersion;
        private final OptionState filtered;

        VersionedImpl(OptionSchema optionSchema, SortedMap<Integer, OptionState> sortedMap, int n2, OptionState optionState) {
            this.schema = optionSchema;
            this.sets = sortedMap;
            this.targetVersion = n2;
            this.filtered = optionState;
        }

        @Override
        public OptionSchema schema() {
            return this.schema;
        }

        @Override
        public boolean has(Option<?> option) {
            return this.filtered.has(option);
        }

        @Override
        public <V> @Nullable V value(Option<V> option) {
            return this.filtered.value(option);
        }

        @Override
        public Map<Integer, OptionState> childStates() {
            return Collections.unmodifiableSortedMap(this.sets.headMap(this.targetVersion + 1));
        }

        @Override
        public OptionState.Versioned at(int n2) {
            return new VersionedImpl(this.schema, this.sets, n2, VersionedImpl.flattened(this.schema, this.sets, n2));
        }

        public static OptionState flattened(OptionSchema optionSchema, SortedMap<Integer, OptionState> sortedMap, int n2) {
            SortedMap<Integer, OptionState> sortedMap2 = sortedMap.headMap(n2 + 1);
            OptionState.Builder builder = optionSchema.stateBuilder();
            for (OptionState optionState : sortedMap2.values()) {
                builder.values(optionState);
            }
            return builder.build();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            VersionedImpl versionedImpl = (VersionedImpl)object;
            return this.targetVersion == versionedImpl.targetVersion && Objects.equals(this.schema, versionedImpl.schema) && Objects.equals(this.sets, versionedImpl.sets) && Objects.equals(this.filtered, versionedImpl.filtered);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.sets, this.targetVersion, this.filtered);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{schema=" + this.schema + ", sets=" + this.sets + ", targetVersion=" + this.targetVersion + ", filtered=" + this.filtered + '}';
        }
    }
}

