/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.option;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.ulrich.clans.library.kyori.option.Option;
import me.ulrich.clans.library.kyori.option.OptionImpl;
import me.ulrich.clans.library.kyori.option.OptionSchema;
import me.ulrich.clans.library.kyori.option.OptionState;
import me.ulrich.clans.library.kyori.option.OptionStateImpl;
import me.ulrich.clans.library.kyori.option.value.ValueType;
import org.jspecify.annotations.Nullable;

final class OptionSchemaImpl
implements OptionSchema {
    final OptionState emptyState;
    final ConcurrentMap<String, Option<?>> options = new ConcurrentHashMap();

    OptionSchemaImpl(@Nullable OptionSchemaImpl optionSchemaImpl) {
        if (optionSchemaImpl != null) {
            this.options.putAll(optionSchemaImpl.options);
        }
        this.emptyState = new OptionStateImpl(this, new IdentityHashMap());
    }

    @Override
    public Set<Option<?>> knownOptions() {
        return Collections.unmodifiableSet(new HashSet(this.options.values()));
    }

    @Override
    public boolean has(Option<?> option) {
        Option option2 = (Option)this.options.get(option.id());
        return option2 != null && option2.equals(option);
    }

    @Override
    public OptionState.Builder stateBuilder() {
        return new OptionStateImpl.BuilderImpl(this);
    }

    @Override
    public OptionState.VersionedBuilder versionedStateBuilder() {
        return new OptionStateImpl.VersionedBuilderImpl(this);
    }

    @Override
    public OptionState emptyState() {
        return this.emptyState;
    }

    public String toString() {
        return "OptionSchemaImpl{options=" + this.options + '}';
    }

    final class MutableImpl
    implements OptionSchema.Mutable {
        MutableImpl() {
        }

        <T> Option<T> register(String string, ValueType<T> valueType, @Nullable T t2) {
            OptionImpl<T> optionImpl = new OptionImpl<T>(Objects.requireNonNull(string, "id"), Objects.requireNonNull(valueType, "type"), t2);
            if (OptionSchemaImpl.this.options.putIfAbsent(string, optionImpl) != null) {
                throw new IllegalStateException("Key " + string + " has already been used. Option keys must be unique within a schema.");
            }
            return optionImpl;
        }

        @Override
        public Option<String> stringOption(String string, @Nullable String string2) {
            return this.register(string, ValueType.stringType(), string2);
        }

        @Override
        public Option<Boolean> booleanOption(String string, boolean bl) {
            return this.register(string, ValueType.booleanType(), bl);
        }

        @Override
        public Option<Integer> intOption(String string, int n2) {
            return this.register(string, ValueType.integerType(), n2);
        }

        @Override
        public Option<Double> doubleOption(String string, double d2) {
            return this.register(string, ValueType.doubleType(), d2);
        }

        @Override
        public <E extends Enum<E>> Option<E> enumOption(String string, Class<E> clazz, @Nullable E e2) {
            return this.register(string, ValueType.enumType(clazz), e2);
        }

        @Override
        public OptionSchema frozenView() {
            return OptionSchemaImpl.this;
        }

        @Override
        public Set<Option<?>> knownOptions() {
            return OptionSchemaImpl.this.knownOptions();
        }

        @Override
        public boolean has(Option<?> option) {
            return OptionSchemaImpl.this.has(option);
        }

        @Override
        public OptionState.Builder stateBuilder() {
            return OptionSchemaImpl.this.stateBuilder();
        }

        @Override
        public OptionState.VersionedBuilder versionedStateBuilder() {
            return OptionSchemaImpl.this.versionedStateBuilder();
        }

        @Override
        public OptionState emptyState() {
            return OptionSchemaImpl.this.emptyState();
        }

        public String toString() {
            return "MutableImpl{schema=" + OptionSchemaImpl.this + "}";
        }
    }

    static final class Instances {
        static MutableImpl GLOBAL = new OptionSchemaImpl(null).new MutableImpl();

        Instances() {
        }
    }
}

