/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Map;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.event.ClickEvent;
import me.ulrich.clans.library.kyori.adventure.text.event.HoverEvent;
import me.ulrich.clans.library.kyori.adventure.text.format.ShadowColor;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.TextDecoration;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.GsonHacks;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.SerializerFactory;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.TextColorWrapper;
import me.ulrich.clans.library.kyori.adventure.text.serializer.json.JSONOptions;
import me.ulrich.clans.library.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import me.ulrich.clans.library.kyori.adventure.util.ARGBLike;
import me.ulrich.clans.library.kyori.adventure.util.Codec;
import me.ulrich.clans.library.kyori.option.OptionState;
import org.jetbrains.annotations.Nullable;

final class StyleSerializer
extends TypeAdapter<Style> {
    private static final TextDecoration[] DECORATIONS = new TextDecoration[]{TextDecoration.BOLD, TextDecoration.ITALIC, TextDecoration.UNDERLINED, TextDecoration.STRIKETHROUGH, TextDecoration.OBFUSCATED};
    private final LegacyHoverEventSerializer legacyHover;
    private final boolean emitValueFieldHover;
    private final boolean emitCamelCaseHover;
    private final boolean emitSnakeCaseHover;
    private final boolean emitCamelCaseClick;
    private final boolean emitSnakeCaseClick;
    private final boolean strictEventValues;
    private final boolean emitShadowColor;
    private final Gson gson;

    static TypeAdapter<Style> create(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, OptionState optionState, Gson gson) {
        JSONOptions.HoverEventValueMode hoverEventValueMode = optionState.value(JSONOptions.EMIT_HOVER_EVENT_TYPE);
        JSONOptions.ClickEventValueMode clickEventValueMode = optionState.value(JSONOptions.EMIT_CLICK_EVENT_TYPE);
        return new StyleSerializer(legacyHoverEventSerializer, hoverEventValueMode == JSONOptions.HoverEventValueMode.VALUE_FIELD || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, hoverEventValueMode == JSONOptions.HoverEventValueMode.CAMEL_CASE || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, hoverEventValueMode == JSONOptions.HoverEventValueMode.SNAKE_CASE || hoverEventValueMode == JSONOptions.HoverEventValueMode.ALL, clickEventValueMode == JSONOptions.ClickEventValueMode.CAMEL_CASE || clickEventValueMode == JSONOptions.ClickEventValueMode.BOTH, clickEventValueMode == JSONOptions.ClickEventValueMode.SNAKE_CASE || clickEventValueMode == JSONOptions.ClickEventValueMode.BOTH, optionState.value(JSONOptions.VALIDATE_STRICT_EVENTS), optionState.value(JSONOptions.SHADOW_COLOR_MODE) != JSONOptions.ShadowColorEmitMode.NONE, gson).nullSafe();
    }

    private StyleSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Gson gson) {
        this.legacyHover = legacyHoverEventSerializer;
        this.emitValueFieldHover = bl;
        this.emitCamelCaseHover = bl2;
        this.emitSnakeCaseHover = bl3;
        this.emitCamelCaseClick = bl4;
        this.emitSnakeCaseClick = bl5;
        this.strictEventValues = bl6;
        this.emitShadowColor = bl7;
        this.gson = gson;
    }

    @Override
    public Style read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Style.Builder builder = Style.style();
        while (jsonReader.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            String string = jsonReader.nextName();
            if (string.equals("font")) {
                builder.font((Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE));
                continue;
            }
            if (string.equals("color")) {
                object3 = (TextColorWrapper)this.gson.fromJson(jsonReader, SerializerFactory.COLOR_WRAPPER_TYPE);
                if (((TextColorWrapper)object3).color != null) {
                    builder.color(((TextColorWrapper)object3).color);
                    continue;
                }
                if (((TextColorWrapper)object3).decoration == null) continue;
                builder.decoration(((TextColorWrapper)object3).decoration, TextDecoration.State.TRUE);
                continue;
            }
            if (string.equals("shadow_color")) {
                builder.shadowColor((ARGBLike)this.gson.fromJson(jsonReader, SerializerFactory.SHADOW_COLOR_TYPE));
                continue;
            }
            if (TextDecoration.NAMES.keys().contains(string)) {
                builder.decoration(TextDecoration.NAMES.value(string), GsonHacks.readBoolean(jsonReader));
                continue;
            }
            if (string.equals("insertion")) {
                builder.insertion(jsonReader.nextString());
                continue;
            }
            if (string.equals("click_event") || string.equals("clickEvent")) {
                jsonReader.beginObject();
                object3 = null;
                object2 = null;
                while (jsonReader.hasNext()) {
                    object = jsonReader.nextName();
                    if (((String)object).equals("action")) {
                        object3 = (ClickEvent.Action)((Object)this.gson.fromJson(jsonReader, SerializerFactory.CLICK_ACTION_TYPE));
                        continue;
                    }
                    if (((String)object).equals("value") || ((String)object).equals("url") || ((String)object).equals("path") || ((String)object).equals("command") || ((String)object).equals("page")) {
                        if (jsonReader.peek() == JsonToken.NULL) {
                            if (this.strictEventValues) {
                                throw ComponentSerializerImpl.notSureHowToDeserialize(object);
                            }
                            jsonReader.nextNull();
                            continue;
                        }
                        object2 = jsonReader.nextString();
                        continue;
                    }
                    jsonReader.skipValue();
                }
                if (object3 != null && ((ClickEvent.Action)((Object)object3)).readable() && object2 != null) {
                    builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)((Object)object3), object2));
                }
                jsonReader.endObject();
                continue;
            }
            if (string.equals("hover_event") || string.equals("hoverEvent")) {
                Object object4;
                JsonElement jsonElement;
                object3 = (JsonObject)this.gson.fromJson(jsonReader, (Type)((Object)JsonObject.class));
                if (object3 == null || (object2 = ((JsonObject)object3).getAsJsonPrimitive("action")) == null || !((HoverEvent.Action)(object = this.gson.fromJson((JsonElement)object2, SerializerFactory.HOVER_ACTION_TYPE))).readable()) continue;
                Class clazz = ((HoverEvent.Action)object).type();
                if (((JsonObject)object3).has("contents")) {
                    jsonElement = ((JsonObject)object3).get("contents");
                    if (GsonHacks.isNullOrEmpty(jsonElement)) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonElement);
                        }
                        object4 = null;
                    } else {
                        object4 = SerializerFactory.COMPONENT_TYPE.isAssignableFrom(clazz) ? this.gson.fromJson(jsonElement, SerializerFactory.COMPONENT_TYPE) : (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom(clazz) ? this.gson.fromJson(jsonElement, SerializerFactory.SHOW_ITEM_TYPE) : (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom(clazz) ? this.gson.fromJson(jsonElement, SerializerFactory.SHOW_ENTITY_TYPE) : null));
                    }
                } else if (((JsonObject)object3).has("value")) {
                    jsonElement = ((JsonObject)object3).get("value");
                    if (GsonHacks.isNullOrEmpty(jsonElement)) {
                        if (this.strictEventValues) {
                            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonElement);
                        }
                        object4 = null;
                    } else if (SerializerFactory.COMPONENT_TYPE.isAssignableFrom(clazz)) {
                        Component component = this.gson.fromJson(jsonElement, SerializerFactory.COMPONENT_TYPE);
                        object4 = this.legacyHoverEventContents((HoverEvent.Action<?>)object, component);
                    } else {
                        object4 = SerializerFactory.STRING_TYPE.isAssignableFrom(clazz) ? this.gson.fromJson(jsonElement, SerializerFactory.STRING_TYPE) : null;
                    }
                } else if (SerializerFactory.SHOW_ITEM_TYPE.isAssignableFrom(clazz)) {
                    object4 = this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ITEM_TYPE);
                } else if (SerializerFactory.SHOW_ENTITY_TYPE.isAssignableFrom(clazz)) {
                    object4 = this.gson.fromJson((JsonElement)object3, SerializerFactory.SHOW_ENTITY_TYPE);
                } else {
                    if (this.strictEventValues) {
                        throw ComponentSerializerImpl.notSureHowToDeserialize(object3);
                    }
                    object4 = null;
                }
                if (object4 == null) continue;
                builder.hoverEvent(HoverEvent.hoverEvent(object, object4));
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return builder.build();
    }

    private Object legacyHoverEventContents(HoverEvent.Action<?> action, Component component) {
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return component;
        }
        if (this.legacyHover != null) {
            try {
                if (action == HoverEvent.Action.SHOW_ENTITY) {
                    return this.legacyHover.deserializeShowEntity(component, this.decoder());
                }
                if (action == HoverEvent.Action.SHOW_ITEM) {
                    return this.legacyHover.deserializeShowItem(component);
                }
            }
            catch (IOException iOException) {
                throw new JsonParseException(iOException);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Codec.Decoder<Component, String, JsonParseException> decoder() {
        return string -> this.gson.fromJson((String)string, SerializerFactory.COMPONENT_TYPE);
    }

    private Codec.Encoder<Component, String, JsonParseException> encoder() {
        return component -> this.gson.toJson(component, SerializerFactory.COMPONENT_TYPE);
    }

    @Override
    public void write(JsonWriter jsonWriter, Style style) {
        Object object;
        String string;
        ShadowColor shadowColor;
        Object object2;
        Object object3;
        jsonWriter.beginObject();
        for (TextDecoration object42 : DECORATIONS) {
            object3 = style.decoration(object42);
            if (object3 == TextDecoration.State.NOT_SET) continue;
            object2 = TextDecoration.NAMES.key(object42);
            assert (object2 != null);
            jsonWriter.name((String)object2);
            jsonWriter.value(object3 == TextDecoration.State.TRUE);
        }
        @Nullable TextColor textColor = style.color();
        if (textColor != null) {
            jsonWriter.name("color");
            this.gson.toJson((Object)textColor, SerializerFactory.COLOR_TYPE, jsonWriter);
        }
        if ((shadowColor = style.shadowColor()) != null && this.emitShadowColor) {
            jsonWriter.name("shadow_color");
            this.gson.toJson((Object)shadowColor, SerializerFactory.SHADOW_COLOR_TYPE, jsonWriter);
        }
        if ((string = style.insertion()) != null) {
            jsonWriter.name("insertion");
            jsonWriter.value(string);
        }
        if ((object3 = style.clickEvent()) != null) {
            object2 = ((ClickEvent)object3).action();
            if (this.emitSnakeCaseClick) {
                jsonWriter.name("click_event");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object2, SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
                if (object2 == ClickEvent.Action.OPEN_URL) {
                    jsonWriter.name("url");
                } else if (object2 == ClickEvent.Action.OPEN_FILE) {
                    jsonWriter.name("path");
                } else if (object2 == ClickEvent.Action.RUN_COMMAND || object2 == ClickEvent.Action.SUGGEST_COMMAND) {
                    jsonWriter.name("command");
                } else if (object2 == ClickEvent.Action.CHANGE_PAGE) {
                    jsonWriter.name("page");
                } else {
                    jsonWriter.name("value");
                }
                if (object2 == ClickEvent.Action.CHANGE_PAGE) {
                    jsonWriter.value(Integer.parseInt(((ClickEvent)object3).value()));
                } else if (object2 == ClickEvent.Action.OPEN_URL) {
                    if (((ClickEvent)object3).value().startsWith("http://") || ((ClickEvent)object3).value().startsWith("https://")) {
                        jsonWriter.value(((ClickEvent)object3).value());
                    } else {
                        jsonWriter.value("https://" + ((ClickEvent)object3).value());
                    }
                } else {
                    jsonWriter.value(((ClickEvent)object3).value());
                }
                jsonWriter.endObject();
            }
            if (this.emitCamelCaseClick) {
                jsonWriter.name("clickEvent");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object2, SerializerFactory.CLICK_ACTION_TYPE, jsonWriter);
                jsonWriter.name("value");
                jsonWriter.value(((ClickEvent)object3).value());
                jsonWriter.endObject();
            }
        }
        if ((object2 = style.hoverEvent()) != null && ((this.emitSnakeCaseHover || this.emitCamelCaseHover) && ((HoverEvent)object2).action() != HoverEvent.Action.SHOW_ACHIEVEMENT || this.emitValueFieldHover)) {
            object = ((HoverEvent)object2).action();
            if (this.emitSnakeCaseHover && object != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                jsonWriter.name("hover_event");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
                if (object == HoverEvent.Action.SHOW_ITEM) {
                    for (Map.Entry<String, JsonElement> entry : this.gson.toJsonTree(((HoverEvent)object2).value(), SerializerFactory.SHOW_ITEM_TYPE).getAsJsonObject().entrySet()) {
                        jsonWriter.name(entry.getKey());
                        this.gson.toJson(entry.getValue(), jsonWriter);
                    }
                } else if (object == HoverEvent.Action.SHOW_ENTITY) {
                    for (Map.Entry<String, JsonElement> entry : this.gson.toJsonTree(((HoverEvent)object2).value(), SerializerFactory.SHOW_ENTITY_TYPE).getAsJsonObject().entrySet()) {
                        jsonWriter.name(entry.getKey());
                        this.gson.toJson(entry.getValue(), jsonWriter);
                    }
                } else if (object == HoverEvent.Action.SHOW_TEXT) {
                    jsonWriter.name("value");
                    this.gson.toJson(((HoverEvent)object2).value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                } else {
                    throw new JsonParseException("Don't know how to serialize " + ((HoverEvent)object2).value());
                }
                jsonWriter.endObject();
            }
            if (this.emitCamelCaseHover || this.emitValueFieldHover) {
                jsonWriter.name("hoverEvent");
                jsonWriter.beginObject();
                jsonWriter.name("action");
                this.gson.toJson(object, SerializerFactory.HOVER_ACTION_TYPE, jsonWriter);
                if (this.emitCamelCaseHover && object != HoverEvent.Action.SHOW_ACHIEVEMENT) {
                    jsonWriter.name("contents");
                    if (object == HoverEvent.Action.SHOW_ITEM) {
                        this.gson.toJson(((HoverEvent)object2).value(), SerializerFactory.SHOW_ITEM_TYPE, jsonWriter);
                    } else if (object == HoverEvent.Action.SHOW_ENTITY) {
                        this.gson.toJson(((HoverEvent)object2).value(), SerializerFactory.SHOW_ENTITY_TYPE, jsonWriter);
                    } else if (object == HoverEvent.Action.SHOW_TEXT) {
                        this.gson.toJson(((HoverEvent)object2).value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
                    } else {
                        throw new JsonParseException("Don't know how to serialize " + ((HoverEvent)object2).value());
                    }
                }
                if (this.emitValueFieldHover) {
                    jsonWriter.name("value");
                    this.serializeLegacyHoverEvent((HoverEvent<?>)object2, jsonWriter);
                }
                jsonWriter.endObject();
            }
        }
        if ((object = style.font()) != null) {
            jsonWriter.name("font");
            this.gson.toJson(object, SerializerFactory.KEY_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }

    private void serializeLegacyHoverEvent(HoverEvent<?> hoverEvent, JsonWriter jsonWriter) {
        if (hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
            this.gson.toJson(hoverEvent.value(), SerializerFactory.COMPONENT_TYPE, jsonWriter);
        } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
            this.gson.toJson(hoverEvent.value(), (Type)((Object)String.class), jsonWriter);
        } else if (this.legacyHover != null) {
            Component component = null;
            try {
                if (hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
                    component = this.legacyHover.serializeShowEntity((HoverEvent.ShowEntity)hoverEvent.value(), this.encoder());
                } else if (hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
                    component = this.legacyHover.serializeShowItem((HoverEvent.ShowItem)hoverEvent.value());
                }
            }
            catch (IOException iOException) {
                throw new JsonSyntaxException(iOException);
            }
            if (component != null) {
                this.gson.toJson((Object)component, SerializerFactory.COMPONENT_TYPE, jsonWriter);
            } else {
                jsonWriter.nullValue();
            }
        } else {
            jsonWriter.nullValue();
        }
    }

    static {
        EnumSet<TextDecoration> enumSet = EnumSet.allOf(TextDecoration.class);
        for (TextDecoration textDecoration : DECORATIONS) {
            enumSet.remove(textDecoration);
        }
        if (!enumSet.isEmpty()) {
            throw new IllegalStateException("Gson serializer is missing some text decorations: " + enumSet);
        }
    }
}

