/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.UUID;
import me.ulrich.clans.library.kyori.adventure.key.InvalidKeyException;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.event.HoverEvent;
import me.ulrich.clans.library.kyori.adventure.text.serializer.gson.SerializerFactory;
import me.ulrich.clans.library.kyori.adventure.text.serializer.json.JSONOptions;
import me.ulrich.clans.library.kyori.option.OptionState;
import org.jetbrains.annotations.Nullable;

final class ShowEntitySerializer
extends TypeAdapter<HoverEvent.ShowEntity> {
    private final Gson gson;
    private final boolean emitKeyAsTypeAndUuidAsId;

    static TypeAdapter<HoverEvent.ShowEntity> create(Gson gson, OptionState optionState) {
        return new ShowEntitySerializer(gson, optionState.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID)).nullSafe();
    }

    private ShowEntitySerializer(Gson gson, boolean bl) {
        this.gson = gson;
        this.emitKeyAsTypeAndUuidAsId = bl;
    }

    @Override
    public HoverEvent.ShowEntity read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        UUID uUID = null;
        Component component = null;
        while (jsonReader.hasNext()) {
            String string;
            switch (string = jsonReader.nextName()) {
                case "id": {
                    if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                        uUID = (UUID)this.gson.fromJson(jsonReader, (Type)((Object)UUID.class));
                        break;
                    }
                    String string2 = jsonReader.nextString();
                    if (string2.contains(":")) {
                        key = Key.key(string2);
                    }
                    try {
                        uUID = UUID.fromString(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        try {
                            key = Key.key(string2);
                        }
                        catch (InvalidKeyException invalidKeyException) {}
                    }
                    break;
                }
                case "type": {
                    key = (Key)this.gson.fromJson(jsonReader, (Type)((Object)Key.class));
                    break;
                }
                case "uuid": {
                    uUID = (UUID)this.gson.fromJson(jsonReader, (Type)((Object)UUID.class));
                    break;
                }
                case "name": {
                    component = (Component)this.gson.fromJson(jsonReader, SerializerFactory.COMPONENT_TYPE);
                    break;
                }
                default: {
                    jsonReader.skipValue();
                }
            }
        }
        if (key == null || uUID == null) {
            throw new JsonParseException("A show entity hover event needs type and id fields to be deserialized");
        }
        jsonReader.endObject();
        return HoverEvent.ShowEntity.showEntity(key, uUID, component);
    }

    @Override
    public void write(JsonWriter jsonWriter, HoverEvent.ShowEntity showEntity) {
        jsonWriter.beginObject();
        jsonWriter.name(this.emitKeyAsTypeAndUuidAsId ? "type" : "id");
        this.gson.toJson((Object)showEntity.type(), SerializerFactory.KEY_TYPE, jsonWriter);
        jsonWriter.name(this.emitKeyAsTypeAndUuidAsId ? "id" : "uuid");
        this.gson.toJson((Object)showEntity.id(), SerializerFactory.UUID_TYPE, jsonWriter);
        @Nullable Component component = showEntity.name();
        if (component != null) {
            jsonWriter.name("name");
            this.gson.toJson((Object)component, SerializerFactory.COMPONENT_TYPE, jsonWriter);
        }
        jsonWriter.endObject();
    }
}

