/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.renderer;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import me.ulrich.clans.library.kyori.adventure.text.BlockNBTComponent;
import me.ulrich.clans.library.kyori.adventure.text.BuildableComponent;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentBuilder;
import me.ulrich.clans.library.kyori.adventure.text.EntityNBTComponent;
import me.ulrich.clans.library.kyori.adventure.text.KeybindComponent;
import me.ulrich.clans.library.kyori.adventure.text.NBTComponent;
import me.ulrich.clans.library.kyori.adventure.text.NBTComponentBuilder;
import me.ulrich.clans.library.kyori.adventure.text.ScoreComponent;
import me.ulrich.clans.library.kyori.adventure.text.SelectorComponent;
import me.ulrich.clans.library.kyori.adventure.text.StorageNBTComponent;
import me.ulrich.clans.library.kyori.adventure.text.TextComponent;
import me.ulrich.clans.library.kyori.adventure.text.TranslatableComponent;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgument;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponent;
import me.ulrich.clans.library.kyori.adventure.text.event.HoverEvent;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.renderer.AbstractComponentRenderer;
import me.ulrich.clans.library.kyori.adventure.translation.Translator;
import me.ulrich.clans.library.kyori.adventure.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranslatableComponentRenderer<C>
extends AbstractComponentRenderer<C> {
    private static final Set<Style.Merge> MERGES;

    @NotNull
    public static TranslatableComponentRenderer<Locale> usingTranslationSource(final @NotNull Translator translator) {
        Objects.requireNonNull(translator, "source");
        return new TranslatableComponentRenderer<Locale>(){

            @Override
            @Nullable
            protected MessageFormat translate(@NotNull String string, @NotNull Locale locale) {
                return translator.translate(string, locale);
            }

            @Override
            @NotNull
            protected Component renderTranslatableInner(@NotNull TranslatableComponent translatableComponent, @NotNull Locale locale) {
                TriState triState = translator.hasAnyTranslations();
                if (triState == TriState.FALSE) {
                    return translatableComponent;
                }
                Component component = translator.canTranslate(translatableComponent.key(), locale) ? translator.translate(translatableComponent, locale) : null;
                return component != null ? this.render(component, locale) : super.renderTranslatableInner(translatableComponent, locale);
            }
        };
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @NotNull C c2) {
        return null;
    }

    @Nullable
    protected MessageFormat translate(@NotNull String string, @Nullable String string2, @NotNull C c2) {
        return this.translate(string, c2);
    }

    @Override
    @NotNull
    protected Component renderBlockNbt(@NotNull BlockNBTComponent blockNBTComponent, @NotNull C c2) {
        BlockNBTComponent.Builder builder = this.nbt(c2, Component.blockNBT(), blockNBTComponent).pos(blockNBTComponent.pos());
        return this.mergeStyleAndOptionallyDeepRender(blockNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderEntityNbt(@NotNull EntityNBTComponent entityNBTComponent, @NotNull C c2) {
        EntityNBTComponent.Builder builder = this.nbt(c2, Component.entityNBT(), entityNBTComponent).selector(entityNBTComponent.selector());
        return this.mergeStyleAndOptionallyDeepRender(entityNBTComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderStorageNbt(@NotNull StorageNBTComponent storageNBTComponent, @NotNull C c2) {
        StorageNBTComponent.Builder builder = this.nbt(c2, Component.storageNBT(), storageNBTComponent).storage(storageNBTComponent.storage());
        return this.mergeStyleAndOptionallyDeepRender(storageNBTComponent, builder, c2);
    }

    protected <O extends NBTComponent<O, B>, B extends NBTComponentBuilder<O, B>> B nbt(@NotNull C c2, B b2, O o2) {
        b2.nbtPath(o2.nbtPath()).interpret(o2.interpret());
        @Nullable Component component = o2.separator();
        if (component != null) {
            b2.separator(this.render(component, c2));
        }
        return b2;
    }

    @Override
    @NotNull
    protected Component renderKeybind(@NotNull KeybindComponent keybindComponent, @NotNull C c2) {
        KeybindComponent.Builder builder = Component.keybind().keybind(keybindComponent.keybind());
        return this.mergeStyleAndOptionallyDeepRender(keybindComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderScore(@NotNull ScoreComponent scoreComponent, @NotNull C c2) {
        ScoreComponent.Builder builder = Component.score().name(scoreComponent.name()).objective(scoreComponent.objective()).value(scoreComponent.value());
        return this.mergeStyleAndOptionallyDeepRender(scoreComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderSelector(@NotNull SelectorComponent selectorComponent, @NotNull C c2) {
        SelectorComponent.Builder builder = Component.selector().pattern(selectorComponent.pattern());
        return this.mergeStyleAndOptionallyDeepRender(selectorComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderText(@NotNull TextComponent textComponent, @NotNull C c2) {
        TextComponent.Builder builder = Component.text().content(textComponent.content());
        return this.mergeStyleAndOptionallyDeepRender(textComponent, builder, c2);
    }

    @Override
    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent translatableComponent, @NotNull C c2) {
        List<TranslationArgument> list = translatableComponent.arguments();
        List<Component> list2 = translatableComponent.children();
        if (!list.isEmpty() || !list2.isEmpty()) {
            TranslatableComponent.Builder builder = (TranslatableComponent.Builder)translatableComponent.toBuilder();
            if (!list.isEmpty()) {
                ArrayList<TranslationArgument> arrayList = new ArrayList<TranslationArgument>(list);
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    TranslationArgument translationArgument = (TranslationArgument)arrayList.get(i2);
                    if (!(translationArgument.value() instanceof Component) || translationArgument.value() instanceof VirtualComponent) continue;
                    arrayList.set(i2, TranslationArgument.component(this.render((Component)translationArgument.value(), c2)));
                }
                builder.arguments(arrayList);
            }
            translatableComponent = (TranslatableComponent)builder.build();
        }
        return this.renderTranslatableInner(translatableComponent, c2);
    }

    @NotNull
    protected Component renderTranslatableInner(@NotNull TranslatableComponent translatableComponent, @NotNull C c2) {
        @Nullable MessageFormat messageFormat = this.translate(translatableComponent.key(), translatableComponent.fallback(), c2);
        if (messageFormat == null) {
            return this.optionallyRenderChildrenAndStyle(translatableComponent, c2);
        }
        List<TranslationArgument> list = translatableComponent.arguments();
        TextComponent.Builder builder = Component.text();
        this.mergeStyle(translatableComponent, builder, c2);
        if (list.isEmpty()) {
            builder.content(messageFormat.format(null, new StringBuffer(), null).toString());
            return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
        }
        Object[] objectArray = new Object[list.size()];
        StringBuffer stringBuffer = messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null);
        AttributedCharacterIterator attributedCharacterIterator = messageFormat.formatToCharacterIterator(objectArray);
        while (attributedCharacterIterator.getIndex() < attributedCharacterIterator.getEndIndex()) {
            int n2 = attributedCharacterIterator.getRunLimit();
            Integer n3 = (Integer)attributedCharacterIterator.getAttribute(MessageFormat.Field.ARGUMENT);
            if (n3 != null) {
                TranslationArgument translationArgument = list.get(n3);
                builder.append(translationArgument.asComponent());
            } else {
                builder.append((Component)Component.text(stringBuffer.substring(attributedCharacterIterator.getIndex(), n2)));
            }
            attributedCharacterIterator.setIndex(n2);
        }
        return this.optionallyRenderChildrenAppendAndBuild(translatableComponent.children(), builder, c2);
    }

    protected Component optionallyRenderChildrenAndStyle(Component styleSetter, C c2) {
        List<Component> list;
        @Nullable HoverEvent<?> hoverEvent = styleSetter.hoverEvent();
        if (hoverEvent != null) {
            styleSetter = styleSetter.hoverEvent(hoverEvent.withRenderedValue(this, c2));
        }
        if ((list = styleSetter.children()).isEmpty()) {
            return styleSetter;
        }
        ArrayList arrayList = new ArrayList(list.size());
        list.forEach(component -> arrayList.add(this.render((Component)component, c2)));
        return styleSetter.children(arrayList);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O mergeStyleAndOptionallyDeepRender(Component component, B b2, C c2) {
        this.mergeStyle(component, b2, c2);
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), b2, c2);
    }

    protected <O extends BuildableComponent<O, B>, B extends ComponentBuilder<O, B>> O optionallyRenderChildrenAppendAndBuild(List<Component> list, B b2, C c2) {
        if (!list.isEmpty()) {
            list.forEach(component -> b2.append(this.render((Component)component, c2)));
        }
        return (O)b2.build();
    }

    protected <B extends ComponentBuilder<?, ?>> void mergeStyle(Component component, B b2, C c2) {
        b2.mergeStyle(component, MERGES);
        b2.clickEvent(component.clickEvent());
        @Nullable HoverEvent<?> hoverEvent = component.hoverEvent();
        if (hoverEvent != null) {
            b2.hoverEvent(hoverEvent.withRenderedValue(this, c2));
        }
    }

    static {
        EnumSet<Style.Merge> enumSet = EnumSet.allOf(Style.Merge.class);
        enumSet.remove((Object)Style.Merge.EVENTS);
        MERGES = Collections.unmodifiableSet(enumSet);
    }
}

