/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.ulrich.clans.library.kyori.adventure.internal.Internals;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.object.PlayerHeadObjectContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PlayerHeadObjectContentsImpl
implements PlayerHeadObjectContents {
    @Nullable
    private final String name;
    @Nullable
    private final UUID id;
    private final List<PlayerHeadObjectContents.ProfileProperty> properties;
    private final boolean hat;
    @Nullable
    private final Key texture;

    PlayerHeadObjectContentsImpl(@Nullable String string, @Nullable UUID uUID, @NotNull List<PlayerHeadObjectContents.ProfileProperty> list, boolean bl, @Nullable Key key) {
        this.name = string;
        this.id = uUID;
        this.properties = list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(list, "properties")));
        this.hat = bl;
        this.texture = key;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public UUID id() {
        return this.id;
    }

    @Override
    @NotNull
    public List<PlayerHeadObjectContents.ProfileProperty> profileProperties() {
        return this.properties;
    }

    @Override
    public boolean hat() {
        return this.hat;
    }

    @Override
    @Nullable
    public Key texture() {
        return this.texture;
    }

    @Override
    @NotNull
    public PlayerHeadObjectContents.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlayerHeadObjectContents)) {
            return false;
        }
        PlayerHeadObjectContentsImpl playerHeadObjectContentsImpl = (PlayerHeadObjectContentsImpl)object;
        return Objects.equals(this.name, playerHeadObjectContentsImpl.name) && Objects.equals(this.id, playerHeadObjectContentsImpl.id) && Objects.equals(this.properties, playerHeadObjectContentsImpl.properties) && this.hat == playerHeadObjectContentsImpl.hat && Objects.equals(this.texture, playerHeadObjectContentsImpl.texture);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.properties, this.hat, this.texture);
    }

    public String toString() {
        return Internals.toString(this);
    }

    static final class BuilderImpl
    implements PlayerHeadObjectContents.Builder {
        @Nullable
        private String name;
        @Nullable
        private UUID id;
        private final List<PlayerHeadObjectContents.ProfileProperty> properties = new ArrayList<PlayerHeadObjectContents.ProfileProperty>();
        private boolean hat = true;
        @Nullable
        private Key texture;

        BuilderImpl() {
        }

        BuilderImpl(@NotNull PlayerHeadObjectContentsImpl playerHeadObjectContentsImpl) {
            this.name = playerHeadObjectContentsImpl.name;
            this.id = playerHeadObjectContentsImpl.id;
            this.properties.addAll(playerHeadObjectContentsImpl.properties);
            this.hat = playerHeadObjectContentsImpl.hat;
            this.texture = playerHeadObjectContentsImpl.texture;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder name(@Nullable String string) {
            this.name = string;
            return this;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder id(@Nullable UUID uUID) {
            this.id = uUID;
            return this;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder profileProperty(@NotNull PlayerHeadObjectContents.ProfileProperty profileProperty) {
            this.properties.add(Objects.requireNonNull(profileProperty, "property"));
            return this;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder profileProperties(@NotNull Collection<PlayerHeadObjectContents.ProfileProperty> collection) {
            for (PlayerHeadObjectContents.ProfileProperty profileProperty : Objects.requireNonNull(collection, "properties")) {
                this.profileProperty(profileProperty);
            }
            return this;
        }

        private void clearProfile() {
            this.name = null;
            this.id = null;
            this.properties.clear();
            this.texture = null;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder skin(@NotNull PlayerHeadObjectContents.SkinSource skinSource) {
            this.clearProfile();
            Objects.requireNonNull(skinSource, "skinSource").applySkinToPlayerHeadContents(this);
            return this;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder hat(boolean bl) {
            this.hat = bl;
            return this;
        }

        @Override
        public @NotNull PlayerHeadObjectContents.Builder texture(@Nullable Key key) {
            this.texture = key;
            return this;
        }

        @Override
        @NotNull
        public PlayerHeadObjectContents build() {
            return new PlayerHeadObjectContentsImpl(this.name, this.id, this.properties, this.hat, this.texture);
        }
    }

    static final class ProfilePropertyImpl
    implements PlayerHeadObjectContents.ProfileProperty {
        private final String name;
        private final String value;
        @Nullable
        private final String signature;

        ProfilePropertyImpl(@NotNull String string, @NotNull String string2, @Nullable String string3) {
            this.name = string;
            this.value = string2;
            this.signature = string3;
        }

        @Override
        @NotNull
        public String name() {
            return this.name;
        }

        @Override
        @NotNull
        public String value() {
            return this.value;
        }

        @Override
        @Nullable
        public String signature() {
            return this.signature;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ProfilePropertyImpl)) {
                return false;
            }
            ProfilePropertyImpl profilePropertyImpl = (ProfilePropertyImpl)object;
            return Objects.equals(this.name, profilePropertyImpl.name) && Objects.equals(this.value, profilePropertyImpl.value) && Objects.equals(this.signature, profilePropertyImpl.signature);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.signature);
        }

        public String toString() {
            return Internals.toString(this);
        }
    }
}

