/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.translation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.ulrich.clans.library.kyori.adventure.pointer.Pointered;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.TranslatableComponent;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgument;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgumentLike;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponent;
import me.ulrich.clans.library.kyori.adventure.text.VirtualComponentRenderer;
import me.ulrich.clans.library.kyori.adventure.text.format.Style;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.MiniMessage;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.ArgumentTag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.LocalePointered;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;
import me.ulrich.clans.library.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MiniMessageTranslator
implements Translator {
    private final MiniMessage miniMessage;

    public MiniMessageTranslator() {
        this(MiniMessage.miniMessage());
    }

    public MiniMessageTranslator(@NotNull MiniMessage miniMessage) {
        this.miniMessage = Objects.requireNonNull(miniMessage, "miniMessage");
    }

    @Nullable
    protected abstract String getMiniMessageString(@NotNull String var1, @NotNull Locale var2);

    @Override
    @Nullable
    public final MessageFormat translate(@NotNull String string, @NotNull Locale locale) {
        return null;
    }

    @Override
    @Nullable
    public final Component translate(@NotNull TranslatableComponent translatableComponent, @NotNull Locale locale) {
        Object object;
        Component component;
        String string = this.getMiniMessageString(translatableComponent.key(), locale);
        if (string == null) {
            return null;
        }
        Pointered pointered = new LocalePointered(locale);
        List<TranslationArgument> list = translatableComponent.arguments();
        if (list.isEmpty()) {
            component = this.miniMessage.deserialize(string, pointered);
        } else {
            object = TagResolver.builder();
            ArrayList<Tag> arrayList = new ArrayList<Tag>(list.size());
            boolean bl = false;
            for (TranslationArgument translationArgument : list) {
                Object object2 = translationArgument.value();
                if (object2 instanceof VirtualComponent) {
                    VirtualComponentRenderer<?> virtualComponentRenderer = ((VirtualComponent)object2).renderer();
                    if (virtualComponentRenderer instanceof MiniMessageTranslatorTarget) {
                        if (bl) {
                            throw new IllegalArgumentException("Multiple Argument.target() translation arguments have been set!");
                        }
                        pointered = ((MiniMessageTranslatorTarget)virtualComponentRenderer).pointered();
                        bl = true;
                        continue;
                    }
                    if (virtualComponentRenderer instanceof MiniMessageTranslatorArgument) {
                        Tag tag;
                        MiniMessageTranslatorArgument miniMessageTranslatorArgument = (MiniMessageTranslatorArgument)virtualComponentRenderer;
                        Object t2 = miniMessageTranslatorArgument.data();
                        if (t2 instanceof TranslationArgumentLike) {
                            tag = Tag.selfClosingInserting((TranslationArgumentLike)t2);
                            object.tag(miniMessageTranslatorArgument.name(), tag);
                            arrayList.add(tag);
                            continue;
                        }
                        if (t2 instanceof Tag) {
                            tag = (Tag)t2;
                            object.tag(miniMessageTranslatorArgument.name(), tag);
                            arrayList.add(tag);
                            continue;
                        }
                        if (t2 instanceof TagResolver) {
                            object.resolvers((TagResolver)t2);
                        } else {
                            throw new IllegalArgumentException("Unknown translator argument type: " + t2.getClass());
                        }
                    }
                }
                arrayList.add(Tag.selfClosingInserting(translationArgument));
            }
            component = this.miniMessage.deserialize(string, pointered, (TagResolver)new ArgumentTag(arrayList, object.build()));
        }
        object = translatableComponent.style();
        if (!object.isEmpty()) {
            component = component.applyFallbackStyle((Style)object);
        }
        return component.append(translatableComponent.children());
    }
}

