/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.translation;

import java.util.Objects;
import me.ulrich.clans.library.kyori.adventure.pointer.Pointered;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ComponentLike;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgument;
import me.ulrich.clans.library.kyori.adventure.text.TranslationArgumentLike;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.TagPattern;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;
import org.jetbrains.annotations.NotNull;

public final class Argument {
    private Argument() {
    }

    @NotNull
    public static ComponentLike bool(@TagPattern @NotNull String string, boolean bl) {
        return Argument.argument(string, TranslationArgument.bool(bl));
    }

    @NotNull
    public static ComponentLike numeric(@TagPattern @NotNull String string, @NotNull Number number) {
        return Argument.argument(string, TranslationArgument.numeric(number));
    }

    @Deprecated
    @NotNull
    public static ComponentLike numeric(@TagPattern @NotNull String string, @NotNull String string2) {
        return Argument.string(string, string2);
    }

    @NotNull
    public static ComponentLike string(@TagPattern @NotNull String string, @NotNull String string2) {
        return Argument.argument(string, TranslationArgument.component(Component.text(string2)));
    }

    @NotNull
    public static ComponentLike component(@TagPattern @NotNull String string, @NotNull ComponentLike componentLike) {
        return Argument.argument(string, TranslationArgument.component(componentLike));
    }

    @NotNull
    public static ComponentLike argument(@TagPattern @NotNull String string, @NotNull TranslationArgumentLike translationArgumentLike) {
        return Argument.argument(string, Objects.requireNonNull(translationArgumentLike, "argument").asTranslationArgument());
    }

    @NotNull
    public static ComponentLike argument(@TagPattern @NotNull String string, @NotNull TranslationArgument translationArgument) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TranslationArgument>(string, Objects.requireNonNull(translationArgument, "argument")));
    }

    @NotNull
    public static ComponentLike tag(@TagPattern @NotNull String string, @NotNull Tag tag) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<Tag>(string, Objects.requireNonNull(tag, "tag")));
    }

    @NotNull
    public static ComponentLike tagResolver(TagResolver ... tagResolverArray) {
        return Argument.tagResolver(TagResolver.resolver(tagResolverArray));
    }

    @NotNull
    public static ComponentLike tagResolver(@NotNull Iterable<TagResolver> iterable) {
        return Argument.tagResolver(TagResolver.resolver(iterable));
    }

    @NotNull
    public static ComponentLike tagResolver(@NotNull TagResolver tagResolver) {
        return Component.virtual(Void.class, new MiniMessageTranslatorArgument<TagResolver>("unused", Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @NotNull
    public static ComponentLike target(@NotNull Pointered pointered) {
        return Component.virtual(Void.class, new MiniMessageTranslatorTarget(Objects.requireNonNull(pointered, "target")));
    }
}

