/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Inserting;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import me.ulrich.clans.library.kyori.examination.Examinable;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;

public final class TransitionTag
implements Inserting,
Examinable {
    public static final String TRANSITION = "transition";
    private final TextColor[] colors;
    private final float phase;
    private final boolean negativePhase;
    static final TagResolver RESOLVER = TagResolver.resolver("transition", TransitionTag::create);

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        List<TextColor> list;
        float f2 = 0.0f;
        if (argumentQueue.hasNext()) {
            list = new ArrayList();
            while (argumentQueue.hasNext()) {
                OptionalDouble optionalDouble;
                Tag.Argument argument = argumentQueue.pop();
                String string = argument.value();
                TextColor textColor = ColorTagResolver.resolveColorOrNull(string);
                if (textColor != null) {
                    list.add(textColor);
                    continue;
                }
                if (!argumentQueue.hasNext() && (optionalDouble = argument.asDouble()).isPresent()) {
                    f2 = (float)optionalDouble.getAsDouble();
                    if (!(f2 < -1.0f) && !(f2 > 1.0f)) break;
                    throw context.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(f2)), argumentQueue);
                }
                throw context.newException(String.format("Unable to parse a color from '%s'. Please use named colors or hex (#RRGGBB) colors.", string), argumentQueue);
            }
            if (list.size() < 2) {
                throw context.newException("Invalid transition, not enough colors. Transitions must have at least two colors.", argumentQueue);
            }
        } else {
            list = Collections.emptyList();
        }
        return new TransitionTag(f2, list);
    }

    private TransitionTag(float f2, List<TextColor> list) {
        if (f2 < 0.0f) {
            this.negativePhase = true;
            this.phase = 1.0f + f2;
            Collections.reverse(list);
        } else {
            this.negativePhase = false;
            this.phase = f2;
        }
        this.colors = list.isEmpty() ? new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)} : list.toArray(new TextColor[0]);
    }

    @Override
    @NotNull
    public Component value() {
        return Component.text("", this.color());
    }

    private TextColor color() {
        float f2 = 1.0f / (float)(this.colors.length - 1);
        for (int i2 = 1; i2 < this.colors.length; ++i2) {
            float f3 = (float)i2 * f2;
            if (!(f3 >= this.phase)) continue;
            float f4 = 1.0f + (this.phase - f3) * (float)(this.colors.length - 1);
            if (this.negativePhase) {
                return TextColor.lerp(1.0f - f4, this.colors[i2], this.colors[i2 - 1]);
            }
            return TextColor.lerp(f4, this.colors[i2 - 1], this.colors[i2]);
        }
        return this.colors[0];
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TransitionTag transitionTag = (TransitionTag)object;
        return this.phase == transitionTag.phase && Arrays.equals(this.colors, transitionTag.colors);
    }

    public int hashCode() {
        int n2 = Objects.hash(Float.valueOf(this.phase));
        n2 = 31 * n2 + Arrays.hashCode(this.colors);
        return n2;
    }
}

