/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import me.ulrich.clans.library.kyori.adventure.text.format.NamedTextColor;
import me.ulrich.clans.library.kyori.adventure.text.format.ShadowColor;
import me.ulrich.clans.library.kyori.adventure.text.format.StyleGetter;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShadowColorTag {
    private static final String SHADOW_COLOR = "shadow";
    private static final String SHADOW_NONE = "!shadow";
    private static final float DEFAULT_ALPHA = 0.25f;
    static final TagResolver RESOLVER = TagResolver.resolver(SerializableResolver.claimingStyle("shadow", ShadowColorTag::create, StyleClaim.claim("shadow", StyleGetter::shadowColor, ShadowColorTag::emit)), TagResolver.resolver("!shadow", Tag.styling(ShadowColor.none())));

    static Tag create(@NotNull ArgumentQueue argumentQueue, @NotNull Context context) {
        ShadowColor shadowColor;
        String string = argumentQueue.popOr("Expected to find a color parameter: #RRGGBBAA").lowerValue();
        if (string.startsWith("#") && string.length() == 9) {
            shadowColor = ShadowColor.fromHexString(string);
            if (shadowColor == null) {
                throw context.newException(String.format("Unable to parse a shadow color from '%s'. Please use #RRGGBBAA formatting.", string));
            }
        } else {
            TextColor textColor = ColorTagResolver.resolveColor(string, context);
            float f2 = argumentQueue.hasNext() ? (float)argumentQueue.pop().asDouble().orElseThrow(() -> context.newException("Number was expected to be a double")) : 0.25f;
            shadowColor = ShadowColor.shadowColor(textColor, (int)(f2 * 255.0f));
        }
        return Tag.styling(shadowColor);
    }

    static void emit(@NotNull ShadowColor shadowColor, @NotNull TokenEmitter tokenEmitter) {
        if (ShadowColor.none().equals(shadowColor)) {
            tokenEmitter.tag(SHADOW_NONE);
            return;
        }
        tokenEmitter.tag(SHADOW_COLOR);
        @Nullable NamedTextColor namedTextColor = NamedTextColor.namedColor(TextColor.color(shadowColor).value());
        if (namedTextColor != null) {
            tokenEmitter.argument(NamedTextColor.NAMES.key(namedTextColor)).argument(Float.toString((float)shadowColor.alpha() / 255.0f));
        } else {
            tokenEmitter.argument(shadowColor.asHexString());
        }
    }

    private ShadowColorTag() {
    }
}

