/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import me.ulrich.clans.library.kyori.adventure.key.Key;
import me.ulrich.clans.library.kyori.adventure.text.Component;
import me.ulrich.clans.library.kyori.adventure.text.ObjectComponent;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.object.ObjectContents;
import me.ulrich.clans.library.kyori.adventure.text.object.PlayerHeadObjectContents;
import me.ulrich.clans.library.kyori.adventure.util.TriState;
import org.jetbrains.annotations.Nullable;

final class SequentialHeadTag {
    private static final String HEAD = "head";
    private static final Pattern UUIDv4_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ABCD][0-9a-f]{3}-[0-9a-f]{12}", 2);
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("head", SequentialHeadTag::create, SequentialHeadTag::claimComponent);

    private SequentialHeadTag() {
    }

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        TriState triState;
        if (!argumentQueue.hasNext()) {
            return Tag.selfClosingInserting(Component.object(ObjectContents.playerHead().build()));
        }
        Tag.Argument argument = argumentQueue.pop();
        String string = argument.value();
        if (!argumentQueue.hasNext()) {
            triState = SequentialHeadTag.argumentToTriState(argument);
            if (triState != TriState.NOT_SET) {
                return Tag.selfClosingInserting(Component.object(ObjectContents.playerHead().hat(triState.toBooleanOrElse(true)).build()));
            }
        } else {
            triState = SequentialHeadTag.argumentToTriState(argumentQueue.pop());
        }
        if (argumentQueue.hasNext()) {
            throw context.newException("Too many arguments present", argumentQueue);
        }
        if (UUIDv4_PATTERN.matcher(string).matches()) {
            return Tag.selfClosingInserting(Component.object(ObjectContents.playerHead().id(UUID.fromString(string)).hat(triState.toBooleanOrElse(true)).build()));
        }
        if (string.contains("/") && Key.parseable(string)) {
            return Tag.selfClosingInserting(Component.object(ObjectContents.playerHead().texture(Key.key(string)).hat(triState.toBooleanOrElse(true)).build()));
        }
        return Tag.selfClosingInserting(Component.object(ObjectContents.playerHead().name(string).hat(triState.toBooleanOrElse(true)).build()));
    }

    @Nullable
    static Emitable claimComponent(Component component) {
        if (!(component instanceof ObjectComponent)) {
            return null;
        }
        ObjectContents objectContents = ((ObjectComponent)component).contents();
        if (!(objectContents instanceof PlayerHeadObjectContents)) {
            return null;
        }
        PlayerHeadObjectContents playerHeadObjectContents = (PlayerHeadObjectContents)objectContents;
        PresentType presentType = null;
        if (playerHeadObjectContents.name() != null) {
            presentType = PresentType.NAME;
        }
        if (playerHeadObjectContents.id() != null) {
            if (presentType != null) {
                return null;
            }
            presentType = PresentType.ID;
        }
        if (playerHeadObjectContents.texture() != null) {
            if (presentType != null) {
                return null;
            }
            presentType = PresentType.TEXTURE;
        }
        if (presentType == null) {
            return tokenEmitter -> {
                tokenEmitter.tag(HEAD);
                if (!playerHeadObjectContents.hat()) {
                    tokenEmitter.argument(Boolean.toString(playerHeadObjectContents.hat()));
                }
            };
        }
        PresentType presentType2 = presentType;
        return tokenEmitter -> {
            tokenEmitter.tag(HEAD);
            String string = presentType2.map(playerHeadObjectContents);
            tokenEmitter.argument(string);
            if (!playerHeadObjectContents.hat()) {
                tokenEmitter.argument(Boolean.toString(playerHeadObjectContents.hat()));
            }
        };
    }

    private static TriState argumentToTriState(Tag.Argument argument) {
        if (argument.isTrue()) {
            return TriState.TRUE;
        }
        if (argument.isFalse()) {
            return TriState.FALSE;
        }
        return TriState.NOT_SET;
    }

    private static enum PresentType {
        NAME(PlayerHeadObjectContents::name),
        ID(playerHeadObjectContents -> Objects.requireNonNull(playerHeadObjectContents.id()).toString()),
        TEXTURE(playerHeadObjectContents -> Objects.requireNonNull(playerHeadObjectContents.texture()).asMinimalString());

        private final Function<PlayerHeadObjectContents, String> mappingFunction;

        private PresentType(Function<PlayerHeadObjectContents, String> function) {
            this.mappingFunction = function;
        }

        public String map(PlayerHeadObjectContents playerHeadObjectContents) {
            return this.mappingFunction.apply(playerHeadObjectContents);
        }
    }
}

