/*
 * Decompiled with CFR 0.152.
 */
package me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.ulrich.clans.library.kyori.adventure.text.format.TextColor;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.Context;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.Tag;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.ulrich.clans.library.kyori.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import me.ulrich.clans.library.kyori.adventure.util.HSVLike;
import me.ulrich.clans.library.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RainbowTag
extends AbstractColorChangingTag {
    private static final String REVERSE = "!";
    private static final String RAINBOW = "rainbow";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("rainbow", RainbowTag::create, AbstractColorChangingTag::claimComponent);
    private final boolean reversed;
    private final double dividedPhase;
    private int colorIndex = 0;

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        boolean bl = false;
        int n2 = 0;
        if (argumentQueue.hasNext()) {
            String string = argumentQueue.pop().value();
            if (string.startsWith(REVERSE)) {
                bl = true;
                string = string.substring(REVERSE.length());
            }
            if (string.length() > 0) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw context.newException("Expected phase, got " + string);
                }
            }
        }
        return new RainbowTag(bl, n2, context);
    }

    private RainbowTag(boolean bl, int n2, Context context) {
        super(context);
        this.reversed = bl;
        this.dividedPhase = (double)n2 / 10.0;
    }

    @Override
    protected void init() {
        if (this.reversed) {
            this.colorIndex = this.size() - 1;
        }
    }

    @Override
    protected void advanceColor() {
        this.colorIndex = this.reversed ? (this.colorIndex == 0 ? this.size() - 1 : --this.colorIndex) : ++this.colorIndex;
    }

    @Override
    protected TextColor color() {
        float f2 = this.colorIndex;
        float f3 = (float)(((double)(f2 / (float)this.size()) + this.dividedPhase) % 1.0);
        return TextColor.color(HSVLike.hsvLike(f3, 1.0f, 1.0f));
    }

    @Override
    @NotNull
    protected Consumer<TokenEmitter> preserveData() {
        boolean bl = this.reversed;
        int n2 = (int)Math.round(this.dividedPhase * 10.0);
        return tokenEmitter -> {
            tokenEmitter.tag(RAINBOW);
            if (bl && n2 != 0) {
                tokenEmitter.argument(REVERSE + n2);
            } else if (bl) {
                tokenEmitter.argument(REVERSE);
            } else if (n2 != 0) {
                tokenEmitter.argument(Integer.toString(n2));
            }
        };
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.dividedPhase));
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RainbowTag rainbowTag = (RainbowTag)object;
        return this.colorIndex == rainbowTag.colorIndex && this.dividedPhase == rainbowTag.dividedPhase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, this.dividedPhase);
    }
}

